/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.tx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.fi.arapcommon.tx.AsyncTx;
import kd.fi.arapcommon.tx.AsyncTxService;
import kd.fi.arapcommon.tx.IAsyncExecutor;

public class AsyncOperationService {
    private List<AsyncTx> txQueue = new ArrayList<AsyncTx>();
    private String entityKey;
    private String action;

    public AsyncOperationService(String entityKey, String action) {
        this.entityKey = entityKey;
        this.action = action;
    }

    public <T extends Serializable> void addTask(Long mainBillId, T param, Class<? extends IAsyncExecutor> executorClass) {
        this.addTask("DefaultUnionTask", mainBillId, param, executorClass);
    }

    public <T extends Serializable> void addTask(String task, Long mainBillId, T param, Class<? extends IAsyncExecutor> executorClass) {
        AsyncTx asyncTx = new AsyncTx();
        asyncTx.setGroup(this.entityKey);
        asyncTx.setAction(this.action);
        asyncTx.setTask(task);
        asyncTx.setParam(param);
        asyncTx.setXid(mainBillId.toString());
        asyncTx.setExecuteClass(executorClass.getName());
        this.txQueue.add(asyncTx);
    }

    public void commit() {
        AsyncTxService asyncTxService = new AsyncTxService();
        asyncTxService.save(this.txQueue.toArray(new AsyncTx[0]));
        for (AsyncTx asyncTx : this.txQueue) {
            this.pushMq(asyncTx);
        }
        this.txQueue.clear();
    }

    private void pushMq(AsyncTx asyncTx) {
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("fi", "fi.ap.autopush");){
            pub.publishInDbTranscation("fi", (Object)asyncTx);
        }
    }
}

