/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import org.apache.commons.io.IOUtils;

public class SceneTestHelper {
    public static final String JSON_ROOT_DIR = "/scene/";
    public static final String unInitOrgNum = "BU-55555555";
    public static final String planOrgNum = "BU-66666666";
    public static final String materialOrgNum = "BU-77777777";
    public static final String supplierNum = "Sup-66666666";
    public static final String customerNum = "Cus-88888888";
    public static final String materialNum = "Item-55555555";
    public static final String warehouseNum = "WH-66666666";

    public static String getFileContent(Class<?> clazz, String jsonName) {
        String content = null;
        URL url = clazz.getResource(JSON_ROOT_DIR + jsonName);
        if (url == null) {
            url = SceneTestHelper.class.getResource(JSON_ROOT_DIR + jsonName);
        }
        try {
            content = IOUtils.toString((URL)url, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        return content;
    }

    public static String getFileContent(String jsonName) {
        String content = null;
        InputStream is = null;
        try {
            is = SceneTestHelper.class.getResourceAsStream(JSON_ROOT_DIR + jsonName);
            content = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return content;
    }
}

