/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.builder;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.OperationWebApiImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.unittest.SceneTestHelper;
import kd.fi.arapcommon.unittest.builder.IBuilder;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataProvider;
import kd.fi.arapcommon.util.DateUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractBuilder
implements IBuilder {
    private static final Log logger = LogFactory.getLog(AbstractBuilder.class);
    protected String entityKey;
    protected String orgNum;

    public AbstractBuilder(String entityKey, String orgNum) {
        this.entityKey = entityKey;
        this.orgNum = orgNum;
    }

    @Override
    public DynamicObject buildBill(String jsonName) {
        this.prepare();
        DynamicObject bill = null;
        Map<String, Object> dataMap = this.convertMap(jsonName);
        this.delete(this.entityKey, (String)dataMap.get("billno"));
        HashMap<String, Map<String, Object>> req = new HashMap<String, Map<String, Object>>(2);
        req.put("data", dataMap);
        OperationWebApiImpl impl = new OperationWebApiImpl();
        Map result = impl.executeOperation(this.entityKey, "save", req);
        boolean isSuccess = (Boolean)result.get("success");
        if (!isSuccess) {
            String message = SerializationUtils.toJsonString((Object)result);
            logger.error("jsonName = " + jsonName + ", error = " + message);
            throw new KDBizException("\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff1a" + result.get(message));
        }
        OperationResult opResult = (OperationResult)result.get("data");
        bill = BusinessDataServiceHelper.loadSingle(opResult.getSuccessPkIds().get(0), (String)this.entityKey);
        bill.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
        return bill;
    }

    private void prepare() {
        BaseDataProvider provider = new BaseDataProvider();
        if ("BU-55555555".equals(this.orgNum)) {
            provider.getUnInitOrg();
        } else if ("BU-66666666".equals(this.orgNum)) {
            provider.getPlanInitOrg();
        } else if ("BU-77777777".equals(this.orgNum)) {
            provider.getDetailInitOrg();
        }
    }

    private void delete(String entityKey, String billno) {
        QFilter qFilter = new QFilter("billno", "=", (Object)billno);
        DynamicObject bill = QueryServiceHelper.queryOne((String)entityKey, (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (!ObjectUtils.isEmpty((Object)bill)) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityKey), (Object[])new Object[]{bill.getLong("id")});
        }
    }

    protected Map<String, Object> convertMap(String jsonName) {
        String fileName = jsonName.substring(0, jsonName.lastIndexOf(46));
        String caseName = fileName.substring(fileName.lastIndexOf(95) + 1);
        String date = DateUtils.formatString(new Date(), "yyyyMMdd");
        String billno = "scene_" + date + "_" + caseName;
        String json = SceneTestHelper.getFileContent(this.getClass(), jsonName);
        json = json.replaceAll("BU-9999999", this.orgNum);
        Map<String, Object> dataMap = this.clearBaseProperty(json);
        this.clearBillProperty(dataMap);
        dataMap.put("billno", billno);
        dataMap.put("bizdate", DateUtils.truncateDate(new Date()));
        this.replaceBillProperty(dataMap);
        return dataMap;
    }

    protected Map<String, Object> clearBaseProperty(String json) {
        Map m = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
        LinkedHashMap dataMap = (LinkedHashMap)m.get("data");
        if (dataMap == null) {
            dataMap = (LinkedHashMap)m;
        }
        this.removeProperty(dataMap);
        return dataMap;
    }

    protected void removeProperty(LinkedHashMap<String, Object> dataMap) {
        try {
            Set<Map.Entry<String, Object>> es = dataMap.entrySet();
            Iterator<Map.Entry<String, Object>> iterator = es.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof List) {
                    ArrayList arrays = (ArrayList)value;
                    if (StringUtils.contains((String)key, (String)"billhead_lk") || StringUtils.contains((String)key, (String)"_attachments")) {
                        iterator.remove();
                        continue;
                    }
                    for (Object object : arrays) {
                        this.removeProperty((LinkedHashMap)object);
                    }
                    continue;
                }
                if (value instanceof Map) {
                    if (StringUtils.contains((String)key, (String)"creator") || StringUtils.contains((String)key, (String)"modifier") || StringUtils.contains((String)key, (String)"auditor")) {
                        iterator.remove();
                        continue;
                    }
                    Map basedata = (Map)value;
                    if (!basedata.containsKey("number")) continue;
                    this.clearProperty(basedata);
                    continue;
                }
                if ("id".equals(key)) {
                    iterator.remove();
                }
                if ("seq".equals(key)) {
                    iterator.remove();
                }
                if (!StringUtils.contains((String)key, (String)"createtime") && !StringUtils.contains((String)key, (String)"modifytime") && !StringUtils.contains((String)key, (String)"auditdate")) continue;
                iterator.remove();
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private void clearProperty(Map<String, Object> basedataMap) {
        Set<Map.Entry<String, Object>> es = basedataMap.entrySet();
        Iterator<Map.Entry<String, Object>> iterator = es.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String key = entry.getKey();
            if ("number".equals(key)) continue;
            iterator.remove();
        }
    }

    protected void removeProperty(Map<String, Object> dataMap, String property) {
        Set<Map.Entry<String, Object>> es = dataMap.entrySet();
        Iterator<Map.Entry<String, Object>> iterator = es.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                ArrayList arrays = (ArrayList)value;
                for (Object object : arrays) {
                    this.removeProperty((LinkedHashMap)object, property);
                }
                continue;
            }
            if (!StringUtils.contains((String)key, (String)property)) continue;
            iterator.remove();
        }
    }

    protected abstract void clearBillProperty(Map<String, Object> var1);

    protected void replaceBillProperty(Map<String, Object> dataMap) {
    }
}

