/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.check;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.unittest.framework.KDAssert;

public class BaddebtlossBillTestChecker {
    public static void validateHeadSettleStatus(DynamicObject finBill, String execptStatus) {
        KDAssert.assertEquals((String)"\u574f\u8d26\u635f\u5931\u5355\u8868\u5934\u7ed3\u7b97\u72b6\u6001\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (String)execptStatus, (String)finBill.getString("settlestatus"));
    }

    public static void validateDetailEntryLockAmt(DynamicObject detailEntryRow, BigDecimal expectedLockAmt, BigDecimal expectedUnLockAmt) {
        BigDecimal lockedAmount = detailEntryRow.getBigDecimal("e_lockedamt");
        BaddebtlossBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u9501\u5b9a\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedLockAmt.compareTo(lockedAmount));
        BigDecimal unLockedAmount = detailEntryRow.getBigDecimal("e_unlockamt");
        BaddebtlossBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u672a\u9501\u5b9a\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedUnLockAmt.compareTo(unLockedAmount));
    }

    public static void validateDetailEntrySettleAmt(DynamicObject detailEntryRow, BigDecimal expectedSettleAmt, BigDecimal expectedUnSettleAmt) {
        BigDecimal settleAmount = detailEntryRow.getBigDecimal("e_settledamt");
        BaddebtlossBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u7ed3\u7b97\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedSettleAmt.compareTo(settleAmount));
        BigDecimal unSettleAmount = detailEntryRow.getBigDecimal("e_unsettleamt");
        BaddebtlossBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedUnSettleAmt.compareTo(unSettleAmount));
    }

    public static void validateDetailLockAndSettleAmt(DynamicObject detailRow, BigDecimal lockedamt, BigDecimal unlockamt, BigDecimal settledamt, BigDecimal unsettleamt) {
        BaddebtlossBillTestChecker.validateDetailEntryLockAmt(detailRow, lockedamt, unlockamt);
        BaddebtlossBillTestChecker.validateDetailEntrySettleAmt(detailRow, settledamt, unsettleamt);
    }

    public static void validatePlanEntryLockAmt(DynamicObject planEntryRow, BigDecimal expectedLockAmt, BigDecimal expectedUnLockAmt) {
        BigDecimal lockedAmount = planEntryRow.getBigDecimal("p_lockedamt");
        BaddebtlossBillTestChecker.assertEquals("\u8ba1\u5212\u884c\u9501\u5b9a\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedLockAmt.compareTo(lockedAmount));
        BigDecimal unLockedAmount = planEntryRow.getBigDecimal("p_unlockamt");
        BaddebtlossBillTestChecker.assertEquals("\u8ba1\u5212\u884c\u672a\u9501\u5b9a\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedUnLockAmt.compareTo(unLockedAmount));
    }

    public static void validatePlanEntrySettleAmt(DynamicObject planEntry, BigDecimal expectedSettleAmt, BigDecimal expectedUnSettleAmt) {
        BigDecimal settleAmount = planEntry.getBigDecimal("p_settledamt");
        BaddebtlossBillTestChecker.assertEquals("\u8ba1\u5212\u884c\u7ed3\u7b97\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedSettleAmt.compareTo(settleAmount));
        BigDecimal unSettleAmount = planEntry.getBigDecimal("p_unsettleamt");
        BaddebtlossBillTestChecker.assertEquals("\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedUnSettleAmt.compareTo(unSettleAmount));
    }

    public static void validatePlanLockAndSettleAmt(DynamicObject planRow, BigDecimal lockedamt, BigDecimal unlockamt, BigDecimal settledamt, BigDecimal unsettleamt) {
        BaddebtlossBillTestChecker.validatePlanEntryLockAmt(planRow, lockedamt, unlockamt);
        BaddebtlossBillTestChecker.validatePlanEntrySettleAmt(planRow, settledamt, unsettleamt);
    }

    public static void validateInitialBill(DynamicObject finBill) {
        KDAssert.assertEquals((String)"\u574f\u8d26\u635f\u5931\u5355\u5e94\u4e3a\u672a\u7ed3\u7b97", (String)"unsettle", (String)finBill.getString("settlestatus"));
        DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("entry");
        for (DynamicObject detailRow : detailEntry) {
            BigDecimal recAmt = detailRow.getBigDecimal("e_baddebtamt");
            BaddebtlossBillTestChecker.validateDetailLockAndSettleAmt(detailRow, BigDecimal.ZERO, recAmt, BigDecimal.ZERO, recAmt);
        }
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentry");
        for (DynamicObject planRow : planEntity) {
            BigDecimal recAmt = planRow.getBigDecimal("p_baddebtamt");
            BaddebtlossBillTestChecker.validatePlanLockAndSettleAmt(planRow, BigDecimal.ZERO, recAmt, BigDecimal.ZERO, recAmt);
        }
    }

    public static void validateFinishBill(DynamicObject finBill) {
        KDAssert.assertEquals((String)"\u574f\u8d26\u635f\u5931\u5355\u5e94\u4e3a\u5168\u90e8\u7ed3\u7b97", (String)"settled", (String)finBill.getString("settlestatus"));
        DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("entry");
        for (DynamicObject detailRow : detailEntry) {
            BigDecimal recAmt = detailRow.getBigDecimal("e_baddebtamt");
            BaddebtlossBillTestChecker.validateDetailLockAndSettleAmt(detailRow, recAmt, BigDecimal.ZERO, recAmt, BigDecimal.ZERO);
        }
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentry");
        for (DynamicObject planRow : planEntity) {
            BigDecimal recAmt = planRow.getBigDecimal("p_baddebtamt");
            BaddebtlossBillTestChecker.validatePlanLockAndSettleAmt(planRow, recAmt, BigDecimal.ZERO, recAmt, BigDecimal.ZERO);
        }
    }

    private static void assertEquals(String message, Object expected, Object actual) {
        KDAssert.assertEquals((String)message, (Object)expected, (Object)actual);
    }
}

