/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.check;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.unittest.framework.KDAssert;

public class FinApBillTestChecker {
    public static void validateApFinHeadAmt(DynamicObject finBill, BigDecimal amount, BigDecimal amountbase, BigDecimal tax, BigDecimal pricetaxtotal, BigDecimal pricetaxtotalbase) {
        KDAssert.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)amount.compareTo(finBill.getBigDecimal("amount")));
        KDAssert.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u91d1\u989d\u6298\u672c\u5e01\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)amountbase.compareTo(finBill.getBigDecimal("amountbase")));
        KDAssert.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u7a0e\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)tax.compareTo(finBill.getBigDecimal("tax")));
        KDAssert.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u5e94\u4ed8\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)pricetaxtotal.compareTo(finBill.getBigDecimal("pricetaxtotal")));
        KDAssert.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u5e94\u4ed8\u6298\u672c\u5e01\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)pricetaxtotalbase.compareTo(finBill.getBigDecimal("pricetaxtotalbase")));
    }

    public static void validateApFinHeadSettleStatus(DynamicObject finBill, String execptStatus) {
        KDAssert.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u7ed3\u7b97\u72b6\u6001\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (String)execptStatus, (String)finBill.getString("settlestatus"));
    }

    public static void validateApFinHeadSettleAmt(DynamicObject finBill, BigDecimal unsettleamount, BigDecimal unsettleamountbase, BigDecimal settleamount, BigDecimal settleamountbase) {
        KDAssert.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u672a\u7ed3\u7b97\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)unsettleamount.compareTo(finBill.getBigDecimal("unsettleamount")));
        KDAssert.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u672a\u7ed3\u7b97\u6298\u672c\u5e01\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)unsettleamountbase.compareTo(finBill.getBigDecimal("unsettleamountbase")));
        KDAssert.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u5df2\u7ed3\u7b97\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)settleamount.compareTo(finBill.getBigDecimal("settleamount")));
        KDAssert.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u5df2\u7ed3\u7b97\u6298\u672c\u5e01\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)settleamountbase.compareTo(finBill.getBigDecimal("settleamountbase")));
    }

    public static void validateApFinHeadVerifyData(DynamicObject finBill, String verifystatus, BigDecimal unverifyamount) {
        KDAssert.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u6838\u9500\u72b6\u6001\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (boolean)true, (boolean)verifystatus.equals(finBill.getString("verifystatus")));
        KDAssert.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u672a\u6838\u9500\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)unverifyamount.compareTo(finBill.getBigDecimal("unverifyamount")));
    }

    public static void validateApFinVerifyRecordData(long mainBillId, long asstBillId) {
        DynamicObjectCollection verifyRecords = QueryServiceHelper.query((String)"ap_verifyrecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)mainBillId), new QFilter("entry.e_billid", "=", (Object)asstBillId)});
        KDAssert.assertEquals((String)"\u5e94\u4ed8\u5355\u672a\u751f\u6210\u5bf9\u5e94\u6838\u9500\u8bb0\u5f55", (boolean)true, (verifyRecords.size() != 0 ? 1 : 0) != 0);
    }

    public static void validateApFinDetailData(DynamicObject detailRow, BigDecimal quantity, BigDecimal price, BigDecimal eTax, BigDecimal eAmount, BigDecimal eAmountBase, BigDecimal ePriceTaxTotal, BigDecimal ePriceTaxTotalBase) {
        KDAssert.assertEquals((String)"\u7269\u6599\u660e\u7ec6\u5206\u5f55\u6570\u91cf\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)quantity.compareTo(detailRow.getBigDecimal("quantity")));
        KDAssert.assertEquals((String)"\u7269\u6599\u660e\u7ec6\u5206\u5f55\u5355\u636e\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)price.compareTo(detailRow.getBigDecimal("price")));
        KDAssert.assertEquals((String)"\u7269\u6599\u660e\u7ec6\u5206\u5f55\u7a0e\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)eTax.compareTo(detailRow.getBigDecimal("e_tax")));
        KDAssert.assertEquals((String)"\u7269\u6599\u660e\u7ec6\u5206\u5f55\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)eAmount.compareTo(detailRow.getBigDecimal("e_amount")));
        KDAssert.assertEquals((String)"\u7269\u6599\u660e\u7ec6\u5206\u5f55\u91d1\u989d\u6298\u672c\u5e01\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)eAmountBase.compareTo(detailRow.getBigDecimal("e_amountbase")));
        KDAssert.assertEquals((String)"\u7269\u6599\u660e\u7ec6\u5206\u5f55\u5e94\u4ed8\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)ePriceTaxTotal.compareTo(detailRow.getBigDecimal("e_pricetaxtotal")));
        KDAssert.assertEquals((String)"\u7269\u6599\u660e\u7ec6\u5206\u5f55\u5e94\u4ed8\u91d1\u989d\u6298\u672c\u5e01\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)ePriceTaxTotalBase.compareTo(detailRow.getBigDecimal("e_pricetaxtotalbase")));
    }

    public static void validateApFinDetailLockAndSettleAmt(DynamicObject detailRow, BigDecimal lockedamt, BigDecimal unlockamt, BigDecimal settledamt, BigDecimal settledamtbase, BigDecimal unsettleamt, BigDecimal unsettleamtbase) {
        FinApBillTestChecker.validateApFinDetailLockAmt(detailRow, lockedamt, unlockamt);
        FinApBillTestChecker.validateApFinDetailSettleAmt(detailRow, settledamt, settledamtbase, unsettleamt, unsettleamtbase);
    }

    public static void validateApFinDetailLockAmt(DynamicObject detailRow, BigDecimal lockedamt, BigDecimal unlockamt) {
        KDAssert.assertEquals((String)"\u7269\u6599\u660e\u7ec6\u5206\u5f55\u5df2\u9501\u5b9a\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)lockedamt.compareTo(detailRow.getBigDecimal("lockedamt")));
        KDAssert.assertEquals((String)"\u7269\u6599\u660e\u7ec6\u5206\u5f55\u672a\u9501\u5b9a\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)unlockamt.compareTo(detailRow.getBigDecimal("unlockamt")));
    }

    public static void validateApFinDetailSettleAmt(DynamicObject detailRow, BigDecimal settledamt, BigDecimal settledamtbase, BigDecimal unsettleamt, BigDecimal unsettleamtbase) {
        KDAssert.assertEquals((String)"\u7269\u6599\u660e\u7ec6\u5206\u5f55\u5df2\u7ed3\u7b97\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)settledamt.compareTo(detailRow.getBigDecimal("settledamt")));
        KDAssert.assertEquals((String)"\u7269\u6599\u660e\u7ec6\u5206\u5f55\u5df2\u7ed3\u7b97\u6298\u672c\u5e01\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)settledamtbase.compareTo(detailRow.getBigDecimal("settledamtbase")));
        KDAssert.assertEquals((String)"\u7269\u6599\u660e\u7ec6\u5206\u5f55\u672a\u7ed3\u7b97\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)unsettleamt.compareTo(detailRow.getBigDecimal("unsettleamt")));
        KDAssert.assertEquals((String)"\u7269\u6599\u660e\u7ec6\u5206\u5f55\u672a\u7ed3\u7b97\u6298\u672c\u5e01\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)unsettleamtbase.compareTo(detailRow.getBigDecimal("unsettleamtbase")));
    }

    public static void validateApFinDetailVerifyData(DynamicObject detailRow, BigDecimal verifyquantity, BigDecimal unverifyquantity, BigDecimal verifyamount, BigDecimal e_unverifyamount) {
        KDAssert.assertEquals((String)"\u7269\u6599\u660e\u7ec6\u5206\u5f55\u5df2\u6838\u9500\u6570\u91cf\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)verifyquantity.compareTo(detailRow.getBigDecimal("verifyquantity")));
        KDAssert.assertEquals((String)"\u7269\u6599\u660e\u7ec6\u5206\u5f55\u672a\u6838\u9500\u6570\u91cf\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)unverifyquantity.compareTo(detailRow.getBigDecimal("unverifyquantity")));
        KDAssert.assertEquals((String)"\u7269\u6599\u660e\u7ec6\u5206\u5f55\u5df2\u6838\u9500\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)verifyamount.compareTo(detailRow.getBigDecimal("verifyamount")));
        KDAssert.assertEquals((String)"\u7269\u6599\u660e\u7ec6\u5206\u5f55\u672a\u6838\u9500\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)e_unverifyamount.compareTo(detailRow.getBigDecimal("e_unverifyamount")));
    }

    public static void validateApFinPlanEntry(DynamicObject planRow, BigDecimal planpricetax, BigDecimal planpricetaxloc, BigDecimal planlockedamt, BigDecimal unplanlockamt, BigDecimal plansettledamt, BigDecimal plansettledlocamt, BigDecimal unplansettleamt, BigDecimal unplansettlelocamt) {
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u5206\u5f55\u5e94\u4ed8\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)planpricetax.compareTo(planRow.getBigDecimal("planpricetax")));
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u5206\u5f55\u5e94\u4ed8\u91d1\u989d\u6298\u672c\u5e01\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)planpricetaxloc.compareTo(planRow.getBigDecimal("planpricetaxloc")));
        FinApBillTestChecker.validateApFinPlanLockAmt(planRow, planlockedamt, unplanlockamt);
        FinApBillTestChecker.validateApFinPlanSettleAmt(planRow, plansettledamt, plansettledlocamt, unplansettleamt, unplansettlelocamt);
    }

    public static void validateApFinPlanLockAndSettleAmt(DynamicObject planRow, BigDecimal planlockedamt, BigDecimal unplanlockamt, BigDecimal plansettledamt, BigDecimal plansettledlocamt, BigDecimal unplansettleamt, BigDecimal unplansettlelocamt) {
        FinApBillTestChecker.validateApFinPlanLockAmt(planRow, planlockedamt, unplanlockamt);
        FinApBillTestChecker.validateApFinPlanSettleAmt(planRow, plansettledamt, plansettledlocamt, unplansettleamt, unplansettlelocamt);
    }

    public static void validateApFinPlanLockAmt(DynamicObject planRow, BigDecimal planlockedamt, BigDecimal unplanlockamt) {
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u5206\u5f55\u9501\u5b9a\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)planlockedamt.compareTo(planRow.getBigDecimal("planlockedamt")));
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u5206\u5f55\u672a\u9501\u5b9a\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)unplanlockamt.compareTo(planRow.getBigDecimal("unplanlockamt")));
    }

    public static void validateApFinPlanSettleAmt(DynamicObject planRow, BigDecimal plansettledamt, BigDecimal plansettledlocamt, BigDecimal unplansettleamt, BigDecimal unplansettlelocamt) {
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u5206\u5f55\u5df2\u7ed3\u7b97\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)plansettledamt.compareTo(planRow.getBigDecimal("plansettledamt")));
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u5206\u5f55\u5df2\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)plansettledlocamt.compareTo(planRow.getBigDecimal("plansettledlocamt")));
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u5206\u5f55\u672a\u7ed3\u7b97\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)unplansettleamt.compareTo(planRow.getBigDecimal("unplansettleamt")));
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u5206\u5f55\u672a\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)unplansettlelocamt.compareTo(planRow.getBigDecimal("unplansettlelocamt")));
    }

    public static void validateInitialApFin(DynamicObject finBill) {
        KDAssert.assertEquals((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u5e94\u4e3a\u672a\u7ed3\u7b97", (String)"unsettle", (String)finBill.getString("settlestatus"));
        FinApBillTestChecker.validateApFinHeadVerifyData(finBill, "10", finBill.getBigDecimal("pricetaxtotal"));
        FinApBillTestChecker.validateApFinHeadSettleAmt(finBill, finBill.getBigDecimal("pricetaxtotal"), finBill.getBigDecimal("pricetaxtotalbase"), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
        for (DynamicObject detailRow : detailEntry) {
            FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailRow, BigDecimal.ZERO, detailRow.getBigDecimal("e_pricetaxtotal"), BigDecimal.ZERO, BigDecimal.ZERO, detailRow.getBigDecimal("e_pricetaxtotal"), detailRow.getBigDecimal("e_pricetaxtotalbase"));
            FinApBillTestChecker.validateApFinDetailVerifyData(detailRow, BigDecimal.ZERO, detailRow.getBigDecimal("quantity"), BigDecimal.ZERO, detailRow.getBigDecimal("e_pricetaxtotal"));
        }
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planRow : planEntity) {
            FinApBillTestChecker.validateApFinPlanEntry(planRow, planRow.getBigDecimal("planpricetax"), planRow.getBigDecimal("planpricetaxloc"), BigDecimal.ZERO, planRow.getBigDecimal("planpricetax"), BigDecimal.ZERO, BigDecimal.ZERO, planRow.getBigDecimal("planpricetax"), planRow.getBigDecimal("planpricetaxloc"));
        }
    }

    public static void validateInitialApFin(long finBillId) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ap_finapbill");
        FinApBillTestChecker.validateInitialApFin(finBill);
    }

    public static void validateFinishApFin(DynamicObject finBill, boolean isSettle, boolean isVerify) {
        BigDecimal priceTaxTotal = finBill.getBigDecimal("pricetaxtotal");
        BigDecimal priceTaxTotalBase = finBill.getBigDecimal("pricetaxtotalbase");
        if (isSettle) {
            KDAssert.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u7ed3\u7b97\u72b6\u6001\u5e94\u4e3a\u5168\u90e8\u7ed3\u7b97", (String)"settled", (String)finBill.getString("settlestatus"));
            FinApBillTestChecker.validateApFinHeadSettleAmt(finBill, BigDecimal.ZERO, BigDecimal.ZERO, priceTaxTotal, priceTaxTotalBase);
            FinApBillTestChecker.validateFinApFullLockData(finBill);
        } else {
            KDAssert.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u7ed3\u7b97\u72b6\u6001\u5e94\u4e3a\u672a\u7ed3\u7b97", (String)"unsettle", (String)finBill.getString("settlestatus"));
            FinApBillTestChecker.validateApFinHeadSettleAmt(finBill, priceTaxTotal, priceTaxTotalBase, BigDecimal.ZERO, BigDecimal.ZERO);
        }
        if (isVerify) {
            FinApBillTestChecker.validateApFinHeadVerifyData(finBill, "30", BigDecimal.ZERO);
        } else {
            FinApBillTestChecker.validateApFinHeadVerifyData(finBill, "10", priceTaxTotal);
        }
        DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        for (DynamicObject detail : detailEntry) {
            BigDecimal ePriceTaxTotal = detail.getBigDecimal("e_pricetaxtotal");
            BigDecimal ePriceTaxTotalBase = detail.getBigDecimal("e_pricetaxtotalbase");
            if (isSettle) {
                FinApBillTestChecker.validateApFinDetailSettleAmt(detail, ePriceTaxTotal, ePriceTaxTotalBase, BigDecimal.ZERO, BigDecimal.ZERO);
            } else {
                FinApBillTestChecker.validateApFinDetailSettleAmt(detail, BigDecimal.ZERO, BigDecimal.ZERO, ePriceTaxTotal, ePriceTaxTotalBase);
            }
            if (isVerify) {
                FinApBillTestChecker.validateApFinDetailVerifyData(detail, detail.getBigDecimal("quantity"), BigDecimal.ZERO, ePriceTaxTotal, BigDecimal.ZERO);
                continue;
            }
            FinApBillTestChecker.validateApFinDetailVerifyData(detail, BigDecimal.ZERO, detail.getBigDecimal("quantity"), BigDecimal.ZERO, ePriceTaxTotal);
        }
        for (DynamicObject plan : planEntity) {
            BigDecimal planPriceTax = plan.getBigDecimal("planpricetax");
            BigDecimal planPriceTaxLoc = plan.getBigDecimal("planpricetaxloc");
            if (isSettle) {
                FinApBillTestChecker.validateApFinPlanSettleAmt(plan, planPriceTax, planPriceTaxLoc, BigDecimal.ZERO, BigDecimal.ZERO);
                continue;
            }
            FinApBillTestChecker.validateApFinPlanSettleAmt(plan, BigDecimal.ZERO, BigDecimal.ZERO, planPriceTax, planPriceTaxLoc);
        }
    }

    public static void validateFinishApFin(long finBillId, boolean isSettle, boolean isVerify) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ap_finapbill");
        FinApBillTestChecker.validateFinishApFin(finBill, isSettle, isVerify);
    }

    public static void validateFinApSettledBill(DynamicObject finBill) {
        BigDecimal priceTaxTotal = finBill.getBigDecimal("pricetaxtotal");
        BigDecimal priceTaxTotalBase = finBill.getBigDecimal("pricetaxtotalbase");
        FinApBillTestChecker.validateApFinHeadSettleStatus(finBill, "settled");
        FinApBillTestChecker.validateApFinHeadSettleAmt(finBill, BigDecimal.ZERO, BigDecimal.ZERO, priceTaxTotal, priceTaxTotalBase);
        DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        for (DynamicObject detail : detailEntry) {
            BigDecimal ePriceTaxTotal = detail.getBigDecimal("e_pricetaxtotal");
            BigDecimal ePriceTaxTotalBase = detail.getBigDecimal("e_pricetaxtotalbase");
            FinApBillTestChecker.validateApFinDetailLockAmt(detail, ePriceTaxTotal, BigDecimal.ZERO);
            FinApBillTestChecker.validateApFinDetailSettleAmt(detail, ePriceTaxTotal, ePriceTaxTotalBase, BigDecimal.ZERO, BigDecimal.ZERO);
        }
        for (DynamicObject plan : planEntity) {
            BigDecimal planPriceTax = plan.getBigDecimal("planpricetax");
            BigDecimal planPriceTaxLoc = plan.getBigDecimal("planpricetaxloc");
            FinApBillTestChecker.validateApFinPlanLockAmt(plan, planPriceTax, BigDecimal.ZERO);
            FinApBillTestChecker.validateApFinPlanSettleAmt(plan, planPriceTax, planPriceTaxLoc, BigDecimal.ZERO, BigDecimal.ZERO);
        }
    }

    public static void validateFinApSettledBill(long finBillId) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ap_finapbill");
        FinApBillTestChecker.validateFinApSettledBill(finBill);
    }

    public static void validateFinApFullLockData(DynamicObject finBill) {
        DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        detailEntry.forEach(detail -> FinApBillTestChecker.validateApFinDetailLockAmt(detail, detail.getBigDecimal("e_pricetaxtotal"), BigDecimal.ZERO));
        planEntity.forEach(plan -> FinApBillTestChecker.validateApFinPlanLockAmt(plan, plan.getBigDecimal("planpricetax"), BigDecimal.ZERO));
    }

    public static void validateFinApFullLockData(long finBillId) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ap_finapbill");
        FinApBillTestChecker.validateFinApFullLockData(finBill);
    }

    public static void validateApFinJournalData(DynamicObject bill) {
        String selector = "org,asstacttype,asstact,currency,basecurrency,payableamt,localpayableamt,sourcebilltype";
        DynamicObject journal = BusinessDataServiceHelper.loadSingle((String)"ap_journal", (String)selector, (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)bill.getLong("id"))});
        KDAssert.assertEquals((String)"\u6d41\u6c34\u4e0d\u5b58\u5728", (boolean)true, (journal != null ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u6838\u7b97\u4e3b\u4f53\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0d\u4e00\u81f4", (boolean)true, (bill.getLong("org.id") == journal.getLong("org.id") ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u5f80\u6765\u7c7b\u578b\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0d\u4e00\u81f4", (boolean)true, (boolean)bill.getString("asstacttype").equals(journal.getString("asstacttype")));
        KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u5f80\u6765\u6237\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0d\u4e00\u81f4", (boolean)true, (bill.getLong("asstact.masterid") == journal.getLong("asstact.masterid") ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u5e01\u522b\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0d\u4e00\u81f4", (boolean)true, (bill.getLong("currency.id") == journal.getLong("currency.id") ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u672c\u4f4d\u5e01\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0d\u4e00\u81f4", (boolean)true, (bill.getLong("basecurrency.id") == journal.getLong("basecurrency.id") ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u5e94\u4ed8\u91d1\u989d\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0d\u4e00\u81f4", (int)0, (int)bill.getBigDecimal("pricetaxtotal").compareTo(journal.getBigDecimal("payableamt")));
        KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u5e94\u4ed8\u91d1\u989d\u6298\u672c\u5e01\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0d\u4e00\u81f4", (int)0, (int)bill.getBigDecimal("pricetaxtotalbase").compareTo(journal.getBigDecimal("localpayableamt")));
    }

    public static void validateApFinJournalExist(DynamicObject bill) {
        KDAssert.assertEquals((String)"\u53cd\u5ba1\u6838\u6ca1\u6709\u5220\u9664\u6d41\u6c34\u3002", (boolean)false, (boolean)QueryServiceHelper.exists((String)"ap_journal", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)bill.getLong("id"))}));
    }

    public static void validateApFinHead(DynamicObject bill) {
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
        BigDecimal taxSum = BigDecimal.ZERO;
        BigDecimal amountSum = BigDecimal.ZERO;
        BigDecimal amountBaseSum = BigDecimal.ZERO;
        BigDecimal priceTaxTotalSum = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBaseSum = BigDecimal.ZERO;
        BigDecimal unVerifyAmountSum = BigDecimal.ZERO;
        BigDecimal unSettleAmtSum = BigDecimal.ZERO;
        BigDecimal unSettleAmtBaseSum = BigDecimal.ZERO;
        BigDecimal settledAmtSum = BigDecimal.ZERO;
        BigDecimal settledAmtBaseSum = BigDecimal.ZERO;
        BigDecimal unInvoicedAmtSum = BigDecimal.ZERO;
        BigDecimal adjustAmountSum = BigDecimal.ZERO;
        BigDecimal adjustLocalAmtSum = BigDecimal.ZERO;
        for (DynamicObject row : entry) {
            BigDecimal tax = row.getBigDecimal("e_tax");
            BigDecimal amount = row.getBigDecimal("e_amount");
            BigDecimal amountBase = row.getBigDecimal("e_amountbase");
            BigDecimal priceTaxTotal = row.getBigDecimal("e_pricetaxtotal");
            BigDecimal priceTaxTotalBase = row.getBigDecimal("e_pricetaxtotalbase");
            BigDecimal unVerifyAmount = row.getBigDecimal("e_unverifyamount");
            BigDecimal unSettleAmt = row.getBigDecimal("unsettleamt");
            BigDecimal unSettleAmtBase = row.getBigDecimal("unsettleamtbase");
            BigDecimal settledAmt = row.getBigDecimal("settledamt");
            BigDecimal settledAmtBase = row.getBigDecimal("settledamtbase");
            BigDecimal unInvoicedAmt = row.getBigDecimal("e_uninvoicedamt");
            BigDecimal adjustAmount = row.getBigDecimal("e_adjustamount");
            BigDecimal adjustLocalAmt = row.getBigDecimal("e_adjustlocalamt");
            taxSum = taxSum.add(tax);
            amountSum = amountSum.add(amount);
            amountBaseSum = amountBaseSum.add(amountBase);
            priceTaxTotalSum = priceTaxTotalSum.add(priceTaxTotal);
            priceTaxTotalBaseSum = priceTaxTotalBaseSum.add(priceTaxTotalBase);
            unVerifyAmountSum = unVerifyAmountSum.add(unVerifyAmount);
            unSettleAmtSum = unSettleAmtSum.add(unSettleAmt);
            unSettleAmtBaseSum = unSettleAmtBaseSum.add(unSettleAmtBase);
            settledAmtSum = settledAmtSum.add(settledAmt);
            settledAmtBaseSum = settledAmtBaseSum.add(settledAmtBase);
            unInvoicedAmtSum = unInvoicedAmtSum.add(unInvoicedAmt);
            adjustAmountSum = adjustAmountSum.add(adjustAmount);
            adjustLocalAmtSum = adjustLocalAmtSum.add(adjustLocalAmt);
        }
        String billno = bill.getString("billno");
        if (unSettleAmtSum.compareTo(BigDecimal.ZERO) == 0) {
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + billno + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u7ed3\u7b97\u72b6\u6001\u9519\u8bef"), (String)"settled", (String)bill.getString("settlestatus"));
        } else if (unSettleAmtSum.compareTo(priceTaxTotalSum) == 0) {
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + billno + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u7ed3\u7b97\u72b6\u6001\u9519\u8bef"), (String)"unsettle", (String)bill.getString("settlestatus"));
        } else {
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + billno + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u7ed3\u7b97\u72b6\u6001\u9519\u8bef"), (String)"partsettle", (String)bill.getString("settlestatus"));
        }
        if (unVerifyAmountSum.compareTo(BigDecimal.ZERO) == 0) {
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + billno + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u6838\u9500\u72b6\u6001\u9519\u8bef"), (String)"30", (String)bill.getString("verifystatus"));
        } else if (unVerifyAmountSum.compareTo(amountSum) == 0) {
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + billno + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u6838\u9500\u72b6\u6001\u9519\u8bef"), (String)"10", (String)bill.getString("verifystatus"));
        } else {
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + billno + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u6838\u9500\u72b6\u6001\u9519\u8bef"), (String)"20", (String)bill.getString("verifystatus"));
        }
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + billno + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u7a0e\u989d\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u6c47\u603b\u4e0d\u76f8\u7b49"), (int)0, (int)taxSum.compareTo(bill.getBigDecimal("tax")));
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + billno + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u91d1\u989d\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u6c47\u603b\u4e0d\u76f8\u7b49"), (int)0, (int)amountSum.compareTo(bill.getBigDecimal("amount")));
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + billno + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u91d1\u989d\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u6c47\u603b\u4e0d\u76f8\u7b49"), (int)0, (int)amountBaseSum.compareTo(bill.getBigDecimal("amountbase")));
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + billno + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u5e94\u4ed8\u91d1\u989d\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u6c47\u603b\u4e0d\u76f8\u7b49"), (int)0, (int)priceTaxTotalSum.compareTo(bill.getBigDecimal("pricetaxtotal")));
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + billno + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u5e94\u4ed8\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u6c47\u603b\u4e0d\u76f8\u7b49"), (int)0, (int)priceTaxTotalBaseSum.compareTo(bill.getBigDecimal("pricetaxtotalbase")));
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + billno + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u672a\u7ed3\u7b97\u91d1\u989d\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u6c47\u603b\u4e0d\u76f8\u7b49"), (int)0, (int)unSettleAmtSum.compareTo(bill.getBigDecimal("unsettleamount")));
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + billno + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u672a\u7ed3\u7b97\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u6c47\u603b\u4e0d\u76f8\u7b49"), (int)0, (int)unSettleAmtBaseSum.compareTo(bill.getBigDecimal("unsettleamountbase")));
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + billno + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u5df2\u7ed3\u7b97\u91d1\u989d\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u6c47\u603b\u4e0d\u76f8\u7b49"), (int)0, (int)settledAmtSum.compareTo(bill.getBigDecimal("settleamount")));
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + billno + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u5df2\u7ed3\u7b97\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u6c47\u603b\u4e0d\u76f8\u7b49"), (int)0, (int)settledAmtBaseSum.compareTo(bill.getBigDecimal("settleamountbase")));
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + billno + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u672a\u6838\u9500\u91d1\u989d\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u6c47\u603b\u4e0d\u76f8\u7b49"), (int)0, (int)unVerifyAmountSum.compareTo(bill.getBigDecimal("unverifyamount")));
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + billno + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u672a\u5f00\u7968\u91d1\u989d\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u6c47\u603b\u4e0d\u76f8\u7b49"), (int)0, (int)unInvoicedAmtSum.compareTo(bill.getBigDecimal("uninvoicedamt")));
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + billno + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u62b5\u6d88\u91d1\u989d\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u6c47\u603b\u4e0d\u76f8\u7b49"), (int)0, (int)adjustAmountSum.compareTo(bill.getBigDecimal("adjustamount")));
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + billno + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u62b5\u6d88\u91d1\u989d\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u6c47\u603b\u4e0d\u76f8\u7b49"), (int)0, (int)adjustLocalAmtSum.compareTo(bill.getBigDecimal("adjustlocalamt")));
    }
}

