/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.check;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.unittest.framework.KDAssert;

public class FinArBillTestChecker {
    public static void validateHeadSettleStatus(DynamicObject finBill, String execptStatus) {
        KDAssert.assertEquals((String)"\u5e94\u6536\u5355\u8868\u5934\u7ed3\u7b97\u72b6\u6001\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (String)execptStatus, (String)finBill.getString("settlestatus"));
    }

    public static void validateHeadSettleAmt(DynamicObject finArBill, BigDecimal expectedSettleAmt, BigDecimal expectedLocalAmt, BigDecimal expectedUnSettleAmt, BigDecimal expectedUnLocalAmt) {
        BigDecimal settledAmt = finArBill.getBigDecimal("settleamount");
        FinArBillTestChecker.assertEquals("\u8868\u5934\u7ed3\u7b97\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedSettleAmt.compareTo(settledAmt));
        BigDecimal settledLocalAmt = finArBill.getBigDecimal("settlelocalamt");
        FinArBillTestChecker.assertEquals("\u8868\u5934\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u6821\u9a8c\u5f02\u5e38", 0, expectedLocalAmt.compareTo(settledLocalAmt));
        BigDecimal unSettleAmt = finArBill.getBigDecimal("unsettleamount");
        FinArBillTestChecker.assertEquals("\u8868\u5934\u672a\u7ed3\u7b97\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedUnSettleAmt.compareTo(unSettleAmt));
        BigDecimal unSettleLocalAmt = finArBill.getBigDecimal("unsettlelocalamt");
        FinArBillTestChecker.assertEquals("\u8868\u5934\u672a\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u6821\u9a8c\u5f02\u5e38", 0, expectedUnLocalAmt.compareTo(unSettleLocalAmt));
    }

    public static void validateDetailEntryLockAmt(DynamicObject detailEntryRow, BigDecimal expectedLockAmt, BigDecimal expectedUnLockAmt) {
        BigDecimal lockedAmount = detailEntryRow.getBigDecimal("e_lockedamt");
        FinArBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u9501\u5b9a\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedLockAmt.compareTo(lockedAmount));
        BigDecimal unLockedAmount = detailEntryRow.getBigDecimal("e_unlockamt");
        FinArBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u672a\u9501\u5b9a\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedUnLockAmt.compareTo(unLockedAmount));
    }

    public static void validateDetailEntrySettleAmt(DynamicObject detailEntryRow, BigDecimal expectedSettleAmt, BigDecimal expectedSettleLocalAmt, BigDecimal expectedUnSettleAmt, BigDecimal expectedUnSettleLocalAmt) {
        BigDecimal settleAmount = detailEntryRow.getBigDecimal("e_settledamt");
        FinArBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u7ed3\u7b97\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedSettleAmt.compareTo(settleAmount));
        BigDecimal settleLocalAmount = detailEntryRow.getBigDecimal("e_settledlocalamt");
        FinArBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u6821\u9a8c\u5f02\u5e38", 0, expectedSettleLocalAmt.compareTo(settleLocalAmount));
        BigDecimal unSettleAmount = detailEntryRow.getBigDecimal("e_unsettleamt");
        FinArBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedUnSettleAmt.compareTo(unSettleAmount));
        BigDecimal unSettleLocalAmount = detailEntryRow.getBigDecimal("e_unsettlelocalamt");
        FinArBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u6821\u9a8c\u5f02\u5e38", 0, expectedUnSettleLocalAmt.compareTo(unSettleLocalAmount));
    }

    public static void validateDetailLockAndSettleAmt(DynamicObject detailRow, BigDecimal lockedamt, BigDecimal unlockamt, BigDecimal settledamt, BigDecimal settledamtbase, BigDecimal unsettleamt, BigDecimal unsettleamtbase) {
        FinArBillTestChecker.validateDetailEntryLockAmt(detailRow, lockedamt, unlockamt);
        FinArBillTestChecker.validateDetailEntrySettleAmt(detailRow, settledamt, settledamtbase, unsettleamt, unsettleamtbase);
    }

    public static void validatePlanEntryLockAmt(DynamicObject planEntryRow, BigDecimal expectedLockAmt, BigDecimal expectedUnLockAmt) {
        BigDecimal lockedAmount = planEntryRow.getBigDecimal("planlockedamt");
        FinArBillTestChecker.assertEquals("\u8ba1\u5212\u884c\u9501\u5b9a\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedLockAmt.compareTo(lockedAmount));
        BigDecimal unLockedAmount = planEntryRow.getBigDecimal("unplanlockamt");
        FinArBillTestChecker.assertEquals("\u8ba1\u5212\u884c\u672a\u9501\u5b9a\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedUnLockAmt.compareTo(unLockedAmount));
    }

    public static void validatePlanEntrySettleAmt(DynamicObject planEntryRow, BigDecimal expectedSettleAmt, BigDecimal expectedSettleLocalAmt, BigDecimal expectedUnSettleAmt, BigDecimal expectedUnSettleLocalAmt) {
        BigDecimal settledAmount = planEntryRow.getBigDecimal("plansettledamt");
        FinArBillTestChecker.assertEquals("\u8ba1\u5212\u884c\u7ed3\u7b97\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedSettleAmt.compareTo(settledAmount));
        BigDecimal settledLocalAmount = planEntryRow.getBigDecimal("plansettledlocamt");
        FinArBillTestChecker.assertEquals("\u8ba1\u5212\u884c\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u6821\u9a8c\u5f02\u5e38", 0, expectedSettleLocalAmt.compareTo(settledLocalAmount));
        BigDecimal unSettledAmount = planEntryRow.getBigDecimal("unplansettleamt");
        FinArBillTestChecker.assertEquals("\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedUnSettleAmt.compareTo(unSettledAmount));
        BigDecimal unSettleLocalAmount = planEntryRow.getBigDecimal("unplansettlelocamt");
        FinArBillTestChecker.assertEquals("\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u6821\u9a8c\u5f02\u5e38", 0, expectedUnSettleLocalAmt.compareTo(unSettleLocalAmount));
    }

    public static void validatePlanLockAndSettleAmt(DynamicObject planRow, BigDecimal planlockedamt, BigDecimal unplanlockamt, BigDecimal plansettledamt, BigDecimal plansettledlocamt, BigDecimal unplansettleamt, BigDecimal unplansettlelocamt) {
        FinArBillTestChecker.validatePlanEntryLockAmt(planRow, planlockedamt, unplanlockamt);
        FinArBillTestChecker.validatePlanEntrySettleAmt(planRow, plansettledamt, plansettledlocamt, unplansettleamt, unplansettlelocamt);
    }

    public static void validateDetailEntryConfirmAmt(DynamicObject detailEntryRow, BigDecimal expectedConfirmAmt, BigDecimal expectedUnConfirmAmt) {
        BigDecimal confirmAmount = detailEntryRow.getBigDecimal("e_confirmedamt");
        FinArBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u786e\u8ba4\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedConfirmAmt.compareTo(confirmAmount));
        BigDecimal unConfirmAmount = detailEntryRow.getBigDecimal("e_unconfirmamt");
        FinArBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u672a\u786e\u8ba4\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedUnConfirmAmt.compareTo(unConfirmAmount));
    }

    public static void validateDetailEntryVerify(DynamicObject detailEntryRow, BigDecimal expectedVerifyQty, BigDecimal expectedVerifyAmt, BigDecimal expectedUnVerifyQty, BigDecimal expectedUnVerifyAmt) {
        BigDecimal verifyQty = detailEntryRow.getBigDecimal("e_verifiedqty");
        FinArBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u6838\u9500\u6570\u91cf\u6821\u9a8c\u5f02\u5e38", 0, expectedVerifyQty.compareTo(verifyQty));
        BigDecimal unVerifyQty = detailEntryRow.getBigDecimal("e_unverifyqty");
        FinArBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u672a\u6838\u9500\u6570\u91cf\u6821\u9a8c\u5f02\u5e38", 0, expectedUnVerifyQty.compareTo(unVerifyQty));
        BigDecimal verifyAmt = detailEntryRow.getBigDecimal("e_verifiedamt");
        FinArBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u6838\u9500\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedVerifyAmt.compareTo(verifyAmt));
        BigDecimal unVerifyAmt = detailEntryRow.getBigDecimal("e_unverifyamt");
        FinArBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u672a\u6838\u9500\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", 0, expectedUnVerifyAmt.compareTo(unVerifyAmt));
    }

    public static void validateInitialArFin(long finBillId) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ar_finarbill");
        FinArBillTestChecker.validateInitialBill(finBill);
    }

    public static void validateInitialBill(DynamicObject finBill) {
        KDAssert.assertEquals((String)"\u8d22\u52a1\u5e94\u6536\u5355\u5e94\u4e3a\u672a\u7ed3\u7b97", (String)"unsettle", (String)finBill.getString("settlestatus"));
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.ZERO, BigDecimal.ZERO, finBill.getBigDecimal("recamount"), finBill.getBigDecimal("reclocalamt"));
        DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("entry");
        for (DynamicObject detailRow : detailEntry) {
            BigDecimal recAmt = detailRow.getBigDecimal("e_recamount");
            BigDecimal recLocalAmt = detailRow.getBigDecimal("e_reclocalamt");
            FinArBillTestChecker.validateDetailLockAndSettleAmt(detailRow, BigDecimal.ZERO, recAmt, BigDecimal.ZERO, BigDecimal.ZERO, recAmt, recLocalAmt);
        }
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planRow : planEntity) {
            BigDecimal recAmt = planRow.getBigDecimal("planpricetax");
            BigDecimal recLocalAmt = planRow.getBigDecimal("planpricetaxloc");
            FinArBillTestChecker.validatePlanLockAndSettleAmt(planRow, BigDecimal.ZERO, recAmt, BigDecimal.ZERO, BigDecimal.ZERO, recAmt, recLocalAmt);
        }
    }

    public static void validateFinishBill(DynamicObject finBill, boolean isSettle, boolean isVerify) {
        BigDecimal pricetaxtotal = finBill.getBigDecimal("recamount");
        BigDecimal pricetaxtotalbase = finBill.getBigDecimal("reclocalamt");
        if (isSettle) {
            KDAssert.assertEquals((String)"\u5e94\u6536\u5355\u8868\u5934\u7ed3\u7b97\u72b6\u6001\u5e94\u4e3a\u5168\u90e8\u7ed3\u7b97", (String)"settled", (String)finBill.getString("settlestatus"));
            FinArBillTestChecker.validateHeadSettleAmt(finBill, pricetaxtotal, pricetaxtotalbase, BigDecimal.ZERO, BigDecimal.ZERO);
        }
        DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("entry");
        for (DynamicObject detail : detailEntry) {
            BigDecimal ePricetTaxTotal = detail.getBigDecimal("e_recamount");
            BigDecimal ePriceTaxTotalBase = detail.getBigDecimal("e_reclocalamt");
            if (!isSettle) continue;
            FinArBillTestChecker.validateDetailEntryLockAmt(detail, ePricetTaxTotal, BigDecimal.ZERO);
            FinArBillTestChecker.validateDetailEntrySettleAmt(detail, ePricetTaxTotal, ePriceTaxTotalBase, BigDecimal.ZERO, BigDecimal.ZERO);
        }
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        for (DynamicObject plan : planEntity) {
            BigDecimal planpricetax = plan.getBigDecimal("planpricetax");
            BigDecimal planpricetaxloc = plan.getBigDecimal("planpricetaxloc");
            if (!isSettle) continue;
            FinArBillTestChecker.validatePlanEntryLockAmt(plan, planpricetax, BigDecimal.ZERO);
            FinArBillTestChecker.validatePlanEntrySettleAmt(plan, planpricetax, planpricetaxloc, BigDecimal.ZERO, BigDecimal.ZERO);
        }
    }

    private static void assertEquals(String message, Object expected, Object actual) {
        KDAssert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public static void chekcFinArInvoiceAmt(String message, DynamicObject billInfo, BigDecimal invoicedamt, BigDecimal uninvoicedamt, BigDecimal e_invoicedqty1, BigDecimal e_uninvoicedqty1, BigDecimal e_invoicedamt1, BigDecimal e_uninvoicedamt1, BigDecimal e_invoicedqty2, BigDecimal e_uninvoicedqty2, BigDecimal e_invoicedamt2, BigDecimal e_uninvoicedamt2) {
        BigDecimal invoicedamt_local = billInfo.getBigDecimal("invoicedamt");
        BigDecimal uninvoicedamt_local = billInfo.getBigDecimal("uninvoicedamt");
        KDAssert.assertEquals((String)String.format(message + "\u8868\u5934\u5df2\u5173\u8054\u5f00\u7968\u91d1\u989d\u4e0d\u6b63\u786e\u3002\u53d6\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", invoicedamt_local, invoicedamt), (boolean)true, (invoicedamt_local.compareTo(invoicedamt) == 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)String.format(message + "\u8868\u5934\u672a\u5173\u8054\u5f00\u7968\u91d1\u989d\u4e0d\u6b63\u786e\u3002\u53d6\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", uninvoicedamt_local, uninvoicedamt), (boolean)true, (uninvoicedamt_local.compareTo(uninvoicedamt) == 0 ? 1 : 0) != 0);
        DynamicObjectCollection entryCol = billInfo.getDynamicObjectCollection("entry");
        for (DynamicObject entryInfo : entryCol) {
            int seq = entryInfo.getInt("seq");
            switch (seq) {
                case 1: {
                    BigDecimal e_invoicedqty_1 = entryInfo.getBigDecimal("e_invoicedqty");
                    BigDecimal e_uninvoicedqty_1 = entryInfo.getBigDecimal("e_uninvoicedqty");
                    BigDecimal e_invoicedamt_1 = entryInfo.getBigDecimal("e_invoicedamt");
                    BigDecimal e_uninvoicedamt_1 = entryInfo.getBigDecimal("e_uninvoicedamt");
                    if (e_invoicedqty1 != null) {
                        KDAssert.assertEquals((String)String.format(message + "\u5206\u5f551\u5df2\u5173\u8054\u5f00\u7968\u6570\u91cf\u4e0d\u6b63\u786e\u3002\u53d6\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_invoicedqty_1, e_invoicedqty1), (boolean)true, (e_invoicedqty_1.compareTo(e_invoicedqty1) == 0 ? 1 : 0) != 0);
                    }
                    if (e_uninvoicedqty1 != null) {
                        KDAssert.assertEquals((String)String.format(message + "\u5206\u5f551\u672a\u5173\u8054\u5f00\u7968\u6570\u91cf\u4e0d\u6b63\u786e\u3002\u53d6\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_uninvoicedqty_1, e_uninvoicedqty1), (boolean)true, (e_uninvoicedqty_1.compareTo(e_uninvoicedqty1) == 0 ? 1 : 0) != 0);
                    }
                    KDAssert.assertEquals((String)String.format(message + "\u5206\u5f551\u5df2\u5173\u8054\u5f00\u7968\u91d1\u989d\u4e0d\u6b63\u786e\u3002\u53d6\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_invoicedamt_1, e_invoicedamt1), (boolean)true, (e_invoicedamt_1.compareTo(e_invoicedamt1) == 0 ? 1 : 0) != 0);
                    KDAssert.assertEquals((String)String.format(message + "\u5206\u5f551\u672a\u5173\u8054\u5f00\u7968\u91d1\u989d\u4e0d\u6b63\u786e\u3002\u53d6\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_uninvoicedamt_1, e_uninvoicedamt1), (boolean)true, (e_uninvoicedamt_1.compareTo(e_uninvoicedamt1) == 0 ? 1 : 0) != 0);
                    break;
                }
                case 2: {
                    BigDecimal e_invoicedqty_2 = entryInfo.getBigDecimal("e_invoicedqty");
                    BigDecimal e_uninvoicedqty_2 = entryInfo.getBigDecimal("e_uninvoicedqty");
                    BigDecimal e_invoicedamt_2 = entryInfo.getBigDecimal("e_invoicedamt");
                    BigDecimal e_uninvoicedamt_2 = entryInfo.getBigDecimal("e_uninvoicedamt");
                    if (e_invoicedqty2 != null) {
                        KDAssert.assertEquals((String)String.format(message + "\u5206\u5f552\u5df2\u5173\u8054\u5f00\u7968\u6570\u91cf\u4e0d\u6b63\u786e\u3002\u53d6\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_invoicedqty_2, e_invoicedqty2), (boolean)true, (e_invoicedqty_2.compareTo(e_invoicedqty2) == 0 ? 1 : 0) != 0);
                    }
                    if (e_uninvoicedqty2 != null) {
                        KDAssert.assertEquals((String)String.format(message + "\u5206\u5f552\u672a\u5173\u8054\u5f00\u7968\u6570\u91cf\u4e0d\u6b63\u786e\u3002\u53d6\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_uninvoicedqty_2, e_uninvoicedqty2), (boolean)true, (e_uninvoicedqty_2.compareTo(e_uninvoicedqty2) == 0 ? 1 : 0) != 0);
                    }
                    KDAssert.assertEquals((String)String.format(message + "\u5206\u5f552\u5df2\u5173\u8054\u5f00\u7968\u91d1\u989d\u4e0d\u6b63\u786e\u3002\u53d6\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_invoicedamt_2, e_invoicedamt2), (boolean)true, (e_invoicedamt_2.compareTo(e_invoicedamt2) == 0 ? 1 : 0) != 0);
                    KDAssert.assertEquals((String)String.format(message + "\u5206\u5f552\u672a\u5173\u8054\u5f00\u7968\u91d1\u989d\u4e0d\u6b63\u786e\u3002\u53d6\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_uninvoicedamt_2, e_uninvoicedamt2), (boolean)true, (e_uninvoicedamt_2.compareTo(e_uninvoicedamt2) == 0 ? 1 : 0) != 0);
                }
            }
        }
    }

    public static void checkEntryAmt(int currentIndex, BigDecimal comparePrice, BigDecimal compareAmt, IDataModel model) {
        BigDecimal exchangerate = (BigDecimal)model.getValue("exchangerate");
        BigDecimal e_unitprice = (BigDecimal)model.getValue("e_unitprice", currentIndex);
        BigDecimal e_taxunitprice = (BigDecimal)model.getValue("e_taxunitprice", currentIndex);
        BigDecimal e_actunitprice = (BigDecimal)model.getValue("e_actunitprice", currentIndex);
        BigDecimal e_acttaxunitprice = (BigDecimal)model.getValue("e_acttaxunitprice", currentIndex);
        BigDecimal e_amount = (BigDecimal)model.getValue("e_amount", currentIndex);
        BigDecimal e_localamt = (BigDecimal)model.getValue("e_localamt", currentIndex);
        BigDecimal e_recamount = (BigDecimal)model.getValue("e_recamount", currentIndex);
        BigDecimal e_reclocalamt = (BigDecimal)model.getValue("e_reclocalamt", currentIndex);
        BigDecimal e_settledamt = (BigDecimal)model.getValue("e_settledamt", currentIndex);
        BigDecimal e_settledlocalamt = (BigDecimal)model.getValue("e_settledlocalamt", currentIndex);
        BigDecimal e_unsettleamt = (BigDecimal)model.getValue("e_unsettleamt", currentIndex);
        BigDecimal e_unsettlelocalamt = (BigDecimal)model.getValue("e_unsettlelocalamt", currentIndex);
        BigDecimal e_lockedamt = (BigDecimal)model.getValue("e_lockedamt", currentIndex);
        BigDecimal e_unlockamt = (BigDecimal)model.getValue("e_unlockamt", currentIndex);
        KDAssert.assertEquals((String)String.format("\u7269\u6599\u884c\u5355\u4ef7\u6709\u8bef\uff0c\u5355\u636e\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_unitprice, comparePrice), (boolean)false, (e_unitprice.compareTo(comparePrice) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)String.format("\u7269\u6599\u884c\u542b\u7a0e\u5355\u4ef7\u6709\u8bef\uff0c\u5355\u636e\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_taxunitprice, comparePrice), (boolean)false, (e_taxunitprice.compareTo(comparePrice) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)String.format("\u7269\u6599\u884c\u5b9e\u9645\u5355\u4ef7\u6709\u8bef\uff0c\u5355\u636e\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_actunitprice, comparePrice), (boolean)false, (e_actunitprice.compareTo(comparePrice) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)String.format("\u7269\u6599\u884c\u5b9e\u9645\u542b\u7a0e\u5355\u4ef7\u6709\u8bef\uff0c\u5355\u636e\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_acttaxunitprice, comparePrice), (boolean)false, (e_acttaxunitprice.compareTo(comparePrice) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)String.format("\u7269\u6599\u884c\u91d1\u989d\u6709\u8bef\uff0c\u5355\u636e\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_amount, compareAmt), (boolean)false, (e_amount.compareTo(compareAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)String.format("\u7269\u6599\u884c\u91d1\u989d\u6298\u672c\u5e01\u6709\u8bef\uff0c\u5355\u636e\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_localamt, compareAmt.multiply(exchangerate)), (boolean)false, (e_localamt.compareTo(compareAmt.multiply(exchangerate)) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)String.format("\u7269\u6599\u884c\u5e94\u6536\u91d1\u989d\u6709\u8bef\uff0c\u5355\u636e\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_recamount, compareAmt), (boolean)false, (e_recamount.compareTo(compareAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)String.format("\u7269\u6599\u884c\u5e94\u6536\u91d1\u989d\u6298\u672c\u5e01\u6709\u8bef\uff0c\u5355\u636e\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_reclocalamt, compareAmt.multiply(exchangerate)), (boolean)false, (e_reclocalamt.compareTo(compareAmt.multiply(exchangerate)) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)String.format("\u7269\u6599\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u6709\u8bef\uff0c\u5355\u636e\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_settledamt, BigDecimal.ZERO), (boolean)false, (e_settledamt.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)String.format("\u7269\u6599\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u6709\u8bef\uff0c\u5355\u636e\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_settledlocalamt, BigDecimal.ZERO), (boolean)false, (e_settledlocalamt.compareTo(BigDecimal.ZERO.multiply(exchangerate)) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)String.format("\u7269\u6599\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u6709\u8bef\uff0c\u5355\u636e\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_unsettleamt, compareAmt), (boolean)false, (e_unsettleamt.compareTo(compareAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)String.format("\u7269\u6599\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u6709\u8bef\uff0c\u5355\u636e\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_unsettlelocalamt, compareAmt.multiply(exchangerate)), (boolean)false, (e_unsettlelocalamt.compareTo(compareAmt.multiply(exchangerate)) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)String.format("\u7269\u6599\u884c\u5df2\u9501\u5b9a\u91d1\u989d\u6709\u8bef\uff0c\u5355\u636e\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_lockedamt, BigDecimal.ZERO), (boolean)false, (e_lockedamt.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)String.format("\u7269\u6599\u884c\u672a\u9501\u5b9a\u91d1\u989d\u6709\u8bef\uff0c\u5355\u636e\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", e_unlockamt, compareAmt), (boolean)false, (e_unlockamt.compareTo(compareAmt) != 0 ? 1 : 0) != 0);
    }

    public static void checkDiscountEntryAmt(int currentIndex, BigDecimal comparePrice, BigDecimal compareAmt, BigDecimal compareRealPrice, BigDecimal compareDiscountAmt, IDataModel model) {
        BigDecimal exchangerate = (BigDecimal)model.getValue("exchangerate");
        BigDecimal e_unitprice = ((BigDecimal)model.getValue("e_unitprice", currentIndex)).setScale(2, 4);
        BigDecimal e_taxunitprice = ((BigDecimal)model.getValue("e_taxunitprice", currentIndex)).setScale(2, 4);
        BigDecimal e_actunitprice = ((BigDecimal)model.getValue("e_actunitprice", currentIndex)).setScale(2, 4);
        BigDecimal e_acttaxunitprice = ((BigDecimal)model.getValue("e_acttaxunitprice", currentIndex)).setScale(2, 4);
        BigDecimal e_amount = ((BigDecimal)model.getValue("e_amount", currentIndex)).setScale(2, 4);
        BigDecimal e_localamt = ((BigDecimal)model.getValue("e_localamt", currentIndex)).setScale(2, 4);
        BigDecimal e_recamount = ((BigDecimal)model.getValue("e_recamount", currentIndex)).setScale(2, 4);
        BigDecimal e_reclocalamt = ((BigDecimal)model.getValue("e_reclocalamt", currentIndex)).setScale(2, 4);
        BigDecimal e_discountamount = ((BigDecimal)model.getValue("e_discountamount", currentIndex)).setScale(2, 4);
        BigDecimal e_settledamt = ((BigDecimal)model.getValue("e_settledamt", currentIndex)).setScale(2, 4);
        BigDecimal e_settledlocalamt = ((BigDecimal)model.getValue("e_settledlocalamt", currentIndex)).setScale(2, 4);
        BigDecimal e_unsettleamt = ((BigDecimal)model.getValue("e_unsettleamt", currentIndex)).setScale(2, 4);
        BigDecimal e_unsettlelocalamt = ((BigDecimal)model.getValue("e_unsettlelocalamt", currentIndex)).setScale(2, 4);
        BigDecimal e_lockedamt = ((BigDecimal)model.getValue("e_lockedamt", currentIndex)).setScale(2, 4);
        BigDecimal e_unlockamt = ((BigDecimal)model.getValue("e_unlockamt", currentIndex)).setScale(2, 4);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5355\u4ef7\u6709\u8bef", (boolean)false, (e_unitprice.compareTo(comparePrice) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u542b\u7a0e\u5355\u4ef7\u6709\u8bef", (boolean)false, (e_taxunitprice.compareTo(comparePrice) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u91d1\u989d\u6709\u8bef", (boolean)false, (e_amount.compareTo(compareAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u91d1\u989d\u6298\u672c\u5e01\u6709\u8bef", (boolean)false, (e_localamt.compareTo(compareAmt.multiply(exchangerate)) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5e94\u6536\u91d1\u989d\u6709\u8bef", (boolean)false, (e_recamount.compareTo(compareAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5e94\u6536\u91d1\u989d\u6298\u672c\u5e01\u6709\u8bef", (boolean)false, (e_reclocalamt.compareTo(compareAmt.multiply(exchangerate)) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5b9e\u9645\u5355\u4ef7\u6709\u8bef", (boolean)false, (e_actunitprice.compareTo(compareRealPrice) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5b9e\u9645\u542b\u7a0e\u5355\u4ef7\u6709\u8bef", (boolean)false, (e_acttaxunitprice.compareTo(compareRealPrice) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u6298\u6263\u989d\u6709\u8bef", (boolean)false, (e_discountamount.compareTo(compareDiscountAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u6709\u8bef", (boolean)false, (e_settledamt.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u6709\u8bef", (boolean)false, (e_settledlocalamt.compareTo(BigDecimal.ZERO.multiply(exchangerate)) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u6709\u8bef", (boolean)false, (e_unsettleamt.compareTo(compareAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u6709\u8bef", (boolean)false, (e_unsettlelocalamt.compareTo(compareAmt.multiply(exchangerate)) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5df2\u9501\u5b9a\u91d1\u989d\u6709\u8bef", (boolean)false, (e_lockedamt.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u672a\u9501\u5b9a\u91d1\u989d\u6709\u8bef", (boolean)false, (e_unlockamt.compareTo(compareAmt) != 0 ? 1 : 0) != 0);
    }

    public static void checkTaxEntryAmt(int currentIndex, BigDecimal comparePrice, BigDecimal compareTaxPrice, BigDecimal compareAmt, BigDecimal compareRecAmt, BigDecimal taxAmt, IDataModel model) {
        BigDecimal exchangerate = (BigDecimal)model.getValue("exchangerate");
        BigDecimal e_unitprice = (BigDecimal)model.getValue("e_unitprice", currentIndex);
        BigDecimal e_taxunitprice = (BigDecimal)model.getValue("e_taxunitprice", currentIndex);
        BigDecimal e_actunitprice = (BigDecimal)model.getValue("e_actunitprice", currentIndex);
        BigDecimal e_acttaxunitprice = (BigDecimal)model.getValue("e_acttaxunitprice", currentIndex);
        BigDecimal e_amount = (BigDecimal)model.getValue("e_amount", currentIndex);
        BigDecimal e_localamt = (BigDecimal)model.getValue("e_localamt", currentIndex);
        BigDecimal e_recamount = (BigDecimal)model.getValue("e_recamount", currentIndex);
        BigDecimal e_reclocalamt = (BigDecimal)model.getValue("e_reclocalamt", currentIndex);
        BigDecimal e_tax = (BigDecimal)model.getValue("e_tax", currentIndex);
        BigDecimal e_settledamt = (BigDecimal)model.getValue("e_settledamt", currentIndex);
        BigDecimal e_settledlocalamt = (BigDecimal)model.getValue("e_settledlocalamt", currentIndex);
        BigDecimal e_unsettleamt = (BigDecimal)model.getValue("e_unsettleamt", currentIndex);
        BigDecimal e_unsettlelocalamt = (BigDecimal)model.getValue("e_unsettlelocalamt", currentIndex);
        BigDecimal e_lockedamt = (BigDecimal)model.getValue("e_lockedamt", currentIndex);
        BigDecimal e_unlockamt = (BigDecimal)model.getValue("e_unlockamt", currentIndex);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5355\u4ef7\u6709\u8bef", (boolean)false, (e_unitprice.compareTo(comparePrice) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5b9e\u9645\u5355\u4ef7\u6709\u8bef", (boolean)false, (e_actunitprice.compareTo(comparePrice) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u542b\u7a0e\u5355\u4ef7\u6709\u8bef", (boolean)false, (e_taxunitprice.compareTo(compareTaxPrice) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5b9e\u9645\u542b\u7a0e\u5355\u4ef7\u6709\u8bef", (boolean)false, (e_acttaxunitprice.compareTo(compareTaxPrice) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u91d1\u989d\u6709\u8bef", (boolean)false, (e_amount.compareTo(compareAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u91d1\u989d\u6298\u672c\u5e01\u6709\u8bef", (boolean)false, (e_localamt.compareTo(compareAmt.multiply(exchangerate)) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5e94\u6536\u91d1\u989d\u6709\u8bef", (boolean)false, (e_recamount.compareTo(compareRecAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5e94\u6536\u91d1\u989d\u6298\u672c\u5e01\u6709\u8bef", (boolean)false, (e_reclocalamt.compareTo(compareRecAmt.multiply(exchangerate)) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u7a0e\u989d\u6709\u8bef", (boolean)false, (e_tax.compareTo(taxAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u6709\u8bef", (boolean)false, (e_settledamt.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u6709\u8bef", (boolean)false, (e_settledlocalamt.compareTo(BigDecimal.ZERO.multiply(exchangerate)) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u6709\u8bef", (boolean)false, (e_unsettleamt.compareTo(compareRecAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u6709\u8bef", (boolean)false, (e_unsettlelocalamt.compareTo(compareRecAmt.multiply(exchangerate)) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5df2\u9501\u5b9a\u91d1\u989d\u6709\u8bef", (boolean)false, (e_lockedamt.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u672a\u9501\u5b9a\u91d1\u989d\u6709\u8bef", (boolean)false, (e_unlockamt.compareTo(compareRecAmt) != 0 ? 1 : 0) != 0);
    }

    public static void checkAmt(IDataModel model) {
        int i;
        BigDecimal recAmt = (BigDecimal)model.getValue("recamount");
        BigDecimal reclocalamt = (BigDecimal)model.getValue("reclocalamt");
        BigDecimal settleamount = (BigDecimal)model.getValue("settleamount");
        BigDecimal settlelocalamt = (BigDecimal)model.getValue("settlelocalamt");
        BigDecimal unsettleamount = (BigDecimal)model.getValue("unsettleamount");
        BigDecimal unsettlelocalamt = (BigDecimal)model.getValue("unsettlelocalamt");
        BigDecimal e_recAmtSum = new BigDecimal("0.00");
        BigDecimal e_recLocalAmtSum = new BigDecimal("0.00");
        BigDecimal e_settleAmtSum = new BigDecimal("0.00");
        BigDecimal e_settleLoacalAmtSum = new BigDecimal("0.00");
        BigDecimal e_unSettleAmtSum = new BigDecimal("0.00");
        BigDecimal e_unSettleLoacalAmtSum = new BigDecimal("0.00");
        BigDecimal p_recAmtSum = new BigDecimal("0.00");
        BigDecimal p_recLocalAmtSum = new BigDecimal("0.00");
        BigDecimal p_settleAmtSum = new BigDecimal("0.00");
        BigDecimal p_settleLoacalAmtSum = new BigDecimal("0.00");
        BigDecimal p_unSettleAmtSum = new BigDecimal("0.00");
        BigDecimal p_unSettleLoacalAmtSum = new BigDecimal("0.00");
        int entryRowCount = model.getEntryRowCount("entry");
        int planRowCount = model.getEntryRowCount("planentity");
        for (i = 0; i < entryRowCount; ++i) {
            e_recAmtSum = e_recAmtSum.add((BigDecimal)model.getValue("e_recamount", i));
            e_recLocalAmtSum = e_recLocalAmtSum.add((BigDecimal)model.getValue("e_reclocalamt", i));
            e_settleAmtSum = e_settleAmtSum.add((BigDecimal)model.getValue("e_settledamt", i));
            e_settleLoacalAmtSum = e_settleLoacalAmtSum.add((BigDecimal)model.getValue("e_settledlocalamt", i));
            e_unSettleAmtSum = e_unSettleAmtSum.add((BigDecimal)model.getValue("e_unsettleamt", i));
            e_unSettleLoacalAmtSum = e_unSettleLoacalAmtSum.add((BigDecimal)model.getValue("e_unsettlelocalamt", i));
        }
        for (i = 0; i < planRowCount; ++i) {
            p_recAmtSum = p_recAmtSum.add((BigDecimal)model.getValue("planpricetax", i));
            p_recLocalAmtSum = p_recLocalAmtSum.add((BigDecimal)model.getValue("planpricetaxloc", i));
            p_settleAmtSum = p_settleAmtSum.add((BigDecimal)model.getValue("plansettledamt", i));
            p_settleLoacalAmtSum = p_settleLoacalAmtSum.add((BigDecimal)model.getValue("plansettledlocamt", i));
            p_unSettleAmtSum = p_unSettleAmtSum.add((BigDecimal)model.getValue("unplansettleamt", i));
            p_unSettleLoacalAmtSum = p_unSettleLoacalAmtSum.add((BigDecimal)model.getValue("unplansettlelocamt", i));
        }
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5e94\u6536\u91d1\u989d\u5408\u8ba1\u548c\u8868\u5934\u5e94\u6536\u91d1\u989d\u4e0d\u4e00\u81f4", (boolean)false, (e_recAmtSum.compareTo(recAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u5e94\u6536\u91d1\u989d\u5408\u8ba1\u548c\u8868\u5934\u5e94\u6536\u91d1\u989d\u4e0d\u4e00\u81f4", (boolean)false, (p_recAmtSum.compareTo(recAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5e94\u6536\u91d1\u989d\u6298\u672c\u5e01\u5408\u8ba1\u548c\u8868\u5934\u5e94\u6536\u91d1\u989d\u6298\u672c\u5e01\u4e0d\u4e00\u81f4", (boolean)false, (e_recLocalAmtSum.compareTo(reclocalamt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u5e94\u6536\u91d1\u989d\u6298\u672c\u5e01\u5408\u8ba1\u548c\u8868\u5934\u5e94\u6536\u91d1\u989d\u6298\u672c\u5e01\u4e0d\u4e00\u81f4", (boolean)false, (p_recLocalAmtSum.compareTo(reclocalamt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u548c\u8868\u5934\u5df2\u7ed3\u7b97\u91d1\u989d\u4e0d\u4e00\u81f4", (boolean)false, (e_settleAmtSum.compareTo(settleamount) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u548c\u8868\u5934\u5df2\u7ed3\u7b97\u91d1\u989d\u4e0d\u4e00\u81f4", (boolean)false, (p_settleAmtSum.compareTo(settleamount) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u5408\u8ba1\u548c\u8868\u5934\u5df2\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u4e0d\u4e00\u81f4", (boolean)false, (e_settleLoacalAmtSum.compareTo(settlelocalamt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u5408\u8ba1\u548c\u8868\u5934\u5df2\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u4e0d\u4e00\u81f4", (boolean)false, (p_settleLoacalAmtSum.compareTo(settlelocalamt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u548c\u8868\u5934\u672a\u9501\u5b9a\u91d1\u989d\u4e0d\u4e00\u81f4", (boolean)false, (e_unSettleAmtSum.compareTo(unsettleamount) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u548c\u8868\u5934\u672a\u9501\u5b9a\u91d1\u989d\u4e0d\u4e00\u81f4", (boolean)false, (p_unSettleAmtSum.compareTo(unsettleamount) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u5408\u8ba1\u548c\u8868\u5934\u672a\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u4e0d\u4e00\u81f4", (boolean)false, (e_unSettleLoacalAmtSum.compareTo(unsettlelocalamt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u5408\u8ba1\u548c\u8868\u5934\u672a\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u4e0d\u4e00\u81f4", (boolean)false, (p_unSettleLoacalAmtSum.compareTo(unsettlelocalamt) != 0 ? 1 : 0) != 0);
    }

    public static void checkArJournal(DynamicObject billInfo, boolean isHasJournal) {
        if (isHasJournal) {
            DynamicObject[] journalObjects = BusinessDataServiceHelper.load((String)"ar_journal", (String)"id,receivableamt,localreceivableamt,asstacttype,asstact", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)billInfo.getLong("id"))});
            KDAssert.assertEquals((String)"\u5ba1\u6838\u6ca1\u6709\u751f\u6210\u6d41\u6c34\u3002", (boolean)true, (journalObjects.length > 0 ? 1 : 0) != 0);
            if (journalObjects.length > 0) {
                DynamicObject journalObject = journalObjects[0];
                BigDecimal receivableamt = journalObject.getBigDecimal("receivableamt");
                KDAssert.assertEquals((String)"\u6d41\u6c34\u5e94\u6536\u91d1\u989d\u4e0e\u6e90\u8d22\u52a1\u5e94\u6536\u5355\u5e94\u6536\u91d1\u989d\u4e0d\u4e00\u81f4", (boolean)true, (receivableamt.compareTo(billInfo.getBigDecimal("recamount")) == 0 ? 1 : 0) != 0);
                BigDecimal localreceivableamt = journalObject.getBigDecimal("localreceivableamt");
                KDAssert.assertEquals((String)"\u6d41\u6c34\u5e94\u6536\u91d1\u989d\u6298\u672c\u5e01\u4e0e\u6e90\u8d22\u52a1\u5e94\u6536\u5355\u5e94\u6536\u91d1\u989d\u6298\u672c\u5e01\u4e0d\u4e00\u81f4", (boolean)true, (localreceivableamt.compareTo(billInfo.getBigDecimal("reclocalamt")) == 0 ? 1 : 0) != 0);
                Long asstactId = journalObject.getLong("asstact.id");
                KDAssert.assertEquals((String)"\u6d41\u6c34\u5f80\u6765\u6237\u4e0e\u539f\u8d22\u52a1\u5e94\u6536\u5355\u5f80\u6765\u6237\u4e0d\u4e00\u81f4", (boolean)true, (boolean)asstactId.equals(billInfo.getDynamicObject("asstact").getLong("masterid")));
            }
        } else {
            DynamicObject[] journalObjects_l = BusinessDataServiceHelper.load((String)"ar_journal", (String)"id,receivableamt,localreceivableamt,asstact", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)billInfo.getLong("id"))});
            KDAssert.assertEquals((String)"\u53cd\u5ba1\u6838\u6ca1\u6709\u5220\u9664\u6d41\u6c34", (boolean)false, (journalObjects_l.length > 0 ? 1 : 0) != 0);
        }
    }

    public static void checkArAmt(DynamicObject billInfo, BigDecimal settleAmt, BigDecimal localSettleAmt, BigDecimal unSettleAmt, BigDecimal localUnSettleAmt) {
        BigDecimal settleamount = billInfo.getBigDecimal("settleamount");
        BigDecimal settlelocalamt = billInfo.getBigDecimal("settlelocalamt");
        BigDecimal unsettleamount = billInfo.getBigDecimal("unsettleamount");
        BigDecimal unsettlelocalamt = billInfo.getBigDecimal("unsettlelocalamt");
        KDAssert.assertEquals((String)"\u8868\u5934\u5df2\u7ed3\u7b97\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (settleamount.compareTo(settleAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8868\u5934\u5df2\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (settlelocalamt.compareTo(localSettleAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8868\u5934\u672a\u7ed3\u7b97\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (unsettleamount.compareTo(unSettleAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8868\u5934\u672a\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (unsettlelocalamt.compareTo(localUnSettleAmt) != 0 ? 1 : 0) != 0);
    }

    public static void checkArDetailAmt(DynamicObject entryInfo, BigDecimal lockAmt, BigDecimal settleAmt, BigDecimal localSettleAmt, BigDecimal unLockAmt, BigDecimal unSettleAmt, BigDecimal localUnSettleAmt) {
        BigDecimal e_lockedamt = entryInfo.getBigDecimal("e_lockedamt");
        BigDecimal e_settledamt = entryInfo.getBigDecimal("e_settledamt");
        BigDecimal e_settledlocalamt = entryInfo.getBigDecimal("e_settledlocalamt");
        BigDecimal e_unlockamt = entryInfo.getBigDecimal("e_unlockamt");
        BigDecimal e_unsettleamt = entryInfo.getBigDecimal("e_unsettleamt");
        BigDecimal e_unsettlelocalamt = entryInfo.getBigDecimal("e_unsettlelocalamt");
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5df2\u9501\u5b9a\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (e_lockedamt.compareTo(lockAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (e_settledamt.compareTo(settleAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u5df2\u7ed3\u7b97\u6298\u672c\u5e01\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (e_settledlocalamt.compareTo(localSettleAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u672a\u9501\u5b9a\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (e_unlockamt.compareTo(unLockAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (e_unsettleamt.compareTo(unSettleAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u7269\u6599\u884c\u672a\u7ed3\u7b97\u6298\u672c\u5e01\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (e_unsettlelocalamt.compareTo(localUnSettleAmt) != 0 ? 1 : 0) != 0);
    }

    public static void checkArPlanAmt(DynamicObject entryInfo, BigDecimal lockAmt, BigDecimal settleAmt, BigDecimal localSettleAmt, BigDecimal unLockAmt, BigDecimal unSettleAmt, BigDecimal localUnSettleAmt) {
        BigDecimal planlockedamt = entryInfo.getBigDecimal("planlockedamt");
        BigDecimal plansettledamt = entryInfo.getBigDecimal("plansettledamt");
        BigDecimal plansettledlocamt = entryInfo.getBigDecimal("plansettledlocamt");
        BigDecimal unplanlockamt = entryInfo.getBigDecimal("unplanlockamt");
        BigDecimal unplansettleamt = entryInfo.getBigDecimal("unplansettleamt");
        BigDecimal unplansettlelocamt = entryInfo.getBigDecimal("unplansettlelocamt");
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u5df2\u9501\u5b9a\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (planlockedamt.compareTo(lockAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (plansettledamt.compareTo(settleAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u5df2\u7ed3\u7b97\u6298\u672c\u5e01\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (plansettledlocamt.compareTo(localSettleAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u672a\u9501\u5b9a\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (unplanlockamt.compareTo(unLockAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (unplansettleamt.compareTo(unSettleAmt) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u6298\u672c\u5e01\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (unplansettlelocamt.compareTo(localUnSettleAmt) != 0 ? 1 : 0) != 0);
    }

    public static void checkArVerifyAmt(DynamicObject billInfo, BigDecimal unVerifyAmt, BigDecimal verifyAmt1, BigDecimal unVerifyAmt1, BigDecimal verifyQty1, BigDecimal unVerifyQty1, BigDecimal verifyAmt2, BigDecimal unVerifyAmt2, BigDecimal verifyQty2, BigDecimal unVerifyQty2) {
        BigDecimal unverifyamount = billInfo.getBigDecimal("unverifyamount");
        KDAssert.assertEquals((String)"\u8868\u5934\u672a\u6838\u9500\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (unverifyamount.compareTo(unVerifyAmt) != 0 ? 1 : 0) != 0);
        DynamicObjectCollection entryCol = billInfo.getDynamicObjectCollection("entry");
        DynamicObject entryInfo_1 = (DynamicObject)entryCol.get(0);
        BigDecimal e_verifiedamt_1 = entryInfo_1.getBigDecimal("e_verifiedamt");
        BigDecimal e_unverifyamt_1 = entryInfo_1.getBigDecimal("e_unverifyamt");
        BigDecimal e_verifiedqty_1 = entryInfo_1.getBigDecimal("e_verifiedqty");
        BigDecimal e_unverifyqty_1 = entryInfo_1.getBigDecimal("e_unverifyqty");
        KDAssert.assertEquals((String)"\u8868\u5934\u672a\u6838\u9500\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (e_verifiedamt_1.compareTo(verifyAmt1) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8868\u5934\u672a\u6838\u9500\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (e_unverifyamt_1.compareTo(unVerifyAmt1) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8868\u5934\u672a\u6838\u9500\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (e_verifiedqty_1.compareTo(verifyQty1) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8868\u5934\u672a\u6838\u9500\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (e_unverifyqty_1.compareTo(unVerifyQty1) != 0 ? 1 : 0) != 0);
        DynamicObject entryInfo_2 = (DynamicObject)entryCol.get(1);
        BigDecimal e_verifiedamt_2 = entryInfo_2.getBigDecimal("e_verifiedamt");
        BigDecimal e_unverifyamt_2 = entryInfo_2.getBigDecimal("e_unverifyamt");
        BigDecimal e_verifiedqty_2 = entryInfo_2.getBigDecimal("e_verifiedqty");
        BigDecimal e_unverifyqty_2 = entryInfo_2.getBigDecimal("e_unverifyqty");
        KDAssert.assertEquals((String)"\u8868\u5934\u672a\u6838\u9500\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (e_verifiedamt_2.compareTo(verifyAmt2) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8868\u5934\u672a\u6838\u9500\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (e_unverifyamt_2.compareTo(unVerifyAmt2) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8868\u5934\u672a\u6838\u9500\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (e_verifiedqty_2.compareTo(verifyQty2) != 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u8868\u5934\u672a\u6838\u9500\u91d1\u989d\u53cd\u5199\u4e0d\u51c6\u786e", (boolean)false, (e_unverifyqty_2.compareTo(unVerifyQty2) != 0 ? 1 : 0) != 0);
    }

    public static void checkSettleAmt(boolean isBack, boolean isMain, List<Long> mainBillIds, Long billId, Long billEntryId, BigDecimal settleAmt, BigDecimal localSettleAmt) {
        if (isMain) {
            QFilter filter = new QFilter("mainbillid", "=", (Object)billId);
            filter.and(new QFilter("mainbillentryid", "=", (Object)billEntryId));
            DynamicObject[] ap_settlerecords = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)"id,mainasstacttype,mainasstactid,mainbillid,mainbillentryid,totalsettleamt,localtotalsettleamt", (QFilter[])new QFilter[]{filter});
            if (!isBack) {
                if (ap_settlerecords.length > 0) {
                    BigDecimal totalsettleamtSum = BigDecimal.ZERO;
                    BigDecimal localtotalsettleamtSum = BigDecimal.ZERO;
                    for (DynamicObject recordInfo : ap_settlerecords) {
                        totalsettleamtSum = totalsettleamtSum.add(recordInfo.getBigDecimal("totalsettleamt"));
                        localtotalsettleamtSum = localtotalsettleamtSum.add(recordInfo.getBigDecimal("localtotalsettleamt"));
                    }
                    KDAssert.assertEquals((String)"\u7ed3\u7b97\u8bb0\u5f55\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0d\u6b63\u786e", (boolean)false, (totalsettleamtSum.compareTo(settleAmt) != 0 ? 1 : 0) != 0);
                    KDAssert.assertEquals((String)"\u7ed3\u7b97\u8bb0\u5f55\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u5408\u8ba1\u4e0d\u6b63\u786e", (boolean)false, (localtotalsettleamtSum.compareTo(localSettleAmt) != 0 ? 1 : 0) != 0);
                    FinArBillTestChecker.checkSettleJournal(ap_settlerecords, true, true);
                } else {
                    KDAssert.assertEquals((String)"\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u7684\u7ed3\u7b97\u8bb0\u5f55", (boolean)true, (ap_settlerecords.length > 0 ? 1 : 0) != 0);
                }
            } else {
                KDAssert.assertEquals((String)"\u5bf9\u5e94\u7684\u7ed3\u7b97\u8bb0\u5f55\u6ca1\u6709\u5220\u9664", (boolean)false, (ap_settlerecords.length > 0 ? 1 : 0) != 0);
            }
        } else {
            QFilter filter = new QFilter("mainbillid", "in", mainBillIds);
            filter.and(new QFilter("entry.billid", "=", (Object)billId));
            filter.and(new QFilter("entry.billentryid", "=", (Object)billEntryId));
            DynamicObject[] ap_settlerecords = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)"id,mainbillid,entry.asstacttype,entry.asstactid,entry.settleamt,entry.localsettleamt", (QFilter[])new QFilter[]{filter});
            if (!isBack) {
                if (ap_settlerecords.length > 0) {
                    BigDecimal settleamtSum = BigDecimal.ZERO;
                    BigDecimal localsettleamtSum = BigDecimal.ZERO;
                    for (DynamicObject recordInfo : ap_settlerecords) {
                        DynamicObjectCollection recordEntryCol = recordInfo.getDynamicObjectCollection("entry");
                        for (DynamicObject recordEntryInfo : recordEntryCol) {
                            settleamtSum = settleamtSum.add(recordEntryInfo.getBigDecimal("settleamt"));
                            localsettleamtSum = localsettleamtSum.add(recordEntryInfo.getBigDecimal("localsettleamt"));
                        }
                    }
                    KDAssert.assertEquals((String)"\u8f85\u65b9\u7ed3\u7b97\u8bb0\u5f55\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0d\u6b63\u786e", (boolean)false, (settleamtSum.compareTo(settleAmt) != 0 ? 1 : 0) != 0);
                    KDAssert.assertEquals((String)"\u8f85\u65b9\u7ed3\u7b97\u8bb0\u5f55\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u4e0d\u6b63\u786e", (boolean)false, (localsettleamtSum.compareTo(localSettleAmt) != 0 ? 1 : 0) != 0);
                    FinArBillTestChecker.checkSettleJournal(ap_settlerecords, true, false);
                } else {
                    KDAssert.assertEquals((String)"\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u7684\u7ed3\u7b97\u8bb0\u5f55", (boolean)true, (ap_settlerecords.length > 0 ? 1 : 0) != 0);
                }
            } else {
                KDAssert.assertEquals((String)"\u5bf9\u5e94\u7684\u7ed3\u7b97\u8bb0\u5f55\u6ca1\u6709\u5220\u9664", (boolean)false, (ap_settlerecords.length > 0 ? 1 : 0) != 0);
            }
        }
    }

    public static void checkSettleJournal(DynamicObject[] billInfos, boolean isHasJournal, boolean isMain) {
        if (isHasJournal) {
            for (DynamicObject billInfo : billInfos) {
                DynamicObject[] journalObjects = BusinessDataServiceHelper.load((String)"ar_journal", (String)"id,receivableamt,localreceivableamt,asstacttype,asstact", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)billInfo.getLong("id"))});
                KDAssert.assertEquals((String)"\u7ed3\u7b97\u8bb0\u5f55\u6ca1\u6709\u751f\u6210\u6d41\u6c34\u3002", (boolean)true, (journalObjects.length > 0 ? 1 : 0) != 0);
                if (journalObjects.length <= 0) continue;
                DynamicObject journalObject = journalObjects[0];
                BigDecimal receivableamt = journalObject.getBigDecimal("receivableamt");
                BigDecimal totalsettleamt = BigDecimal.ZERO;
                BigDecimal localtotalsettleamt = BigDecimal.ZERO;
                Long settleAsstId = 0L;
                if (isMain) {
                    totalsettleamt = billInfo.getBigDecimal("totalsettleamt");
                    localtotalsettleamt = billInfo.getBigDecimal("localtotalsettleamt");
                    settleAsstId = billInfo.getDynamicObject("mainasstactid").getLong("masterid");
                } else {
                    DynamicObjectCollection billEntryCol = billInfo.getDynamicObjectCollection("entry");
                    DynamicObject billEntryInfo = (DynamicObject)billEntryCol.get(0);
                    totalsettleamt = billEntryInfo.getBigDecimal("settleamt");
                    localtotalsettleamt = billEntryInfo.getBigDecimal("localsettleamt");
                    settleAsstId = billEntryInfo.getDynamicObject("asstactid").getLong("masterid");
                }
                KDAssert.assertEquals((String)"\u6d41\u6c34\u5e94\u6536\u91d1\u989d\u4e0e\u6e90\u7ed3\u7b97\u8bb0\u5f55\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0d\u4e00\u81f4", (boolean)true, (receivableamt.abs().compareTo(totalsettleamt.abs()) == 0 ? 1 : 0) != 0);
                BigDecimal localreceivableamt = journalObject.getBigDecimal("localreceivableamt");
                KDAssert.assertEquals((String)"\u6d41\u6c34\u5e94\u6536\u91d1\u989d\u4e0e\u6e90\u7ed3\u7b97\u8bb0\u5f55\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u4e0d\u4e00\u81f4", (boolean)true, (localreceivableamt.abs().compareTo(localtotalsettleamt.abs()) == 0 ? 1 : 0) != 0);
                Long asstactId = journalObject.getLong("asstact.id");
                KDAssert.assertEquals((String)"\u6d41\u6c34\u5f80\u6765\u6237\u4e0e\u539f\u8d22\u52a1\u5e94\u6536\u5355\u5f80\u6765\u6237\u4e0d\u4e00\u81f4", (boolean)true, (boolean)asstactId.equals(settleAsstId));
            }
        } else {
            for (DynamicObject billInfo : billInfos) {
                DynamicObject[] journalObjects_l = BusinessDataServiceHelper.load((String)"ar_journal", (String)"id,receivableamt,localreceivableamt,asstact", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)billInfo.getLong("id"))});
                KDAssert.assertEquals((String)"\u7ed3\u7b97\u8bb0\u5f55\u6ca1\u6709\u5220\u9664\u6d41\u6c34", (boolean)false, (journalObjects_l.length > 0 ? 1 : 0) != 0);
            }
        }
    }

    public static void entryCheckByArRevVerify(DynamicObject finArBill, BigDecimal e_confirmedqty, BigDecimal e_unconfirmqty, BigDecimal e_confirmedbaseqty, BigDecimal e_unconfirmbaseqty, BigDecimal e_confirmedamt, BigDecimal e_unconfirmamt, int rowIndex) {
        DynamicObject entry = (DynamicObject)finArBill.getDynamicObjectCollection("entry").get(rowIndex);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finArBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5df2\u786e\u8ba4\u6570\u91cf\u8ba1\u7b97\u9519\u8bef"), (int)e_confirmedqty.compareTo(entry.getBigDecimal("e_confirmedqty")), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finArBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u672a\u786e\u8ba4\u6570\u91cf\u8ba1\u7b97\u9519\u8bef"), (int)e_unconfirmqty.compareTo(entry.getBigDecimal("e_unconfirmqty")), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finArBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5df2\u786e\u8ba4\u57fa\u672c\u6570\u91cf\u8ba1\u7b97\u9519\u8bef"), (int)e_confirmedbaseqty.compareTo(entry.getBigDecimal("e_confirmedbaseqty")), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finArBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u672a\u786e\u8ba4\u57fa\u672c\u6570\u91cf\u8ba1\u7b97\u9519\u8bef"), (int)e_unconfirmbaseqty.compareTo(entry.getBigDecimal("e_unconfirmbaseqty")), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finArBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5df2\u786e\u8ba4\u91d1\u989d\u8ba1\u7b97\u9519\u8bef"), (int)e_confirmedamt.compareTo(entry.getBigDecimal("e_confirmedamt")), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finArBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u672a\u786e\u8ba4\u91d1\u989d\u8ba1\u7b97\u9519\u8bef"), (int)e_unconfirmamt.compareTo(entry.getBigDecimal("e_unconfirmamt")), (int)0);
    }

    public static void entryCheckByArSaloutVerify(DynamicObject finArBill, int rowIndex, BigDecimal e_verifiedqty, BigDecimal e_unverifyqty, BigDecimal e_verifybaseqty, BigDecimal e_unverifybaseqty, BigDecimal e_verifiedamt, BigDecimal e_unverifyamt) {
        DynamicObject entry = (DynamicObject)finArBill.getDynamicObjectCollection("entry").get(rowIndex);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finArBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5df2\u6838\u9500\u6570\u91cf\u8ba1\u7b97\u9519\u8bef"), (int)e_verifiedqty.compareTo(entry.getBigDecimal("e_verifiedqty")), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finArBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u672a\u6838\u9500\u6570\u91cf\u8ba1\u7b97\u9519\u8bef"), (int)e_unverifyqty.compareTo(entry.getBigDecimal("e_unverifyqty")), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finArBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5df2\u6838\u9500\u57fa\u672c\u6570\u91cf\u8ba1\u7b97\u9519\u8bef"), (int)e_verifybaseqty.compareTo(entry.getBigDecimal("e_verifybaseqty")), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finArBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u672a\u6838\u9500\u57fa\u672c\u6570\u91cf\u8ba1\u7b97\u9519\u8bef"), (int)e_unverifybaseqty.compareTo(entry.getBigDecimal("e_unverifybaseqty")), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finArBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5df2\u6838\u9500\u91d1\u989d\u8ba1\u7b97\u9519\u8bef"), (int)e_verifiedamt.compareTo(entry.getBigDecimal("e_verifiedamt")), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finArBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u672a\u6838\u9500\u91d1\u989d\u8ba1\u7b97\u9519\u8bef"), (int)e_unverifyamt.compareTo(entry.getBigDecimal("e_unverifyamt")), (int)0);
    }
}

