/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.check;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.unittest.framework.KDAssert;

public class PmAcceptTestChecker {
    public static void validatePmAcceptDetailEntry(long billId, BigDecimal joinPayablePriceQtyOne, BigDecimal payablePriceQtyOne, BigDecimal joinPayablePriceQtyTwo, BigDecimal payablePriceQtyTwo) {
        DynamicObject pmAcceptBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"pm_puracceptbill");
        DynamicObjectCollection billEntry = pmAcceptBill.getDynamicObjectCollection("billentry");
        PmAcceptTestChecker.validatePmAcceptDetailEntry((DynamicObject)billEntry.get(0), joinPayablePriceQtyOne, payablePriceQtyOne);
        PmAcceptTestChecker.validatePmAcceptDetailEntry((DynamicObject)billEntry.get(1), joinPayablePriceQtyTwo, payablePriceQtyTwo);
    }

    public static void validatePmAcceptDetailEntryByFull(long billId) {
        DynamicObject pmAcceptBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"pm_puracceptbill");
        DynamicObjectCollection billEntry = pmAcceptBill.getDynamicObjectCollection("billentry");
        for (DynamicObject detail : billEntry) {
            BigDecimal qty = detail.getBigDecimal("qty");
            PmAcceptTestChecker.validatePmAcceptDetailEntry(detail, qty, qty);
        }
    }

    public static void validatePmAcceptDetailEntryByZero(long billId) {
        DynamicObject pmAcceptBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"pm_puracceptbill");
        DynamicObjectCollection billEntry = pmAcceptBill.getDynamicObjectCollection("billentry");
        for (DynamicObject detail : billEntry) {
            PmAcceptTestChecker.validatePmAcceptDetailEntry(detail, BigDecimal.ZERO, BigDecimal.ZERO);
        }
    }

    public static void validatePmAcceptDetailEntry(DynamicObject detail, BigDecimal joinPayablePriceQty, BigDecimal payablePriceQty) {
        KDAssert.assertEquals((String)"\u91c7\u8d2d\u9a8c\u6536\u5355\u7269\u6599\u660e\u7ec6\u5206\u5f55\u5173\u8054\u5e94\u4ed8\u6570\u91cf\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)joinPayablePriceQty.compareTo(detail.getBigDecimal("joinpayablepriceqty")));
        KDAssert.assertEquals((String)"\u91c7\u8d2d\u9a8c\u6536\u5355\u7269\u6599\u660e\u7ec6\u5206\u5f55\u7d2f\u8ba1\u5e94\u4ed8\u6570\u91cf\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)payablePriceQty.compareTo(detail.getBigDecimal("payablepriceqty")));
    }
}

