/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.check;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.unittest.framework.KDAssert;

public class PurOrderBillTestChecker {
    public static void validatePurOrderHeadAmt(DynamicObject orderBill, BigDecimal paidPreAllAmount, BigDecimal paidAllAmount) {
        KDAssert.assertEquals((String)"\u91c7\u8d2d\u8ba2\u5355\u8868\u5934\u7d2f\u8ba1\u9884\u4ed8\u6b3e\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)paidPreAllAmount.compareTo(orderBill.getBigDecimal("paidpreallamount")));
        KDAssert.assertEquals((String)"\u91c7\u8d2d\u8ba2\u5355\u8868\u5934\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)paidAllAmount.compareTo(orderBill.getBigDecimal("paidallamount")));
    }

    public static void validatePurOrderPayEntry(DynamicObject orderBill, BigDecimal joinPayAmountOne, BigDecimal paidAmountOne, BigDecimal joinPayAmountTwo, BigDecimal paidAmountTwo) {
        DynamicObjectCollection purBillEntryPay = orderBill.getDynamicObjectCollection("purbillentry_pay");
        PurOrderBillTestChecker.validatePurOrderPayEntry((DynamicObject)purBillEntryPay.get(0), joinPayAmountOne, paidAmountOne);
        PurOrderBillTestChecker.validatePurOrderPayEntry((DynamicObject)purBillEntryPay.get(1), joinPayAmountTwo, paidAmountTwo);
    }

    public static void validatePurOrderPayEntry(long orderId, BigDecimal joinPayAmountOne, BigDecimal paidAmountOne, BigDecimal joinPayAmountTwo, BigDecimal paidAmountTwo) {
        DynamicObject orderBill = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"pm_purorderbill");
        PurOrderBillTestChecker.validatePurOrderPayEntry(orderBill, joinPayAmountOne, paidAmountOne, joinPayAmountTwo, paidAmountTwo);
    }

    public static void validatePurOrderPayEntry(DynamicObject plan, BigDecimal joinPayAmount, BigDecimal paidAmount) {
        KDAssert.assertEquals((String)"\u91c7\u8d2d\u8ba2\u5355\u4ed8\u6b3e\u8ba1\u5212\u5206\u5f55\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)joinPayAmount.compareTo(plan.getBigDecimal("joinpayamount")));
        KDAssert.assertEquals((String)"\u91c7\u8d2d\u8ba2\u5355\u4ed8\u6b3e\u8ba1\u5212\u5206\u5f55\u5b9e\u9645\u4ed8\u6b3e\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)paidAmount.compareTo(plan.getBigDecimal("paidamount")));
    }

    public static void validatePurOrderApData(DynamicObject detail, BigDecimal joinPayablePriceQty, BigDecimal payablePriceQty, BigDecimal payableAmount) {
        KDAssert.assertEquals((String)"\u91c7\u8d2d\u8ba2\u5355\u7269\u6599\u660e\u7ec6\u5206\u5f55\u5173\u8054\u5e94\u4ed8\u6570\u91cf\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)joinPayablePriceQty.compareTo(detail.getBigDecimal("joinpayablepriceqty")));
        KDAssert.assertEquals((String)"\u91c7\u8d2d\u8ba2\u5355\u7269\u6599\u660e\u7ec6\u5206\u5f55\u7d2f\u8ba1\u5e94\u4ed8\u6570\u91cf\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)payablePriceQty.compareTo(detail.getBigDecimal("payablepriceqty")));
        KDAssert.assertEquals((String)"\u91c7\u8d2d\u8ba2\u5355\u7269\u6599\u660e\u7ec6\u5206\u5f55\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)payableAmount.compareTo(detail.getBigDecimal("payableamount")));
    }

    public static void validatePurOrderApDataByZero(long orderId) {
        DynamicObject orderBill = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"pm_purorderbill");
        DynamicObjectCollection billEntry = orderBill.getDynamicObjectCollection("billentry");
        for (DynamicObject detail : billEntry) {
            PurOrderBillTestChecker.validatePurOrderApData(detail, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
        }
    }

    public static void validatePurOrderApDataByFull(long orderId) {
        DynamicObject orderBill = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"pm_purorderbill");
        DynamicObjectCollection billEntry = orderBill.getDynamicObjectCollection("billentry");
        for (DynamicObject detail : billEntry) {
            BigDecimal qty = detail.getBigDecimal("qty");
            PurOrderBillTestChecker.validatePurOrderApData(detail, qty, qty, detail.getBigDecimal("amountandtax"));
        }
    }
}

