/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.check;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.journal.JournalAmountType;
import kd.fi.arapcommon.journal.convert.SrPushJournalSetting;
import kd.fi.arapcommon.journal.convert.SrPushJournalSettingFactory;
import kd.fi.arapcommon.unittest.framework.check.AmtBaseChecker;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;

public class SettleRecordTestChecker {
    public static void checkSettleAmt(Long[] mainIds, Long[] asstIds, boolean isAr) {
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(mainIds, asstIds, isAr);
        SettleRecordTestChecker.checkSettleAmt(settleRecords);
    }

    public static void checkSettleAmt(DynamicObject[] settleRecords) {
        for (DynamicObject settleRecord : settleRecords) {
            BigDecimal mainSettleAmt = settleRecord.getBigDecimal("totalsettleamt");
            BigDecimal remainSettleAmt = BigDecimal.ZERO;
            DynamicObjectCollection settleRecordEntries = settleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : settleRecordEntries) {
                remainSettleAmt = remainSettleAmt.add(entry.getBigDecimal("settleamt"));
            }
            AmtBaseChecker.assertEquals(mainSettleAmt.abs(), remainSettleAmt.abs(), "\u4e3b\u65b9\u672c\u6b21\u7ed3\u7b97\u91d1\u989d: " + mainSettleAmt + "\u548c\u8f85\u65b9\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u6c47\u603b: " + remainSettleAmt + "\u4e0d\u76f8\u7b49");
        }
    }

    public static void checkSettleAmt(DynamicObject settleRecord, BigDecimal exceptSettleAmt) {
        BigDecimal totalsettleamt = settleRecord.getBigDecimal("totalsettleamt");
        AmtBaseChecker.assertEquals(exceptSettleAmt, totalsettleamt, "\u671f\u671b\u672c\u6b21\u7ed3\u7b97\u91d1\u989d:" + exceptSettleAmt + ", \u4e3b\u65b9\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u91d1\u989d: " + totalsettleamt + "\u4e0d\u76f8\u7b49");
    }

    public static void checkSwapL(DynamicObject settleRecord, BigDecimal exceptSwapL) {
        BigDecimal mainSwapL = settleRecord.getBigDecimal("swappl");
        AmtBaseChecker.assertEquals(exceptSwapL, mainSwapL, "\u671f\u671b\u6c47\u5151\u635f\u76ca\u91d1\u989d:" + exceptSwapL + ", \u4e3b\u65b9\u6c47\u5151\u635f\u76ca\u91d1\u989d: " + mainSwapL + "\u4e0d\u76f8\u7b49");
    }

    public static void checkNotExist(Long[] mainIds, Long[] asstIds, boolean isAr) {
        KDAssert.assertEquals((boolean)false, (boolean)SettleRecordTestHelper.exists(mainIds, asstIds, isAr));
    }

    public static void checkNotExist(QFilter filter, boolean isAr) {
        KDAssert.assertEquals((boolean)false, (boolean)SettleRecordTestHelper.exists(filter, isAr));
    }

    public static void checkJournal(Long[] mainIds, Long[] asstIds, boolean isAr) {
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(mainIds, asstIds, isAr);
        SettleRecordTestChecker.checkJournal(settleRecords);
    }

    public static void checkJournal(DynamicObject[] settleRecords) {
        if (settleRecords.length == 0) {
            return;
        }
        Set settleRecordIds = Arrays.stream(settleRecords).map(settleRecord -> settleRecord.getLong("id")).collect(Collectors.toSet());
        QFilter journalFilter = new QFilter("sourcebillid", "in", settleRecordIds);
        List arJournalIds = QueryServiceHelper.queryPrimaryKeys((String)"ar_journal", (QFilter[])journalFilter.toArray(), null, (int)-1);
        List apJournalIds = QueryServiceHelper.queryPrimaryKeys((String)"ap_journal", (QFilter[])journalFilter.toArray(), null, (int)-1);
        DynamicObject[] arJournals = BusinessDataServiceHelper.load((Object[])arJournalIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ar_journal"));
        DynamicObject[] apJournals = BusinessDataServiceHelper.load((Object[])apJournalIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ap_journal"));
        List journals = Arrays.stream(arJournals).collect(Collectors.toList());
        journals.addAll(Arrays.asList(apJournals));
        HashMap<String, DynamicObject> journalMap = new HashMap<String, DynamicObject>();
        for (DynamicObject journal : journals) {
            long sourcebillid = journal.getLong("sourcebillid");
            long sourceentryid = journal.getLong("sourceentryid");
            if (sourceentryid == 0L) {
                journalMap.put(Long.toString(sourcebillid), journal);
                continue;
            }
            journalMap.put(Long.toString(sourcebillid) + sourceentryid, journal);
        }
        for (DynamicObject settleRecord2 : settleRecords) {
            SrPushJournalSetting journalSetting;
            long settleRecordId = settleRecord2.getLong("id");
            String settleRelation = settleRecord2.getString("settlerelation");
            SettleRelationEnum settleRelationEnum = SettleRelationEnum.getSettleRelationEnumByValue(settleRelation);
            if (settleRelationEnum == null || (journalSetting = SrPushJournalSettingFactory.getSetting(settleRelationEnum)).getMainAmountType() == null) continue;
            String journalMainAmtKey = journalSetting.getMainAmountType().getAmtKey();
            String journalMainLocakAmtKey = journalSetting.getMainAmountType().getLocalAmtKey();
            JournalAmountType asstAmountType = journalSetting.getAsstAmountType();
            DynamicObject mainJournal = (DynamicObject)journalMap.get(Long.toString(settleRecordId));
            KDAssert.assertEquals((String)"\u7ed3\u7b97\u8bb0\u5f55\u4e3b\u65b9\u5bf9\u5e94\u7684\u6d41\u6c34\u4e0d\u5b58\u5728", (boolean)true, (mainJournal != null ? 1 : 0) != 0);
            if (mainJournal != null) {
                KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u6838\u7b97\u4e3b\u4f53\u4e0e\u7ed3\u7b97\u8bb0\u5f55\u4e3b\u65b9\u5bf9\u5e94\u7684\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u4e00\u81f4", (long)settleRecord2.getLong("org.id"), (long)mainJournal.getLong("org.id"));
                KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u5f80\u6765\u7c7b\u578b\u4e0e\u7ed3\u7b97\u8bb0\u5f55\u4e3b\u65b9\u5bf9\u5e94\u7684\u5f80\u6765\u7c7b\u578b\u4e0d\u4e00\u81f4", (String)settleRecord2.getString("mainasstacttype"), (String)mainJournal.getString("asstacttype"));
                KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u5f80\u6765\u6237\u4e0e\u7ed3\u7b97\u8bb0\u5f55\u4e3b\u65b9\u5bf9\u5e94\u7684\u5f80\u6765\u6237\u4e0d\u4e00\u81f4", (long)settleRecord2.getLong("mainasstactid.masterid"), (long)mainJournal.getLong("asstact.masterid"));
                KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u5e01\u522b\u4e0e\u7ed3\u7b97\u8bb0\u5f55\u4e3b\u65b9\u5bf9\u5e94\u7684\u5e01\u522b\u4e0d\u4e00\u81f4", (long)settleRecord2.getLong("maincurrency.id"), (long)mainJournal.getLong("currency.id"));
                KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u672c\u4f4d\u5e01\u4e0e\u7ed3\u7b97\u8bb0\u5f55\u4e3b\u65b9\u5bf9\u5e94\u7684\u672c\u4f4d\u5e01\u4e0d\u4e00\u81f4", (long)settleRecord2.getLong("basecurrency.id"), (long)mainJournal.getLong("basecurrency.id"));
                AmtBaseChecker.assertEquals(settleRecord2.getBigDecimal("totalsettleamt"), mainJournal.getBigDecimal(journalMainAmtKey).negate(), "\u6d41\u6c34\u7684\u91d1\u989d\u4e0e\u7ed3\u7b97\u8bb0\u5f55\u4e3b\u65b9\u5bf9\u5e94\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0d\u4e00\u81f4");
                AmtBaseChecker.assertEquals(settleRecord2.getBigDecimal("localtotalsettleamt"), mainJournal.getBigDecimal(journalMainLocakAmtKey).negate(), "\u6d41\u6c34\u7684\u91d1\u989d\u6298\u672c\u5e01\u4e0e\u7ed3\u7b97\u8bb0\u5f55\u4e3b\u65b9\u5bf9\u5e94\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u4e0d\u4e00\u81f4");
            }
            if (asstAmountType == null) continue;
            DynamicObjectCollection entries = settleRecord2.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                long entryId = entry.getLong("id");
                DynamicObject asstJournal = (DynamicObject)journalMap.get(Long.toString(settleRecordId) + entryId);
                KDAssert.assertEquals((String)"\u7ed3\u7b97\u8bb0\u5f55\u8f85\u65b9\u5bf9\u5e94\u7684\u6d41\u6c34\u4e0d\u5b58\u5728", (boolean)true, (asstJournal != null ? 1 : 0) != 0);
                if (asstJournal == null) continue;
                KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u5f80\u6765\u7c7b\u578b\u4e0e\u7ed3\u7b97\u8bb0\u5f55\u8f85\u65b9\u5bf9\u5e94\u7684\u5f80\u6765\u7c7b\u578b\u4e0d\u4e00\u81f4", (String)entry.getString("asstacttype"), (String)asstJournal.getString("asstacttype"));
                KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u5f80\u6765\u6237\u4e0e\u7ed3\u7b97\u8bb0\u5f55\u8f85\u65b9\u5bf9\u5e94\u7684\u5f80\u6765\u6237\u4e0d\u4e00\u81f4", (long)entry.getLong("asstactid.masterid"), (long)asstJournal.getLong("asstact.masterid"));
                KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u5e01\u522b\u4e0e\u7ed3\u7b97\u8bb0\u5f55\u8f85\u65b9\u5bf9\u5e94\u7684\u5e01\u522b\u4e0d\u4e00\u81f4", (long)entry.getLong("currency.id"), (long)asstJournal.getLong("currency.id"));
                AmtBaseChecker.assertEquals(entry.getBigDecimal("settleamt"), asstJournal.getBigDecimal(asstAmountType.getAmtKey()).negate(), "\u6d41\u6c34\u7684\u91d1\u989d\u4e0e\u7ed3\u7b97\u8bb0\u5f55\u8f85\u65b9\u5bf9\u5e94\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0d\u4e00\u81f4");
                AmtBaseChecker.assertEquals(entry.getBigDecimal("localsettleamt"), asstJournal.getBigDecimal(asstAmountType.getLocalAmtKey()).negate(), "\u6d41\u6c34\u7684\u91d1\u989d\u6298\u672c\u5e01\u4e0e\u7ed3\u7b97\u8bb0\u5f55\u8f85\u65b9\u5bf9\u5e94\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u4e0d\u4e00\u81f4");
            }
        }
    }

    public static void checkSettleAmtAndJournal(Long[] mainIds, Long[] asstIds, boolean isAr) {
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(mainIds, asstIds, isAr);
        SettleRecordTestChecker.checkSettleAmt(settleRecords);
        SettleRecordTestChecker.checkJournal(settleRecords);
    }

    public static void checkSettleAmtAndJournal(DynamicObject[] settleRecords) {
        SettleRecordTestChecker.checkSettleAmt(settleRecords);
        SettleRecordTestChecker.checkJournal(settleRecords);
    }
}

