/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.ArInvoiceBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.ArInvoiceBillDataVO;

public class ArInvoiceBillTestDataProvider {
    private static DynamicObject buildHeader(ArInvoiceBillDataVO billInfo) {
        DynamicObject invBill = BusinessDataServiceHelper.newDynamicObject((String)"ar_invoice");
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        invBill.set("org", (Object)org);
        String billNo = StringUtils.isEmpty((CharSequence)billInfo.getBillNo()) ? "AP-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo();
        invBill.set("billno", (Object)billNo);
        invBill.set("biztype", (Object)"SAL");
        invBill.set("invoicecode", (Object)"AR019_001_001");
        invBill.set("invoiceno", (Object)"AR019_001_002");
        invBill.set("applydate", (Object)new Date());
        invBill.set("bizdate", (Object)new Date());
        invBill.set("invoicetype", (Object)"GE");
        invBill.set("remark", (Object)(billNo + "\u5355\u5143\u6d4b\u8bd5\u7528"));
        invBill.set("billsrctype", (Object)"0");
        invBill.set("seller", (Object)org);
        invBill.set("sellername", (Object)org.getString("name"));
        invBill.set("sellertin", (Object)"test123");
        invBill.set("selleraddr", (Object)"test123");
        invBill.set("sellertel", (Object)"test123");
        invBill.set("sellerbank", (Object)"test123");
        invBill.set("selleracct", (Object)"test123");
        DynamicObject customer = BaseDataTestProvider.getCustomer();
        invBill.set("buyer", (Object)customer);
        invBill.set("buyername", (Object)customer.getString("name"));
        invBill.set("buyertin", (Object)"test123");
        invBill.set("buyeraddr", (Object)"test123");
        invBill.set("buyertel", (Object)"test123");
        invBill.set("buyerbank", (Object)"test123");
        invBill.set("buyeracct", (Object)"test123");
        invBill.set("currency", (Object)billInfo.getCurrency());
        invBill.set("basecurrency", (Object)billInfo.getCurrency());
        invBill.set("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        invBill.set("exratedate", (Object)new Date());
        invBill.set("exchangerate", (Object)billInfo.getExchangerate());
        invBill.set("recorg", (Object)org);
        invBill.set("paymode", (Object)"CREDIT");
        invBill.set("duedate", (Object)new Date());
        invBill.set("asstacttype", (Object)"bd_customer");
        invBill.set("asstact", (Object)customer);
        invBill.set("billstatus", (Object)"C");
        invBill.set("invoicestatus", (Object)"0");
        invBill.set("creator", (Object)1L);
        invBill.set("isincludetax", (Object)Boolean.FALSE);
        return invBill;
    }

    public static DynamicObject buildByPriceAndQuantity(String billNo, List<ArInvoiceBillDataDetailVO> entryInfoList) {
        return ArInvoiceBillTestDataProvider.buildByPriceAndQuantity(billNo, null, entryInfoList);
    }

    public static DynamicObject buildByPriceAndQuantity(String billNo, DynamicObject org, List<ArInvoiceBillDataDetailVO> entryInfoList) {
        ArInvoiceBillDataVO billInfo = ArInvoiceBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo(billNo).setOrg(org);
        return ArInvoiceBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryInfoList);
    }

    public static DynamicObject buildByPriceAndQuantity(ArInvoiceBillDataVO billInfo, List<ArInvoiceBillDataDetailVO> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)"ar_invoice", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject invInfo = ArInvoiceBillTestDataProvider.buildHeader(billInfo);
        DynamicObjectType dataEntityType = (DynamicObjectType)invInfo.getDataEntityType();
        DynamicObjectType detailEntryType = ((EntryProp)dataEntityType.getProperty("entry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection detailEntries = invInfo.getDynamicObjectCollection("entry");
        BigDecimal recamountHeader = BigDecimal.ZERO;
        BigDecimal localRecamountHeader = BigDecimal.ZERO;
        BigDecimal amountHeader = BigDecimal.ZERO;
        BigDecimal localAmountHeader = BigDecimal.ZERO;
        BigDecimal taxHeader = BigDecimal.ZERO;
        for (ArInvoiceBillDataDetailVO entryInfo : entryInfoList) {
            DynamicObject detailEntry = new DynamicObject(detailEntryType);
            BigDecimal pricetaxTotal = entryInfo.getPrice().multiply(entryInfo.getQuantity()).setScale(2, RoundingMode.HALF_UP);
            BigDecimal localAmount = pricetaxTotal.multiply(billInfo.getExchangerate()).setScale(2, RoundingMode.HALF_UP);
            BigDecimal taxrate = entryInfo.getE_taxrate() == null ? BigDecimal.ZERO : entryInfo.getE_taxrate();
            BigDecimal tax = pricetaxTotal.multiply(taxrate);
            DynamicObject material = BaseDataTestProvider.getMaterial();
            detailEntry.set("seq", (Object)entryInfo.getSeq());
            detailEntry.set("e_material", (Object)material);
            detailEntry.set("e_discountmode", (Object)"NULL");
            detailEntry.set("e_corebilltype", (Object)"sm_salorder");
            detailEntry.set("e_taxclass", (Object)101010101L);
            detailEntry.set("taxrateid", (Object)entryInfo.getTaxrateid());
            detailEntry.set("e_taxrate", (Object)taxrate.multiply(BigDecimal.valueOf(100L)));
            detailEntry.set("e_baseunitqty", (Object)entryInfo.getQuantity());
            detailEntry.set("e_quantity", (Object)entryInfo.getQuantity());
            detailEntry.set("e_measureunit", (Object)entryInfo.getQuantity());
            detailEntry.set("e_baseunit", (Object)entryInfo.getQuantity());
            detailEntry.set("e_unitcoefficient", (Object)1);
            detailEntry.set("e_ispresent", (Object)Boolean.FALSE);
            detailEntry.set("e_unitprice", (Object)entryInfo.getPrice());
            detailEntry.set("e_actunitprice", (Object)entryInfo.getPrice());
            detailEntry.set("e_taxunitprice", (Object)entryInfo.getPrice().add(entryInfo.getPrice().multiply(taxrate)));
            detailEntry.set("e_taxunitprice", (Object)entryInfo.getPrice().add(entryInfo.getPrice().multiply(taxrate)));
            detailEntry.set("e_amount", (Object)pricetaxTotal);
            detailEntry.set("e_localamt", (Object)localAmount);
            detailEntry.set("e_tax", (Object)tax);
            detailEntry.set("e_recamount", (Object)pricetaxTotal.add(tax));
            detailEntry.set("e_reclocalamt", (Object)localAmount.add(tax));
            detailEntry.set("e_verifiedwriteoffamt", (Object)BigDecimal.ZERO);
            detailEntry.set("e_unverifiedwriteoffamt", (Object)pricetaxTotal.add(tax));
            detailEntry.set("e_verifiedwriteoffqty", (Object)BigDecimal.ZERO);
            detailEntry.set("e_unverifiedwriteoffqty", (Object)entryInfo.getQuantity());
            detailEntry.set("e_associatedamt", (Object)BigDecimal.ZERO);
            detailEntry.set("e_invresult", (Object)"0");
            detailEntry.set("e_itemname", (Object)material.getString("name"));
            detailEntry.set("e_rowtype", (Object)"0");
            detailEntries.add((Object)detailEntry);
            recamountHeader = recamountHeader.add(pricetaxTotal.add(tax));
            localRecamountHeader = localRecamountHeader.add(localAmount.add(tax));
            amountHeader = amountHeader.add(pricetaxTotal);
            localAmountHeader = localAmountHeader.add(localAmount);
            taxHeader = taxHeader.add(tax);
        }
        invInfo.set("recamount", (Object)recamountHeader);
        invInfo.set("reclocalamt", (Object)localRecamountHeader);
        invInfo.set("amount", (Object)amountHeader);
        invInfo.set("localamt", (Object)localAmountHeader);
        invInfo.set("tax", (Object)taxHeader);
        invInfo.set("associatedamt", (Object)BigDecimal.ZERO);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invInfo});
        return invInfo;
    }
}

