/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;

public class BaddebtlossBillTestDataProvider {
    public static DynamicObject buildBill(String billno, DynamicObject org, BigDecimal amout, boolean isIndirect) {
        if (StringUtils.isNotEmpty((CharSequence)billno)) {
            DeleteServiceHelper.delete((String)"ar_baddebtlossbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
        }
        DynamicObject finBill = BusinessDataServiceHelper.newDynamicObject((String)"ar_baddebtlossbill");
        finBill.set("org", (Object)(org == null ? BaseDataTestProvider.getDetailInitOrg() : org));
        String billNo = StringUtils.isEmpty((CharSequence)billno) ? "BAD-" + DBServiceHelper.genGlobalLongId() : billno;
        finBill.set("billno", (Object)billNo);
        finBill.set("bizdate", (Object)new Date());
        finBill.set("billstatus", (Object)"C");
        finBill.set("settlestatus", (Object)"unsettle");
        finBill.set("asstacttype", (Object)"bd_customer");
        finBill.set("asstact", (Object)BaseDataTestProvider.getCustomer());
        finBill.set("currency", (Object)BaseDataTestProvider.getCurrencyCNY());
        finBill.set("basecurrency", (Object)BaseDataTestProvider.getCurrencyCNY());
        finBill.set("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        finBill.set("exchangerate", (Object)1L);
        finBill.set("recamt", (Object)amout);
        finBill.set("baddebtamt", (Object)amout);
        if (isIndirect) {
            finBill.set("quotation", (Object)"1");
        }
        DynamicObjectType dataEntityType = (DynamicObjectType)finBill.getDataEntityType();
        DynamicObjectType detailEntryType = ((EntryProp)dataEntityType.getProperty("entry")).getDynamicCollectionItemPropertyType();
        DynamicObject detailEntry = new DynamicObject(detailEntryType);
        detailEntry.set("e_material", (Object)BaseDataTestProvider.getMaterial());
        detailEntry.set("e_baddebtamt", (Object)amout);
        detailEntry.set("e_baddebtlocamt", (Object)amout);
        detailEntry.set("e_unlockamt", (Object)amout);
        detailEntry.set("e_unsettleamt", (Object)amout);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        detailEntries.add((Object)detailEntry);
        DynamicObjectType planEntityType = ((EntryProp)dataEntityType.getProperty("planentry")).getDynamicCollectionItemPropertyType();
        DynamicObject planEntry = new DynamicObject(planEntityType);
        planEntry.set("p_baddebtamt", (Object)amout);
        planEntry.set("p_baddebtlocamt", (Object)amout);
        planEntry.set("p_unlockamt", (Object)amout);
        planEntry.set("p_unsettleamt", (Object)amout);
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentry");
        planEntries.add((Object)planEntry);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill});
        return finBill;
    }

    public static DynamicObject[] loadData(Long[] ids) {
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ar_baddebtlossbill"));
    }

    public static DynamicObject loadSingle(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"ar_baddebtlossbill");
    }
}

