/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.OperationWebApiImpl;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.unittest.SceneTestHelper;

public class BaseDataProvider {
    private static final Log logger = LogFactory.getLog(BaseDataProvider.class);
    public static final String SCENE_TEST = "sceneTest";
    private boolean prepared = false;
    private ReentrantLock lock = new ReentrantLock();
    private static final String jsonName = "basedata.json";

    public DynamicObject getUnInitOrg() {
        return this.getOrgCache("unInitOrg");
    }

    public DynamicObject getPlanInitOrg() {
        return this.getOrgCache("planInitOrg");
    }

    public DynamicObject getDetailInitOrg() {
        return this.getOrgCache("detailInitOrg");
    }

    public DynamicObject getSupplier() {
        DynamicObject supplier;
        Map cache = ConfigCache.get(SCENE_TEST, "supplier", Map.class);
        if (ObjectUtils.isEmpty((Object)cache)) {
            QFilter qFilter = new QFilter("number", "=", (Object)"Sup-66666666");
            DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id, name, number", (QFilter[])new QFilter[]{qFilter});
            if (ObjectUtils.isEmpty((Object)obj)) {
                this.prepare();
                obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id, name, number", (QFilter[])new QFilter[]{qFilter});
            }
            ConfigCache.put(SCENE_TEST, "supplier", this.convertMap(obj));
            supplier = obj;
        } else {
            supplier = this.getDynamicObject("bd_supplier", cache);
        }
        return supplier;
    }

    public DynamicObject getCustomer() {
        DynamicObject customer;
        Map cache = ConfigCache.get(SCENE_TEST, "customer", Map.class);
        if (ObjectUtils.isEmpty((Object)cache)) {
            QFilter qFilter = new QFilter("number", "=", (Object)"Cus-88888888");
            DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_customer", (String)"id, name, number", (QFilter[])new QFilter[]{qFilter});
            if (ObjectUtils.isEmpty((Object)obj)) {
                this.prepare();
                obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_customer", (String)"id, name, number", (QFilter[])new QFilter[]{qFilter});
            }
            ConfigCache.put(SCENE_TEST, "customer", this.convertMap(obj));
            customer = obj;
        } else {
            customer = this.getDynamicObject("bd_customer", cache);
        }
        return customer;
    }

    public DynamicObject getMaterial() {
        DynamicObject material;
        Map cache = ConfigCache.get(SCENE_TEST, "material", Map.class);
        if (ObjectUtils.isEmpty((Object)cache)) {
            QFilter qFilter = new QFilter("number", "=", (Object)"Item-55555555");
            DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (String)"id, name, number", (QFilter[])new QFilter[]{qFilter});
            if (ObjectUtils.isEmpty((Object)obj)) {
                this.prepare();
                obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (String)"id, name, number", (QFilter[])new QFilter[]{qFilter});
            }
            ConfigCache.put(SCENE_TEST, "material", this.convertMap(obj));
            material = obj;
        } else {
            material = this.getDynamicObject("bd_material", cache);
        }
        return material;
    }

    private DynamicObject getOrgCache(String cacheKey) {
        DynamicObject org;
        Map cache = ConfigCache.get(SCENE_TEST, cacheKey, Map.class);
        if (ObjectUtils.isEmpty((Object)cache)) {
            String number = "BU-55555555";
            if ("planInitOrg".equals(cacheKey)) {
                number = "BU-66666666";
            } else if ("detailInitOrg".equals(cacheKey)) {
                number = "BU-77777777";
            }
            QFilter qFilter = new QFilter("number", "=", (Object)number);
            DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id, name, number", (QFilter[])new QFilter[]{qFilter});
            if (ObjectUtils.isEmpty((Object)obj)) {
                this.prepare();
                obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id, name, number", (QFilter[])new QFilter[]{qFilter});
            }
            ConfigCache.put(SCENE_TEST, cacheKey, this.convertMap(obj));
            org = obj;
        } else {
            org = this.getDynamicObject("bos_org", cache);
        }
        return org;
    }

    private Object convertMap(DynamicObject obj) {
        HashMap<String, Object> m = new HashMap<String, Object>(3);
        m.put("id", obj.getLong("id"));
        m.put("name", obj.getLocaleString("name").getLocaleValue());
        m.put("number", obj.getString("number"));
        return m;
    }

    private DynamicObject getDynamicObject(String entityKey, Map<String, Object> cache) {
        DynamicObject obj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityKey));
        obj.set("id", cache.get("id"));
        obj.set("name", cache.get("name"));
        obj.set("number", cache.get("number"));
        return obj;
    }

    public void prepare() {
        if (this.prepared) {
            return;
        }
        try {
            this.lock.lock();
            String json = SceneTestHelper.getFileContent(this.getClass(), jsonName);
            Map baseMap = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
            this.prepareOrg((List)baseMap.get("org"));
            this.prepareBasedata("bd_supplier", "Sup-66666666");
            this.prepareBasedata("bd_customer", "Cus-88888888");
            this.prepareMaterial();
            this.prepareWarehouse();
            this.prepared = true;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void prepareOrg(List<Map<String, Object>> orgs) {
        ArrayList<OrgParam> paramList = new ArrayList<OrgParam>(3);
        for (Map<String, Object> orgMap : orgs) {
            OrgParam param = new OrgParam();
            long pk = Long.parseLong(orgMap.get("id").toString());
            param.setCustomOrgId(pk);
            param.setNumber((String)orgMap.get("number"));
            param.setName((String)orgMap.get("name"));
            param.setOrgPatternId(1L);
            TreeMap<String, OrgDutyView> multiViewMap = new TreeMap<String, OrgDutyView>();
            multiViewMap.put("10", this.getDutyView());
            multiViewMap.put("02", this.getDutyView());
            multiViewMap.put("03", this.getDutyView());
            multiViewMap.put("04", this.getDutyView());
            multiViewMap.put("05", this.getDutyView());
            multiViewMap.put("07", this.getDutyView());
            multiViewMap.put("08", this.getDutyView());
            multiViewMap.put("09", this.getDutyView());
            multiViewMap.put("11", this.getDutyView());
            multiViewMap.put("12", this.getDutyView());
            param.setMultiViewMap(multiViewMap);
            paramList.add(param);
        }
        OrgUnitServiceHelper.addOrUpdate(paramList);
        StringBuffer error = null;
        for (OrgParam result : paramList) {
            if (result.isSuccess()) continue;
            if (error == null) {
                error = new StringBuffer("---\u521b\u5efa\u7ec4\u7ec7\u5931\u8d25\uff1a");
            }
            error.append(result.getNumber()).append('-').append(result.getMsg());
        }
        if (error != null) {
            throw new KDBizException(error.toString());
        }
        this.prepareInit();
    }

    private OrgDutyView getDutyView() {
        OrgDutyView dutyView = new OrgDutyView();
        dutyView.setParentId(100000L);
        return dutyView;
    }

    private void prepareInit() {
        String sqlName = "kd_1.5.1_arap_init.sql";
        String insSQL = SceneTestHelper.getFileContent(this.getClass(), sqlName);
        if (insSQL != null) {
            try (TXHandle h = TX.required();){
                DB.execute((DBRoute)DBRouteConst.AP, (String)insSQL);
            }
            catch (Exception e) {
                logger.error("---\u6267\u884c\u811a\u672c\u5931\u8d25\uff1a", (Throwable)e);
                throw new KDBizException("---\u6267\u884c\u811a\u672c\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    private void prepareMaterial() {
        Long pk = this.prepareBasedata("bd_material", "Item-55555555");
        this.executeSql(pk);
    }

    private Long prepareBasedata(String entityKey, String number) {
        Long pk = null;
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        DynamicObject basedata = QueryServiceHelper.queryOne((String)entityKey, (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (!ObjectUtils.isEmpty((Object)basedata)) {
            pk = basedata.getLong("id");
        } else {
            String jsonName = "basedata/" + entityKey + ".json";
            String json = SceneTestHelper.getFileContent(this.getClass(), jsonName);
            Map m = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
            HashMap req = new HashMap(2);
            req.put("data", m.get("data"));
            OperationWebApiImpl impl = new OperationWebApiImpl();
            Map result = impl.executeOperation(entityKey, "save", req);
            boolean isSuccess = (Boolean)result.get("success");
            if (isSuccess) {
                OperationResult opResult = (OperationResult)result.get("data");
                pk = (Long)opResult.getSuccessPkIds().get(0);
                Object[] pks = new Object[]{pk};
                OperationServiceHelper.executeOperate((String)"submit", (String)entityKey, (Object[])pks, (OperateOption)OperateOption.create());
                OperationServiceHelper.executeOperate((String)"audit", (String)entityKey, (Object[])pks, (OperateOption)OperateOption.create());
            } else {
                String message = SerializationUtils.toJsonString((Object)result);
                logger.error("jsonName = " + jsonName + ", error = " + message);
                throw new KDBizException("\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff1a" + result.get(message));
            }
        }
        return pk;
    }

    private void executeSql(Long pk) {
        String sqlName = "basedata/kd_1.5.1_bd_material_init.sql";
        String insSQL = SceneTestHelper.getFileContent(this.getClass(), sqlName);
        if ((insSQL = insSQL.replaceAll("%s", pk.toString())) != null) {
            try (TXHandle h = TX.required();){
                DB.execute((DBRoute)DBRouteConst.BASEDATA, (String)insSQL);
            }
            catch (Exception e) {
                logger.error("---\u6267\u884c\u811a\u672c\u5931\u8d25\uff1a", (Throwable)e);
                throw new KDBizException("---\u6267\u884c\u811a\u672c\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    private void prepareWarehouse() {
        String sqlName = "basedata/kd_1.5.1_bd_warehouse_init.sql";
        String insSQL = SceneTestHelper.getFileContent(this.getClass(), sqlName);
        if (insSQL != null) {
            try (TXHandle h = TX.required();){
                DB.execute((DBRoute)DBRouteConst.BASEDATA, (String)insSQL);
            }
            catch (Exception e) {
                logger.error("---\u6267\u884c\u811a\u672c\u5931\u8d25\uff1a", (Throwable)e);
                throw new KDBizException("---\u6267\u884c\u811a\u672c\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        this.prepareIm();
    }

    private void prepareIm() {
        String sqlName = "kd_1.5.1_im_init.sql";
        String insSQL = SceneTestHelper.getFileContent(this.getClass(), sqlName);
        if (insSQL != null) {
            try (TXHandle h = TX.required();){
                DB.execute((DBRoute)new DBRoute("im"), (String)insSQL);
            }
            catch (Exception e) {
                logger.error("---\u6267\u884c\u811a\u672c\u5931\u8d25\uff1a", (Throwable)e);
                throw new KDBizException("---\u6267\u884c\u811a\u672c\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }
}

