/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.BusArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.BusArBillDataVO;

public class BusArBillTestDataProvider {
    public static DynamicObject buildByHeadPriceTaxTotal(BigDecimal priceTaxTotal) {
        return BusArBillTestDataProvider.buildByHeadPriceTaxTotal("", priceTaxTotal);
    }

    public static DynamicObject buildByHeadPriceTaxTotal(String billNo, BigDecimal priceTaxTotal) {
        return BusArBillTestDataProvider.buildByHeadPriceTaxTotal(billNo, null, priceTaxTotal);
    }

    public static DynamicObject buildByHeadPriceTaxTotal(String billNo, DynamicObject org, BigDecimal priceTaxTotal) {
        BusArBillDataVO billInfo = new BusArBillDataVO();
        billInfo.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setPricetaxTotal(priceTaxTotal).setBillNo(billNo).setOrg(org);
        return BusArBillTestDataProvider.buildByHeadPriceTaxTotal(billInfo);
    }

    public static DynamicObject buildByHeadPriceTaxTotal(BusArBillDataVO billInfo) {
        ArrayList<BusArBillDataDetailVO> entryInfoList = new ArrayList<BusArBillDataDetailVO>(1);
        BusArBillDataDetailVO detailInfo = new BusArBillDataDetailVO();
        detailInfo.setPrice(billInfo.getPricetaxTotal()).setQuantity(BigDecimal.ONE);
        entryInfoList.add(detailInfo);
        return BusArBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryInfoList);
    }

    public static DynamicObject buildByPriceAndQuantity(List<BusArBillDataDetailVO> entryInfoList) {
        return BusArBillTestDataProvider.buildByPriceAndQuantity("", entryInfoList);
    }

    public static DynamicObject buildByPriceAndQuantity(String billNo, List<BusArBillDataDetailVO> entryInfoList) {
        return BusArBillTestDataProvider.buildByPriceAndQuantity(billNo, null, entryInfoList);
    }

    public static DynamicObject buildByPriceAndQuantity(String billNo, DynamicObject org, List<BusArBillDataDetailVO> entryInfoList) {
        BusArBillDataVO billInfo = new BusArBillDataVO();
        billInfo.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo(billNo).setOrg(org);
        return BusArBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryInfoList);
    }

    public static DynamicObject buildByPriceAndQuantity(BusArBillDataVO billInfo, List<BusArBillDataDetailVO> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject finBill = BusArBillTestDataProvider.buildHeader(billInfo);
        DynamicObjectType dataEntityType = (DynamicObjectType)finBill.getDataEntityType();
        DynamicObjectType detailEntryType = ((EntryProp)dataEntityType.getProperty("entry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        BigDecimal pricetaxTotalHeader = BigDecimal.ZERO;
        BigDecimal localAmtHeader = BigDecimal.ZERO;
        int seq = 0;
        for (BusArBillDataDetailVO entryInfo : entryInfoList) {
            DynamicObject detailEntry = new DynamicObject(detailEntryType);
            BigDecimal pricetaxTotal = entryInfo.getPrice().multiply(entryInfo.getQuantity()).setScale(2, RoundingMode.HALF_UP);
            BigDecimal localAmount = pricetaxTotal.multiply(billInfo.getExchangerate()).setScale(2, RoundingMode.HALF_UP);
            detailEntry.set("seq", (Object)(entryInfo.getSeq() == 0 ? seq : entryInfo.getSeq()));
            ++seq;
            DynamicObject material = BaseDataTestProvider.getMaterial();
            detailEntry.set("e_material", (Object)material);
            long baseunitId = material.getLong("baseunit.id");
            detailEntry.set("e_baseunit", (Object)baseunitId);
            detailEntry.set("e_measureunit", (Object)baseunitId);
            detailEntry.set("e_baseunitqty", (Object)entryInfo.getQuantity());
            detailEntry.set("e_quantity", (Object)entryInfo.getQuantity());
            detailEntry.set("e_unrelateinvqty", (Object)entryInfo.getQuantity());
            detailEntry.set("e_unitprice", (Object)entryInfo.getPrice());
            detailEntry.set("e_taxunitprice", (Object)entryInfo.getPrice());
            detailEntry.set("e_actunitprice", (Object)entryInfo.getPrice());
            detailEntry.set("e_acttaxunitprice", (Object)entryInfo.getPrice());
            detailEntry.set("e_recamount", (Object)pricetaxTotal);
            detailEntry.set("e_unrelateinvamt", (Object)pricetaxTotal);
            detailEntry.set("e_reclocalamt", (Object)localAmount);
            detailEntry.set("e_unrelateinvlocamt", (Object)localAmount);
            detailEntry.set("e_amount", (Object)pricetaxTotal);
            detailEntry.set("e_unwoffnotaxamt", (Object)pricetaxTotal);
            detailEntry.set("e_localamt", (Object)localAmount);
            detailEntry.set("e_unwoffnotaxlocamt", (Object)localAmount);
            detailEntry.set("e_unconfirmamt", (Object)pricetaxTotal);
            detailEntry.set("e_uninvoicedamt", (Object)pricetaxTotal);
            detailEntry.set("e_uninvoicedlocamt", (Object)localAmount);
            detailEntry.set("e_uninvnotaxamt", (Object)pricetaxTotal);
            detailEntry.set("e_uninvnotaxlocalamt", (Object)localAmount);
            detailEntry.set("e_uninvnotaxamt", (Object)pricetaxTotal);
            detailEntry.set("e_uninvnotaxlocalamt", (Object)localAmount);
            detailEntry.set("e_unwoffamt", (Object)pricetaxTotal);
            detailEntry.set("e_unwofflocamt", (Object)localAmount);
            detailEntry.set("e_uninvoicedqty", (Object)entryInfo.getQuantity());
            detailEntry.set("e_unwoffqty", (Object)entryInfo.getQuantity());
            detailEntry.set("e_discountmode", (Object)"NULL");
            detailEntry.set("e_corebilltype", (Object)entryInfo.getCorebilltype());
            detailEntry.set("e_corebillno", (Object)entryInfo.getCorebillno());
            detailEntry.set("corebillid", (Object)entryInfo.getCorebillid());
            detailEntry.set("e_corebillentryseq", (Object)entryInfo.getCorebillentryseq());
            detailEntry.set("corebillentryid", (Object)entryInfo.getCorebillentryid());
            detailEntry.set("groupnumber", (Object)entryInfo.getGroupnumber());
            detailEntry.set("groupseq", (Object)entryInfo.getGroupseq());
            detailEntries.add((Object)detailEntry);
            pricetaxTotalHeader = pricetaxTotalHeader.add(pricetaxTotal);
            localAmtHeader = localAmtHeader.add(localAmount);
        }
        finBill.set("recamount", (Object)pricetaxTotalHeader);
        finBill.set("reclocalamt", (Object)localAmtHeader);
        finBill.set("amount", (Object)pricetaxTotalHeader);
        finBill.set("localamt", (Object)localAmtHeader);
        finBill.set("unwoffnotaxamt", (Object)pricetaxTotalHeader);
        finBill.set("unwoffnotaxlocamt", (Object)localAmtHeader);
        finBill.set("unwoffamt", (Object)pricetaxTotalHeader);
        finBill.set("unwofflocamt", (Object)localAmtHeader);
        finBill.set("uninvoicedamt", (Object)pricetaxTotalHeader);
        finBill.set("uninvoicedlocamt", (Object)localAmtHeader);
        finBill.set("unrelateinvamt", (Object)pricetaxTotalHeader);
        finBill.set("unrelateinvlocamt", (Object)localAmtHeader);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill});
        return finBill;
    }

    public static DynamicObject[] loadData(Long[] ids) {
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"ar_busbill").getDynamicObjectType());
    }

    public static DynamicObject loadSingle(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"ar_busbill");
    }

    private static DynamicObject buildHeader(BusArBillDataVO billInfo) {
        DynamicObject finBill = BusinessDataServiceHelper.newDynamicObject((String)"ar_busbill");
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        finBill.set("org", (Object)org);
        finBill.set("recorg", (Object)org);
        String billNo = StringUtils.isEmpty((CharSequence)billInfo.getBillNo()) ? "BUSAR-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo();
        finBill.set("billno", (Object)billNo);
        finBill.set("bizdate", (Object)new Date());
        finBill.set("duedate", (Object)new Date());
        finBill.set("bookdate", (Object)new Date());
        finBill.set("exratedate", (Object)new Date());
        finBill.set("asstacttype", (Object)"bd_customer");
        finBill.set("asstact", (Object)BaseDataTestProvider.getCustomer());
        finBill.set("paymode", (Object)"CASH");
        DynamicObject payProperty = billInfo.getPayProperty() == null ? BaseDataTestProvider.getRecProperty() : billInfo.getPayProperty();
        finBill.set("payproperty", (Object)payProperty);
        long currency = billInfo.getCurrency() == null ? BaseDataTestProvider.getCurrencyCNY().getLong("id") : billInfo.getCurrency().longValue();
        finBill.set("currency", (Object)currency);
        finBill.set("basecurrency", (Object)BaseDataTestProvider.getCurrencyCNY());
        finBill.set("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        BigDecimal exchangeRate = billInfo.getExchangerate() == null ? BigDecimal.ONE : billInfo.getExchangerate();
        finBill.set("exchangerate", (Object)exchangeRate);
        String billStatus = billInfo.getBillStatus() == null ? "C" : billInfo.getBillStatus();
        finBill.set("billstatus", (Object)billStatus);
        finBill.set("creator", (Object)1L);
        finBill.set("billtype", (Object)676495785168226304L);
        return finBill;
    }
}

