/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataVO;

public class CasPayBillTestDataProvider {
    public static DynamicObject buildByHeadPriceTaxTotal(BigDecimal amount) {
        return CasPayBillTestDataProvider.buildByHeadPriceTaxTotal("", amount);
    }

    public static DynamicObject buildByHeadPriceTaxTotal(String billNo, BigDecimal amount) {
        CasPayBillDataVO billInfo = CasPayBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setPricetaxTotal(amount).setBillNo(billNo);
        ArrayList<CasPayBillDataDetailVO> entryInfoList = new ArrayList<CasPayBillDataDetailVO>(1);
        entryInfoList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(amount));
        return CasPayBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, entryInfoList);
    }

    public static DynamicObject buildByEntryPriceTaxTotal(List<CasPayBillDataDetailVO> entryInfoList) {
        return CasPayBillTestDataProvider.buildByEntryPriceTaxTotal("", entryInfoList);
    }

    public static DynamicObject buildByEntryPriceTaxTotal(String billNo, List<CasPayBillDataDetailVO> entryInfoList) {
        CasPayBillDataVO billInfo = CasPayBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo(billNo);
        return CasPayBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, entryInfoList);
    }

    public static DynamicObject buildByEntryPriceTaxTotal(String billNo, DynamicObject org, List<CasPayBillDataDetailVO> entryInfoList) {
        CasPayBillDataVO billInfo = CasPayBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo(billNo).setOrg(org);
        return CasPayBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, entryInfoList);
    }

    public static DynamicObject buildByEntryPriceTaxTotal(CasPayBillDataVO billInfo, List<CasPayBillDataDetailVO> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject payBill = BusinessDataServiceHelper.newDynamicObject((String)"cas_paybill");
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        payBill.set("openorg", (Object)org);
        payBill.set("org", (Object)org);
        payBill.set("billno", (Object)(StringUtils.isEmpty((CharSequence)billInfo.getBillNo()) ? "PV-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo()));
        payBill.set("bizdate", (Object)new Date());
        payBill.set("currency", (Object)billInfo.getCurrency());
        payBill.set("basecurrency", (Object)BaseDataTestProvider.getCurrencyCNY());
        payBill.set("payquotation", (Object)billInfo.getQuotation());
        payBill.set("exchangerate", (Object)billInfo.getExchangerate());
        payBill.set("payeetype", (Object)"bd_supplier");
        payBill.set("itempayeetype", (Object)"bd_supplier");
        payBill.set("payee", (Object)(billInfo.getAsstactId() != null && billInfo.getAsstactId() != 0L ? billInfo.getAsstactId().longValue() : BaseDataTestProvider.getSupplier().getLong("id")));
        payBill.set("billstatus", (Object)billInfo.getStatus());
        payBill.set("billtype", (Object)326564972232466432L);
        payBill.set("matchflag", (Object)"0");
        payBill.set("paymenttype", (Object)BaseDataTestProvider.getPaymentType());
        DynamicObjectType dataEntityType = (DynamicObjectType)payBill.getDataEntityType();
        DynamicObjectType entrydt = ((EntryProp)dataEntityType.getProperty("entry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection entry = payBill.getDynamicObjectCollection("entry");
        BigDecimal pricetaxTotalHeader = BigDecimal.ZERO;
        for (CasPayBillDataDetailVO entryInfo : entryInfoList) {
            DynamicObject row = new DynamicObject(entrydt);
            BigDecimal amount = entryInfo.getPriceTaxTotal().setScale(2, RoundingMode.HALF_UP);
            BigDecimal localAmount = amount.multiply(billInfo.getExchangerate()).setScale(2, RoundingMode.HALF_UP);
            row.set("seq", (Object)entryInfo.getSeq());
            row.set("settleorg", (Object)org);
            row.set("e_paymenttype", (Object)BaseDataTestProvider.getPaymentType());
            row.set("e_material", (Object)BaseDataTestProvider.getMaterial());
            row.set("e_corebilltype", (Object)"pm_purorderbill");
            row.set("e_corebillno", (Object)entryInfo.getCorebillno());
            row.set("e_corebillentryseq", (Object)entryInfo.getCorebillentryseq());
            row.set("e_payableamt", (Object)amount);
            row.set("e_payablelocamt", (Object)localAmount);
            row.set("e_actamt", (Object)amount);
            row.set("e_localamt", (Object)localAmount);
            row.set("e_remainrefundamt", (Object)amount);
            row.set("e_unlockamt", (Object)amount);
            row.set("e_unsettledamt", (Object)amount);
            row.set("e_unsettledlocalamt", (Object)localAmount);
            pricetaxTotalHeader = pricetaxTotalHeader.add(amount);
            entry.add((Object)row);
        }
        payBill.set("actpayamt", (Object)pricetaxTotalHeader);
        payBill.set("totalremainrefundamt", (Object)pricetaxTotalHeader);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payBill});
        return BusinessDataServiceHelper.loadSingle((Object)payBill.getLong("id"), (String)"cas_paybill");
    }

    public static DynamicObject[] loadData(Long[] ids) {
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"cas_paybill").getDynamicObjectType());
    }

    public static DynamicObject loadSingle(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"cas_paybill");
    }
}

