/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataVO;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinApBillTestDataProvider {
    public static DynamicObject buildByHeadPriceTaxTotal(BigDecimal priceTaxTotal) {
        return FinApBillTestDataProvider.buildByHeadPriceTaxTotal("", priceTaxTotal);
    }

    public static DynamicObject buildByHeadPriceTaxTotal(String billNo, BigDecimal priceTaxTotal) {
        return FinApBillTestDataProvider.buildByHeadPriceTaxTotal(billNo, null, priceTaxTotal);
    }

    public static DynamicObject buildByHeadPriceTaxTotal(String billNo, DynamicObject org, BigDecimal priceTaxTotal) {
        FinApBillDataVO billInfo = new FinApBillDataVO();
        billInfo.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setPricetaxTotal(priceTaxTotal).setBillNo(billNo).setOrg(org);
        return FinApBillTestDataProvider.buildByHeadPriceTaxTotal(billInfo);
    }

    public static DynamicObject buildByHeadPriceTaxTotal(FinApBillDataVO billInfo) {
        ArrayList<FinApBillDataDetailVO> entryInfoList = new ArrayList<FinApBillDataDetailVO>(1);
        FinApBillDataDetailVO detailInfo = new FinApBillDataDetailVO();
        detailInfo.setPrice(billInfo.getPricetaxTotal()).setQuantity(BigDecimal.ONE);
        entryInfoList.add(detailInfo);
        return FinApBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryInfoList);
    }

    public static DynamicObject buildByPriceAndQuantity(List<FinApBillDataDetailVO> entryInfoList) {
        return FinApBillTestDataProvider.buildByPriceAndQuantity("", entryInfoList);
    }

    public static DynamicObject buildByPriceAndQuantity(String billNo, List<FinApBillDataDetailVO> entryInfoList) {
        return FinApBillTestDataProvider.buildByPriceAndQuantity(billNo, null, entryInfoList);
    }

    public static DynamicObject buildByPriceAndQuantity(String billNo, DynamicObject org, List<FinApBillDataDetailVO> entryInfoList) {
        FinApBillDataVO billInfo = new FinApBillDataVO();
        billInfo.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo(billNo).setOrg(org);
        return FinApBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryInfoList);
    }

    public static DynamicObject buildNewByPriceAndQuantity(String billNo, DynamicObject org, List<FinApBillDataDetailVO> entryInfoList) {
        return FinApBillTestDataProvider.buildByPriceAndQuantity(billNo, org, "1", entryInfoList);
    }

    public static DynamicObject buildByPriceAndQuantity(String billNo, DynamicObject org, String settleVersion, List<FinApBillDataDetailVO> entryInfoList) {
        FinApBillDataVO billInfo = new FinApBillDataVO();
        billInfo.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo(billNo).setOrg(org).setSettleVersion(settleVersion);
        return FinApBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryInfoList);
    }

    public static DynamicObject buildByPriceAndQuantity(FinApBillDataVO billInfo, List<FinApBillDataDetailVO> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)"ap_finapbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject finBill = FinApBillTestDataProvider.buildHeader(billInfo);
        DynamicObjectType dataEntityType = (DynamicObjectType)finBill.getDataEntityType();
        DynamicObjectType detailEntryType = ((EntryProp)dataEntityType.getProperty("detailentry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("detailentry");
        DynamicObjectType planEntryType = ((EntryProp)dataEntityType.getProperty("planentity")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        BigDecimal pricetaxTotalHeader = BigDecimal.ZERO;
        BigDecimal localAmtHeader = BigDecimal.ZERO;
        Set negativeQuantity = entryInfoList.stream().filter(entryInfo -> entryInfo.getQuantity().compareTo(BigDecimal.ZERO) < 0).collect(Collectors.toSet());
        for (FinApBillDataDetailVO entryInfo2 : entryInfoList) {
            DynamicObject detailEntry = new DynamicObject(detailEntryType);
            BigDecimal pricetaxTotal = entryInfo2.getPrice().multiply(entryInfo2.getQuantity()).setScale(2, RoundingMode.HALF_UP);
            BigDecimal localAmount = pricetaxTotal.multiply(billInfo.getExchangerate()).setScale(2, RoundingMode.HALF_UP);
            detailEntry.set("seq", (Object)entryInfo2.getSeq());
            DynamicObject material = entryInfo2.getMaterial() == null ? BaseDataTestProvider.getMaterial() : entryInfo2.getMaterial();
            detailEntry.set("material", (Object)material);
            long unitId = material.getLong("baseunit.id");
            detailEntry.set("measureunit", (Object)unitId);
            detailEntry.set("e_baseunit", (Object)unitId);
            detailEntry.set("e_unitconvertrate", (Object)BigDecimal.ONE);
            detailEntry.set("ispresent", (Object)entryInfo2.isPresent());
            detailEntry.set("quantity", (Object)entryInfo2.getQuantity());
            detailEntry.set("e_baseunitqty", (Object)entryInfo2.getQuantity());
            detailEntry.set("price", (Object)entryInfo2.getPrice());
            detailEntry.set("actprice", (Object)entryInfo2.getPrice());
            detailEntry.set("actpricetax", (Object)entryInfo2.getPrice());
            detailEntry.set("e_pricetaxtotal", (Object)pricetaxTotal);
            detailEntry.set("e_pricetaxtotalbase", (Object)localAmount);
            detailEntry.set("e_amount", (Object)pricetaxTotal);
            detailEntry.set("e_amountbase", (Object)localAmount);
            detailEntry.set("unlockamt", (Object)pricetaxTotal);
            detailEntry.set("unsettleamt", (Object)pricetaxTotal);
            detailEntry.set("unverifyquantity", (Object)entryInfo2.getQuantity());
            detailEntry.set("e_unverifyamount", (Object)pricetaxTotal);
            detailEntry.set("e_uninvoicedamt", (Object)pricetaxTotal);
            detailEntry.set("unsettleamtbase", (Object)localAmount);
            detailEntry.set("discountmode", (Object)"NULL");
            detailEntry.set("corebilltype", (Object)entryInfo2.getCorebilltype());
            detailEntry.set("corebillno", (Object)entryInfo2.getCorebillno());
            detailEntry.set("corebillid", (Object)entryInfo2.getCorebillid());
            detailEntry.set("corebillentryseq", (Object)entryInfo2.getCorebillentryseq());
            detailEntry.set("e_conbillnumber", (Object)entryInfo2.getConbillno());
            detailEntry.set("e_conbillrownum", (Object)entryInfo2.getConbillentryseq());
            detailEntry.set("corebillentryid", (Object)entryInfo2.getCorebillentryid());
            detailEntry.set("groupnumber", (Object)entryInfo2.getGroupnumber());
            detailEntry.set("groupseq", (Object)entryInfo2.getGroupseq());
            detailEntries.add((Object)detailEntry);
            if (EmptyUtils.isEmpty(negativeQuantity)) {
                DynamicObject planEntry = new DynamicObject(planEntryType);
                planEntry.set("seq", (Object)entryInfo2.getSeq());
                planEntry.set("planduedate", (Object)new Date());
                planEntry.set("planpricetax", (Object)pricetaxTotal);
                planEntry.set("planpricetaxloc", (Object)localAmount);
                planEntry.set("unplanlockamt", (Object)pricetaxTotal);
                planEntry.set("unplansettleamt", (Object)pricetaxTotal);
                planEntry.set("unplansettlelocamt", (Object)localAmount);
                planEntry.set("e_freezestate", (Object)"unfreeze");
                planEntries.add((Object)planEntry);
            }
            pricetaxTotalHeader = pricetaxTotalHeader.add(pricetaxTotal);
            localAmtHeader = localAmtHeader.add(localAmount);
        }
        if (EmptyUtils.isNotEmpty(negativeQuantity)) {
            DynamicObject planEntry = new DynamicObject(planEntryType);
            planEntry.set("planduedate", (Object)new Date());
            planEntry.set("planpricetax", (Object)pricetaxTotalHeader);
            planEntry.set("planpricetaxloc", (Object)localAmtHeader);
            planEntry.set("unplanlockamt", (Object)pricetaxTotalHeader);
            planEntry.set("unplansettleamt", (Object)pricetaxTotalHeader);
            planEntry.set("unplansettlelocamt", (Object)localAmtHeader);
            planEntry.set("e_freezestate", (Object)"unfreeze");
            planEntries.add((Object)planEntry);
        }
        finBill.set("pricetaxtotal", (Object)pricetaxTotalHeader);
        finBill.set("amount", (Object)pricetaxTotalHeader);
        finBill.set("unsettleamount", (Object)pricetaxTotalHeader);
        finBill.set("unverifyamount", (Object)pricetaxTotalHeader);
        finBill.set("uninvoicedamt", (Object)pricetaxTotalHeader);
        finBill.set("pricetaxtotalbase", (Object)localAmtHeader);
        finBill.set("unsettleamountbase", (Object)localAmtHeader);
        finBill.set("amountbase", (Object)localAmtHeader);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill});
        if ("C".equals(billInfo.getBillStatus())) {
            OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{finBill.getLong("id")}, (OperateOption)OperateOption.create());
            finBill = BusinessDataServiceHelper.loadSingle((Object)finBill.getLong("id"), (String)"ap_finapbill");
            FinApBillTestChecker.validateApFinJournalData(finBill);
            return finBill;
        }
        return finBill;
    }

    public static DynamicObject buildTailData() {
        return FinApBillTestDataProvider.buildTailData("");
    }

    public static DynamicObject buildTailData(String billNo) {
        return FinApBillTestDataProvider.buildTailData(billNo, null);
    }

    public static DynamicObject buildTailData(String billNo, DynamicObject org) {
        if (StringUtils.isNotEmpty((CharSequence)billNo)) {
            DeleteServiceHelper.delete((String)"ap_finapbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        }
        FinApBillDataVO billInfo = new FinApBillDataVO();
        billInfo.setCurrency(BaseDataTestProvider.getCurrencyUSD().getLong("id")).setExchangerate(new BigDecimal("3.333333333")).setOrg(org).setBillNo(billNo);
        DynamicObject finBill = FinApBillTestDataProvider.buildHeader(billInfo);
        DynamicObjectType dataEntityType = (DynamicObjectType)finBill.getDataEntityType();
        DynamicObjectType detailEntryType = ((EntryProp)dataEntityType.getProperty("detailentry")).getDynamicCollectionItemPropertyType();
        DynamicObject detailEntry = new DynamicObject(detailEntryType);
        FinApBillDataDetailVO entryInfo = new FinApBillDataDetailVO();
        entryInfo.setPrice(new BigDecimal("3.00"));
        entryInfo.setQuantity(new BigDecimal("1.00"));
        BigDecimal pricetaxTotal = entryInfo.getPrice().multiply(entryInfo.getQuantity()).setScale(2, RoundingMode.HALF_UP);
        BigDecimal localAmount = pricetaxTotal.multiply(billInfo.getExchangerate()).setScale(2, RoundingMode.HALF_UP);
        detailEntry.set("material", (Object)BaseDataTestProvider.getMaterial());
        detailEntry.set("quantity", (Object)entryInfo.getQuantity());
        detailEntry.set("price", (Object)entryInfo.getPrice());
        detailEntry.set("e_pricetaxtotal", (Object)pricetaxTotal);
        detailEntry.set("e_pricetaxtotalbase", (Object)localAmount);
        detailEntry.set("e_amount", (Object)pricetaxTotal);
        detailEntry.set("unlockamt", (Object)pricetaxTotal);
        detailEntry.set("unsettleamt", (Object)pricetaxTotal);
        detailEntry.set("unverifyquantity", (Object)entryInfo.getQuantity());
        detailEntry.set("e_unverifyamount", (Object)pricetaxTotal);
        detailEntry.set("e_uninvoicedamt", (Object)pricetaxTotal);
        detailEntry.set("unsettleamtbase", (Object)localAmount);
        detailEntry.set("discountmode", (Object)"NULL");
        detailEntry.set("corebilltype", (Object)entryInfo.getCorebilltype());
        detailEntry.set("corebillno", (Object)entryInfo.getCorebillno());
        detailEntry.set("corebillid", (Object)entryInfo.getCorebillid());
        detailEntry.set("corebillentryseq", (Object)entryInfo.getCorebillentryseq());
        detailEntry.set("corebillentryid", (Object)entryInfo.getCorebillentryid());
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("detailentry");
        detailEntries.add((Object)detailEntry);
        finBill.set("pricetaxtotal", (Object)pricetaxTotal);
        finBill.set("amount", (Object)pricetaxTotal);
        finBill.set("unsettleamount", (Object)pricetaxTotal);
        finBill.set("unverifyamount", (Object)pricetaxTotal);
        finBill.set("uninvoicedamt", (Object)pricetaxTotal);
        finBill.set("pricetaxtotalbase", (Object)localAmount);
        finBill.set("unsettleamountbase", (Object)localAmount);
        finBill.set("amountbase", (Object)localAmount);
        DynamicObjectType planEntityType = ((EntryProp)dataEntityType.getProperty("planentity")).getDynamicCollectionItemPropertyType();
        DynamicObject planEntryRow1 = new DynamicObject(planEntityType);
        BigDecimal planAmount = new BigDecimal("1.00");
        BigDecimal planLocalAmount = planAmount.multiply(billInfo.getExchangerate()).setScale(2, RoundingMode.HALF_UP);
        planEntryRow1.set("planduedate", (Object)new Date());
        planEntryRow1.set("planpricetax", (Object)planAmount);
        planEntryRow1.set("planpricetaxloc", (Object)planLocalAmount);
        planEntryRow1.set("unplanlockamt", (Object)planAmount);
        planEntryRow1.set("unplansettleamt", (Object)planAmount);
        planEntryRow1.set("unplansettlelocamt", (Object)planLocalAmount);
        DynamicObject planEntryRow2 = new DynamicObject(planEntityType);
        BigDecimal planAmount2 = new BigDecimal("2.00");
        BigDecimal planLocalAmount2 = localAmount.subtract(planLocalAmount).setScale(2, RoundingMode.HALF_UP);
        planEntryRow2.set("planduedate", (Object)new Date());
        planEntryRow2.set("planpricetax", (Object)planAmount2);
        planEntryRow2.set("planpricetaxloc", (Object)planLocalAmount2);
        planEntryRow2.set("unplanlockamt", (Object)planAmount2);
        planEntryRow2.set("unplansettleamt", (Object)planAmount2);
        planEntryRow2.set("unplansettlelocamt", (Object)planLocalAmount2);
        DynamicObjectCollection planEntry = finBill.getDynamicObjectCollection("planentity");
        planEntry.add((Object)planEntryRow1);
        planEntry.add((Object)planEntryRow2);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill});
        if ("C".equals(billInfo.getBillStatus())) {
            OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{finBill.getLong("id")}, (OperateOption)OperateOption.create());
            return BusinessDataServiceHelper.loadSingle((Object)finBill.getLong("id"), (String)"ap_finapbill");
        }
        return finBill;
    }

    public static DynamicObject[] loadData(Long[] ids) {
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"ap_finapbill").getDynamicObjectType());
    }

    public static DynamicObject loadSingle(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"ap_finapbill");
    }

    private static DynamicObject buildHeader(FinApBillDataVO billInfo) {
        DynamicObject finBill = BusinessDataServiceHelper.newDynamicObject((String)"ap_finapbill");
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        finBill.set("org", (Object)org);
        finBill.set("payorg", (Object)org);
        String billNo = StringUtils.isEmpty((CharSequence)billInfo.getBillNo()) ? "AP-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo();
        finBill.set("billno", (Object)billNo);
        finBill.set("bizdate", (Object)new Date());
        finBill.set("exratedate", (Object)new Date());
        finBill.set("duedate", (Object)new Date());
        finBill.set("bookdate", (Object)new Date());
        finBill.set("asstacttype", (Object)"bd_supplier");
        DynamicObject supplier = billInfo.getSupplier() == null ? BaseDataTestProvider.getSupplier() : billInfo.getSupplier();
        finBill.set("asstact", (Object)supplier);
        finBill.set("receivingsupplierid", (Object)supplier);
        finBill.set("purmode", (Object)"CREDIT");
        finBill.set("settlementtype", (Object)900001L);
        finBill.set("quotation", (Object)billInfo.getQuotation());
        finBill.set("payproperty", (Object)(billInfo.getPayproperty() == null ? BaseDataTestProvider.getPayProperty() : billInfo.getPayproperty()));
        finBill.set("currency", (Object)billInfo.getCurrency());
        finBill.set("basecurrency", (Object)BaseDataTestProvider.getCurrencyCNY());
        finBill.set("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        finBill.set("exchangerate", (Object)billInfo.getExchangerate());
        finBill.set("billstatus", (Object)(billInfo.getBillStatus().equals("C") ? "B" : billInfo.getBillStatus()));
        finBill.set("settlestatus", (Object)"unsettle");
        finBill.set("verifystatus", (Object)"10");
        finBill.set("freezestate", (Object)"unfreeze");
        finBill.set("creator", (Object)1L);
        finBill.set("billtypeid", (Object)535198337297582080L);
        finBill.set("settleversion", (Object)billInfo.getSettleVersion());
        return finBill;
    }

    public static DynamicObject buildBySaleFeePriceAndQuantity(FinApBillDataVO billInfo, List<FinApBillDataDetailVO> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)"ap_finapbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject finBill = FinApBillTestDataProvider.buildHeader(billInfo);
        finBill.set("billtypeid", (Object)1732559174216213504L);
        DynamicObjectType dataEntityType = (DynamicObjectType)finBill.getDataEntityType();
        DynamicObjectType detailEntryType = ((EntryProp)dataEntityType.getProperty("detailentry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("detailentry");
        DynamicObjectType planEntryType = ((EntryProp)dataEntityType.getProperty("planentity")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        BigDecimal pricetaxTotalHeader = BigDecimal.ZERO;
        BigDecimal localAmtHeader = BigDecimal.ZERO;
        Set negativeQuantity = entryInfoList.stream().filter(entryInfo -> entryInfo.getQuantity().compareTo(BigDecimal.ZERO) < 0).collect(Collectors.toSet());
        for (FinApBillDataDetailVO entryInfo2 : entryInfoList) {
            DynamicObject detailEntry = new DynamicObject(detailEntryType);
            BigDecimal pricetaxTotal = entryInfo2.getPrice().multiply(entryInfo2.getQuantity()).setScale(2, RoundingMode.HALF_UP);
            BigDecimal localAmount = pricetaxTotal.multiply(billInfo.getExchangerate()).setScale(2, RoundingMode.HALF_UP);
            detailEntry.set("seq", (Object)entryInfo2.getSeq());
            DynamicObject material = entryInfo2.getMaterial() == null ? BaseDataTestProvider.getMaterial() : entryInfo2.getMaterial();
            detailEntry.set("material", (Object)material);
            long unitId = material.getLong("baseunit.id");
            detailEntry.set("measureunit", (Object)unitId);
            detailEntry.set("e_baseunit", (Object)unitId);
            detailEntry.set("expenseitem", (Object)BusinessDataServiceHelper.loadSingle((String)"er_expenseitemedit", (String)"id", (QFilter[])new QFilter[]{new QFilter("isleaf", "=", (Object)true)}));
            detailEntry.set("e_unitconvertrate", (Object)BigDecimal.ONE);
            detailEntry.set("ispresent", (Object)entryInfo2.isPresent());
            detailEntry.set("quantity", (Object)entryInfo2.getQuantity());
            detailEntry.set("e_baseunitqty", (Object)entryInfo2.getQuantity());
            detailEntry.set("price", (Object)entryInfo2.getPrice());
            detailEntry.set("actprice", (Object)entryInfo2.getPrice());
            detailEntry.set("actpricetax", (Object)entryInfo2.getPrice());
            detailEntry.set("e_pricetaxtotal", (Object)pricetaxTotal);
            detailEntry.set("e_pricetaxtotalbase", (Object)localAmount);
            detailEntry.set("e_amount", (Object)pricetaxTotal);
            detailEntry.set("e_amountbase", (Object)localAmount);
            detailEntry.set("unlockamt", (Object)pricetaxTotal);
            detailEntry.set("unsettleamt", (Object)pricetaxTotal);
            detailEntry.set("unverifyquantity", (Object)entryInfo2.getQuantity());
            detailEntry.set("e_unverifyamount", (Object)pricetaxTotal);
            detailEntry.set("e_uninvoicedamt", (Object)pricetaxTotal);
            detailEntry.set("unsettleamtbase", (Object)localAmount);
            detailEntry.set("discountmode", (Object)"NULL");
            detailEntry.set("corebilltype", (Object)entryInfo2.getCorebilltype());
            detailEntry.set("corebillno", (Object)entryInfo2.getCorebillno());
            detailEntry.set("corebillid", (Object)entryInfo2.getCorebillid());
            detailEntry.set("corebillentryseq", (Object)entryInfo2.getCorebillentryseq());
            detailEntry.set("corebillentryid", (Object)entryInfo2.getCorebillentryid());
            detailEntry.set("e_prepaid", (Object)Boolean.TRUE);
            detailEntries.add((Object)detailEntry);
            if (EmptyUtils.isEmpty(negativeQuantity)) {
                DynamicObject planEntry = new DynamicObject(planEntryType);
                planEntry.set("seq", (Object)entryInfo2.getSeq());
                planEntry.set("planduedate", (Object)new Date());
                planEntry.set("planpricetax", (Object)pricetaxTotal);
                planEntry.set("planpricetaxloc", (Object)localAmount);
                planEntry.set("unplanlockamt", (Object)pricetaxTotal);
                planEntry.set("unplansettleamt", (Object)pricetaxTotal);
                planEntry.set("unplansettlelocamt", (Object)localAmount);
                planEntry.set("e_freezestate", (Object)"unfreeze");
                planEntries.add((Object)planEntry);
            }
            pricetaxTotalHeader = pricetaxTotalHeader.add(pricetaxTotal);
            localAmtHeader = localAmtHeader.add(localAmount);
        }
        if (EmptyUtils.isNotEmpty(negativeQuantity)) {
            DynamicObject planEntry = new DynamicObject(planEntryType);
            planEntry.set("planduedate", (Object)new Date());
            planEntry.set("planpricetax", (Object)pricetaxTotalHeader);
            planEntry.set("planpricetaxloc", (Object)localAmtHeader);
            planEntry.set("unplanlockamt", (Object)pricetaxTotalHeader);
            planEntry.set("unplansettleamt", (Object)pricetaxTotalHeader);
            planEntry.set("unplansettlelocamt", (Object)localAmtHeader);
            planEntry.set("e_freezestate", (Object)"unfreeze");
            planEntries.add((Object)planEntry);
        }
        finBill.set("pricetaxtotal", (Object)pricetaxTotalHeader);
        finBill.set("amount", (Object)pricetaxTotalHeader);
        finBill.set("unsettleamount", (Object)pricetaxTotalHeader);
        finBill.set("unverifyamount", (Object)pricetaxTotalHeader);
        finBill.set("uninvoicedamt", (Object)pricetaxTotalHeader);
        finBill.set("pricetaxtotalbase", (Object)localAmtHeader);
        finBill.set("unsettleamountbase", (Object)localAmtHeader);
        finBill.set("amountbase", (Object)localAmtHeader);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill});
        if ("C".equals(billInfo.getBillStatus())) {
            OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])new Long[]{finBill.getLong("id")}, (OperateOption)OperateOption.create());
            OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{finBill.getLong("id")}, (OperateOption)OperateOption.create());
            finBill = BusinessDataServiceHelper.loadSingle((Object)finBill.getLong("id"), (String)"ap_finapbill");
            FinApBillTestChecker.validateApFinJournalData(finBill);
            return finBill;
        }
        return finBill;
    }

    public static DynamicObject createFinApBill(String billno, boolean isAudit, boolean isDiffCurrency, boolean isPlan) {
        FinApBillDataVO headVO = FinApBillTestDataProvider.structureFinApHeadVo(billno, isPlan, isAudit, isDiffCurrency);
        List<FinApBillDataDetailVO> finApBillDataDetailVOS = FinApBillTestDataProvider.structureFinApDataDetailVO(false, true);
        return FinApBillTestDataProvider.buildByPriceAndQuantity(headVO, finApBillDataDetailVOS);
    }

    public static DynamicObject createFinApBill(boolean isPlanOrg, boolean isFirstCreate, boolean isDiffCurrency, boolean isAudit, String billno) {
        FinApBillDataVO headVO = FinApBillTestDataProvider.structureFinApHeadVo(billno, isPlanOrg, isAudit, isDiffCurrency);
        List<FinApBillDataDetailVO> finApBillDataDetailVOS = FinApBillTestDataProvider.structureFinApDataDetailVO(isFirstCreate, false);
        return FinApBillTestDataProvider.buildByPriceAndQuantity(headVO, finApBillDataDetailVOS);
    }

    public static DynamicObject createFinApBill(boolean isPlanOrg, boolean isDiffCurrency, String billno) {
        FinApBillDataVO headVO = FinApBillTestDataProvider.structureFinApHeadVo(billno, isPlanOrg, true, isDiffCurrency);
        FinApBillDataDetailVO detailVOOne = FinApBillDataDetailVO.New();
        detailVOOne.setSeq(1).setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.ONE);
        return FinApBillTestDataProvider.buildByPriceAndQuantity(headVO, Collections.singletonList(detailVOOne));
    }

    public static DynamicObject createFinApPremiumBill(String billNo, boolean isComplexData, boolean isPlan) {
        DynamicObject finBill = null;
        if (isComplexData) {
            finBill = FinApBillTestDataProvider.createFinApBill(billNo, false, true, isPlan);
            finBill.set("premiumrate", (Object)BigDecimal.valueOf(20L));
            finBill.set("premiumamt", (Object)BigDecimal.valueOf(4L));
        } else {
            finBill = FinApBillTestDataProvider.createFinApBill(isPlan, true, false, false, billNo);
            finBill.set("premiumrate", (Object)BigDecimal.valueOf(20L));
            finBill.set("premiumamt", (Object)BigDecimal.valueOf(20L));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill});
        OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{finBill.getLong("id")}, (OperateOption)OperateOption.create());
        finBill = BusinessDataServiceHelper.loadSingle((Object)finBill.getLong("id"), (String)"ap_finapbill");
        FinApBillTestChecker.validateApFinJournalData(finBill);
        return finBill;
    }

    public static FinApBillDataVO structureFinApHeadVo(String billNo, boolean isPlanOrg, boolean isAudit, boolean isDiffCurrency) {
        FinApBillDataVO headVO = FinApBillDataVO.New();
        headVO.setOrg(BaseDataTestProvider.getDetailInitOrg()).setBillNo(billNo).setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE);
        if (isPlanOrg) {
            headVO.setOrg(BaseDataTestProvider.getPlanInitOrg());
        }
        if (!isAudit) {
            headVO.setBillStatus("B");
        }
        if (isDiffCurrency) {
            headVO.setCurrency(BaseDataTestProvider.getCurrencyUSD().getLong("id")).setExchangerate(BigDecimal.valueOf(6.045));
        }
        return headVO;
    }

    public static FinApBillDataVO structureFinApCoordinationHeadVo(String billNo, boolean isAudit, boolean isDiffCurrency) {
        FinApBillDataVO headVO = FinApBillTestDataProvider.structureFinApHeadVo(billNo, true, isAudit, isDiffCurrency);
        headVO.setSupplier(BaseDataTestProvider.getCoordinationSupplier());
        return headVO;
    }

    public static List<FinApBillDataDetailVO> structureFinApDataDetailVO(boolean isFirstCreate, boolean isNegative) {
        FinApBillDataDetailVO detailVOOne = FinApBillDataDetailVO.New();
        FinApBillDataDetailVO detailVOTwo = FinApBillDataDetailVO.New();
        if (isNegative) {
            detailVOOne.setSeq(1).setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.ONE);
            detailVOTwo.setSeq(2).setPrice(BigDecimal.valueOf(40L)).setQuantity(BigDecimal.ONE.negate());
        } else if (isFirstCreate) {
            detailVOOne.setSeq(1).setPrice(BigDecimal.valueOf(70L)).setQuantity(BigDecimal.ONE);
            detailVOTwo.setSeq(2).setPrice(BigDecimal.valueOf(30L)).setQuantity(BigDecimal.ONE);
        } else {
            detailVOOne.setSeq(1).setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.ONE);
            detailVOTwo.setSeq(2).setPrice(BigDecimal.valueOf(40L)).setQuantity(BigDecimal.ONE);
        }
        return Arrays.asList(detailVOOne, detailVOTwo);
    }
}

