/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public class FinArBillTestDataProvider {
    public static DynamicObject buildByHeadPriceTaxTotal(BigDecimal priceTaxTotal) {
        return FinArBillTestDataProvider.buildByHeadPriceTaxTotal("", priceTaxTotal);
    }

    public static DynamicObject buildByHeadPriceTaxTotal(String billNo, BigDecimal priceTaxTotal) {
        return FinArBillTestDataProvider.buildByHeadPriceTaxTotal(billNo, null, priceTaxTotal);
    }

    public static DynamicObject buildByHeadPriceTaxTotal(String billNo, DynamicObject org, BigDecimal priceTaxTotal) {
        FinArBillDataVO billInfo = new FinArBillDataVO();
        billInfo.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setPricetaxTotal(priceTaxTotal).setBillNo(billNo).setOrg(org);
        return FinArBillTestDataProvider.buildByHeadPriceTaxTotal(billInfo);
    }

    public static DynamicObject buildByHeadPriceTaxTotal(FinArBillDataVO billInfo) {
        ArrayList<FinArBillDataDetailVO> entryInfoList = new ArrayList<FinArBillDataDetailVO>(1);
        FinArBillDataDetailVO detailInfo = new FinArBillDataDetailVO();
        detailInfo.setPrice(billInfo.getPricetaxTotal()).setQuantity(BigDecimal.ONE);
        entryInfoList.add(detailInfo);
        return FinArBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryInfoList);
    }

    public static DynamicObject buildByPriceAndQuantity(List<FinArBillDataDetailVO> entryInfoList) {
        return FinArBillTestDataProvider.buildByPriceAndQuantity("", entryInfoList);
    }

    public static DynamicObject buildByPriceAndQuantity(String billNo, List<FinArBillDataDetailVO> entryInfoList) {
        return FinArBillTestDataProvider.buildByPriceAndQuantity(billNo, null, entryInfoList);
    }

    public static DynamicObject buildByPriceAndQuantity(String billNo, DynamicObject org, List<FinArBillDataDetailVO> entryInfoList) {
        FinArBillDataVO billInfo = FinArBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo(billNo).setOrg(org);
        return FinArBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryInfoList);
    }

    public static DynamicObject buildByPriceAndQtySpecific(String billNo, List<FinArBillDataDetailVO> entryInfoList, boolean isDetailSettle, boolean isLocal) {
        Long currencyId = isLocal ? BaseDataTestProvider.getCurrencyCNY().getLong("id") : BaseDataTestProvider.getCurrencyUSD().getLong("id");
        BigDecimal exchangerate = isLocal ? BigDecimal.ONE : BigDecimal.valueOf(6L);
        DynamicObject org = isDetailSettle ? BaseDataTestProvider.getDetailInitOrg() : BaseDataTestProvider.getPlanInitOrg();
        FinArBillDataVO billInfo = FinArBillDataVO.New().setCurrency(currencyId).setExchangerate(exchangerate).setBillNo(billNo).setOrg(org).setAsst(BaseDataTestProvider.getCustomer());
        return FinArBillTestDataProvider.buildByPriceAndQuantityOnePlan(billInfo, entryInfoList);
    }

    public static DynamicObject buildByPriceAndQty008Org(String billNo, DynamicObject org, List<FinArBillDataDetailVO> entryInfoList) {
        Long currencyId = BaseDataTestProvider.getCurrencyCNY().getLong("id");
        BigDecimal exchangerate = BigDecimal.ONE;
        FinArBillDataVO billInfo = FinArBillDataVO.New().setCurrency(currencyId).setExchangerate(exchangerate).setBillNo(billNo).setOrg(org).setAsst(FinArBillTestHelper.getCustomer());
        return FinArBillTestDataProvider.buildByPriceAndQuantityOnePlan(billInfo, entryInfoList);
    }

    public static DynamicObject buildByPriceAndQtyArToAp(String billNo, List<FinArBillDataDetailVO> entryInfoList, boolean isDetailSettle, boolean isLocal) {
        Long currencyId = isLocal ? BaseDataTestProvider.getCurrencyCNY().getLong("id") : BaseDataTestProvider.getCurrencyUSD().getLong("id");
        BigDecimal exchangerate = isLocal ? BigDecimal.ONE : BigDecimal.valueOf(6L);
        DynamicObject org = isDetailSettle ? BaseDataTestProvider.getDetailInitOrg() : BaseDataTestProvider.getPlanInitOrg();
        DynamicObject billTypeInfo = BusinessDataServiceHelper.loadSingle((Object)735268140732146688L, (String)"bos_billtype");
        DynamicObject bizTypeInfo = BusinessDataServiceHelper.loadSingle((Object)422876630176775168L, (String)"bd_biztype");
        FinArBillDataVO billInfo = FinArBillDataVO.New().setBizeType(bizTypeInfo).setBillType(billTypeInfo).setCurrency(currencyId).setExchangerate(exchangerate).setBillNo(billNo).setOrg(org).setAsst(BaseDataTestProvider.getCoordinationCustomer());
        return FinArBillTestDataProvider.buildByPriceAndQuantityOnePlan(billInfo, entryInfoList);
    }

    public static DynamicObject buildNewByPriceAndQuantity(String billNo, DynamicObject org, List<FinArBillDataDetailVO> entryInfoList) {
        return FinArBillTestDataProvider.buildByPriceAndQuantity(billNo, org, "1", entryInfoList);
    }

    public static DynamicObject buildByPriceAndQuantity(String billNo, DynamicObject org, String settleVersion, List<FinArBillDataDetailVO> entryInfoList) {
        FinArBillDataVO billInfo = new FinArBillDataVO();
        billInfo.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo(billNo).setOrg(org).setSettleVersion(settleVersion);
        return FinArBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryInfoList);
    }

    public static DynamicObject buildByPriceAndQuantity(FinArBillDataVO billInfo, List<FinArBillDataDetailVO> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)"ar_finarbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject finBill = FinArBillTestDataProvider.buildHeader(billInfo);
        DynamicObjectType dataEntityType = (DynamicObjectType)finBill.getDataEntityType();
        DynamicObjectType detailEntryType = ((EntryProp)dataEntityType.getProperty("entry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        DynamicObjectType planEntityType = ((EntryProp)dataEntityType.getProperty("planentity")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        BigDecimal pricetaxTotalHeader = BigDecimal.ZERO;
        BigDecimal localAmtHeader = BigDecimal.ZERO;
        int precision = BaseDataTestProvider.getCurrencyCNY().getInt("amtprecision");
        Set negativeQuantity = entryInfoList.stream().filter(entryInfo -> entryInfo.getQuantity().compareTo(BigDecimal.ZERO) < 0).collect(Collectors.toSet());
        for (FinArBillDataDetailVO entryInfo2 : entryInfoList) {
            DynamicObject detailEntry = new DynamicObject(detailEntryType);
            BigDecimal pricetaxTotal = entryInfo2.getPrice().multiply(entryInfo2.getQuantity()).setScale(precision, RoundingMode.HALF_UP);
            BigDecimal localAmount = pricetaxTotal.multiply(billInfo.getExchangerate()).setScale(precision, RoundingMode.HALF_UP);
            detailEntry.set("seq", (Object)entryInfo2.getSeq());
            detailEntry.set("e_material", (Object)BaseDataTestProvider.getMaterial());
            detailEntry.set("e_measureunit", (Object)BaseDataTestProvider.getMaterial().getDynamicObject("baseunit"));
            detailEntry.set("e_baseunit", (Object)BaseDataTestProvider.getMaterial().getDynamicObject("baseunit"));
            detailEntry.set("e_unitcoefficient", (Object)BigDecimal.valueOf(1L));
            detailEntry.set("e_quantity", (Object)entryInfo2.getQuantity());
            detailEntry.set("e_baseunitqty", (Object)entryInfo2.getQuantity());
            detailEntry.set("e_unconfirmqty", (Object)entryInfo2.getQuantity());
            detailEntry.set("e_unconfirmbaseqty", (Object)entryInfo2.getQuantity());
            detailEntry.set("e_uninvoicedqty", (Object)entryInfo2.getQuantity());
            detailEntry.set("e_unitprice", (Object)entryInfo2.getPrice());
            detailEntry.set("e_actunitprice", (Object)entryInfo2.getPrice());
            detailEntry.set("e_recamount", (Object)pricetaxTotal);
            detailEntry.set("e_uninvoicedamt", (Object)pricetaxTotal);
            detailEntry.set("e_reclocalamt", (Object)localAmount);
            detailEntry.set("e_amount", (Object)pricetaxTotal);
            detailEntry.set("e_localamt", (Object)pricetaxTotal);
            detailEntry.set("e_unlockamt", (Object)pricetaxTotal);
            detailEntry.set("e_unsettleamt", (Object)pricetaxTotal);
            detailEntry.set("e_unverifyqty", (Object)entryInfo2.getQuantity());
            detailEntry.set("e_unverifybaseqty", (Object)entryInfo2.getQuantity());
            detailEntry.set("e_unverifyamt", (Object)pricetaxTotal);
            detailEntry.set("e_unsettlelocalamt", (Object)localAmount);
            detailEntry.set("e_discountmode", (Object)"NULL");
            detailEntry.set("e_corebilltype", (Object)entryInfo2.getCorebilltype());
            detailEntry.set("e_corebillno", (Object)entryInfo2.getCorebillno());
            detailEntry.set("corebillid", (Object)entryInfo2.getCorebillid());
            detailEntry.set("e_corebillentryseq", (Object)entryInfo2.getCorebillentryseq());
            detailEntry.set("corebillentryid", (Object)entryInfo2.getCorebillentryid());
            detailEntry.set("groupnumber", (Object)entryInfo2.getGroupnumber());
            detailEntry.set("groupseq", (Object)entryInfo2.getGroupseq());
            detailEntry.set("e_unconfirmamt", (Object)pricetaxTotal);
            detailEntry.set("e_isallverify", (Object)entryInfo2.getIsallverify());
            detailEntries.add((Object)detailEntry);
            if (EmptyUtils.isEmpty(negativeQuantity)) {
                DynamicObject planEntry = new DynamicObject(planEntityType);
                planEntry.set("seq", (Object)entryInfo2.getSeq());
                planEntry.set("planduedate", (Object)new Date());
                planEntry.set("planpricetax", (Object)pricetaxTotal);
                planEntry.set("planpricetaxloc", (Object)localAmount);
                planEntry.set("unplanlockamt", (Object)pricetaxTotal);
                planEntry.set("unplansettleamt", (Object)pricetaxTotal);
                planEntry.set("unplansettlelocamt", (Object)localAmount);
                planEntries.add((Object)planEntry);
            }
            pricetaxTotalHeader = pricetaxTotalHeader.add(pricetaxTotal);
            localAmtHeader = localAmtHeader.add(localAmount);
        }
        if (EmptyUtils.isNotEmpty(negativeQuantity)) {
            DynamicObject planEntry = new DynamicObject(planEntityType);
            planEntry.set("planduedate", (Object)new Date());
            planEntry.set("planpricetax", (Object)pricetaxTotalHeader);
            planEntry.set("planpricetaxloc", (Object)localAmtHeader);
            planEntry.set("unplanlockamt", (Object)pricetaxTotalHeader);
            planEntry.set("unplansettleamt", (Object)pricetaxTotalHeader);
            planEntry.set("unplansettlelocamt", (Object)localAmtHeader);
            planEntries.add((Object)planEntry);
        }
        finBill.set("recamount", (Object)pricetaxTotalHeader);
        finBill.set("amount", (Object)pricetaxTotalHeader);
        finBill.set("unsettleamount", (Object)pricetaxTotalHeader);
        finBill.set("unverifyamount", (Object)pricetaxTotalHeader);
        finBill.set("uninvoicedamt", (Object)pricetaxTotalHeader);
        finBill.set("reclocalamt", (Object)localAmtHeader);
        finBill.set("unsettlelocalamt", (Object)localAmtHeader);
        finBill.set("localamt", (Object)localAmtHeader);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill});
        if ("C".equals(billInfo.getBillStatus())) {
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])new Long[]{finBill.getLong("id")}, (OperateOption)OperateOption.create());
            KDAssert.assertEquals((String)("\u8d22\u52a1\u5e94\u6536\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a" + auditResult.getMessage()), (boolean)true, (boolean)auditResult.isSuccess());
            finBill = BusinessDataServiceHelper.loadSingle((Object)finBill.getLong("id"), (String)"ar_finarbill");
            return finBill;
        }
        return finBill;
    }

    public static DynamicObject buildByPriceAndQuantityOnePlan(FinArBillDataVO billInfo, List<FinArBillDataDetailVO> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)"ar_finarbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject finBill = FinArBillTestDataProvider.buildHeaderNew(billInfo);
        DynamicObjectType dataEntityType = (DynamicObjectType)finBill.getDataEntityType();
        DynamicObjectType detailEntryType = ((EntryProp)dataEntityType.getProperty("entry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        BigDecimal pricetaxTotalHeader = BigDecimal.ZERO;
        BigDecimal localAmtHeader = BigDecimal.ZERO;
        int precision = BaseDataTestProvider.getCurrencyCNY().getInt("amtprecision");
        for (FinArBillDataDetailVO entryInfo : entryInfoList) {
            DynamicObject material = FinArBillTestHelper.getMaterial();
            DynamicObject detailEntry = new DynamicObject(detailEntryType);
            BigDecimal pricetaxTotal = entryInfo.getPrice().multiply(entryInfo.getQuantity()).setScale(precision, RoundingMode.HALF_UP);
            BigDecimal localAmount = pricetaxTotal.multiply(billInfo.getExchangerate()).setScale(precision, RoundingMode.HALF_UP);
            detailEntry.set("seq", (Object)entryInfo.getSeq());
            detailEntry.set("e_material", (Object)material);
            detailEntry.set("e_measureunit", (Object)material.getDynamicObject("baseunit"));
            detailEntry.set("e_quantity", (Object)entryInfo.getQuantity());
            detailEntry.set("e_uninvoicedqty", (Object)entryInfo.getQuantity());
            detailEntry.set("e_unconfirmqty", (Object)entryInfo.getQuantity());
            detailEntry.set("e_unitprice", (Object)entryInfo.getPrice());
            detailEntry.set("e_recamount", (Object)pricetaxTotal);
            detailEntry.set("e_reclocalamt", (Object)localAmount);
            detailEntry.set("e_amount", (Object)pricetaxTotal);
            detailEntry.set("e_localamt", (Object)pricetaxTotal);
            detailEntry.set("e_unlockamt", (Object)pricetaxTotal);
            detailEntry.set("e_unsettleamt", (Object)pricetaxTotal);
            detailEntry.set("e_unverifyqty", (Object)entryInfo.getQuantity());
            detailEntry.set("e_unverifyamt", (Object)pricetaxTotal);
            detailEntry.set("e_unsettlelocalamt", (Object)localAmount);
            detailEntry.set("e_discountmode", (Object)"NULL");
            detailEntry.set("e_corebilltype", (Object)entryInfo.getCorebilltype());
            detailEntry.set("e_corebillno", (Object)entryInfo.getCorebillno());
            detailEntry.set("corebillid", (Object)entryInfo.getCorebillid());
            detailEntry.set("e_corebillentryseq", (Object)entryInfo.getCorebillentryseq());
            detailEntry.set("corebillentryid", (Object)entryInfo.getCorebillentryid());
            detailEntry.set("e_unconfirmamt", (Object)pricetaxTotal);
            detailEntry.set("e_uninvoicedamt", (Object)pricetaxTotal);
            detailEntries.add((Object)detailEntry);
            pricetaxTotalHeader = pricetaxTotalHeader.add(pricetaxTotal);
            localAmtHeader = localAmtHeader.add(localAmount);
        }
        finBill.set("recamount", (Object)pricetaxTotalHeader);
        finBill.set("amount", (Object)pricetaxTotalHeader);
        finBill.set("unsettleamount", (Object)pricetaxTotalHeader);
        finBill.set("unverifyamount", (Object)pricetaxTotalHeader);
        finBill.set("uninvoicedamt", (Object)pricetaxTotalHeader);
        finBill.set("reclocalamt", (Object)localAmtHeader);
        finBill.set("unsettlelocalamt", (Object)localAmtHeader);
        finBill.set("localamt", (Object)localAmtHeader);
        DynamicObjectType planEntityType = ((EntryProp)dataEntityType.getProperty("planentity")).getDynamicCollectionItemPropertyType();
        DynamicObject planEntryRow1 = new DynamicObject(planEntityType);
        DynamicObject settlementType = BusinessDataServiceHelper.loadSingle((Object)900004L, (String)"bd_settlementtype");
        BigDecimal recAmt = pricetaxTotalHeader;
        BigDecimal recAmtLocl = pricetaxTotalHeader.multiply(billInfo.getExchangerate()).setScale(2, RoundingMode.HALF_UP);
        planEntryRow1.set("planduedate", (Object)new Date());
        planEntryRow1.set("planpricetax", (Object)recAmt);
        planEntryRow1.set("planpricetaxloc", (Object)recAmtLocl);
        planEntryRow1.set("unplanlockamt", (Object)recAmt);
        planEntryRow1.set("unplansettleamt", (Object)recAmt);
        planEntryRow1.set("unplansettlelocamt", (Object)recAmtLocl);
        planEntryRow1.set("plansettletype", (Object)settlementType);
        DynamicObjectCollection planEntry = finBill.getDynamicObjectCollection("planentity");
        planEntry.add((Object)planEntryRow1);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill});
        if ("C".equals(billInfo.getBillStatus())) {
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])new Long[]{finBill.getLong("id")}, (OperateOption)OperateOption.create());
            KDAssert.assertEquals((String)("\u8d22\u52a1\u5e94\u6536\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a" + auditResult.getMessage()), (boolean)true, (boolean)auditResult.isSuccess());
            finBill = BusinessDataServiceHelper.loadSingle((Object)finBill.getLong("id"), (String)"ar_finarbill");
            return finBill;
        }
        return finBill;
    }

    public static DynamicObject buildTailData() {
        return FinArBillTestDataProvider.buildTailData("");
    }

    public static DynamicObject buildTailData(String billNo) {
        return FinArBillTestDataProvider.buildTailData(billNo, null);
    }

    public static DynamicObject buildTailData(String billNo, DynamicObject org) {
        if (StringUtils.isNotEmpty((CharSequence)billNo)) {
            DeleteServiceHelper.delete((String)"ar_finarbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        }
        FinArBillDataVO billInfo = new FinArBillDataVO();
        billInfo.setCurrency(BaseDataTestProvider.getCurrencyUSD().getLong("id")).setExchangerate(new BigDecimal("3.333333333")).setBillNo(billNo).setOrg(org);
        DynamicObject finBill = FinArBillTestDataProvider.buildHeader(billInfo);
        DynamicObjectType dataEntityType = (DynamicObjectType)finBill.getDataEntityType();
        DynamicObjectType detailEntryType = ((EntryProp)dataEntityType.getProperty("entry")).getDynamicCollectionItemPropertyType();
        DynamicObject detailEntry = new DynamicObject(detailEntryType);
        FinArBillDataDetailVO entryInfo = new FinArBillDataDetailVO();
        entryInfo.setPrice(new BigDecimal("3.00"));
        entryInfo.setQuantity(new BigDecimal("1.00"));
        BigDecimal pricetaxTotal = entryInfo.getPrice().multiply(entryInfo.getQuantity()).setScale(2, RoundingMode.HALF_UP);
        BigDecimal localAmount = pricetaxTotal.multiply(billInfo.getExchangerate()).setScale(2, RoundingMode.HALF_UP);
        detailEntry.set("e_material", (Object)BaseDataTestProvider.getMaterial());
        detailEntry.set("e_quantity", (Object)entryInfo.getQuantity());
        detailEntry.set("e_unitprice", (Object)entryInfo.getPrice());
        detailEntry.set("e_recamount", (Object)pricetaxTotal);
        detailEntry.set("e_reclocalamt", (Object)localAmount);
        detailEntry.set("e_amount", (Object)pricetaxTotal);
        detailEntry.set("e_unlockamt", (Object)pricetaxTotal);
        detailEntry.set("e_unsettleamt", (Object)pricetaxTotal);
        detailEntry.set("e_unverifyqty", (Object)entryInfo.getQuantity());
        detailEntry.set("e_unverifyamt", (Object)pricetaxTotal);
        detailEntry.set("e_unsettlelocalamt", (Object)localAmount);
        detailEntry.set("e_discountmode", (Object)"NULL");
        detailEntry.set("e_corebilltype", (Object)entryInfo.getCorebilltype());
        detailEntry.set("e_corebillno", (Object)entryInfo.getCorebillno());
        detailEntry.set("corebillid", (Object)entryInfo.getCorebillid());
        detailEntry.set("e_corebillentryseq", (Object)entryInfo.getCorebillentryseq());
        detailEntry.set("corebillentryid", (Object)entryInfo.getCorebillentryid());
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        detailEntries.add((Object)detailEntry);
        finBill.set("recamount", (Object)pricetaxTotal);
        finBill.set("amount", (Object)pricetaxTotal);
        finBill.set("unsettleamount", (Object)pricetaxTotal);
        finBill.set("unverifyamount", (Object)pricetaxTotal);
        finBill.set("uninvoicedamt", (Object)pricetaxTotal);
        finBill.set("reclocalamt", (Object)localAmount);
        finBill.set("unsettlelocalamt", (Object)localAmount);
        finBill.set("localamt", (Object)localAmount);
        DynamicObjectType planEntityType = ((EntryProp)dataEntityType.getProperty("planentity")).getDynamicCollectionItemPropertyType();
        DynamicObject planEntryRow1 = new DynamicObject(planEntityType);
        BigDecimal planAmount = new BigDecimal("1.00");
        BigDecimal planLocalAmount = planAmount.multiply(billInfo.getExchangerate()).setScale(2, RoundingMode.HALF_UP);
        planEntryRow1.set("planduedate", (Object)new Date());
        planEntryRow1.set("planpricetax", (Object)planAmount);
        planEntryRow1.set("planpricetaxloc", (Object)planLocalAmount);
        planEntryRow1.set("unplanlockamt", (Object)planAmount);
        planEntryRow1.set("unplansettleamt", (Object)planAmount);
        planEntryRow1.set("unplansettlelocamt", (Object)planLocalAmount);
        DynamicObject planEntryRow2 = new DynamicObject(planEntityType);
        BigDecimal planAmount2 = new BigDecimal("2.00");
        BigDecimal planLocalAmount2 = localAmount.subtract(planLocalAmount).setScale(2, RoundingMode.HALF_UP);
        planEntryRow2.set("planduedate", (Object)new Date());
        planEntryRow2.set("planpricetax", (Object)planAmount2);
        planEntryRow2.set("planpricetaxloc", (Object)planLocalAmount2);
        planEntryRow2.set("unplanlockamt", (Object)planAmount2);
        planEntryRow2.set("unplansettleamt", (Object)planAmount2);
        planEntryRow2.set("unplansettlelocamt", (Object)planLocalAmount2);
        DynamicObjectCollection planEntry = finBill.getDynamicObjectCollection("planentity");
        planEntry.add((Object)planEntryRow1);
        planEntry.add((Object)planEntryRow2);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill});
        return finBill;
    }

    public static DynamicObject[] loadData(Long[] ids) {
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ar_finarbill"));
    }

    public static DynamicObject loadSingle(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"ar_finarbill");
    }

    private static DynamicObject buildHeader(FinArBillDataVO billInfo) {
        DynamicObject finBill = BusinessDataServiceHelper.newDynamicObject((String)"ar_finarbill");
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        finBill.set("org", (Object)org);
        finBill.set("recorg", (Object)org);
        String billNo = StringUtils.isEmpty((CharSequence)billInfo.getBillNo()) ? "AP-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo();
        finBill.set("billno", (Object)billNo);
        finBill.set("bizdate", (Object)new Date());
        finBill.set("duedate", (Object)new Date());
        finBill.set("bookdate", (Object)new Date());
        finBill.set("asstacttype", (Object)"bd_customer");
        finBill.set("asstact", (Object)(billInfo.getCustomer() != null ? billInfo.getCustomer() : BaseDataTestProvider.getCustomer()));
        finBill.set("paymentcustomerid", (Object)(billInfo.getCustomer() != null ? billInfo.getCustomer() : BaseDataTestProvider.getCustomer()));
        finBill.set("paymode", (Object)"CASH");
        finBill.set("payproperty", (Object)(billInfo.getPayproperty() != null ? billInfo.getPayproperty() : BaseDataTestProvider.getRecProperty()));
        finBill.set("currency", (Object)billInfo.getCurrency());
        finBill.set("basecurrency", (Object)BaseDataTestProvider.getCurrencyCNY());
        finBill.set("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        finBill.set("quotation", (Object)billInfo.getQuotation());
        finBill.set("exchangerate", (Object)billInfo.getExchangerate());
        finBill.set("billstatus", (Object)(billInfo.getBillStatus().equals("C") ? "B" : billInfo.getBillStatus()));
        finBill.set("settlestatus", (Object)"unsettle");
        finBill.set("verifystatus", (Object)"unverify");
        finBill.set("creator", (Object)1L);
        finBill.set("billtype", (Object)580977310207850496L);
        finBill.set("exratedate", (Object)new Date());
        return finBill;
    }

    private static DynamicObject buildHeaderNew(FinArBillDataVO billInfo) {
        String billNo;
        DynamicObject finBill = BusinessDataServiceHelper.newDynamicObject((String)"ar_finarbill");
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        finBill.set("org", (Object)org);
        finBill.set("recorg", (Object)org);
        String string = billNo = StringUtils.isEmpty((CharSequence)billInfo.getBillNo()) ? "AP-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo();
        if (billInfo.getBizeType() != null) {
            finBill.set("biztype", (Object)billInfo.getBizeType());
        }
        finBill.set("billno", (Object)billNo);
        finBill.set("bizdate", (Object)new Date());
        finBill.set("duedate", (Object)new Date());
        finBill.set("bookdate", (Object)new Date());
        finBill.set("asstacttype", (Object)"bd_customer");
        finBill.set("asstact", (Object)billInfo.getAsst());
        finBill.set("paymentcustomerid", (Object)billInfo.getAsst());
        finBill.set("paymode", (Object)"CASH");
        finBill.set("payproperty", (Object)BaseDataTestProvider.getRecProperty());
        finBill.set("currency", (Object)billInfo.getCurrency());
        finBill.set("basecurrency", (Object)BaseDataTestProvider.getCurrencyCNY());
        finBill.set("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        finBill.set("exchangerate", (Object)billInfo.getExchangerate());
        finBill.set("billstatus", (Object)(billInfo.getBillStatus().equals("C") ? "B" : billInfo.getBillStatus()));
        finBill.set("settlestatus", (Object)"unsettle");
        finBill.set("verifystatus", (Object)"unverify");
        finBill.set("creator", (Object)1L);
        DynamicObject billTypeInfo = null;
        billTypeInfo = billInfo.getBillType() != null ? billInfo.getBillType() : BusinessDataServiceHelper.loadSingle((Object)580977310207850496L, (String)"bos_billtype");
        finBill.set("billtype", (Object)billTypeInfo);
        finBill.set("exratedate", (Object)new Date());
        if (EntityMetadataUtils.isExistProperty(finBill, "quotation")) {
            finBill.set("quotation", (Object)"0");
        }
        return finBill;
    }

    public static DynamicObject createAR018FinBill(FinArBillDataVO header, BigDecimal[] entryQtyArray, BigDecimal[] entryPriceArray) {
        ArrayList<FinArBillDataDetailVO> detailRows = new ArrayList<FinArBillDataDetailVO>(16);
        for (int i = 0; i < entryQtyArray.length; ++i) {
            FinArBillDataDetailVO detailRow = new FinArBillDataDetailVO();
            detailRow.setSeq(i + 1);
            detailRow.setQuantity(entryQtyArray[i]);
            detailRow.setPrice(entryPriceArray[i]);
            detailRows.add(detailRow);
        }
        DynamicObject finArBill = FinArBillTestDataProvider.buildByPriceAndQuantity(header, detailRows);
        DynamicObjectType dataEntityType = (DynamicObjectType)finArBill.getDataEntityType();
        DynamicObjectCollection detailEntries = finArBill.getDynamicObjectCollection("entry");
        BigDecimal headRecAmount = finArBill.getBigDecimal("recamount");
        BigDecimal headRecLocalAmount = finArBill.getBigDecimal("reclocalamt");
        int precision = BaseDataTestProvider.getCurrencyCNY().getInt("amtprecision");
        DynamicObjectType planEntityType = ((EntryProp)dataEntityType.getProperty("planentity")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection planEntry = finArBill.getDynamicObjectCollection("planentity");
        planEntry.clear();
        BigDecimal planAmount = headRecAmount.divide(BigDecimal.valueOf(detailEntries.size()), precision, RoundingMode.HALF_UP);
        BigDecimal planLocalAmount = headRecLocalAmount.divide(BigDecimal.valueOf(detailEntries.size()), precision, RoundingMode.HALF_UP);
        for (DynamicObject detailEntryRow : detailEntries) {
            DynamicObject planEntryRow = new DynamicObject(planEntityType);
            planEntryRow.set("seq", detailEntryRow.get("seq"));
            planEntryRow.set("planduedate", (Object)new Date());
            planEntryRow.set("planpricetax", (Object)planAmount);
            planEntryRow.set("planpricetaxloc", (Object)planLocalAmount);
            planEntryRow.set("unplanlockamt", (Object)planAmount);
            planEntryRow.set("unplansettleamt", (Object)planAmount);
            planEntryRow.set("unplansettlelocamt", (Object)planLocalAmount);
            planEntry.add((Object)planEntryRow);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finArBill});
        return finArBill;
    }
}

