/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.OmInBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.OmInBillDataVO;
import kd.fi.arapcommon.util.DateUtils;
import org.apache.commons.lang3.ObjectUtils;

public class OmInBillDataTestDataProvider {
    public static DynamicObject buildByEntryPriceAndQty(OmInBillDataVO billInfo, List<OmInBillDataDetailVO> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)(ObjectUtils.isEmpty((Object)billInfo.getBillEntity()) ? "im_mdc_ominbill" : billInfo.getBillEntity()), (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject supplier = BaseDataTestProvider.getSupplier();
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        DynamicObject purinBill = OmInBillDataTestDataProvider.buildHead(billInfo);
        DynamicObjectType dataEntityType = (DynamicObjectType)purinBill.getDataEntityType();
        DynamicObjectType entryType = ((EntryProp)dataEntityType.getProperty("billentry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection entry = purinBill.getDynamicObjectCollection("billentry");
        DynamicObject lineType = QueryServiceHelper.queryOne((String)"bd_linetype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"010")});
        DynamicObject warehouse = QueryServiceHelper.queryOne((String)"bd_warehouse", (String)"id", (QFilter[])new QFilter[]{new QFilter("isopenlocation", "=", (Object)Boolean.FALSE)});
        QFilter qFilter = new QFilter("masterid.configproperties", "!=", (Object)"2");
        List allMaterialId = QueryServiceHelper.queryPrimaryKeys((String)"bd_materialpurchaseinfo", (QFilter[])new QFilter[]{qFilter}, (String)"id", (int)5000);
        DynamicObject materialInv = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialinventoryinfo", (QFilter[])new QFilter[]{new QFilter("masterid.id", "in", (Object)allMaterialId), new QFilter("enablelot", "=", (Object)Boolean.FALSE)});
        DynamicObject invType = QueryServiceHelper.queryOne((String)"bd_invtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"110")});
        DynamicObject invStatus = QueryServiceHelper.queryOne((String)"bd_invstatus", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"110")});
        int rowIndex = 0;
        for (OmInBillDataDetailVO entryInfo : entryInfoList) {
            DynamicObject row = new DynamicObject(entryType);
            BigDecimal price = entryInfo.getPrice();
            BigDecimal quantity = entryInfo.getQuantity();
            BigDecimal amount = price.multiply(quantity);
            BigDecimal exchangeRate = ObjectUtils.isEmpty((Object)billInfo.getExchangeRate()) ? BigDecimal.ONE : billInfo.getExchangeRate();
            BigDecimal curAmount = price.multiply(quantity).multiply(exchangeRate);
            row.set("seq", (Object)rowIndex);
            ++rowIndex;
            row.set("linetype", (Object)lineType.getLong("id"));
            row.set("material", (Object)materialInv);
            row.set("ispresent", (Object)entryInfo.isPresent());
            row.set("unit", (Object)materialInv.getLong("inventoryunit.id"));
            row.set("baseunit", (Object)materialInv.getLong("inventoryunit.id"));
            row.set("qty", (Object)quantity);
            row.set("baseqty", (Object)quantity);
            row.set("warehouse", (Object)warehouse.getLong("id"));
            row.set("entryreqorg", (Object)org);
            row.set("entrysettleorg", (Object)org);
            row.set("price", (Object)price);
            row.set("priceandtax", (Object)price);
            row.set("actualprice", (Object)price);
            row.set("actualtaxprice", (Object)price);
            row.set("amount", (Object)amount);
            row.set("curamount", (Object)curAmount);
            row.set("amountandtax", (Object)amount);
            row.set("curamountandtax", (Object)curAmount);
            row.set("providersupplier", (Object)supplier);
            row.set("invoicesupplier", (Object)supplier);
            row.set("receivesupplier", (Object)supplier);
            row.set("discounttype", (Object)"NULL");
            row.set("remainreturnqty", (Object)quantity);
            row.set("remainreturnbaseqty", (Object)quantity);
            row.set("remainjoinpriceqty", (Object)quantity);
            row.set("remainjoinpricebaseqty", (Object)quantity);
            row.set("unverifyqty", (Object)quantity);
            row.set("unverifybaseqty", (Object)quantity);
            row.set("invtype", (Object)invType.getLong("id"));
            row.set("invstatus", (Object)invStatus.getLong("id"));
            row.set("ownertype", (Object)"bos_org");
            row.set("owner", (Object)org);
            row.set("keepertype", (Object)"bos_org");
            row.set("keeper", (Object)org);
            entry.add((Object)row);
        }
        return purinBill;
    }

    private static DynamicObject buildHead(OmInBillDataVO billInfo) {
        String billentity = ObjectUtils.isEmpty((Object)billInfo.getBillEntity()) ? "im_mdc_ominbill" : billInfo.getBillEntity();
        DynamicObject purinBill = BusinessDataServiceHelper.newDynamicObject((String)billentity);
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        purinBill.set("org", (Object)org);
        String billNo = StringUtils.isEmpty((CharSequence)billInfo.getBillNo()) ? "WWRK-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo();
        purinBill.set("billno", (Object)billNo);
        purinBill.set("billtype", (Object)("im_mdc_ominbill".equals(billInfo.getBillEntity()) ? 989772873411359744L : 1228835943272797184L));
        String bizTypeNumber = ObjectUtils.isEmpty((Object)billInfo.getBizTypeNumber()) ? "110" : billInfo.getBizTypeNumber();
        DynamicObject bizType = QueryServiceHelper.queryOne((String)"bd_biztype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bizTypeNumber)});
        purinBill.set("biztype", (Object)bizType.getLong("id"));
        String invSchemeNumber = ObjectUtils.isEmpty((Object)billInfo.getInvSchemeNumber()) ? "110" : billInfo.getInvSchemeNumber();
        DynamicObject invscheme = QueryServiceHelper.queryOne((String)"im_invscheme", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)invSchemeNumber)});
        purinBill.set("invscheme", (Object)invscheme.getLong("id"));
        Date createDate = DateUtils.getDataFormat(new Date(), true);
        purinBill.set("biztime", (Object)createDate);
        purinBill.set("bookdate", (Object)createDate);
        String billstatus = ObjectUtils.isEmpty((Object)billInfo.getBillStatus()) ? "A" : billInfo.getBillStatus();
        purinBill.set("billstatus", (Object)billstatus);
        purinBill.set("bizorg", (Object)org);
        DynamicObject supplier = BaseDataTestProvider.getSupplier();
        purinBill.set("supplier", (Object)supplier);
        DynamicObject currencyCNY = BaseDataTestProvider.getCurrencyCNY();
        purinBill.set("currency", (Object)currencyCNY);
        DynamicObject settleCurrency = ObjectUtils.isEmpty((Object)billInfo.getSettleCurrency()) ? currencyCNY : billInfo.getSettleCurrency();
        purinBill.set("settlecurrency", (Object)settleCurrency);
        DynamicObject extrateTable = BaseDataTestProvider.getExtrateTable();
        purinBill.set("exratetable", (Object)extrateTable);
        purinBill.set("exratedate", (Object)createDate);
        purinBill.set("paymode", (Object)"CREDIT");
        purinBill.set("isvirtualbill", (Object)Boolean.FALSE);
        purinBill.set("istax", (Object)Boolean.FALSE);
        BigDecimal exchangeRate = ObjectUtils.isEmpty((Object)billInfo.getExchangeRate()) ? BigDecimal.ONE : billInfo.getExchangeRate();
        purinBill.set("exchangerate", (Object)exchangeRate);
        return purinBill;
    }

    public static DynamicObject createSimpleOmInBill(String billNo, BigDecimal amt) {
        OmInBillDataVO mainInfo = OmInBillDataVO.New().setBillNo(billNo).setBillStatus("C");
        ArrayList<OmInBillDataDetailVO> mainEntryList = new ArrayList<OmInBillDataDetailVO>(1);
        mainEntryList.add(OmInBillDataDetailVO.New().setPrice(amt).setQuantity(BigDecimal.ONE).setSeq(1));
        DynamicObject omInBill = OmInBillDataTestDataProvider.buildByEntryPriceAndQty(mainInfo, mainEntryList);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{omInBill});
        return BusinessDataServiceHelper.loadSingle((Object)omInBill.getLong("id"), (String)"im_mdc_ominbill");
    }

    public static DynamicObject[] loadData(Long[] ids) {
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"im_mdc_ominbill").getDynamicObjectType());
    }

    public static DynamicObject loadSingle(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"im_mdc_ominbill");
    }
}

