/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.PayApplyBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.PayApplyBillDataVO;

public class PayApplyBillTestDataProvider {
    public static DynamicObject buildByHeadPriceTaxTotal(BigDecimal amount) {
        return PayApplyBillTestDataProvider.buildByHeadPriceTaxTotal("", amount);
    }

    public static DynamicObject buildByHeadPriceTaxTotal(String billNo, BigDecimal amount) {
        PayApplyBillDataVO billInfo = PayApplyBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setPricetaxTotal(amount).setBillNo(billNo);
        ArrayList<PayApplyBillDataDetailVO> entryInfoList = new ArrayList<PayApplyBillDataDetailVO>(1);
        entryInfoList.add(PayApplyBillDataDetailVO.New().setPriceTaxTotal(amount));
        return PayApplyBillTestDataProvider.buildByEntryAmount(billInfo, entryInfoList);
    }

    public static DynamicObject buildByEntryAmount(List<PayApplyBillDataDetailVO> entryInfoList) {
        return PayApplyBillTestDataProvider.buildByEntryAmount("", entryInfoList);
    }

    public static DynamicObject buildByEntryAmount(String billNo, List<PayApplyBillDataDetailVO> entryInfoList) {
        return PayApplyBillTestDataProvider.buildByEntryAmount(billNo, null, entryInfoList);
    }

    public static DynamicObject buildByEntryAmount(String billNo, DynamicObject org, List<PayApplyBillDataDetailVO> entryInfoList) {
        PayApplyBillDataVO billInfo = new PayApplyBillDataVO();
        billInfo.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo(billNo).setOrg(org);
        return PayApplyBillTestDataProvider.buildByEntryAmount(billInfo, entryInfoList);
    }

    public static DynamicObject buildByEntryAmount(PayApplyBillDataVO billInfo, List<PayApplyBillDataDetailVO> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)"ap_payapply", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject finBill = PayApplyBillTestDataProvider.buildHeader(billInfo);
        DynamicObjectType dataEntityType = (DynamicObjectType)finBill.getDataEntityType();
        DynamicObjectType detailEntryType = ((EntryProp)dataEntityType.getProperty("entry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection entry = finBill.getDynamicObjectCollection("entry");
        BigDecimal pricetaxTotalHeader = BigDecimal.ZERO;
        BigDecimal localAmtHeader = BigDecimal.ZERO;
        for (PayApplyBillDataDetailVO entryInfo : entryInfoList) {
            DynamicObject row = new DynamicObject(detailEntryType);
            BigDecimal amount = entryInfo.getPriceTaxTotal().setScale(2, RoundingMode.HALF_UP);
            BigDecimal localAmount = amount.multiply(billInfo.getExchangerate()).setScale(2, RoundingMode.HALF_UP);
            row.set("seq", (Object)entryInfo.getSeq());
            row.set("e_paymenttype", (Object)180909827147451392L);
            row.set("e_freezestate", (Object)"unfreeze");
            row.set("e_settlementtype", (Object)entryInfo.getSettlementType());
            row.set("e_asstacttype", (Object)"bd_supplier");
            row.set("e_asstact", (Object)BaseDataTestProvider.getSupplier());
            row.set("e_payamount", (Object)amount);
            row.set("e_applyamount", (Object)amount);
            row.set("e_approvedamt", (Object)amount);
            row.set("e_appseleamount", (Object)localAmount);
            row.set("e_approvedseleamt", (Object)localAmount);
            pricetaxTotalHeader = pricetaxTotalHeader.add(amount);
            localAmtHeader = localAmtHeader.add(localAmount);
            entry.add((Object)row);
        }
        finBill.set("applyamount", (Object)pricetaxTotalHeader);
        finBill.set("approvalamount", (Object)pricetaxTotalHeader);
        finBill.set("appseleamount", (Object)localAmtHeader);
        finBill.set("aprseleamount", (Object)localAmtHeader);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill});
        return finBill;
    }

    public static DynamicObject[] loadData(Long[] ids) {
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"ap_payapply").getDynamicObjectType());
    }

    public static DynamicObject loadSingle(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"ap_payapply");
    }

    private static DynamicObject buildHeader(PayApplyBillDataVO billInfo) {
        DynamicObject finBill = BusinessDataServiceHelper.newDynamicObject((String)"ap_payapply");
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        finBill.set("settleorg", (Object)org);
        finBill.set("applyorg", (Object)org);
        finBill.set("payorg", (Object)org);
        finBill.set("purorg", (Object)org);
        String billNo = StringUtils.isEmpty((CharSequence)billInfo.getBillNo()) ? "APPLY-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo();
        finBill.set("billno", (Object)billNo);
        finBill.set("applydate", (Object)new Date());
        finBill.set("paycurrency", (Object)billInfo.getCurrency());
        finBill.set("settlecurrency", (Object)BaseDataTestProvider.getCurrencyCNY());
        finBill.set("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        finBill.set("exchangerate", (Object)billInfo.getExchangerate());
        finBill.set("billstatus", (Object)"C");
        finBill.set("freezestate", (Object)"unfreeze");
        finBill.set("paystatus", (Object)"Unpaid");
        finBill.set("creator", (Object)1L);
        finBill.set("billtype", (Object)668013607723766784L);
        return finBill;
    }

    public static DynamicObject createPayApplyBill(boolean isSameData, String billNo) {
        PayApplyBillDataDetailVO newOne = PayApplyBillDataDetailVO.New();
        PayApplyBillDataDetailVO newTwo = PayApplyBillDataDetailVO.New();
        if (isSameData) {
            newOne.setPriceTaxTotal(BigDecimal.valueOf(30L));
            newTwo.setPriceTaxTotal(BigDecimal.valueOf(70L));
        } else {
            newOne.setPriceTaxTotal(BigDecimal.valueOf(40L));
            newTwo.setPriceTaxTotal(BigDecimal.valueOf(60L));
        }
        DynamicObject settlementType = BusinessDataServiceHelper.loadSingleFromCache((Object)900001L, (String)"bd_settlementtype");
        newOne.setSettlementType(settlementType).setSeq(1);
        newTwo.setSettlementType(settlementType).setSeq(2);
        PayApplyBillDataVO billInfo = new PayApplyBillDataVO();
        billInfo.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo(billNo);
        return PayApplyBillTestDataProvider.buildByEntryAmount(billInfo, Arrays.asList(newOne, newTwo));
    }
}

