/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.PurInBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.PurInBillDataVO;
import kd.fi.arapcommon.util.DateUtils;
import org.apache.commons.lang3.ObjectUtils;

public class PurInBillDataTestProvider {
    public static DynamicObject buildByEntryPriceAndQty(PurInBillDataVO billInfo, List<PurInBillDataDetailVO> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)"im_purinbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject supplier = BaseDataTestProvider.getSupplier();
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        DynamicObject purinBill = PurInBillDataTestProvider.buildHead(billInfo);
        DynamicObjectType dataEntityType = (DynamicObjectType)purinBill.getDataEntityType();
        DynamicObjectType entryType = ((EntryProp)dataEntityType.getProperty("billentry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection entry = purinBill.getDynamicObjectCollection("billentry");
        String materialType = ObjectUtils.isEmpty((Object)billInfo.getMaterialType()) ? "1" : billInfo.getMaterialType();
        DynamicObject lineType = QueryServiceHelper.queryOne((String)"bd_linetype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"010")});
        DynamicObject warehouse = QueryServiceHelper.queryOne((String)"bd_warehouse", (String)"id", (QFilter[])new QFilter[]{new QFilter("isopenlocation", "=", (Object)Boolean.FALSE)});
        QFilter qFilter = new QFilter("configproperties", "!=", (Object)"2");
        qFilter.and(new QFilter("createorg", "=", (Object)100000L));
        qFilter.and(new QFilter("ctrlstrategy", "=", (Object)"5"));
        qFilter.and(new QFilter("materialtype", "=", (Object)materialType));
        List allMaterialId = QueryServiceHelper.queryPrimaryKeys((String)"bd_material", (QFilter[])new QFilter[]{qFilter}, (String)"id", (int)5000);
        DynamicObject materialInv = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialinventoryinfo", (QFilter[])new QFilter[]{new QFilter("masterid.id", "in", (Object)allMaterialId), new QFilter("enablelot", "=", (Object)Boolean.FALSE), new QFilter("manustrategy", "=", (Object)0L)});
        DynamicObject invType = QueryServiceHelper.queryOne((String)"bd_invtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"110")});
        DynamicObject invStatus = QueryServiceHelper.queryOne((String)"bd_invstatus", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"110")});
        int rowIndex = 0;
        for (PurInBillDataDetailVO entryInfo : entryInfoList) {
            DynamicObject row = new DynamicObject(entryType);
            BigDecimal price = entryInfo.getPrice();
            BigDecimal quantity = entryInfo.getQuantity();
            BigDecimal amount = price.multiply(quantity);
            BigDecimal exchangeRate = ObjectUtils.isEmpty((Object)billInfo.getExchangeRate()) ? BigDecimal.ONE : billInfo.getExchangeRate();
            BigDecimal curAmount = price.multiply(quantity).multiply(exchangeRate);
            row.set("seq", (Object)rowIndex);
            ++rowIndex;
            row.set("linetype", (Object)lineType.getLong("id"));
            row.set("material", (Object)materialInv);
            row.set("ispresent", (Object)entryInfo.isPresent());
            row.set("unit", (Object)materialInv.getLong("inventoryunit.id"));
            row.set("baseunit", (Object)materialInv.getLong("inventoryunit.id"));
            row.set("qty", (Object)quantity);
            row.set("baseqty", (Object)quantity);
            row.set("warehouse", (Object)warehouse.getLong("id"));
            row.set("entryreqorg", (Object)org);
            row.set("entrysettleorg", (Object)org);
            row.set("price", (Object)price);
            row.set("priceandtax", (Object)price);
            row.set("actualprice", (Object)price);
            row.set("actualtaxprice", (Object)price);
            row.set("amount", (Object)amount);
            row.set("curamount", (Object)curAmount);
            row.set("amountandtax", (Object)amount);
            row.set("curamountandtax", (Object)curAmount);
            row.set("providersupplier", (Object)supplier);
            row.set("invoicesupplier", (Object)supplier);
            row.set("receivesupplier", (Object)supplier);
            row.set("discounttype", (Object)"NULL");
            row.set("remainreturnqty", (Object)quantity);
            row.set("remainreturnbaseqty", (Object)quantity);
            row.set("remainjoinpriceqty", (Object)quantity);
            row.set("remainjoinpricebaseqty", (Object)quantity);
            row.set("unverifyqty", (Object)quantity);
            row.set("unverifybaseqty", (Object)quantity);
            row.set("invtype", (Object)invType.getLong("id"));
            row.set("invstatus", (Object)invStatus.getLong("id"));
            row.set("ownertype", (Object)"bos_org");
            row.set("owner", (Object)org);
            row.set("keepertype", (Object)"bos_org");
            row.set("keeper", (Object)org);
            entry.add((Object)row);
        }
        return purinBill;
    }

    private static DynamicObject buildHead(PurInBillDataVO billInfo) {
        DynamicObject purinBill = BusinessDataServiceHelper.newDynamicObject((String)"im_purinbill");
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        purinBill.set("org", (Object)org);
        String billNo = StringUtils.isEmpty((CharSequence)billInfo.getBillNo()) ? "CGRK-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo();
        purinBill.set("billno", (Object)billNo);
        purinBill.set("billtype", (Object)366348248593474560L);
        String bizTypeNumber = ObjectUtils.isEmpty((Object)billInfo.getBizTypeNumber()) ? "110" : billInfo.getBizTypeNumber();
        DynamicObject bizType = QueryServiceHelper.queryOne((String)"bd_biztype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bizTypeNumber)});
        purinBill.set("biztype", (Object)bizType.getLong("id"));
        String invSchemeNumber = ObjectUtils.isEmpty((Object)billInfo.getInvSchemeNumber()) ? "110" : billInfo.getInvSchemeNumber();
        DynamicObject invscheme = QueryServiceHelper.queryOne((String)"im_invscheme", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)invSchemeNumber)});
        purinBill.set("invscheme", (Object)invscheme.getLong("id"));
        Date createDate = DateUtils.getDataFormat(new Date(), true);
        purinBill.set("biztime", (Object)createDate);
        purinBill.set("bookdate", (Object)createDate);
        String billstatus = ObjectUtils.isEmpty((Object)billInfo.getBillStatus()) ? "A" : billInfo.getBillStatus();
        purinBill.set("billstatus", (Object)billstatus);
        purinBill.set("bizorg", (Object)org);
        DynamicObject supplier = BaseDataTestProvider.getSupplier();
        purinBill.set("supplier", (Object)supplier);
        DynamicObject currencyCNY = BaseDataTestProvider.getCurrencyCNY();
        purinBill.set("currency", (Object)currencyCNY);
        DynamicObject settleCurrency = ObjectUtils.isEmpty((Object)billInfo.getSettleCurrency()) ? currencyCNY : billInfo.getSettleCurrency();
        purinBill.set("settlecurrency", (Object)settleCurrency);
        DynamicObject extrateTable = BaseDataTestProvider.getExtrateTable();
        purinBill.set("exratetable", (Object)extrateTable);
        purinBill.set("quotation", (Object)billInfo.getQuotation());
        purinBill.set("exratedate", (Object)createDate);
        purinBill.set("exchangerate", (Object)BigDecimal.ONE);
        purinBill.set("paymode", (Object)"CREDIT");
        purinBill.set("isvirtualbill", (Object)Boolean.FALSE);
        purinBill.set("istax", (Object)Boolean.FALSE);
        BigDecimal exchangeRate = ObjectUtils.isEmpty((Object)billInfo.getExchangeRate()) ? BigDecimal.ONE : billInfo.getExchangeRate();
        purinBill.set("exchangerate", (Object)exchangeRate);
        return purinBill;
    }

    public static DynamicObject[] loadData(Long[] ids) {
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"im_purinbill").getDynamicObjectType());
    }

    public static DynamicObject loadSingle(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"im_purinbill");
    }

    public static DynamicObject createPurInBill(boolean isFirstCreate, boolean isDiffCurrency, String billNo) {
        PurInBillDataVO purInBillDataVO = new PurInBillDataVO();
        purInBillDataVO.setBillNo(billNo);
        purInBillDataVO.setOrg(BaseDataTestProvider.getDetailInitOrg());
        purInBillDataVO.setBillStatus("C");
        if (isDiffCurrency) {
            purInBillDataVO.setSettleCurrency(BaseDataTestProvider.getCurrencyUSD());
            purInBillDataVO.setExchangeRate(BigDecimal.valueOf(6.045));
        }
        PurInBillDataDetailVO dataDetailVO_1 = new PurInBillDataDetailVO();
        dataDetailVO_1.setSeq(1);
        dataDetailVO_1.setQuantity(BigDecimal.ONE);
        PurInBillDataDetailVO dataDetailVO_2 = new PurInBillDataDetailVO();
        dataDetailVO_2.setSeq(2);
        dataDetailVO_2.setQuantity(BigDecimal.ONE);
        dataDetailVO_1.setPrice(BigDecimal.valueOf(70L));
        dataDetailVO_2.setPrice(BigDecimal.valueOf(30L));
        if (isFirstCreate) {
            dataDetailVO_1.setPrice(BigDecimal.valueOf(60L));
            dataDetailVO_2.setPrice(BigDecimal.valueOf(40L));
        }
        DynamicObject purInBill = PurInBillDataTestProvider.buildByEntryPriceAndQty(purInBillDataVO, Arrays.asList(dataDetailVO_1, dataDetailVO_2));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{purInBill});
        return BusinessDataServiceHelper.loadSingle((Object)purInBill.getLong("id"), (String)"im_purinbill");
    }
}

