/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.PurReceiveBillDataDetailVo;
import kd.fi.arapcommon.unittest.framework.entity.PurReceiveBillDataVo;
import kd.fi.arapcommon.util.DateUtils;
import org.apache.commons.lang3.ObjectUtils;

public class PurReceiveBillTestDataProvider {
    public static DynamicObject buildByEntryPriceAndQty(PurReceiveBillDataVo billInfo, List<PurReceiveBillDataDetailVo> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)"im_purreceivebill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject supplier = BaseDataTestProvider.getSupplier();
        DynamicObject org = ObjectUtils.isEmpty((Object)billInfo.getOrg()) ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        DynamicObject purReceiveBill = PurReceiveBillTestDataProvider.buildHead(billInfo);
        DynamicObjectType dataEntityType = (DynamicObjectType)purReceiveBill.getDataEntityType();
        DynamicObjectType entryType = ((EntryProp)dataEntityType.getProperty("billentry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection entry = purReceiveBill.getDynamicObjectCollection("billentry");
        String lineTypeNumber = ObjectUtils.isEmpty((Object)billInfo.getLineTypeNumber()) ? "010" : billInfo.getLineTypeNumber();
        DynamicObject lineType = QueryServiceHelper.queryOne((String)"bd_linetype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)lineTypeNumber)});
        DynamicObject warehouse = QueryServiceHelper.queryOne((String)"bd_warehouse", (String)"id", (QFilter[])new QFilter[]{new QFilter("isopenlocation", "=", (Object)Boolean.FALSE)});
        QFilter qFilter = new QFilter("configproperties", "!=", (Object)"2");
        qFilter.and(new QFilter("ctrlstrategy", "=", (Object)"5"));
        List allMaterialId = QueryServiceHelper.queryPrimaryKeys((String)"bd_material", (QFilter[])new QFilter[]{qFilter}, (String)"id", (int)5000);
        DynamicObject materialInv = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialinventoryinfo", (QFilter[])new QFilter[]{new QFilter("masterid.id", "in", (Object)allMaterialId), new QFilter("enablelot", "=", (Object)Boolean.FALSE), new QFilter("manustrategy", "=", (Object)0L)});
        materialInv = ObjectUtils.isEmpty((Object)billInfo.getMaterialInv()) ? materialInv : billInfo.getMaterialInv();
        DynamicObject invType = QueryServiceHelper.queryOne((String)"bd_invtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"112")});
        DynamicObject invStatus = QueryServiceHelper.queryOne((String)"bd_invstatus", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"111")});
        int rowIndex = 0;
        for (PurReceiveBillDataDetailVo entryInfo : entryInfoList) {
            DynamicObject row = new DynamicObject(entryType);
            BigDecimal price = entryInfo.getPrice();
            BigDecimal quantity = entryInfo.getQuantity();
            BigDecimal amount = price.multiply(quantity);
            BigDecimal exchangeRate = ObjectUtils.isEmpty((Object)billInfo.getExchangeRate()) ? BigDecimal.ONE : billInfo.getExchangeRate();
            BigDecimal curAmount = price.multiply(quantity).multiply(exchangeRate);
            row.set("seq", (Object)rowIndex);
            ++rowIndex;
            row.set("linetype", (Object)lineType.getLong("id"));
            row.set("material", (Object)materialInv);
            row.set("unit", (Object)materialInv.getLong("inventoryunit.id"));
            row.set("baseunit", (Object)materialInv.getLong("inventoryunit.id"));
            row.set("qty", (Object)quantity);
            row.set("baseqty", (Object)quantity);
            row.set("warehouse", (Object)warehouse.getLong("id"));
            row.set("entryreqorg", (Object)org);
            row.set("entrysettleorg", (Object)org);
            row.set("price", (Object)price);
            row.set("priceandtax", (Object)price);
            row.set("actualprice", (Object)price);
            row.set("actualtaxprice", (Object)price);
            row.set("amount", (Object)amount);
            row.set("curamount", (Object)curAmount);
            row.set("amountandtax", (Object)amount);
            row.set("curamountandtax", (Object)curAmount);
            row.set("providersupplier", (Object)supplier);
            row.set("invoicesupplier", (Object)supplier);
            row.set("receivesupplier", (Object)supplier);
            row.set("discounttype", (Object)"NULL");
            row.set("remainreturnqty", (Object)quantity);
            row.set("remainreturnbaseqty", (Object)quantity);
            row.set("remainjoinpriceqty", (Object)quantity);
            row.set("remainjoinpricebaseqty", (Object)quantity);
            row.set("unverifyqty", (Object)quantity);
            row.set("unverifybaseqty", (Object)quantity);
            row.set("invtype", (Object)invType.getLong("id"));
            row.set("invstatus", (Object)invStatus.getLong("id"));
            row.set("ownertype", (Object)"bd_supplier");
            row.set("owner", (Object)supplier);
            row.set("keepertype", (Object)"bos_org");
            row.set("keeper", (Object)org);
            row.set("remaininvqty", (Object)quantity);
            row.set("remaininvbaseqty", (Object)quantity);
            row.set("remainpurqty", (Object)quantity);
            row.set("qualifiedqty", (Object)quantity);
            row.set("qualifiedbaseqty", (Object)quantity);
            row.set("remainreturnqty", (Object)quantity);
            row.set("remainreturnbaseqty", (Object)quantity);
            entry.add((Object)row);
        }
        return purReceiveBill;
    }

    private static DynamicObject buildHead(PurReceiveBillDataVo billInfo) {
        DynamicObject purinBill = BusinessDataServiceHelper.newDynamicObject((String)"im_purreceivebill");
        DynamicObject org = ObjectUtils.isEmpty((Object)billInfo.getOrg()) ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        purinBill.set("org", (Object)org);
        String billno = ObjectUtils.isEmpty((Object)billInfo.getBillNo()) ? "CGSH-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo();
        purinBill.set("billno", (Object)billno);
        purinBill.set("billtype", (Object)631624048106832896L);
        String bizTypeNumber = ObjectUtils.isEmpty((Object)billInfo.getBizTypeNumber()) ? "110" : billInfo.getBizTypeNumber();
        DynamicObject bizType = QueryServiceHelper.queryOne((String)"bd_biztype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bizTypeNumber)});
        purinBill.set("biztype", (Object)bizType.getLong("id"));
        String invSchemeNumber = ObjectUtils.isEmpty((Object)billInfo.getInvSchemeNumber()) ? "113" : billInfo.getInvSchemeNumber();
        DynamicObject invscheme = QueryServiceHelper.queryOne((String)"im_invscheme", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)invSchemeNumber)});
        purinBill.set("invscheme", (Object)invscheme.getLong("id"));
        Date createDate = DateUtils.getDataFormat(new Date(), true);
        purinBill.set("biztime", (Object)createDate);
        purinBill.set("bookdate", (Object)createDate);
        String billstatus = ObjectUtils.isEmpty((Object)billInfo.getBillStatus()) ? "A" : billInfo.getBillStatus();
        purinBill.set("billstatus", (Object)billstatus);
        purinBill.set("bizorg", (Object)org);
        DynamicObject supplier = ObjectUtils.isEmpty((Object)billInfo.getSupplier()) ? BaseDataTestProvider.getSupplier() : billInfo.getSupplier();
        purinBill.set("supplier", (Object)supplier);
        DynamicObject currencyCNY = BaseDataTestProvider.getCurrencyCNY();
        purinBill.set("currency", (Object)currencyCNY);
        DynamicObject settleCurrency = ObjectUtils.isEmpty((Object)billInfo.getSettleCurrency()) ? currencyCNY : billInfo.getSettleCurrency();
        purinBill.set("settlecurrency", (Object)settleCurrency);
        DynamicObject extrateTable = BaseDataTestProvider.getExtrateTable();
        purinBill.set("exratetable", (Object)extrateTable);
        purinBill.set("exratedate", (Object)createDate);
        purinBill.set("paymode", (Object)"CREDIT");
        purinBill.set("isvirtualbill", (Object)Boolean.FALSE);
        purinBill.set("istax", (Object)Boolean.FALSE);
        BigDecimal exchangeRate = ObjectUtils.isEmpty((Object)billInfo.getExchangeRate()) ? BigDecimal.ONE : billInfo.getExchangeRate();
        purinBill.set("exchangerate", (Object)exchangeRate);
        return purinBill;
    }

    public static DynamicObject loadSingle(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"im_purreceivebill");
    }
}

