/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.RecCfmBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.RecCfmBillDataVO;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public class RecCfmBillTestDataProvider {
    public static DynamicObject buildByPriceAndQuantity(String billNo, DynamicObject org, List<RecCfmBillDataDetailVO> entryInfoList) {
        RecCfmBillDataVO billInfo = RecCfmBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo(billNo).setOrg(org);
        return RecCfmBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryInfoList);
    }

    public static DynamicObject buildByPriceAndQuantity(RecCfmBillDataVO billInfo, List<RecCfmBillDataDetailVO> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)"ar_revcfmbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject finBill = RecCfmBillTestDataProvider.buildHeader(billInfo);
        DynamicObjectType dataEntityType = (DynamicObjectType)finBill.getDataEntityType();
        DynamicObjectType detailEntryType = ((EntryProp)dataEntityType.getProperty("entry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        BigDecimal pricetaxTotalHeader = BigDecimal.ZERO;
        BigDecimal localAmtHeader = BigDecimal.ZERO;
        DynamicObject currency = BusinessDataServiceHelper.loadSingle((Object)finBill.getLong("currency"), (String)"bd_currency");
        int precision = currency.getInt("amtprecision");
        for (RecCfmBillDataDetailVO entryInfo : entryInfoList) {
            DynamicObject detailEntry = new DynamicObject(detailEntryType);
            BigDecimal pricetaxTotal = entryInfo.getPrice().multiply(entryInfo.getQuantity()).setScale(precision, RoundingMode.HALF_UP);
            BigDecimal localAmount = pricetaxTotal.multiply(billInfo.getExchangerate()).setScale(precision, RoundingMode.HALF_UP);
            detailEntry.set("seq", (Object)entryInfo.getSeq());
            detailEntry.set("e_material", (Object)BaseDataTestProvider.getMaterial());
            detailEntry.set("e_measureunit", (Object)BaseDataTestProvider.getMaterial().getDynamicObject("baseunit"));
            detailEntry.set("e_baseunitid", (Object)BaseDataTestProvider.getMaterial().getDynamicObject("baseunit"));
            detailEntry.set("e_quantity", (Object)entryInfo.getQuantity());
            detailEntry.set("e_baseunitqty", (Object)entryInfo.getQuantity());
            detailEntry.set("e_unitprice", (Object)entryInfo.getPrice());
            detailEntry.set("e_actunitprice", (Object)entryInfo.getPrice());
            detailEntry.set("e_unitcoefficient", (Object)BigDecimal.valueOf(1L));
            detailEntry.set("e_ispresent", (Object)entryInfo.isPresent());
            detailEntry.set("e_amount", (Object)pricetaxTotal);
            detailEntry.set("e_localamt", (Object)pricetaxTotal);
            detailEntry.set("e_unverifyqty", (Object)entryInfo.getQuantity());
            detailEntry.set("e_unverifybaseqty", (Object)entryInfo.getQuantity());
            detailEntry.set("e_unverifyamt", (Object)pricetaxTotal);
            detailEntry.set("e_confirmqty", (Object)entryInfo.getQuantity());
            detailEntry.set("e_confirmbaseqty", (Object)entryInfo.getQuantity());
            detailEntry.set("e_confirmamt", (Object)pricetaxTotal);
            detailEntry.set("e_unrecamt", (Object)pricetaxTotal);
            detailEntry.set("e_unrecqty", (Object)entryInfo.getQuantity());
            detailEntry.set("e_unrecbaseqty", (Object)entryInfo.getQuantity());
            detailEntry.set("e_discountmode", (Object)"NULL");
            detailEntry.set("e_corebilltype", (Object)entryInfo.getCorebilltype());
            detailEntry.set("e_corebillno", (Object)entryInfo.getCorebillno());
            detailEntry.set("e_corebillentryseq", (Object)entryInfo.getCorebillentryseq());
            detailEntry.set("groupnumber", (Object)entryInfo.getGroupnumber());
            detailEntry.set("groupseq", (Object)entryInfo.getGroupseq());
            detailEntry.set("e_isallverify", (Object)entryInfo.getIsallverify());
            detailEntries.add((Object)detailEntry);
            pricetaxTotalHeader = pricetaxTotalHeader.add(pricetaxTotal);
            localAmtHeader = localAmtHeader.add(localAmount);
        }
        finBill.set("amount", (Object)pricetaxTotalHeader);
        finBill.set("localamt", (Object)localAmtHeader);
        finBill.set("confirmamt", (Object)pricetaxTotalHeader);
        finBill.set("confirmlocamt", (Object)localAmtHeader);
        finBill.set("unverifyamt", (Object)pricetaxTotalHeader);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill});
        return finBill;
    }

    private static DynamicObject buildHeader(RecCfmBillDataVO billInfo) {
        DynamicObject finBill = BusinessDataServiceHelper.newDynamicObject((String)"ar_revcfmbill");
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        finBill.set("org", (Object)org);
        finBill.set("recorg", (Object)org);
        String billNo = StringUtils.isEmpty((CharSequence)billInfo.getBillNo()) ? "RECFM-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo();
        finBill.set("billno", (Object)billNo);
        finBill.set("bizdate", (Object)new Date());
        finBill.set("bookdate", (Object)new Date());
        finBill.set("asstacttype", (Object)"bd_customer");
        finBill.set("asstact", (Object)BaseDataTestProvider.getCustomer());
        finBill.set("payproperty", (Object)(billInfo.getPayproperty() != null ? billInfo.getPayproperty() : BaseDataTestProvider.getRecProperty()));
        finBill.set("currency", (Object)billInfo.getCurrency());
        finBill.set("basecurrency", (Object)BaseDataTestProvider.getCurrencyCNY());
        finBill.set("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        finBill.set("exchangerate", (Object)billInfo.getExchangerate());
        finBill.set("billstatus", (Object)billInfo.getBillStatus());
        finBill.set("verifystatus", (Object)"unverify");
        finBill.set("creator", (Object)1L);
        finBill.set("billtype", (Object)732351444413344768L);
        finBill.set("exratedate", (Object)new Date());
        if (EntityMetadataUtils.isExistProperty(finBill, "quotation")) {
            finBill.set("quotation", (Object)"0");
        }
        finBill.set("confirmway", (Object)"RATE");
        finBill.set("confirmrate", (Object)BigDecimal.valueOf(100.0));
        return finBill;
    }

    public static DynamicObject[] loadData(Long[] ids) {
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"ar_revcfmbill").getDynamicObjectType());
    }

    public static DynamicObject loadSingle(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"ar_revcfmbill");
    }
}

