/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.SalOutBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.SalOutBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.SalOutBillTestHelper;
import kd.fi.arapcommon.util.DateUtils;
import org.apache.commons.lang3.ObjectUtils;

public class SalOutBillDataTestProvider {
    public static DynamicObject buildByEntryPriceAndQty(SalOutBillDataVO billInfo, List<SalOutBillDataDetailVO> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)"im_saloutbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject customer = BaseDataTestProvider.getCustomer();
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        DynamicObject salOutBill = SalOutBillDataTestProvider.buildHead(billInfo);
        DynamicObjectType dataEntityType = (DynamicObjectType)salOutBill.getDataEntityType();
        DynamicObjectType entryType = ((EntryProp)dataEntityType.getProperty("billentry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection entry = salOutBill.getDynamicObjectCollection("billentry");
        DynamicObject lineType = QueryServiceHelper.queryOne((String)"bd_linetype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"010")});
        DynamicObject warehouse = QueryServiceHelper.queryOne((String)"bd_warehouse", (String)"id", (QFilter[])new QFilter[]{new QFilter("isopenlocation", "=", (Object)Boolean.FALSE)});
        QFilter materialFilter = new QFilter("masterid.configproperties", "!=", (Object)"2");
        materialFilter.and(new QFilter("masterid.ctrlstrategy", "=", (Object)"5"));
        materialFilter.and(new QFilter("ctrlstrategy", "=", (Object)"5"));
        materialFilter.and(new QFilter("enablelot", "=", (Object)Boolean.FALSE));
        DynamicObject materialInv = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialinventoryinfo", (QFilter[])new QFilter[]{materialFilter});
        DynamicObject invType = QueryServiceHelper.queryOne((String)"bd_invtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"110")});
        DynamicObject invStatus = QueryServiceHelper.queryOne((String)"bd_invstatus", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"110")});
        int rowIndex = 0;
        for (SalOutBillDataDetailVO entryInfo : entryInfoList) {
            DynamicObject row = new DynamicObject(entryType);
            BigDecimal price = entryInfo.getPrice();
            BigDecimal quantity = entryInfo.getQuantity();
            BigDecimal amount = price.multiply(quantity);
            BigDecimal exchangeRate = ObjectUtils.isEmpty((Object)billInfo.getExchangeRate()) ? BigDecimal.ONE : billInfo.getExchangeRate();
            BigDecimal curAmount = price.multiply(quantity).multiply(exchangeRate);
            row.set("seq", (Object)rowIndex);
            ++rowIndex;
            row.set("linetype", (Object)lineType.getLong("id"));
            row.set("material", (Object)materialInv);
            row.set("ispresent", (Object)entryInfo.isPresent());
            row.set("unit", (Object)materialInv.getLong("inventoryunit.id"));
            row.set("baseunit", (Object)materialInv.getLong("inventoryunit.id"));
            row.set("qty", (Object)quantity);
            row.set("baseqty", (Object)quantity);
            row.set("warehouse", (Object)warehouse.getLong("id"));
            row.set("entrysettleorg", (Object)org);
            row.set("price", (Object)price);
            row.set("priceandtax", (Object)price);
            row.set("actualprice", (Object)price);
            row.set("actualtaxprice", (Object)price);
            row.set("amount", (Object)amount);
            row.set("curamount", (Object)curAmount);
            row.set("amountandtax", (Object)amount);
            row.set("curamountandtax", (Object)curAmount);
            row.set("payingcustomer", (Object)customer);
            row.set("reccustomer", (Object)customer);
            row.set("discounttype", (Object)"NULL");
            row.set("remainreturnqty", (Object)quantity);
            row.set("remainreturnbaseqty", (Object)quantity);
            row.set("remainjoinpriceqty", (Object)quantity);
            row.set("remainjoinpricebaseqty", (Object)quantity);
            row.set("unverifyqty", (Object)quantity);
            row.set("unverifybaseqty", (Object)quantity);
            row.set("invtype", (Object)invType.getLong("id"));
            row.set("invstatus", (Object)invStatus.getLong("id"));
            row.set("ownertype", (Object)"bos_org");
            row.set("owner", (Object)org);
            row.set("keepertype", (Object)"bos_org");
            row.set("keeper", (Object)org);
            row.set("settlecustomer", (Object)customer);
            row.set("mainbillentity", (Object)entryInfo.getCorebilltype());
            row.set("mainbillnumber", (Object)entryInfo.getCorebillno());
            row.set("mainbillid", (Object)entryInfo.getCorebillid());
            row.set("mainbillentryseq", (Object)entryInfo.getCorebillentryseq());
            row.set("mainbillentryid", (Object)entryInfo.getCorebillentryid());
            row.set("groupnumber", (Object)entryInfo.getGroupnumber());
            row.set("groupseq", (Object)entryInfo.getGroupseq());
            entry.add((Object)row);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{salOutBill});
        return salOutBill;
    }

    private static DynamicObject buildHead(SalOutBillDataVO billInfo) {
        DynamicObject salOutBill = BusinessDataServiceHelper.newDynamicObject((String)"im_saloutbill");
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        salOutBill.set("org", (Object)org);
        String billNo = StringUtils.isEmpty((CharSequence)billInfo.getBillNo()) ? "XSCK-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo();
        salOutBill.set("billno", (Object)billNo);
        salOutBill.set("billtype", (Object)452682831861140480L);
        String bizTypeNumber = ObjectUtils.isEmpty((Object)billInfo.getBizTypeNumber()) ? "210" : billInfo.getBizTypeNumber();
        DynamicObject bizType = QueryServiceHelper.queryOne((String)"bd_biztype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bizTypeNumber)});
        salOutBill.set("biztype", (Object)bizType.getLong("id"));
        String invSchemeNumber = ObjectUtils.isEmpty((Object)billInfo.getInvSchemeNumber()) ? "210" : billInfo.getInvSchemeNumber();
        DynamicObject invscheme = QueryServiceHelper.queryOne((String)"im_invscheme", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)invSchemeNumber)});
        salOutBill.set("invscheme", (Object)invscheme.getLong("id"));
        Date createDate = DateUtils.getDataFormat(new Date(), true);
        salOutBill.set("biztime", (Object)createDate);
        salOutBill.set("bookdate", (Object)createDate);
        String billstatus = ObjectUtils.isEmpty((Object)billInfo.getBillStatus()) ? "A" : billInfo.getBillStatus();
        salOutBill.set("billstatus", (Object)billstatus);
        salOutBill.set("bizorg", (Object)org);
        DynamicObject customer = SalOutBillTestHelper.getCustomer();
        salOutBill.set("customer", (Object)customer);
        DynamicObject currencyCNY = BaseDataTestProvider.getCurrencyCNY();
        salOutBill.set("currency", (Object)currencyCNY);
        DynamicObject settleCurrency = ObjectUtils.isEmpty((Object)billInfo.getSettleCurrency()) ? currencyCNY : billInfo.getSettleCurrency();
        salOutBill.set("settlecurrency", (Object)settleCurrency);
        DynamicObject extrateTable = BaseDataTestProvider.getExtrateTable();
        salOutBill.set("exratetable", (Object)extrateTable);
        salOutBill.set("exratedate", (Object)createDate);
        salOutBill.set("exchangerate", (Object)BigDecimal.ONE);
        salOutBill.set("paymode", (Object)"CREDIT");
        salOutBill.set("isvirtualbill", (Object)Boolean.FALSE);
        salOutBill.set("istax", (Object)Boolean.FALSE);
        BigDecimal exchangeRate = ObjectUtils.isEmpty((Object)billInfo.getExchangeRate()) ? BigDecimal.ONE : billInfo.getExchangeRate();
        salOutBill.set("exchangerate", (Object)exchangeRate);
        return salOutBill;
    }

    public static DynamicObject[] loadData(Long[] ids) {
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"im_saloutbill").getDynamicObjectType());
    }

    public static DynamicObject loadSingle(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"im_saloutbill");
    }

    public static DynamicObject createSalOutBill(boolean isFirstCreate, boolean isDiffCurrency, String billNo) {
        if (StringUtils.isNotEmpty((CharSequence)billNo)) {
            DeleteServiceHelper.delete((String)"im_saloutbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        }
        SalOutBillDataVO salOutBillDataVO = new SalOutBillDataVO();
        salOutBillDataVO.setBillNo(billNo);
        salOutBillDataVO.setOrg(BaseDataTestProvider.getDetailInitOrg());
        if (isDiffCurrency) {
            salOutBillDataVO.setSettleCurrency(BaseDataTestProvider.getCurrencyUSD());
            salOutBillDataVO.setExchangeRate(BigDecimal.valueOf(6.045));
        }
        SalOutBillDataDetailVO dataDetailVO1 = new SalOutBillDataDetailVO();
        dataDetailVO1.setSeq(1);
        dataDetailVO1.setQuantity(BigDecimal.ONE);
        dataDetailVO1.setPrice(BigDecimal.valueOf(70L));
        SalOutBillDataDetailVO dataDetailVO2 = new SalOutBillDataDetailVO();
        dataDetailVO2.setSeq(2);
        dataDetailVO2.setQuantity(BigDecimal.ONE);
        dataDetailVO2.setPrice(BigDecimal.valueOf(30L));
        if (isFirstCreate) {
            dataDetailVO1.setPrice(BigDecimal.valueOf(60L));
            dataDetailVO2.setPrice(BigDecimal.valueOf(40L));
        }
        DynamicObject salOutBill = SalOutBillDataTestProvider.buildByEntryPriceAndQty(salOutBillDataVO, Arrays.asList(dataDetailVO1, dataDetailVO2));
        salOutBill.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{salOutBill});
        return salOutBill;
    }
}

