/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.InvokeTestHelper;
import org.apache.commons.lang3.ObjectUtils;

public class ApInvoiceBillTestHelper {
    public static void searchOneRowDataByBillNo(AbstractJUnitTestPlugIn junit, DynamicObject invoice) {
        String param = "[{\"key\":\"billlistap\",\"methodName\":\"entryRowClick\",\"args\":[0],\"postData\":[{\"billlistap\":{\"fieldKey\":\"0\",\"row\":0,\"selRows\":[0],\"isClientNewRow\":false,\"clientNewRows\":\"\",\"selDatas\":[[\"%s\",\"574546959092681728\",\"C\",\"%s\",\" \"]]}},[]]}]";
        InvokeTestHelper.invokeAction(String.format(param, invoice.getPkValue(), invoice.getString("billno")), junit);
    }

    public static void setAP001(long orgId, boolean AP001) {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        if (AP001) {
            params.put("ap_001", 1);
        } else {
            params.put("ap_001", 0);
        }
        SystemParameterHelper.setSystemParameter(false, orgId, params);
    }

    public static DynamicObject pushInvoice(String srcBillEntity, List<Long> srcIds) {
        return ApInvoiceBillTestHelper.pushInvoice(srcBillEntity, srcIds, "C", null, BigDecimal.ONE);
    }

    public static DynamicObject pushInvoice(String srcBillEntity, List<Long> srcIds, BigDecimal exchangeRate) {
        return ApInvoiceBillTestHelper.pushInvoice(srcBillEntity, srcIds, "C", null, exchangeRate);
    }

    public static DynamicObject pushInvoice(String srcBillEntity, List<Long> srcIds, String billStatus, String ruleId, BigDecimal exchangeRate) {
        List<DynamicObject> invoices = BOTPHelper.push(srcBillEntity, "ap_invoice", ruleId, srcIds, "\u6682\u4f30\u5e94\u4ed8\u4e0b\u63a8\u589e\u503c\u7a0e\u53d1\u7968\u5931\u8d25");
        DynamicObject invoiceBill = invoices.get(0);
        ApInvoiceBillTestHelper.setApInvoice(invoiceBill);
        long invoiceId = invoiceBill.getLong("id");
        if (exchangeRate.compareTo(BigDecimal.ONE) != 0) {
            long currencyId = invoiceBill.getLong("currency.id");
            invoiceBill.set("exchangerate", (Object)exchangeRate);
            DynamicObject currency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currencyId)});
            int amtPrecision = currency.getInt("amtprecision");
            DynamicObjectCollection entry = invoiceBill.getDynamicObjectCollection("entry");
            BigDecimal amountBaseSum = BigDecimal.ZERO;
            BigDecimal priceTaxTotalBaseSum = BigDecimal.ZERO;
            for (DynamicObject row : entry) {
                BigDecimal amount = row.getBigDecimal("e_amount");
                BigDecimal priceTaxTotal = row.getBigDecimal("e_pricetaxtotal");
                BigDecimal discountAmt = row.getBigDecimal("discountamt");
                BigDecimal amountBase = amount.multiply(exchangeRate).setScale(amtPrecision, RoundingMode.HALF_UP);
                BigDecimal priceTaxTotalBase = priceTaxTotal.multiply(exchangeRate).setScale(amtPrecision, RoundingMode.HALF_UP);
                BigDecimal discountAmtBase = discountAmt.multiply(exchangeRate).setScale(amtPrecision, RoundingMode.HALF_UP);
                amountBaseSum = amountBaseSum.add(amountBase);
                priceTaxTotalBaseSum = priceTaxTotalBaseSum.add(priceTaxTotalBase);
                row.set("e_amountbase", (Object)amountBase);
                row.set("e_pricetaxtotalbase", (Object)priceTaxTotalBase);
                row.set("discountlocalamt", (Object)discountAmtBase);
            }
            invoiceBill.set("amountbase", (Object)amountBaseSum);
            invoiceBill.set("pricetaxtotalbase", (Object)priceTaxTotalBaseSum);
        }
        BusBillTestHelper.executeOperation("save", "ap_invoice", new DynamicObject[]{invoiceBill});
        if (ObjectUtils.isEmpty((Object)billStatus) || "C".equals(billStatus)) {
            BusBillTestHelper.executeOperation("submit", "ap_invoice", new Object[]{invoiceId});
            BusBillTestHelper.executeOperation("audit", "ap_invoice", new Object[]{invoiceId});
        }
        invoiceBill = BusinessDataServiceHelper.loadSingle((Object)invoiceId, (String)"ap_invoice");
        return invoiceBill;
    }

    public static List<Long> pushInvoiceAndAudit(String srcBillEntity, List<Long> srcIds) {
        List<DynamicObject> invoices = BOTPHelper.push(srcBillEntity, "ap_invoice", null, srcIds, "\u6682\u4f30\u5e94\u4ed8\u4e0b\u63a8\u589e\u503c\u7a0e\u53d1\u7968\u5931\u8d25");
        ArrayList<Long> invoiceIds = new ArrayList<Long>(invoices.size());
        for (DynamicObject invoice : invoices) {
            ApInvoiceBillTestHelper.setApInvoice(invoice);
            invoiceIds.add(invoice.getLong("id"));
        }
        BusBillTestHelper.executeOperation("save", "ap_invoice", invoices.toArray(new DynamicObject[0]));
        BusBillTestHelper.executeOperation("submit", "ap_invoice", invoiceIds.toArray());
        BusBillTestHelper.executeOperation("audit", "ap_invoice", invoiceIds.toArray());
        return invoiceIds;
    }

    public static void setApInvoice(DynamicObject invoiceBill) {
        invoiceBill.set("sellertin", (Object)"1");
        invoiceBill.set("selleraddr", (Object)"test");
        invoiceBill.set("sellertel", (Object)"17212345678");
        invoiceBill.set("sellerbank", (Object)"bank");
        invoiceBill.set("selleracct", (Object)"110");
        invoiceBill.set("buyertin", (Object)"2");
        invoiceBill.set("buyeraddr", (Object)"test");
        invoiceBill.set("buyertel", (Object)"17287654321");
        invoiceBill.set("buyerbank", (Object)"bank");
        invoiceBill.set("buyeracct", (Object)"120");
        invoiceBill.set("receivedate", (Object)new Date());
    }
}

