/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.util.DateUtils;

public class ArApCommonTestHelper {
    public static void executeOperate(String operationKey, String entityNumber, DynamicObject[] dataEntities) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("iswoff", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option);
        OperationHelper.assertResult(operationResult);
    }

    public static void executeOperate(String operationKey, String entityNumber, Object[] ids) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("iswoff", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids, (OperateOption)option);
        OperationHelper.assertResult(operationResult);
    }

    public static void setOrgIntertemporal(DynamicObject intertemporalOrg) {
        Date date = DateUtils.parseDate("2099-01-01", "yyyy-MM-dd");
        DynamicObject[] apInit = BusinessDataServiceHelper.load((String)"ap_init", (String)"startdate,currentdate", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)intertemporalOrg.getLong("id"))});
        apInit[0].set("currentdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])apInit);
        DynamicObject[] arInit = BusinessDataServiceHelper.load((String)"ar_init", (String)"startdate,currentdate", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)intertemporalOrg.getLong("id"))});
        arInit[0].set("currentdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])arInit);
    }

    public static DynamicObject loadSingle(String entityName, QFilter[] filters) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])filters);
        return BusinessDataServiceHelper.loadSingle((Object)obj.getLong("id"), (String)entityName);
    }

    public static void createRelationShip(DynamicObject srcBill, String srcEntryName, DynamicObject tarBill, String tarEntryName) {
        String srcEntityName = srcBill.getDataEntityType().getName();
        String billEntityName = tarBill.getDataEntityType().getName();
        TableDefine sourceTableDefine = ConvertMetaServiceHelper.loadTableDefine((String)srcEntityName, (String)srcEntityName);
        TableDefine sourceTableDefine1 = ConvertMetaServiceHelper.loadTableDefine((String)srcEntityName, (String)srcEntryName);
        TableDefine tarTableDefine = ConvertMetaServiceHelper.loadTableDefine((String)billEntityName, (String)billEntityName);
        TableDefine tarTableDefine1 = ConvertMetaServiceHelper.loadTableDefine((String)billEntityName, (String)tarEntryName);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FSBILLID", srcBill.getLong("id"));
        map.put("FSTABLEID", sourceTableDefine.getTableId());
        map.put("FTBILLID", tarBill.getLong("id"));
        map.put("FTTABLEID", tarTableDefine.getTableId());
        ArApCommonTestHelper.saveSysRelation(map);
        LinkSetElement loadLinkSet = ConvertMetaServiceHelper.loadLinkSet((String)billEntityName);
        MainEntityType targetEntityType = MetadataServiceHelper.getDataEntityType((String)billEntityName);
        String dbRouteKey = targetEntityType.getDBRouteKey();
        DBRoute targetDbRoute = new DBRoute(dbRouteKey);
        map.put("FSBillId", srcBill.getLong("id"));
        map.put("FSTableId", sourceTableDefine1.getTableId());
        map.put("FTBillId", tarBill.getLong("id"));
        map.put("FTTableId", tarTableDefine1.getTableId());
        map.put("FTId", ((DynamicObject)tarBill.getDynamicObjectCollection(tarEntryName).get(0)).getLong("id"));
        map.put("fentryid", ((DynamicObject)tarBill.getDynamicObjectCollection(tarEntryName).get(0)).getLong("id"));
        map.put("FSId", ((DynamicObject)srcBill.getDynamicObjectCollection(srcEntryName).get(0)).getLong("id"));
        String entryLk = null;
        for (LinkSetItemElement item : loadLinkSet.getItems()) {
            if (!tarEntryName.equals(item.getParentEntityKey())) continue;
            entryLk = item.getTableName();
        }
        ArApCommonTestHelper.saveBizRelation(map, loadLinkSet.getTrackerTable(), entryLk, targetDbRoute);
    }

    public static void saveSysRelation(Map<String, Object> map) {
        ArrayList<SqlParameter[]> batchParameters = new ArrayList<SqlParameter[]>(2);
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(":FID", -5, (Object)DBServiceHelper.genGlobalLongId()));
        params.add(new SqlParameter(":FSTABLEID", -5, map.get("FSTABLEID")));
        params.add(new SqlParameter(":FSBILLID", -5, map.get("FSBILLID")));
        params.add(new SqlParameter(":FTTABLEID", -5, map.get("FTTABLEID")));
        params.add(new SqlParameter(":FTBILLID", -5, map.get("FTBILLID")));
        params.add(new SqlParameter(":FCREATETIME", 91, (Object)new Date()));
        batchParameters.add(params.toArray(new SqlParameter[0]));
        String sBuilder = "INSERT INTO T_BOTP_BillTracker (FID, FSTABLEID, FSBILLID, FTTABLEID, FTBILLID, FCREATETIME) VALUES (?, ?, ?, ?, ?, ?)";
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)sBuilder, batchParameters);
    }

    public static void saveBizRelation(Map<String, Object> map, String tc, String lk, DBRoute targetDbRoute) {
        ArrayList<SqlParameter[]> tcBatchParameters = new ArrayList<SqlParameter[]>(64);
        ArrayList<SqlParameter[]> lkBatchParameters = new ArrayList<SqlParameter[]>(64);
        Long id_tc = DBServiceHelper.genGlobalLongId();
        ArrayList<SqlParameter> params_tc = new ArrayList<SqlParameter>(64);
        params_tc.add(new SqlParameter(":FID", -5, (Object)id_tc));
        params_tc.add(new SqlParameter(":FTBillId", -5, map.get("FTBillId")));
        params_tc.add(new SqlParameter(":FTTableId", -5, map.get("FTTableId")));
        params_tc.add(new SqlParameter(":FTId", -5, map.get("FTId")));
        params_tc.add(new SqlParameter(":FSBillId", -5, map.get("FSBillId")));
        params_tc.add(new SqlParameter(":FSTableId", -5, map.get("FSTableId")));
        params_tc.add(new SqlParameter(":FSId", -5, map.get("FSId")));
        tcBatchParameters.add(params_tc.toArray(new SqlParameter[0]));
        Long id_lk = DBServiceHelper.genGlobalLongId();
        ArrayList<SqlParameter> params_lk = new ArrayList<SqlParameter>(64);
        params_lk.add(new SqlParameter(":fentryid", -5, map.get("fentryid")));
        params_lk.add(new SqlParameter(":FPKId", -5, (Object)id_lk));
        params_lk.add(new SqlParameter(":FSeq", 4, (Object)1));
        params_lk.add(new SqlParameter(":FSTableId", -5, map.get("FSTableId")));
        params_lk.add(new SqlParameter(":FSBillId", -5, map.get("FSBillId")));
        params_lk.add(new SqlParameter(":FSId", -5, map.get("FSId")));
        lkBatchParameters.add(params_lk.toArray(new SqlParameter[0]));
        String sBuilder_tc = "INSERT INTO " + tc + " (FID, FTBillId, FTTableId,FTId,FSBillId,FSTableId,FSId) VALUES (?, ?,?,?, ?,?,?)";
        DB.executeBatch((DBRoute)targetDbRoute, (String)sBuilder_tc, tcBatchParameters);
        String sBuilder_lk = "INSERT INTO " + lk + " (fentryid, FPKId, FSeq,FSTableId,FSBillId,FSId) VALUES (?, ?,?,?, ?,?)";
        DB.executeBatch((DBRoute)targetDbRoute, (String)sBuilder_lk, lkBatchParameters);
    }
}

