/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.ArInvoiceBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.ArInvoiceBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import org.apache.commons.lang3.ObjectUtils;

public class ArInvoiceBillTestHelper {
    public static void setAR001(long orgId, boolean AR001) {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        if (AR001) {
            params.put("ar_001", 1);
        } else {
            params.put("ar_001", 0);
        }
        SystemParameterHelper.setSystemParameter(true, orgId, params);
    }

    public static DynamicObject createArInvoice(String billNo, BigDecimal quantity_1, BigDecimal price_1, BigDecimal quantity_2, BigDecimal price_2) {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<ArInvoiceBillDataDetailVO> arInvoiceBillDataDetailVO_list = new ArrayList<ArInvoiceBillDataDetailVO>();
        ArInvoiceBillDataDetailVO arInvoiceBillDataDetailVO_1 = new ArInvoiceBillDataDetailVO();
        arInvoiceBillDataDetailVO_1.setSeq(1);
        arInvoiceBillDataDetailVO_1.setPrice(price_1);
        arInvoiceBillDataDetailVO_1.setQuantity(quantity_1);
        arInvoiceBillDataDetailVO_1.setTaxrateid(2L);
        arInvoiceBillDataDetailVO_1.setE_taxrate(BigDecimal.valueOf(0.09));
        arInvoiceBillDataDetailVO_list.add(arInvoiceBillDataDetailVO_1);
        ArInvoiceBillDataDetailVO arInvoiceBillDataDetailVO_2 = new ArInvoiceBillDataDetailVO();
        arInvoiceBillDataDetailVO_2.setSeq(2);
        arInvoiceBillDataDetailVO_2.setPrice(price_2);
        arInvoiceBillDataDetailVO_2.setQuantity(quantity_2);
        arInvoiceBillDataDetailVO_2.setTaxrateid(2L);
        arInvoiceBillDataDetailVO_2.setE_taxrate(BigDecimal.valueOf(0.09));
        arInvoiceBillDataDetailVO_list.add(arInvoiceBillDataDetailVO_2);
        DynamicObject invBillInfo = ArInvoiceBillTestDataProvider.buildByPriceAndQuantity(billNo, org, arInvoiceBillDataDetailVO_list);
        return invBillInfo;
    }

    public static BigDecimal invoiceEntrySet(DynamicObject entryInfo, String type, BigDecimal temp) {
        BigDecimal amt = BigDecimal.ZERO;
        switch (type) {
            case "price": {
                BigDecimal e_quantity = (BigDecimal)entryInfo.get("e_quantity");
                entryInfo.set("e_amount", (Object)temp.multiply(e_quantity));
                entryInfo.set("e_localamt", (Object)temp.multiply(e_quantity));
                entryInfo.set("e_recamount", (Object)temp.multiply(e_quantity));
                entryInfo.set("e_reclocalamt", (Object)temp.multiply(e_quantity));
                amt = temp.multiply(e_quantity);
                break;
            }
            case "quantity": {
                BigDecimal e_unitprice = (BigDecimal)entryInfo.get("e_unitprice");
                entryInfo.set("e_quantity", (Object)temp);
                entryInfo.set("e_baseunitqty", (Object)temp);
                entryInfo.set("e_amount", (Object)temp.multiply(e_unitprice));
                entryInfo.set("e_localamt", (Object)temp.multiply(e_unitprice));
                entryInfo.set("e_recamount", (Object)temp.multiply(e_unitprice));
                entryInfo.set("e_reclocalamt", (Object)temp.multiply(e_unitprice));
                amt = temp.multiply(e_unitprice);
            }
        }
        return amt;
    }

    public static void deleteBill(String entityName, String ... billnos) {
        ArrayList<String> billNoList = new ArrayList<String>(billnos.length);
        for (int i = 0; i < billnos.length; ++i) {
            billNoList.add(billnos[i]);
        }
        DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter("billno", "in", billNoList)});
    }

    public static DynamicObject pushInvoice(String srcBillEntity, List<Long> srcIds) {
        return ArInvoiceBillTestHelper.pushInvoice(srcBillEntity, srcIds, "C", null, BigDecimal.ONE);
    }

    public static DynamicObject pushInvoice(String srcBillEntity, List<Long> srcIds, BigDecimal exchangeRate) {
        return ArInvoiceBillTestHelper.pushInvoice(srcBillEntity, srcIds, "C", null, exchangeRate);
    }

    public static DynamicObject pushInvoice(String srcBillEntity, List<Long> srcIds, String billStatus, String ruleId, BigDecimal exchangeRate) {
        List<DynamicObject> invoiceBills = BOTPHelper.push(srcBillEntity, "ar_invoice", ruleId, srcIds);
        DynamicObject invoiceBill = invoiceBills.get(0);
        ArInvoiceBillTestHelper.setArInvoice(invoiceBill);
        long invoiceBillId = invoiceBill.getLong("id");
        if (exchangeRate.compareTo(BigDecimal.ONE) != 0) {
            long currencyId = invoiceBill.getLong("currency.id");
            invoiceBill.set("exchangerate", (Object)exchangeRate);
            DynamicObject currency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currencyId)});
            int amtPrecision = currency.getInt("amtprecision");
            DynamicObjectCollection entry = invoiceBill.getDynamicObjectCollection("entry");
            BigDecimal amountBaseSum = BigDecimal.ZERO;
            BigDecimal priceTaxTotalBaseSum = BigDecimal.ZERO;
            for (DynamicObject row : entry) {
                BigDecimal amount = row.getBigDecimal("e_amount");
                BigDecimal priceTaxTotal = row.getBigDecimal("e_recamount");
                BigDecimal discountAmt = row.getBigDecimal("e_discountamount");
                BigDecimal amountBase = amount.multiply(exchangeRate).setScale(amtPrecision, RoundingMode.HALF_UP);
                BigDecimal priceTaxTotalBase = priceTaxTotal.multiply(exchangeRate).setScale(amtPrecision, RoundingMode.HALF_UP);
                BigDecimal discountAmtBase = discountAmt.multiply(exchangeRate).setScale(amtPrecision, RoundingMode.HALF_UP);
                amountBaseSum = amountBaseSum.add(amountBase);
                priceTaxTotalBaseSum = priceTaxTotalBaseSum.add(priceTaxTotalBase);
                row.set("e_localamt", (Object)amountBase);
                row.set("e_reclocalamt", (Object)priceTaxTotalBase);
                row.set("e_discountlocalamt", (Object)discountAmtBase);
            }
            invoiceBill.set("localamt", (Object)amountBaseSum);
            invoiceBill.set("reclocalamt", (Object)priceTaxTotalBaseSum);
        }
        BusBillTestHelper.executeOperation("save", "ar_invoice", new DynamicObject[]{invoiceBill});
        if (ObjectUtils.isEmpty((Object)billStatus) || "C".equals(billStatus)) {
            BusBillTestHelper.executeOperation("submit", "ar_invoice", new Object[]{invoiceBillId});
            BusBillTestHelper.executeOperation("audit", "ar_invoice", new Object[]{invoiceBillId});
        }
        invoiceBill = BusinessDataServiceHelper.loadSingle((Object)invoiceBillId, (String)"ar_invoice");
        return invoiceBill;
    }

    public static List<Long> pushInvoiceAndAudit(String srcBillEntity, List<Long> srcIds, String ruleId) {
        List<DynamicObject> invoiceBills = BOTPHelper.push(srcBillEntity, "ar_invoice", ruleId, srcIds);
        ArrayList<Long> invoiceIds = new ArrayList<Long>(invoiceBills.size());
        for (DynamicObject invoiceBill : invoiceBills) {
            ArInvoiceBillTestHelper.setArInvoice(invoiceBill);
            invoiceIds.add(invoiceBill.getLong("id"));
        }
        BusBillTestHelper.executeOperation("save", "ar_invoice", invoiceBills.toArray(new DynamicObject[0]));
        BusBillTestHelper.executeOperation("submit", "ar_invoice", invoiceIds.toArray());
        BusBillTestHelper.executeOperation("audit", "ar_invoice", invoiceIds.toArray());
        return invoiceIds;
    }

    public static void setArInvoice(DynamicObject invoiceBill) {
        invoiceBill.set("invoicetype", (Object)"ELE");
        invoiceBill.set("sellertin", (Object)"1");
        invoiceBill.set("selleraddr", (Object)"test");
        invoiceBill.set("sellertel", (Object)"17212345678");
        invoiceBill.set("sellerbank", (Object)"bank");
        invoiceBill.set("selleracct", (Object)"110");
        invoiceBill.set("buyertin", (Object)"2");
        invoiceBill.set("buyeraddr", (Object)"test");
        invoiceBill.set("buyertel", (Object)"17287654321");
        invoiceBill.set("buyerbank", (Object)"bank");
        invoiceBill.set("buyeracct", (Object)"120");
        DynamicObject taxClass = BusinessDataServiceHelper.loadSingleFromCache((String)"er_taxclasscode", (QFilter[])new QFilter[]{new QFilter("taxrate", "=", (Object)BigDecimal.ZERO)});
        if (ObjectUtils.isEmpty((Object)taxClass)) {
            taxClass = BusinessDataServiceHelper.loadSingleFromCache((String)"er_taxclasscode", (QFilter[])new QFilter[]{new QFilter("taxrate", "!=", (Object)BigDecimal.ZERO)});
        }
        DynamicObjectCollection entry = invoiceBill.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            if (row.getDynamicObject("e_taxclass") != null) continue;
            row.set("e_taxclass", (Object)taxClass);
        }
    }
}

