/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;

public class CasPayBillTestHelper {
    public static void casPayBillToDelete(DynamicObject[] casPayBills, boolean isPay) {
        Object[] payBillIds = (Long[])Arrays.stream(casPayBills).map(payBill -> payBill.getLong("id")).toArray(Long[]::new);
        OperateOption option = OperateOption.create();
        if (isPay) {
            OperationResult cancelPay = OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])payBillIds, (OperateOption)option);
            OperationHelper.assertResult(cancelPay);
        }
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cas_paybill", (Object[])payBillIds, (OperateOption)option);
        OperationHelper.assertResult(unAudit);
        OperationResult delete = OperationServiceHelper.executeOperate((String)"delete", (String)"cas_paybill", (Object[])payBillIds, (OperateOption)option);
        OperationHelper.assertResult(delete);
    }

    public static void executeReturnMoney(AbstractJUnitTestPlugIn plugIn, long payBillId, long casRecBillId) {
        DynamicObject casRefundAndRenoteBill = BusinessDataServiceHelper.newDynamicObject((String)"cas_refund_renote");
        casRefundAndRenoteBill.set("relebilltype", (Object)"cas_paybill");
        casRefundAndRenoteBill.set("relewithinfo", (Object)false);
        DynamicObjectType casRefundRenoteType = (DynamicObjectType)casRefundAndRenoteBill.getDataEntityType();
        DynamicObjectType revListType = ((DynamicCollectionProperty)casRefundRenoteType.getProperty("revlist")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection revList = casRefundAndRenoteBill.getDynamicObjectCollection("revlist");
        DynamicObject revInfo = new DynamicObject(revListType);
        revInfo.set("revid", (Object)casRecBillId);
        revList.add((Object)revInfo);
        DynamicObjectType releBillListType = ((DynamicCollectionProperty)casRefundRenoteType.getProperty("relebilllist")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection releBillList = casRefundAndRenoteBill.getDynamicObjectCollection("relebilllist");
        QFilter filter = new QFilter("id", "=", (Object)casRecBillId);
        DynamicObjectCollection revBills = QueryServiceHelper.query((String)"cas_recbill", (String)"id,actrecamt", (QFilter[])filter.toArray());
        for (DynamicObject revBill : revBills) {
            DynamicObject releBill = new DynamicObject(releBillListType);
            releBill.set("id", (Object)payBillId);
            releBill.set("currentrefundamt", revBill.get("actrecamt"));
            releBillList.add((Object)releBill);
        }
        casRefundAndRenoteBill.set("relebilllist", (Object)releBillList);
        OperateOption option = OperateOption.create();
        option.setVariableValue("operateKey", "refund");
        OperationResult recResult = OperationServiceHelper.executeOperate((String)"refundrenote", (String)"cas_refund_renote", (DynamicObject[])new DynamicObject[]{casRefundAndRenoteBill}, (OperateOption)option);
        OperationHelper.assertResult(recResult);
    }

    public static void executeChargeback(DynamicObject[] casPayBillArray) {
        long orgId = casPayBillArray[0].getLong("org.id");
        String chargebackStatus = (String)SystemParameterHelper.getCasParam(orgId, "cs110");
        if (chargebackStatus.contains("B")) {
            for (DynamicObject casPayBill : casPayBillArray) {
                casPayBill.set("billstatus", (Object)"B");
            }
        } else if (chargebackStatus.contains("C")) {
            for (DynamicObject casPayBill : casPayBillArray) {
                casPayBill.set("billstatus", (Object)"C");
            }
        }
        SaveServiceHelper.save((DynamicObject[])casPayBillArray);
        OperateOption optionDel = OperateOption.create();
        optionDel.setVariableValue("ishasright", "true");
        OperationResult chargeback = OperationServiceHelper.executeOperate((String)"chargeback", (String)"cas_paybill", (DynamicObject[])casPayBillArray, (OperateOption)optionDel);
        OperationHelper.assertResult(chargeback);
        OperationResult chargeBackWrite = OperationServiceHelper.executeOperate((String)"chargebackwrite", (String)"cas_paybill", (DynamicObject[])casPayBillArray, (OperateOption)optionDel);
        OperationHelper.assertResult(chargeBackWrite);
    }

    public static DynamicObject[] pushPayBill(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String payBillNo) {
        return CasPayBillTestHelper.pushPayBill(deleteAmt, sourceEntity, srcIds, "D", payBillNo, null);
    }

    public static DynamicObject[] pushPayBill(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String payBillNo, BigDecimal exchangeRate) {
        return CasPayBillTestHelper.pushPayBill(deleteAmt, sourceEntity, srcIds, "D", payBillNo, exchangeRate);
    }

    public static DynamicObject[] fullPushPayBill(String sourceEntity, List<Long> srcIds, String payBillNo) {
        return CasPayBillTestHelper.pushPayBill(null, sourceEntity, srcIds, "D", payBillNo, null);
    }

    public static DynamicObject[] fullPushPayBill(String sourceEntity, List<Long> srcIds, String payStatus, String payBillNo) {
        return CasPayBillTestHelper.pushPayBill(null, sourceEntity, srcIds, payStatus, payBillNo, null);
    }

    public static DynamicObject[] fullPushPayBill(String sourceEntity, List<Long> srcIds, String payBillNo, BigDecimal exchangeRate) {
        return CasPayBillTestHelper.pushPayBill(null, sourceEntity, srcIds, "D", payBillNo, exchangeRate);
    }

    public static DynamicObject[] pushPayBill(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String payStatus, String payBillNo, BigDecimal exchangeRate) {
        List<DynamicObject> casPayBills = BOTPHelper.push(sourceEntity, "cas_paybill", srcIds);
        DynamicObject[] casPayBillArray = casPayBills.toArray(new DynamicObject[0]);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"cas_paybill", (DynamicObject[])casPayBillArray, (OperateOption)option);
        OperationHelper.assertResult(saveResult);
        Object[] payBillIds = (Long[])Arrays.stream(casPayBillArray).map(bill -> bill.getLong("id")).toArray(Long[]::new);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cas_paybill");
        casPayBillArray = BusinessDataServiceHelper.load((Object[])payBillIds, (DynamicObjectType)entityType);
        if (exchangeRate != null && BigDecimal.ZERO.compareTo(exchangeRate) != 0) {
            CasPayBillTestHelper.remedyNoSameRateCasPayBillData(casPayBillArray, exchangeRate);
        }
        if (deleteAmt != null && BigDecimal.ZERO.compareTo(deleteAmt) != 0) {
            DynamicObject[] casPayBill = casPayBillArray[0];
            DynamicObjectCollection casPayEntry = casPayBill.getDynamicObjectCollection("entry");
            BigDecimal actPayAmt = BigDecimal.ZERO;
            BigDecimal localAmt = BigDecimal.ZERO;
            int precision = casPayBill.getInt("basecurrency.amtprecision");
            for (int i = casPayEntry.size() - 1; i >= 0; --i) {
                DynamicObject casPayRow = (DynamicObject)casPayEntry.get(i);
                if (deleteAmt.compareTo(casPayRow.getBigDecimal("e_payableamt")) == 0) {
                    casPayEntry.remove(i);
                    continue;
                }
                BigDecimal changeAmt = casPayRow.getBigDecimal("e_payableamt").divide(BigDecimal.valueOf(2L));
                BigDecimal changeLocalAmt = changeAmt.multiply(casPayBill.getBigDecimal("exchangerate")).setScale(precision, RoundingMode.HALF_UP);
                casPayRow.set("e_payableamt", (Object)changeAmt);
                casPayRow.set("e_payablelocamt", (Object)changeLocalAmt);
                casPayRow.set("e_actamt", (Object)changeAmt);
                casPayRow.set("e_localamt", (Object)changeLocalAmt);
                casPayRow.set("e_unlockamt", (Object)changeAmt);
                casPayRow.set("e_unsettledamt", (Object)changeAmt);
                casPayRow.set("e_unsettledlocalamt", (Object)changeLocalAmt);
                actPayAmt = actPayAmt.add(changeAmt);
                localAmt = localAmt.add(casPayRow.getBigDecimal("e_localamt"));
            }
            casPayBill.set("actpayamt", (Object)actPayAmt);
            casPayBill.set("localamt", (Object)localAmt);
        }
        saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"cas_paybill", (DynamicObject[])casPayBillArray, (OperateOption)option);
        OperationHelper.assertResult(saveResult);
        for (DynamicObject payBill : casPayBillArray = BusinessDataServiceHelper.load((Object[])payBillIds, (DynamicObjectType)entityType)) {
            if (payBillNo != null) {
                payBill.set("billno", (Object)payBillNo);
            }
            if ("D".equals(payStatus)) {
                payBill.set("billstatus", (Object)"C");
                continue;
            }
            payBill.set("billstatus", (Object)payStatus);
        }
        SaveServiceHelper.save((DynamicObject[])casPayBillArray);
        if ("D".equals(payStatus)) {
            OperationResult payResult = OperationServiceHelper.executeOperate((String)"pay", (String)"cas_paybill", (Object[])payBillIds, (OperateOption)option);
            OperationHelper.assertResult(payResult);
            KDAssert.assertEquals((String)"\u4ed8\u6b3e\u5355\u786e\u8ba4\u4ed8\u6b3e\u5931\u8d25", (boolean)true, (boolean)payResult.isSuccess());
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            casPayBillArray = BusinessDataServiceHelper.load((Object[])payBillIds, (DynamicObjectType)entityType);
            Arrays.stream(casPayBillArray).forEach(CasPayBillTestChecker::validateCasPayBillJournalData);
        }
        return casPayBillArray;
    }

    protected static DynamicObject[] remedyNoSameRateCasPayBillData(DynamicObject[] casPayBills, BigDecimal exchangeRate) {
        for (DynamicObject casPayBill : casPayBills) {
            casPayBill.set("exchangerate", (Object)exchangeRate);
            BigDecimal localAmt = BigDecimal.ZERO;
            DynamicObjectCollection detailEntry = casPayBill.getDynamicObjectCollection("entry");
            int precision = casPayBill.getInt("basecurrency.amtprecision");
            for (DynamicObject detail : detailEntry) {
                BigDecimal ePayableLocAmt = detail.getBigDecimal("e_payableamt").multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
                detail.set("e_payablelocamt", (Object)ePayableLocAmt);
                BigDecimal eDiscountLocAmt = detail.getBigDecimal("e_discountamt").multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
                detail.set("e_discountlocamt", (Object)eDiscountLocAmt);
                BigDecimal eLocalAmt = detail.getBigDecimal("e_actamt").multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
                detail.set("e_localamt", (Object)eLocalAmt);
                localAmt = localAmt.add(eLocalAmt);
                detail.set("e_unsettledlocalamt", (Object)ePayableLocAmt);
            }
            casPayBill.set("localamt", (Object)localAmt);
            casPayBill.set("dplocalamt", (Object)localAmt);
        }
        return casPayBills;
    }

    public static void setPayEntryAmt(DynamicObject entryIfno, BigDecimal payAmt) {
        entryIfno.set("e_payableamt", (Object)payAmt);
        entryIfno.set("e_payablelocamt", (Object)payAmt);
        entryIfno.set("e_actamt", (Object)payAmt);
        entryIfno.set("e_localamt", (Object)payAmt);
        entryIfno.set("e_unlockamt", (Object)payAmt);
        entryIfno.set("e_unsettledamt", (Object)payAmt);
        entryIfno.set("e_unsettledlocalamt", (Object)payAmt);
    }
}

