/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.helper.InvokeTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SimulatorTestHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinArBillTestHelper {
    private static final String ENTRY = "entry";
    private static final String PLAN = "planentity";

    public static DynamicObject setEntryAmount(DynamicObject finArBill, BigDecimal[] entryAmtArray) {
        DynamicObjectCollection entryCollection = finArBill.getDynamicObjectCollection(ENTRY);
        BigDecimal exchangeRate = finArBill.getBigDecimal("exchangerate");
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal totalLocalAmount = BigDecimal.ZERO;
        BigDecimal totalRecAmount = BigDecimal.ZERO;
        BigDecimal totalRecLocalAmount = BigDecimal.ZERO;
        int precision = finArBill.getDynamicObject("currency").getInt("amtprecision");
        for (int i = 0; i < entryCollection.size(); ++i) {
            DynamicObject entryRow = (DynamicObject)entryCollection.get(i);
            BigDecimal tax = entryAmtArray[i].multiply(entryRow.getBigDecimal("e_taxrate").setScale(precision, RoundingMode.HALF_UP));
            BigDecimal localAmount = entryAmtArray[i].multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
            BigDecimal recAmount = entryAmtArray[i].add(tax).setScale(precision, RoundingMode.HALF_UP);
            BigDecimal recLocalAmount = entryAmtArray[i].multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
            entryRow.set("e_amount", (Object)entryAmtArray[i]);
            entryRow.set("e_localamt", (Object)localAmount);
            entryRow.set("e_tax", (Object)tax);
            entryRow.set("e_recamount", (Object)recAmount);
            entryRow.set("e_reclocalamt", (Object)recLocalAmount);
            entryRow.set("e_unlockamt", (Object)recAmount);
            entryRow.set("e_unsettleamt", (Object)recLocalAmount);
            entryRow.set("e_unsettlelocalamt", (Object)recAmount);
            entryRow.set("e_unverifyamt", (Object)recLocalAmount);
            entryRow.set("e_uninvoicedamt", (Object)recAmount);
            entryRow.set("e_unconfirmamt", (Object)recAmount);
            totalAmt = totalAmt.add(entryAmtArray[i]);
            totalRecAmount = totalRecAmount.add(recAmount);
            totalRecLocalAmount = totalRecLocalAmount.add(recLocalAmount);
            totalLocalAmount = totalLocalAmount.add(localAmount);
        }
        DynamicObjectCollection planEntryCollection = finArBill.getDynamicObjectCollection(PLAN);
        BigDecimal planRecAmount = BigDecimal.ZERO;
        BigDecimal planRecLocalAmount = BigDecimal.ZERO;
        if (!planEntryCollection.isEmpty()) {
            planRecAmount = totalRecAmount.divide(BigDecimal.valueOf(planEntryCollection.size()), 2, RoundingMode.HALF_UP);
            planRecLocalAmount = totalRecLocalAmount.divide(BigDecimal.valueOf(planEntryCollection.size()), 2, RoundingMode.HALF_UP);
        }
        for (DynamicObject planEntryRow : planEntryCollection) {
            planEntryRow.set("planpricetax", (Object)planRecAmount);
            planEntryRow.set("planpricetaxloc", (Object)planRecLocalAmount);
            planEntryRow.set("unplanlockamt", (Object)planRecAmount);
            planEntryRow.set("unplansettleamt", (Object)planRecAmount);
            planEntryRow.set("unplansettlelocamt", (Object)planRecLocalAmount);
        }
        finArBill.set("amount", (Object)totalAmt);
        finArBill.set("localamt", (Object)totalLocalAmount);
        finArBill.set("recamount", (Object)totalRecAmount);
        finArBill.set("reclocalamt", (Object)totalRecLocalAmount);
        finArBill.set("unsettleamount", (Object)totalRecAmount);
        finArBill.set("unsettlelocalamt", (Object)totalRecLocalAmount);
        finArBill.set("unverifyamount", (Object)totalRecAmount);
        finArBill.set("uninvoicedamt", (Object)totalRecAmount);
        finArBill.set("quotation", (Object)0);
        return finArBill;
    }

    public static void checkFinJournal(long finBillId) {
        DynamicObject journal = BusinessDataServiceHelper.loadSingle((String)"ar_journal", (String)"id,asstacttype,asstact,currency,basecurrency,billno,receivableamt,localreceivableamt", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)finBillId), new QFilter("sourcebilltype", "=", (Object)"ar_finarbill")});
        KDAssert.assertTrue((String)"\u8d22\u52a1\u5355\u6d41\u6c34\u4e0d\u5b58\u5728", (boolean)EmptyUtils.isNotEmpty(journal));
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ar_finarbill");
        FinArBillTestHelper.assertEquals("\u8d22\u52a1\u5355\u4e0e\u6d41\u6c34\u5f80\u6765\u7c7b\u578b\u4e0d\u4e00\u81f4", journal.getString("asstacttype"), finBill.getString("asstacttype"));
        FinArBillTestHelper.assertEquals("\u8d22\u52a1\u5355\u4e0e\u6d41\u6c34\u5f80\u6765\u6237\u4e0d\u4e00\u81f4", journal.getLong("asstact.masterid"), finBill.getLong("asstact.masterid"));
        FinArBillTestHelper.assertEquals("\u8d22\u52a1\u5355\u4e0e\u6d41\u6c34\u5e01\u522b\u4e0d\u4e00\u81f4", journal.getLong("currency.id"), finBill.getLong("currency.id"));
        FinArBillTestHelper.assertEquals("\u8d22\u52a1\u5355\u4e0e\u6d41\u6c34\u672c\u4f4d\u5e01\u4e0d\u4e00\u81f4", journal.getLong("basecurrency.id"), finBill.getLong("basecurrency.id"));
        FinArBillTestHelper.assertEquals("\u8d22\u52a1\u5355\u4e0e\u6d41\u6c34\u7f16\u53f7\u4e0d\u4e00\u81f4", journal.getString("billno"), finBill.getString("billno"));
        FinArBillTestHelper.assertEquals("\u8d22\u52a1\u5355\u4e0e\u6d41\u6c34\u5e94\u6536\u91d1\u989d\u4e0d\u4e00\u81f4", 0, journal.getBigDecimal("receivableamt").compareTo(finBill.getBigDecimal("recamount")));
        FinArBillTestHelper.assertEquals("\u8d22\u52a1\u5355\u4e0e\u6d41\u6c34\u5e94\u6536\u91d1\u989d\u6298\u672c\u5e01\u4e0d\u4e00\u81f4", 0, journal.getBigDecimal("localreceivableamt").compareTo(finBill.getBigDecimal("reclocalamt")));
    }

    public static void checkJournalExists(long finBillId, boolean expected) {
        boolean result = QueryServiceHelper.exists((String)"ar_journal", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)finBillId), new QFilter("sourcebilltype", "=", (Object)"ar_finarbill")});
        if (expected) {
            KDAssert.assertTrue((String)"\u6d41\u6c34\u662f\u5426\u5b58\u5728\u6821\u9a8c\u5f02\u5e38", (boolean)result);
        } else {
            KDAssert.assertFalse((String)"\u6d41\u6c34\u662f\u5426\u5b58\u5728\u6821\u9a8c\u5f02\u5e38", (boolean)result);
        }
    }

    private static void assertEquals(String message, Object expected, Object actual) {
        KDAssert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public static DynamicObject createFinArBill(String billNo, BigDecimal quantity_1, BigDecimal price_1, BigDecimal quantity_2, BigDecimal price_2, boolean isDetailSettle, boolean isLocal) {
        ArrayList<FinArBillDataDetailVO> finArBillDataDetailV0List = new ArrayList<FinArBillDataDetailVO>();
        FinArBillDataDetailVO finArBillDataDetailVO_1 = new FinArBillDataDetailVO();
        finArBillDataDetailVO_1.setSeq(1);
        finArBillDataDetailVO_1.setPrice(price_1);
        finArBillDataDetailVO_1.setQuantity(quantity_1);
        finArBillDataDetailV0List.add(finArBillDataDetailVO_1);
        FinArBillDataDetailVO finArBillDataDetailVO_2 = new FinArBillDataDetailVO();
        finArBillDataDetailVO_2.setSeq(2);
        finArBillDataDetailVO_2.setPrice(price_2);
        finArBillDataDetailVO_2.setQuantity(quantity_2);
        finArBillDataDetailV0List.add(finArBillDataDetailVO_2);
        return FinArBillTestDataProvider.buildByPriceAndQtySpecific(billNo, finArBillDataDetailV0List, isDetailSettle, isLocal);
    }

    public static DynamicObject getCustomer() {
        QFilter filter = new QFilter("ctrlstrategy", "=", (Object)"5");
        DynamicObject selectOne = QueryServiceHelper.queryOne((String)"bd_customer", (String)"id", (QFilter[])new QFilter[]{filter});
        if (selectOne == null) {
            throw new KDBizException("\u57fa\u7840\u8d44\u6599-\u5ba2\u6237\u4e0d\u5b58\u5728");
        }
        return BusinessDataServiceHelper.loadSingle((Object)selectOne.getLong("id"), (String)"bd_customer");
    }

    public static DynamicObject getCustomerSupplier() {
        QFilter filter = new QFilter("ctrlstrategy", "=", (Object)"5");
        filter.and(new QFilter("internal_company", "!=", (Object)0));
        DynamicObject selectOne = QueryServiceHelper.queryOne((String)"bd_customer", (String)"id", (QFilter[])new QFilter[]{filter});
        if (selectOne == null) {
            throw new KDBizException("\u57fa\u7840\u8d44\u6599-\u5ba2\u6237\u4e0d\u5b58\u5728");
        }
        return BusinessDataServiceHelper.loadSingle((Object)selectOne.getLong("id"), (String)"bd_customer");
    }

    public static void setPayBillEntry(DynamicObject entryInfo, BigDecimal payableAmt, BigDecimal exchangerate) {
        entryInfo.set("e_payableamt", (Object)payableAmt);
        entryInfo.set("e_payablelocamt", (Object)payableAmt.multiply(exchangerate));
        entryInfo.set("e_actamt", (Object)payableAmt);
        entryInfo.set("e_localamt", (Object)payableAmt.multiply(exchangerate));
        entryInfo.set("e_lockamt", (Object)payableAmt);
        entryInfo.set("e_unsettledamt", (Object)payableAmt);
        entryInfo.set("e_unsettledlocalamt", (Object)payableAmt.multiply(exchangerate));
    }

    public static void buildLocalAmt(DynamicObject billInfo, BigDecimal exchangerate) {
        billInfo.set("localamt", (Object)BigDecimal.valueOf(900L).multiply(exchangerate));
        DynamicObjectCollection entryCol = billInfo.getDynamicObjectCollection(ENTRY);
        for (DynamicObject entryInfo : entryCol) {
            BigDecimal e_payableamt = entryInfo.getBigDecimal("e_payableamt");
            entryInfo.set("e_payablelocamt", (Object)e_payableamt.multiply(exchangerate));
            entryInfo.set("e_localamt", (Object)e_payableamt.multiply(exchangerate));
            entryInfo.set("e_unsettledlocalamt", (Object)e_payableamt.multiply(exchangerate));
        }
    }

    public static void setFinArDetailEntry(DynamicObject entryInfo, BigDecimal qty) {
        BigDecimal price = entryInfo.getBigDecimal("e_unitprice");
        BigDecimal taxRate = entryInfo.getBigDecimal("e_taxrate") != null ? entryInfo.getBigDecimal("e_taxrate") : BigDecimal.ZERO;
        BigDecimal amount = price.multiply(qty);
        BigDecimal taxAmount = amount.multiply(taxRate.divide(BigDecimal.valueOf(100L), 2));
        BigDecimal recAmt = amount.add(taxAmount);
        entryInfo.set("e_quantity", (Object)qty);
        entryInfo.set("e_baseunitqty", (Object)qty);
        entryInfo.set("e_uninvoicedqty", (Object)qty);
        entryInfo.set("e_unconfirmqty", (Object)qty);
        entryInfo.set("e_recamount", (Object)recAmt);
        entryInfo.set("e_reclocalamt", (Object)recAmt);
        entryInfo.set("e_amount", (Object)amount);
        entryInfo.set("e_tax", (Object)taxAmount);
        entryInfo.set("e_localamt", (Object)amount);
        entryInfo.set("e_unlockamt", (Object)recAmt);
        entryInfo.set("e_unsettleamt", (Object)recAmt);
        entryInfo.set("e_unverifyqty", (Object)qty);
        entryInfo.set("e_unverifyamt", (Object)amount);
        entryInfo.set("e_unsettlelocalamt", (Object)recAmt);
        entryInfo.set("e_unconfirmamt", (Object)amount);
        entryInfo.set("e_uninvoicedamt", (Object)recAmt);
    }

    public static void recHeadAmt(DynamicObject billInfo) {
        BigDecimal amountSum = BigDecimal.ZERO;
        BigDecimal localAmtSum = BigDecimal.ZERO;
        BigDecimal taxSum = BigDecimal.ZERO;
        BigDecimal recamountSum = BigDecimal.ZERO;
        BigDecimal recLocalamtSum = BigDecimal.ZERO;
        BigDecimal unlockamountSum = BigDecimal.ZERO;
        BigDecimal unsettleamountSum = BigDecimal.ZERO;
        BigDecimal unsettlelocalamtSum = BigDecimal.ZERO;
        BigDecimal uninvoicedamtSum = BigDecimal.ZERO;
        BigDecimal unverifyamount = BigDecimal.ZERO;
        DynamicObjectCollection entryCol = billInfo.getDynamicObjectCollection(ENTRY);
        for (DynamicObject entryInfo : entryCol) {
            amountSum = amountSum.add(entryInfo.getBigDecimal("e_amount"));
            localAmtSum = localAmtSum.add(entryInfo.getBigDecimal("e_localamt"));
            taxSum = taxSum.add(entryInfo.getBigDecimal("e_tax"));
            recamountSum = recamountSum.add(entryInfo.getBigDecimal("e_recamount"));
            recLocalamtSum = recLocalamtSum.add(entryInfo.getBigDecimal("e_reclocalamt"));
            unsettleamountSum = unsettleamountSum.add(entryInfo.getBigDecimal("e_unsettleamt"));
            unsettlelocalamtSum = unsettlelocalamtSum.add(entryInfo.getBigDecimal("e_unsettlelocalamt"));
            uninvoicedamtSum = uninvoicedamtSum.add(entryInfo.getBigDecimal("e_uninvoicedamt"));
            unlockamountSum = unlockamountSum.add(entryInfo.getBigDecimal("e_unlockamt"));
            unverifyamount = unverifyamount.add(entryInfo.getBigDecimal("e_unverifyamt"));
        }
        billInfo.set("amount", (Object)amountSum);
        billInfo.set("localamt", (Object)localAmtSum);
        billInfo.set("tax", (Object)taxSum);
        billInfo.set("recamount", (Object)recamountSum);
        billInfo.set("reclocalamt", (Object)recLocalamtSum);
        billInfo.set("unsettleamount", (Object)unsettleamountSum);
        billInfo.set("unsettlelocalamt", (Object)unsettlelocalamtSum);
        billInfo.set("uninvoicedamt", (Object)uninvoicedamtSum);
        billInfo.set("unverifyamount", (Object)unverifyamount);
        DynamicObjectCollection planentityCol = billInfo.getDynamicObjectCollection(PLAN);
        DynamicObject planentityInfo = (DynamicObject)planentityCol.get(0);
        planentityInfo.set("planpricetax", (Object)recamountSum);
        planentityInfo.set("planpricetaxloc", (Object)recLocalamtSum);
        planentityInfo.set("unplanlockamt", (Object)unlockamountSum);
        planentityInfo.set("unplansettleamt", (Object)unsettleamountSum);
        planentityInfo.set("unplansettlelocamt", (Object)unsettlelocalamtSum);
    }

    public static DynamicObject getMaterial() {
        QFilter filter = new QFilter("configproperties", "!=", (Object)"2");
        filter.and(new QFilter("ctrlstrategy", "=", (Object)"5"));
        DynamicObject selectOne = QueryServiceHelper.queryOne((String)"bd_material", (String)"id", (QFilter[])new QFilter[]{filter});
        if (selectOne == null) {
            throw new KDBizException("\u57fa\u7840\u8d44\u6599-\u7269\u6599\u4e0d\u5b58\u5728");
        }
        return BusinessDataServiceHelper.loadSingle((Object)selectOne.getLong("id"), (String)"bd_material");
    }

    public static void deleteBill(String entityName, String ... billnos) {
        DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billnos)});
    }

    public static void setAR005(Long orgId, boolean AR005) {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        if (AR005) {
            params.put("ar_005", 1);
        } else {
            params.put("ar_005", 0);
        }
        SystemParameterHelper.setSystemParameter(true, orgId, params);
    }

    public static void setAR003(Long orgId, boolean isMaterialSettle) {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        String settleParam = isMaterialSettle ? "1" : "2";
        params.put("ar_003", settleParam);
        SystemParameterHelper.setSystemParameter(true, orgId, params);
    }

    public static DynamicObject[] pushFinArBill(String sourceEntity, List<Long> srcIds, String billStatus, String billNo, BigDecimal exchangeRate) {
        return FinArBillTestHelper.pushFinArBill(BigDecimal.valueOf(999999L), sourceEntity, srcIds, billStatus, billNo, exchangeRate);
    }

    public static DynamicObject[] pushFinArBill(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String billNo) {
        return FinArBillTestHelper.pushFinArBill(deleteAmt, sourceEntity, srcIds, "C", billNo, null);
    }

    public static DynamicObject[] fullPushFinArBill(String sourceEntity, List<Long> srcIds, String billStatus, String billNo) {
        return FinArBillTestHelper.pushFinArBill(null, sourceEntity, srcIds, billStatus, billNo, null);
    }

    public static DynamicObject[] fullPushFinArBill(String sourceEntity, List<Long> srcIds, String billNo) {
        return FinArBillTestHelper.pushFinArBill(null, sourceEntity, srcIds, "C", billNo, null);
    }

    public static DynamicObject[] fullPushFinArBill(String sourceEntity, List<Long> srcIds, String billNo, BigDecimal exchangeRate) {
        return FinArBillTestHelper.pushFinArBill(null, sourceEntity, srcIds, "C", billNo, exchangeRate);
    }

    public static Long[] pushFinArBillIds(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String billStatus, String billNo, BigDecimal exchangeRate) {
        List<DynamicObject> finArBills = BOTPHelper.push(sourceEntity, "ar_finarbill", srcIds);
        DynamicObject[] finArBillArray = finArBills.toArray(new DynamicObject[0]);
        if (exchangeRate != null && exchangeRate.compareTo(BigDecimal.ZERO) != 0) {
            FinArBillTestHelper.remedyNoSameRateFinArData(finArBillArray, exchangeRate);
        }
        if (deleteAmt != null && BigDecimal.ZERO.compareTo(deleteAmt) != 0) {
            for (DynamicObject finArBill : finArBillArray) {
                DynamicObjectCollection entry = finArBill.getDynamicObjectCollection(ENTRY);
                BigDecimal[] qtys = new BigDecimal[entry.size()];
                for (int i = 0; i < entry.size(); ++i) {
                    DynamicObject detail = (DynamicObject)entry.get(i);
                    qtys[i] = detail.getBigDecimal("e_quantity").divide(BigDecimal.valueOf(2L));
                    if (deleteAmt.compareTo(detail.getBigDecimal("e_recamount")) != 0) continue;
                    qtys[i] = BigDecimal.ZERO;
                }
                FinArBillTestHelper.finArModifyQty(finArBill, qtys);
            }
        }
        FinArBillTestHelper.fillValueInFinArBill(finArBillArray);
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])finArBillArray, (OperateOption)option);
        Object[] FinArIds = (Long[])Arrays.stream(finArBillArray).map(bill -> bill.getLong("id")).toArray(Long[]::new);
        OperationResult submit = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_finarbill", (Object[])FinArIds, (OperateOption)option);
        OperationHelper.assertResult(submit);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ar_finarbill");
        if (billNo != null) {
            finArBillArray = BusinessDataServiceHelper.load((Object[])FinArIds, (DynamicObjectType)entityType);
            finArBillArray[0].set("billno", (Object)billNo);
            SaveServiceHelper.save((DynamicObject[])finArBillArray);
        }
        if ("C".equals(billStatus)) {
            OperationResult audit = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])FinArIds, (OperateOption)option);
            OperationHelper.assertResult(audit);
        }
        return FinArIds;
    }

    public static DynamicObject[] pushFinArBill(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String billStatus, String billNo, BigDecimal exchangeRate) {
        Object[] FinArIds = FinArBillTestHelper.pushFinArBillIds(deleteAmt, sourceEntity, srcIds, billStatus, billNo, exchangeRate);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ar_finarbill");
        return BusinessDataServiceHelper.load((Object[])FinArIds, (DynamicObjectType)entityType);
    }

    private static void fillValueInFinArBill(DynamicObject[] finArBillArray) {
        for (DynamicObject finArBill : finArBillArray) {
            finArBill.set("payproperty", (Object)BaseDataTestProvider.getRecProperty());
            finArBill.set("quotation", (Object)"0");
            DynamicObjectCollection entry = finArBill.getDynamicObjectCollection(ENTRY);
            entry.forEach(detail -> detail.set("e_expenseitem", (Object)BaseDataTestProvider.getExpenseItem()));
        }
    }

    public static void finArModifyQty(DynamicObject finArBill, BigDecimal[] qtys) {
        DynamicObjectCollection entry = finArBill.getDynamicObjectCollection(ENTRY);
        BigDecimal exchangeRate = finArBill.getBigDecimal("exchangerate");
        BigDecimal amountSum = BigDecimal.ZERO;
        BigDecimal priceTaxTotalSum = BigDecimal.ZERO;
        BigDecimal amountBaseSum = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBaseSum = BigDecimal.ZERO;
        BigDecimal taxSum = BigDecimal.ZERO;
        int index = 0;
        Iterator iterator = entry.iterator();
        while (iterator.hasNext()) {
            DynamicObject row = (DynamicObject)iterator.next();
            BigDecimal qty = qtys[index];
            if (qty.compareTo(BigDecimal.ZERO) == 0) {
                iterator.remove();
            }
            BigDecimal actUnitPrice = row.getBigDecimal("e_actunitprice");
            BigDecimal accTaxUnitPrice = row.getBigDecimal("e_acttaxunitprice");
            BigDecimal amount = qty.multiply(actUnitPrice);
            BigDecimal amountBase = qty.multiply(actUnitPrice).multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
            BigDecimal priceTaxTotal = qty.multiply(accTaxUnitPrice);
            BigDecimal priceTaxTotalBase = qty.multiply(accTaxUnitPrice).multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
            amountSum = amountSum.add(amount);
            amountBaseSum = amountBaseSum.add(amountBase);
            priceTaxTotalSum = priceTaxTotalSum.add(priceTaxTotal);
            priceTaxTotalBaseSum = priceTaxTotalBaseSum.add(priceTaxTotalBase);
            row.set("e_quantity", (Object)qty);
            row.set("e_baseunitqty", (Object)qty);
            row.set("e_amount", (Object)amount);
            row.set("e_localamt", (Object)amountBase);
            row.set("e_recamount", (Object)priceTaxTotal);
            row.set("e_reclocalamt", (Object)priceTaxTotalBase);
            row.set("e_unverifyqty", (Object)qty);
            row.set("e_unverifyamt", (Object)amount);
            row.set("e_unlockamt", (Object)priceTaxTotal);
            row.set("e_unsettleamt", (Object)priceTaxTotal);
            row.set("e_unsettlelocalamt", (Object)priceTaxTotalBase);
            row.set("e_uninvoicedqty", (Object)qty);
            row.set("e_uninvoicedamt", (Object)priceTaxTotal);
            row.set("e_unconfirmqty", (Object)qty);
            row.set("e_unconfirmamt", (Object)priceTaxTotal);
            BigDecimal taxRate = row.getBigDecimal("e_taxrate");
            BigDecimal tax = priceTaxTotal.multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
            row.set("e_tax", (Object)tax);
            taxSum = taxSum.add(tax);
            ++index;
        }
        finArBill.set("amount", (Object)amountSum);
        finArBill.set("localamt", (Object)amountBaseSum);
        finArBill.set("tax", (Object)taxSum);
        finArBill.set("recamount", (Object)priceTaxTotalSum);
        finArBill.set("reclocalamt", (Object)priceTaxTotalBaseSum);
        finArBill.set("unsettleamount", (Object)priceTaxTotalSum);
        finArBill.set("unsettlelocalamt", (Object)priceTaxTotalBaseSum);
        finArBill.set("unverifyamount", (Object)amountSum);
        finArBill.set("uninvoicedamt", (Object)priceTaxTotalSum);
        DynamicObjectCollection planEntity = finArBill.getDynamicObjectCollection(PLAN);
        int planIndex = 0;
        Iterator planIterator = planEntity.iterator();
        while (planIterator.hasNext()) {
            DynamicObject planRow = (DynamicObject)planIterator.next();
            if (planIndex == 0) {
                planRow.set("planpricetax", (Object)priceTaxTotalSum);
                planRow.set("planpricetaxloc", (Object)priceTaxTotalBaseSum);
                planRow.set("unplanlockamt", (Object)priceTaxTotalSum);
                planRow.set("unplansettleamt", (Object)priceTaxTotalSum);
                planRow.set("unplansettlelocamt", (Object)priceTaxTotalBaseSum);
            } else {
                planIterator.remove();
            }
            ++planIndex;
        }
    }

    public static void remedyNoSameRateFinArData(DynamicObject[] finBills, BigDecimal exchangeRate) {
        for (DynamicObject finBill : finBills) {
            finBill.set("exchangerate", (Object)exchangeRate);
            BigDecimal amountbase = BigDecimal.ZERO;
            BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
            DynamicObjectCollection entry = finBill.getDynamicObjectCollection(ENTRY);
            for (DynamicObject detail : entry) {
                BigDecimal eAmountBase = detail.getBigDecimal("e_amount").multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
                BigDecimal ePriceTaxTotalBase = detail.getBigDecimal("e_recamount").multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
                detail.set("e_localamt", (Object)eAmountBase);
                detail.set("e_reclocalamt", (Object)ePriceTaxTotalBase);
                detail.set("e_unsettlelocalamt", (Object)ePriceTaxTotalBase);
                amountbase = amountbase.add(eAmountBase);
                pricetaxtotalbase = pricetaxtotalbase.add(ePriceTaxTotalBase);
            }
            DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection(PLAN);
            ((DynamicObject)planEntity.get(0)).set("planpricetaxloc", (Object)pricetaxtotalbase);
            ((DynamicObject)planEntity.get(0)).set("unplansettlelocamt", (Object)pricetaxtotalbase);
            finBill.set("localamt", (Object)amountbase);
            finBill.set("recamount", (Object)pricetaxtotalbase);
            finBill.set("unsettlelocalamt", (Object)pricetaxtotalbase);
        }
    }

    public static DynamicObject executeAndGetWriteOffBill(long finArBillId) {
        FinArBillTestHelper.executeWriteOff(finArBillId);
        return BusinessDataServiceHelper.loadSingle((Object)FinArBillTestHelper.getWriteOffBillId(finArBillId), (String)"ar_finarbill");
    }

    public static void executeWriteOff(long finArBillId) {
        List<DynamicObject> writeOffBills = BOTPHelper.push("ar_finarbill", "ar_finarbill", "516550166468103168", Collections.singletonList(finArBillId));
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("mutex_writeback", "false");
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])writeOffBills.toArray(new DynamicObject[0]), (OperateOption)operateOption);
        OperationHelper.assertResult(result);
    }

    public static long getWriteOffBillId(long srcBillId) {
        QFilter filter = new QFilter("sourcebillid", "=", (Object)String.valueOf(srcBillId));
        filter.and("iswrittenoff", "=", (Object)Boolean.TRUE);
        DynamicObject writeOff = QueryServiceHelper.queryOne((String)"ar_finarbill", (String)"id", (QFilter[])new QFilter[]{filter});
        KDAssert.assertEquals((String)"\u672a\u751f\u6210\u51b2\u9500\u5355", (boolean)false, (writeOff == null ? 1 : 0) != 0);
        return writeOff.getLong("id");
    }

    public static void searchOneRowDataByBillNo(AbstractJUnitTestPlugIn junit, String currentBillNo) {
        SimulatorTestHelper util = new SimulatorTestHelper(junit);
        InvokeTestHelper.invokeAction("[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[{\"FieldName\":[\"billno\",\"payproperty.name\"],\"Value\":[\"" + currentBillNo + "\"]}],[{\"FieldName\":[\"org.id\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"bizdate\"],\"Value\":[\"63\"],\"Compare\":[\"63\"]},{\"FieldName\":[\"billstatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"settlestatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"bookdate\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"isvoucher\"],\"Value\":[\"\"],\"Compare\":[\"\"]}],\"entry\"],\"postData\":[{},[]]}]", junit);
        util.selectAllRows();
    }

    public static long getPremiumBillId(long srcBillId) {
        QFilter filter = new QFilter("sourcebillid", "=", (Object)String.valueOf(srcBillId));
        filter.and("ispremium", "=", (Object)Boolean.TRUE);
        DynamicObject premiumBill = QueryServiceHelper.queryOne((String)"ar_finarbill", (String)"id", (QFilter[])new QFilter[]{filter});
        KDAssert.assertEquals((String)"\u672a\u751f\u6210\u8d28\u4fdd\u91d1\u5355", (boolean)false, (premiumBill == null ? 1 : 0) != 0);
        return premiumBill.getLong("id");
    }
}

