/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.PurInBillDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.PurInBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.PurInBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;

public class PurInBillTestHelper {
    public static DynamicObject[] pushPruInBill(String sourceEntity, List<Long> srcIds, String billNo, Boolean isPart) {
        return PurInBillTestHelper.pushPruInBill(sourceEntity, srcIds, billNo, isPart, "C");
    }

    public static DynamicObject[] fullPushPruInBill(String sourceEntity, List<Long> srcIds, String billNo) {
        return PurInBillTestHelper.pushPruInBill(sourceEntity, srcIds, billNo, null);
    }

    public static DynamicObject[] pushPruInBill(String sourceEntity, List<Long> srcIds, String billNo, Boolean isPart, String billStatus) {
        List<DynamicObject> purInBills = BOTPHelper.push(sourceEntity, "im_purinbill", srcIds);
        DynamicObject[] purBillArray = purInBills.toArray(new DynamicObject[0]);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"im_purinbill");
        for (DynamicObject purBill2 : purBillArray) {
            DynamicObjectCollection billEntry = purBill2.getDynamicObjectCollection("billentry");
            for (DynamicObject row : billEntry) {
                if (!Boolean.TRUE.equals(isPart)) continue;
                row.set("qty", (Object)row.getBigDecimal("qty").divide(BigDecimal.valueOf(2L)));
                row.set("baseQty", (Object)row.getBigDecimal("baseqty").divide(BigDecimal.valueOf(2L)));
                row.set("amount", (Object)row.getBigDecimal("amount").divide(BigDecimal.valueOf(2L)));
                row.set("curamount", (Object)row.getBigDecimal("curamount").divide(BigDecimal.valueOf(2L)));
                row.set("amountandtax", (Object)row.getBigDecimal("amountandtax").divide(BigDecimal.valueOf(2L)));
                row.set("curamountandtax", (Object)row.getBigDecimal("curamountandtax").divide(BigDecimal.valueOf(2L)));
            }
        }
        OperateOption option = OperateOption.create();
        OperationResult save = OperationServiceHelper.executeOperate((String)"save", (String)"im_purinbill", (DynamicObject[])purBillArray, (OperateOption)option);
        OperationHelper.assertResult(save);
        Object[] purBillIds = (Long[])Arrays.stream(purBillArray).map(purIn -> purIn.getLong("id")).toArray(Long[]::new);
        DynamicObject[] purBills = BusinessDataServiceHelper.load((Object[])purBillIds, (DynamicObjectType)entityType);
        if (billStatus != null) {
            purBills[0].set("billno", (Object)billNo);
        }
        if ("C".equals(billStatus)) {
            Arrays.stream(purBills).forEach(purBill -> purBill.set("billstatus", (Object)"B"));
            SaveServiceHelper.save((DynamicObject[])purBills);
            OperationResult audit = OperationServiceHelper.executeOperate((String)"audit", (String)"im_purinbill", (Object[])purBillIds, (OperateOption)option);
            OperationHelper.assertResult(audit);
            return BusinessDataServiceHelper.load((Object[])purBillIds, (DynamicObjectType)entityType);
        }
        Arrays.stream(purBills).forEach(purBill -> purBill.set("billstatus", (Object)billStatus));
        SaveServiceHelper.save((DynamicObject[])purBills);
        return purBills;
    }

    public static DynamicObject getAuditStatusPurinBill(BigDecimal[] qtys, BigDecimal[] prices, PurInBillDataVO billInfo) {
        ArrayList<PurInBillDataDetailVO> entryInfoList = new ArrayList<PurInBillDataDetailVO>(qtys.length);
        for (int i = 0; i < qtys.length; ++i) {
            PurInBillDataDetailVO purinDetailVO = new PurInBillDataDetailVO();
            purinDetailVO.setQuantity(qtys[i]);
            purinDetailVO.setPrice(prices[i]);
            entryInfoList.add(purinDetailVO);
        }
        DynamicObject purinBill = PurInBillDataTestProvider.buildByEntryPriceAndQty(billInfo, entryInfoList);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{purinBill});
        purinBill = BusinessDataServiceHelper.loadSingle((Object)purinBill.getPkValue(), (String)"im_purinbill");
        BusBillTestHelper.executeOperation("submit", "im_purinbill", new DynamicObject[]{purinBill});
        BusBillTestHelper.executeOperation("audit", "im_purinbill", new DynamicObject[]{purinBill});
        return purinBill;
    }

    public static DynamicObject purInBillPushBusApBill(List<Long> purinBills) {
        List<DynamicObject> busApBills = BOTPHelper.push("im_purinbill", "ap_busbill", "727233134134847488", purinBills);
        DynamicObject busApBill = busApBills.get(0);
        BusBillTestHelper.executeOperation("save", "ap_busbill", new DynamicObject[]{busApBill});
        busApBill = BusinessDataServiceHelper.loadSingle((Object)busApBill.getLong("id"), (String)"ap_busbill");
        busApBill.set("payproperty", (Object)BaseDataTestProvider.getPayProperty());
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{busApBill});
        BusBillTestHelper.executeOperation("submit", "ap_busbill", new Object[]{busApBill.getLong("id")});
        BusBillTestHelper.executeOperation("audit", "ap_busbill", new Object[]{busApBill.getLong("id")});
        busApBill = BusinessDataServiceHelper.loadSingle((Object)busApBill.getLong("id"), (String)"ap_busbill");
        return busApBill;
    }

    public static DynamicObject purInBillPushFinApBill(List<Long> purinBills, boolean isModifyQty, boolean isReturnBill) {
        List<DynamicObject> finApBills = BOTPHelper.push("im_purinbill", "ap_finapbill", "562850542418677760", purinBills);
        DynamicObject finApBill = finApBills.get(0);
        long finApBillId = finApBill.getLong("id");
        if (isModifyQty) {
            DynamicObjectCollection detailEntry = finApBill.getDynamicObjectCollection("detailentry");
            ArrayList qtyList = new ArrayList(4);
            detailEntry.forEach(row -> qtyList.add(row.getBigDecimal("quantity").divide(BigDecimal.valueOf(2L))));
            FinApBillTestHelper.modifyQty(finApBill, qtyList.toArray(new BigDecimal[0]));
        }
        if (isReturnBill) {
            finApBill.set("payproperty", (Object)BaseDataTestProvider.getPayProperty());
            BusBillTestHelper.executeOperation("save", "ap_finapbill", new DynamicObject[]{finApBill});
            BusBillTestHelper.executeOperation("submit", "ap_finapbill", new Object[]{finApBillId});
        } else {
            BusBillTestHelper.executeOperation("submit", "ap_finapbill", new DynamicObject[]{finApBill});
        }
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new Object[]{finApBillId});
        finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        return finApBill;
    }

    public static DynamicObject getPushPurInBill(String srcBillEntity, List<Long> srcBillIds, String billno) {
        DynamicObject warehouse = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_warehouse", (QFilter[])new QFilter[]{new QFilter("isopenlocation", "=", (Object)Boolean.FALSE)});
        List<DynamicObject> purInBills = BOTPHelper.push(srcBillEntity, "im_purinbill", null, srcBillIds);
        DynamicObject purInBill = purInBills.get(0);
        purInBill.set("billno", (Object)billno);
        DynamicObjectCollection entry = purInBill.getDynamicObjectCollection("billentry");
        for (DynamicObject row : entry) {
            row.set("warehouse", (Object)warehouse);
        }
        BusBillTestHelper.executeOperation("save", "im_purinbill", new DynamicObject[]{purInBill});
        BusBillTestHelper.executeOperation("submit", "im_purinbill", new Object[]{purInBill.getLong("id")});
        BusBillTestHelper.executeOperation("audit", "im_purinbill", new Object[]{purInBill.getLong("id")});
        purInBill = BusinessDataServiceHelper.loadSingle((Object)purInBill.getLong("id"), (String)"im_purinbill");
        return purInBill;
    }
}

