/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.SalOutBillDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.SalOutBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.SalOutBillDataVO;

public class SalOutBillTestHelper {
    public static DynamicObject createSalOutBill(String billNo, BigDecimal qty1, BigDecimal price1, BigDecimal qty2, BigDecimal price2) {
        SalOutBillDataVO salOutBillV0 = new SalOutBillDataVO();
        salOutBillV0.setBillNo(billNo);
        salOutBillV0.setBillStatus("C");
        ArrayList<SalOutBillDataDetailVO> entryInfoList = new ArrayList<SalOutBillDataDetailVO>(2);
        SalOutBillDataDetailVO entryInfo_1 = new SalOutBillDataDetailVO();
        entryInfo_1.setSeq(1);
        entryInfo_1.setQuantity(qty1);
        entryInfo_1.setPrice(price1);
        entryInfoList.add(entryInfo_1);
        SalOutBillDataDetailVO entryInfo_2 = new SalOutBillDataDetailVO();
        entryInfo_2.setSeq(2);
        entryInfo_2.setQuantity(qty2);
        entryInfo_2.setPrice(price2);
        entryInfoList.add(entryInfo_2);
        DynamicObject salOutBillInfo = SalOutBillDataTestProvider.buildByEntryPriceAndQty(salOutBillV0, entryInfoList);
        return salOutBillInfo;
    }

    public static DynamicObject createSalOutBill(String billNo, BigDecimal qty1, BigDecimal price1, BigDecimal qty2, BigDecimal price2, boolean isUSD) {
        SalOutBillDataDetailVO salOutDetailVO1 = new SalOutBillDataDetailVO();
        salOutDetailVO1.setQuantity(qty1);
        salOutDetailVO1.setPrice(price1);
        SalOutBillDataDetailVO salOutDetailVO2 = new SalOutBillDataDetailVO();
        salOutDetailVO2.setQuantity(qty2);
        salOutDetailVO2.setPrice(price2);
        ArrayList<SalOutBillDataDetailVO> entryInfoList = new ArrayList<SalOutBillDataDetailVO>(2);
        entryInfoList.add(salOutDetailVO1);
        entryInfoList.add(salOutDetailVO2);
        SalOutBillDataVO billInfo = new SalOutBillDataVO();
        billInfo.setBillNo(billNo);
        billInfo.setBillStatus("C");
        if (isUSD) {
            billInfo.setSettleCurrency(BaseDataTestProvider.getCurrencyUSD());
            billInfo.setExchangeRate(BigDecimal.valueOf(6.5));
        }
        return SalOutBillDataTestProvider.buildByEntryPriceAndQty(billInfo, entryInfoList);
    }

    public static DynamicObject getCustomer() {
        QFilter filter = new QFilter("ctrlstrategy", "=", (Object)"5");
        DynamicObject selectOne = QueryServiceHelper.queryOne((String)"bd_customer", (String)"id", (QFilter[])new QFilter[]{filter});
        if (selectOne == null) {
            throw new KDBizException("\u57fa\u7840\u8d44\u6599-\u5ba2\u6237\u4e0d\u5b58\u5728");
        }
        DynamicObject customer = BusinessDataServiceHelper.loadSingle((Object)selectOne.getLong("id"), (String)"bd_customer");
        return customer;
    }

    public static void deleteBill(String entityName, String ... billnos) {
        ArrayList<String> billNoList = new ArrayList<String>(billnos.length);
        for (int i = 0; i < billnos.length; ++i) {
            billNoList.add(billnos[i]);
        }
        DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter("billno", "in", billNoList)});
    }

    public static void buildEntryByQtyDivide2(DynamicObject redBillInfo) {
        DynamicObjectCollection entryCol = redBillInfo.getDynamicObjectCollection("billentry");
        for (DynamicObject entryInfo : entryCol) {
            BigDecimal price = entryInfo.getBigDecimal("price");
            BigDecimal quantity = entryInfo.getBigDecimal("qty").divide(BigDecimal.valueOf(2L));
            BigDecimal amount = price.multiply(quantity);
            BigDecimal exchangeRate = redBillInfo.getBigDecimal("exchangerate");
            BigDecimal curAmount = price.multiply(quantity).multiply(exchangeRate);
            entryInfo.set("qty", (Object)quantity);
            entryInfo.set("baseqty", (Object)quantity);
            entryInfo.set("price", (Object)price);
            entryInfo.set("priceandtax", (Object)price);
            entryInfo.set("actualprice", (Object)price);
            entryInfo.set("actualtaxprice", (Object)price);
            entryInfo.set("amount", (Object)amount);
            entryInfo.set("curamount", (Object)curAmount);
            entryInfo.set("amountandtax", (Object)amount);
            entryInfo.set("curamountandtax", (Object)curAmount);
            entryInfo.set("discounttype", (Object)"NULL");
            entryInfo.set("remainreturnqty", (Object)quantity);
            entryInfo.set("remainreturnbaseqty", (Object)quantity);
            entryInfo.set("remainjoinpriceqty", (Object)quantity);
            entryInfo.set("remainjoinpricebaseqty", (Object)quantity);
            entryInfo.set("unverifyqty", (Object)quantity);
            entryInfo.set("unverifybaseqty", (Object)quantity);
        }
    }
}

