/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.basic;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.SimulatorTestHelper;
import kd.fi.arapcommon.util.DateUtils;
import org.junit.Test;

public class AP002_ApInvoiceBasicTest
extends AbstractJUnitTestPlugIn {
    private SimulatorTestHelper util = new SimulatorTestHelper(this);
    private IFormView invoiceView = null;
    private IDataModel model = null;
    private DynamicObject material = null;

    public void initData() {
        super.initData();
        List<String> deleteInvoices = Arrays.asList("ApInvoiceBasic_1", "ApInvoiceBasic_2", "ApInvoiceBasic_3", "ApInvoiceBasic_4", "ApInvoiceBasic_5");
        DeleteServiceHelper.delete((String)"ap_invoice", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteInvoices)});
        long orgId = BaseDataTestProvider.getDetailInitOrg().getLong("id");
        this.material = BaseDataTestProvider.getMaterial();
        String param = "[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[],[{\"FieldName\":[\"biztype\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"invoicetype\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"billstatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"issuedate\"],\"Value\":[\"13\"],\"Compare\":[\"13\"]},{\"FieldName\":[\"org.id\"],\"Value\":[\"" + orgId + "\"],\"Compare\":[\"\"]}],\"entry\"],\"postData\":[{},[]]}]";
        this.util.invokeAction((IFormView)((IListView)this.getView()), param);
    }

    @TestMethod(value=1)
    @DisplayName(value="\u6536\u7968\u5355\u672c\u7aef\u91d1\u989d\u8ba1\u7b97\u573a\u666f")
    @Test
    public void invoiceAmountChange() {
        this.fillFieldValues();
        this.model.setValue("isincludetax", (Object)Boolean.FALSE);
        this.model.setValue("material", (Object)this.material, 0);
        this.model.setValue("price", (Object)new BigDecimal(100), 0);
        this.model.setValue("discountmode", (Object)"TOTAL", 0);
        this.model.setValue("discountamt", (Object)new BigDecimal(20), 0);
        this.validateApInvoiceBill(0, new BigDecimal(100), new BigDecimal(80), BigDecimal.ZERO, new BigDecimal(80), false);
        this.model.setValue("quantity", (Object)2, 0);
        this.validateApInvoiceBill(0, new BigDecimal(100), new BigDecimal(160), BigDecimal.ZERO, new BigDecimal(160), false);
        this.addNewLine();
        this.model.setValue("material", (Object)this.material, 1);
        this.model.setValue("price", (Object)new BigDecimal(100), 1);
        this.model.setValue("discountmode", (Object)"PERCENT", 1);
        this.model.setValue("discountrate", (Object)new BigDecimal(20), 1);
        this.model.setValue("isfx", (Object)Boolean.TRUE);
        this.model.setValue("e_tax", (Object)new BigDecimal(20), 1);
        this.validateApInvoiceBill(1, new BigDecimal(100), new BigDecimal(60), new BigDecimal(20), new BigDecimal(80), false);
        this.model.setValue("isfx", (Object)Boolean.FALSE);
        this.model.setValue("quantity", (Object)2, 1);
        this.validateApInvoiceBill(1, new BigDecimal(100), new BigDecimal(160), BigDecimal.ZERO, new BigDecimal(160), false);
        this.addNewLine();
        this.model.setValue("isincludetax", (Object)Boolean.TRUE);
        this.model.setValue("material", (Object)this.material, 2);
        this.model.setValue("e_pricetaxtotal", (Object)new BigDecimal(100), 2);
        this.model.setValue("discountmode", (Object)"PERUNIT", 2);
        this.model.setValue("discountrate", (Object)new BigDecimal(20), 2);
        this.validateApInvoiceBill(2, new BigDecimal(120), new BigDecimal(100), BigDecimal.ZERO, new BigDecimal(100), false);
        this.model.setValue("quantity", (Object)2, 2);
        this.validateApInvoiceBill(2, new BigDecimal(70), new BigDecimal(100), BigDecimal.ZERO, new BigDecimal(100), false);
        this.invoiceView.invokeOperation("save");
        this.model.setValue("billno", (Object)"ApInvoiceBasic_1");
        OperationResult saveResult = this.invoiceView.invokeOperation("save");
        AP002_ApInvoiceBasicTest.assertEquals((String)"\u4fdd\u5b58\u5931\u8d25", (boolean)true, (boolean)saveResult.isSuccess());
    }

    @TestMethod(value=2)
    @DisplayName(value="\u6536\u7968\u5355-\u590d\u5236\u884c-\u4fdd\u5b58")
    @Test
    public void invoiceCopyEntry() {
        this.fillFieldValues();
        this.model.setValue("material", (Object)this.material, 0);
        this.model.setValue("e_pricetaxtotal", (Object)new BigDecimal(100), 0);
        String selectOne = "[{\"key\":\"entry\",\"methodName\":\"entryRowClick\",\"args\":[0],\"postData\":[{\"entry\":{\"fieldKey\":\"price\",\"row\":0,\"selRows\":[0],\"isClientNewRow\":false,\"clientNewRows\":\"\",\"selDatas\":[]}},[]]}]";
        this.util.invokeAction(this.invoiceView, selectOne);
        String copyRow = "[{\"key\":\"advcontoolbarap\",\"methodName\":\"itemClick\",\"args\":[\"copyentry\",\"copyentryrow\"],\"postData\":[{},[]]}]";
        this.util.invokeAction(this.invoiceView, copyRow);
        this.validateApInvoiceBill(1, new BigDecimal(100), new BigDecimal(100), BigDecimal.ZERO, new BigDecimal(100), false);
        this.invoiceView.invokeOperation("save");
        this.model.setValue("billno", (Object)"ApInvoiceBasic_2");
        OperationResult saveResult = this.invoiceView.invokeOperation("save");
        AP002_ApInvoiceBasicTest.assertEquals((String)"\u4fdd\u5b58\u5931\u8d25", (boolean)true, (boolean)saveResult.isSuccess());
    }

    @TestMethod(value=3)
    @DisplayName(value="\u6536\u7968\u5355\u590d\u6742\u6570\u636e\u4fdd\u5b58\u6821\u9a8c")
    @Test
    public void invoiceComplexData() {
        this.fillFieldValues();
        this.model.setValue("material", (Object)this.material, 0);
        this.model.setValue("currency", (Object)BaseDataTestProvider.getCurrencyUSD());
        this.model.setValue("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        this.model.setValue("exratedate", (Object)new Date());
        this.model.setValue("exchangerate", (Object)new BigDecimal("6.3045"));
        this.model.setValue("e_pricetaxtotal", (Object)new BigDecimal(100), 0);
        this.model.setValue("taxrateid", (Object)BaseDataTestProvider.getTaxRate(), 0);
        this.model.setValue("discountmode", (Object)"PERUNIT", 0);
        this.model.setValue("discountrate", (Object)new BigDecimal(20), 0);
        this.invoiceView.invokeOperation("save");
        this.model.setValue("billno", (Object)"ApInvoiceBasic_3");
        OperationResult saveResult = this.invoiceView.invokeOperation("save");
        AP002_ApInvoiceBasicTest.assertEquals((String)"\u4fdd\u5b58\u5931\u8d25", (boolean)true, (boolean)saveResult.isSuccess());
        this.validateApInvoiceBill(0, new BigDecimal("106.1946902655"), new BigDecimal("88.4955752212"), new BigDecimal("11.5044247788"), new BigDecimal(100), true);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u6536\u7968\u5355-propertyChanged\u4e8b\u4ef6\u89e6\u53d1")
    @Test
    public void invoicePropertyChanged() {
        this.fillFieldValues();
        this.model.setValue("material", (Object)this.material, 0);
        this.model.setValue("e_pricetaxtotal", (Object)new BigDecimal(100), 0);
        this.model.setValue("invoicetype", (Object)"GE");
        AP002_ApInvoiceBasicTest.assertEquals((String)"\u666e\u901a\u53d1\u7968(\u7eb8\u8d28)\u65f6\uff0c\u6536\u7968\u5355\u8fdb\u9879\u7a0e\u62b5\u6263\u6807\u8bc6\u5e94\u4e3a\u5426", (Object)Boolean.FALSE, (Object)this.model.getValue("istaxdeduction"));
        Date lastDay = DateUtils.getLastDay(new Date(), -1);
        this.model.setValue("issuedate", (Object)lastDay);
        AP002_ApInvoiceBasicTest.assertEquals((String)"\u6700\u8fdf\u4ed8\u6b3e\u65e5\u671f\u8054\u52a8\u8d4b\u503c\u9519\u8bef", (int)0, (int)lastDay.compareTo((Date)this.model.getValue("lastpaydate")));
        this.invoiceView.invokeOperation("save");
        this.model.setValue("billno", (Object)"ApInvoiceBasic_4");
        OperationResult saveResult = this.invoiceView.invokeOperation("save");
        AP002_ApInvoiceBasicTest.assertEquals((String)"\u4fdd\u5b58\u5931\u8d25", (boolean)true, (boolean)saveResult.isSuccess());
        this.validateApInvoiceBill(0, new BigDecimal(100), new BigDecimal(100), BigDecimal.ZERO, new BigDecimal(100), false);
    }

    private void validateApInvoiceBill(int index, BigDecimal ePrice, BigDecimal eAmount, BigDecimal eTax, BigDecimal ePriceTaxTotal, boolean isComplexData) {
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountBase = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal unRelatedAmt = BigDecimal.ZERO;
        BigDecimal unMatchAmt = BigDecimal.ZERO;
        DynamicObjectCollection entry = this.model.getEntryEntity("entry");
        if (isComplexData) {
            DynamicObject baseCurrency = (DynamicObject)this.model.getValue("currency");
            int localPrecision = ObjectUtils.isEmpty((Object)baseCurrency) ? 2 : baseCurrency.getInt("amtprecision");
            eAmount = eAmount.setScale(localPrecision, RoundingMode.HALF_UP);
            ePriceTaxTotal = ePriceTaxTotal.setScale(localPrecision, RoundingMode.HALF_UP);
            eTax = eTax.setScale(localPrecision, RoundingMode.HALF_UP);
        }
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject row = (DynamicObject)entry.get(i);
            BigDecimal e_amount = row.getBigDecimal("e_amount");
            BigDecimal e_amountbase = row.getBigDecimal("e_amountbase");
            BigDecimal e_tax = row.getBigDecimal("e_tax");
            BigDecimal e_pricetaxtotal = row.getBigDecimal("e_pricetaxtotal");
            BigDecimal e_pricetaxtotalbase = row.getBigDecimal("e_pricetaxtotalbase");
            BigDecimal e_unrelatedamt = row.getBigDecimal("e_unrelatedamt");
            BigDecimal e_relatedamt = row.getBigDecimal("e_relatedamt");
            BigDecimal e_unmatchamt = row.getBigDecimal("e_unmatchamt");
            if (index == i) {
                AP002_ApInvoiceBasicTest.assertEquals((String)String.format("\u6536\u7968\u5355\u7b2c%s\u884c\u5355\u4ef7\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", i), (int)0, (int)row.getBigDecimal("price").compareTo(ePrice));
                AP002_ApInvoiceBasicTest.assertEquals((String)String.format("\u6536\u7968\u5355\u7b2c%s\u884c\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", i), (int)0, (int)e_amount.compareTo(eAmount));
                AP002_ApInvoiceBasicTest.assertEquals((String)String.format("\u6536\u7968\u5355\u7b2c%s\u884c\u7a0e\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", i), (int)0, (int)e_tax.compareTo(eTax));
                AP002_ApInvoiceBasicTest.assertEquals((String)String.format("\u6536\u7968\u5355\u7b2c%s\u884c\u4ef7\u7a0e\u5408\u8ba1\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", i), (int)0, (int)e_pricetaxtotal.compareTo(ePriceTaxTotal));
            }
            priceTaxTotal = priceTaxTotal.add(e_pricetaxtotal);
            priceTaxTotalBase = priceTaxTotalBase.add(e_pricetaxtotalbase);
            amount = amount.add(e_amount);
            amountBase = amountBase.add(e_amountbase);
            tax = tax.add(e_tax);
            unRelatedAmt = unRelatedAmt.add(e_unrelatedamt);
            unMatchAmt = unMatchAmt.add(e_unmatchamt);
            AP002_ApInvoiceBasicTest.assertEquals((String)String.format("\u6536\u7968\u5355\u7b2c%s\u884c\u5df2\u5173\u8054\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", i), (int)0, (int)e_relatedamt.compareTo(BigDecimal.ZERO));
            AP002_ApInvoiceBasicTest.assertEquals((String)String.format("\u6536\u7968\u5355\u7b2c%s\u884c\u672a\u5173\u8054\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", i), (int)0, (int)e_unrelatedamt.compareTo(e_pricetaxtotal));
            AP002_ApInvoiceBasicTest.assertEquals((String)String.format("\u6536\u7968\u5355\u7b2c%s\u884c\u672a\u5339\u914d\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", i), (int)0, (int)e_unmatchamt.compareTo(e_pricetaxtotal));
            AP002_ApInvoiceBasicTest.assertEquals((String)String.format("\u6536\u7968\u5355\u7b2c%s\u884c\u672a\u5339\u914d\u6570\u91cf\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", i), (boolean)true, (row.getInt("e_unmatchqty") == row.getInt("quantity") ? 1 : 0) != 0);
        }
        boolean flag = priceTaxTotal.compareTo((BigDecimal)this.model.getValue("pricetaxtotal")) == 0 && priceTaxTotalBase.compareTo((BigDecimal)this.model.getValue("pricetaxtotalbase")) == 0 && amount.compareTo((BigDecimal)this.model.getValue("amount")) == 0 && amountBase.compareTo((BigDecimal)this.model.getValue("amountbase")) == 0 && tax.compareTo((BigDecimal)this.model.getValue("tax")) == 0 && unRelatedAmt.compareTo((BigDecimal)this.model.getValue("unrelatedamt")) == 0 && unMatchAmt.compareTo((BigDecimal)this.model.getValue("unmatchamt")) == 0;
        AP002_ApInvoiceBasicTest.assertEquals((String)"\u6536\u7968\u5355\u5206\u5f55\u6c47\u603b\u4e0d\u7b49\u4e8e\u8868\u5934", (boolean)true, (boolean)flag);
        AP002_ApInvoiceBasicTest.assertEquals((String)"\u6536\u7968\u5355\u8868\u5934\u672a\u5173\u8054\u91d1\u989d\u4e0d\u7b49\u4e8e\u4ef7\u7a0e\u5408\u8ba1", (int)0, (int)priceTaxTotal.compareTo((BigDecimal)this.model.getValue("unrelatedamt")));
        AP002_ApInvoiceBasicTest.assertEquals((String)"\u6536\u7968\u5355\u8868\u5934\u672a\u5339\u914d\u91d1\u989d\u4e0d\u7b49\u4e8e\u4ef7\u7a0e\u5408\u8ba1", (int)0, (int)priceTaxTotal.compareTo((BigDecimal)this.model.getValue("unmatchamt")));
    }

    private void fillFieldValues() {
        this.invoiceView = this.util.clickBarItemReturnChildView((IFormView)((IListView)this.getView()), "tblnew", "new");
        this.model = this.invoiceView.getModel();
        this.model.deleteEntryData("finentry");
        this.model.setValue("receivablessupp", (Object)BaseDataTestProvider.getSupplier().getLong("id"));
        this.model.setValue("remark", (Object)"\u6536\u7968\u5355\u65b0\u5355\u5143\u6d4b\u8bd5\u672c\u7aef\u6d4b\u8bd5\u6570\u636e\uff0c\u52ff\u52a8");
    }

    private void addNewLine() {
        String param = "[{\"key\":\"advcontoolbarap\",\"methodName\":\"itemClick\",\"args\":[\"newentry\",\"newentry\"],\"postData\":[{},[]]}]";
        this.util.invokeAction(this.invoiceView, param);
    }
}

