/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.basic;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.list.IListView;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.SimulatorTestHelper;
import org.junit.Test;

public class AP004_ApPayApplyBasicTest
extends AbstractJUnitTestPlugIn {
    private IListView listView = null;
    private SimulatorTestHelper util = new SimulatorTestHelper(this);

    public void initData() {
        super.initData();
        this.listView = (IListView)this.getView();
    }

    @TestMethod(value=1)
    @DisplayName(value="\u4ed8\u6b3e\u7533\u8bf7\u5355\u672c\u7aef\u5168\u6d41\u7a0b\u6d4b\u8bd5-\u5207\u6362\u7ec4\u7ec7\uff08\u73af\u5b87\u5bb6\u7535\u603b\u90e8\uff09")
    @Test
    public void changeOrg() {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        String param = "[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[],[{\"FieldName\":[\"billtype.id\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"bizdate\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"billstatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"applyorg.id\"],\"Value\":[\"" + org.getLong("id") + "\"],\"Compare\":[\"\"]}],\"entry\"],\"postData\":[{},[]]}]";
        this.util.invokeAction((IFormView)this.listView, param);
        AP004_ApPayApplyBasicTest.assertEquals((int)1, (int)1);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u6570\u636e\u5168\u6d4b\u9a8c")
    @Test
    public void initTest() {
        IFormView arBillView = this.util.clickBarItemReturnChildView((IFormView)this.listView, "tblnew", "new");
        IDataModel model = arBillView.getModel();
        DynamicObject cur = (DynamicObject)model.getValue("settlecurrency");
        model.setValue("paycurrency", cur.getPkValue());
        if (model.getEntryRowCount("entry") == 0) {
            model.createNewEntryRow("entry");
        }
        DynamicObject paymentType = BaseDataTestProvider.getPaymentType();
        model.setValue("e_paymenttype", paymentType.getPkValue(), 0);
        DynamicObject supplier = BaseDataTestProvider.getSupplier();
        model.setValue("e_asstact", supplier.getPkValue(), 0);
        model.setValue("e_payamount", (Object)1000, 0);
        this.checkHeadAmt(1000.0, model);
        this.checkEntryAmt(1000.0, model);
        model.setValue("e_applyamount", (Object)500, 0);
        this.checkHeadAmt(500.0, model);
        this.checkEntryAmt(500.0, model);
        model.setValue("e_applyamount", (Object)2000, 0);
        this.checkHeadAmt(1000.0, model);
        this.checkEntryAmt(1000.0, model);
        OperationResult opResult = arBillView.invokeOperation("save");
        AP004_ApPayApplyBasicTest.assertInvokeOperation((OperationResult)opResult);
        OperationResult submitOp = arBillView.invokeOperation("submit");
        AP004_ApPayApplyBasicTest.assertInvokeOperation((OperationResult)submitOp);
        OperationResult auditOp = arBillView.invokeOperation("audit");
        AP004_ApPayApplyBasicTest.assertInvokeOperation((OperationResult)auditOp);
    }

    private void checkHeadAmt(double expectedAmt, IDataModel model) {
        DynamicObject apPayApply = model.getDataEntity();
        BigDecimal applyAmount = apPayApply.getBigDecimal("applyamount");
        AP004_ApPayApplyBasicTest.assertEquals((Object)expectedAmt, (Object)applyAmount.doubleValue());
        BigDecimal applyLocalAmount = apPayApply.getBigDecimal("appseleamount");
        AP004_ApPayApplyBasicTest.assertEquals((Object)expectedAmt, (Object)applyLocalAmount.doubleValue());
        BigDecimal approvalAmount = apPayApply.getBigDecimal("approvalamount");
        AP004_ApPayApplyBasicTest.assertEquals((Object)expectedAmt, (Object)approvalAmount.doubleValue());
        BigDecimal approvalLocalAmount = apPayApply.getBigDecimal("aprseleamount");
        AP004_ApPayApplyBasicTest.assertEquals((Object)expectedAmt, (Object)approvalLocalAmount.doubleValue());
    }

    private void checkEntryAmt(double expectedAmt, IDataModel model) {
        DynamicObjectCollection detailEntries = model.getEntryEntity("entry");
        for (DynamicObject detailRow : detailEntries) {
            BigDecimal rowPayAmt = detailRow.getBigDecimal("e_payamount");
            AP004_ApPayApplyBasicTest.assertEquals((Object)1000.0, (Object)rowPayAmt.doubleValue());
            BigDecimal rowApplyAmt = detailRow.getBigDecimal("e_applyamount");
            AP004_ApPayApplyBasicTest.assertEquals((Object)expectedAmt, (Object)rowApplyAmt.doubleValue());
            BigDecimal rowApplyLocalAmt = detailRow.getBigDecimal("e_appseleamount");
            AP004_ApPayApplyBasicTest.assertEquals((Object)expectedAmt, (Object)rowApplyLocalAmt.doubleValue());
            BigDecimal rowApprovalAmt = detailRow.getBigDecimal("e_approvedamt");
            AP004_ApPayApplyBasicTest.assertEquals((Object)expectedAmt, (Object)rowApprovalAmt.doubleValue());
            BigDecimal rowApprovalLocalAmt = detailRow.getBigDecimal("e_approvedseleamt");
            AP004_ApPayApplyBasicTest.assertEquals((Object)expectedAmt, (Object)rowApprovalLocalAmt.doubleValue());
            BigDecimal rowPaidAmt = detailRow.getBigDecimal("e_paidamt");
            AP004_ApPayApplyBasicTest.assertEquals((Object)0.0, (Object)rowPaidAmt.doubleValue());
            BigDecimal rowLockedAmt = detailRow.getBigDecimal("lockedamt");
            AP004_ApPayApplyBasicTest.assertEquals((Object)0.0, (Object)rowLockedAmt.doubleValue());
        }
    }
}

