/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.basic;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.SimulatorTestHelper;
import org.junit.Test;

public class AR002_ArInvoiceBasicTest
extends AbstractJUnitTestPlugIn {
    private SimulatorTestHelper util = new SimulatorTestHelper(this);
    private IFormView invoiceView = null;
    private IDataModel model = null;
    private DynamicObject material = null;
    private DynamicObject taxClassCode = null;

    public void initData() {
        super.initData();
        List<String> deleteInvoices = Arrays.asList("ArInvoiceBasicTest_1", "ArInvoiceBasicTest_2", "ArInvoiceBasicTest_3");
        DeleteServiceHelper.delete((String)"ar_invoice", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteInvoices)});
        long orgId = BaseDataTestProvider.getDetailInitOrg().getLong("id");
        this.material = BaseDataTestProvider.getMaterial();
        this.taxClassCode = BusinessDataServiceHelper.loadSingleFromCache((String)"er_taxclasscode", (QFilter[])new QFilter[0]);
        String param = "[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[],[{\"FieldName\":[\"biztype\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"invoicetype\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"billstatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"org.id\"],\"Value\":[\"" + orgId + "\"],\"Compare\":[\"\"]},{\"FieldName\":[\"bizdate\"],\"Value\":[\"\"],\"Compare\":[\"13\"]}],\"entry\"],\"postData\":[{},[]]}]";
        this.util.invokeAction((IFormView)((IListView)this.getView()), param);
    }

    @TestMethod(value=1)
    @DisplayName(value="\u5f00\u7968\u5355\u672c\u7aef\u91d1\u989d\u8ba1\u7b97\u573a\u666f")
    @Test
    public void invoiceAmountChange() {
        this.fillFieldValues();
        this.model.setValue("isincludetax", (Object)Boolean.FALSE);
        this.model.setValue("e_material", (Object)this.material, 0);
        this.model.setValue("e_taxclass", (Object)this.taxClassCode, 0);
        this.model.setValue("e_unitprice", (Object)new BigDecimal(100), 0);
        this.model.setValue("e_discountmode", (Object)"TOTAL", 0);
        this.model.setValue("e_discountamount", (Object)new BigDecimal(20), 0);
        this.validateArInvoiceBill(0, new BigDecimal(100), new BigDecimal(80), BigDecimal.ZERO, new BigDecimal(80), false);
        this.model.setValue("e_quantity", (Object)2, 0);
        this.validateArInvoiceBill(0, new BigDecimal(100), new BigDecimal(160), BigDecimal.ZERO, new BigDecimal(160), false);
        this.addNewLine();
        this.model.setValue("e_material", (Object)this.material, 1);
        this.model.setValue("e_taxclass", (Object)this.taxClassCode, 1);
        this.model.setValue("e_unitprice", (Object)new BigDecimal(100), 1);
        this.model.setValue("e_discountmode", (Object)"PERCENT", 1);
        this.model.setValue("e_discountrate", (Object)new BigDecimal(20), 1);
        this.model.setValue("isfx", (Object)Boolean.TRUE);
        this.model.setValue("e_tax", (Object)new BigDecimal(20), 1);
        this.validateArInvoiceBill(1, new BigDecimal(100), new BigDecimal(60), new BigDecimal(20), new BigDecimal(80), false);
        this.model.setValue("isfx", (Object)Boolean.FALSE);
        this.model.setValue("e_quantity", (Object)2, 1);
        this.validateArInvoiceBill(1, new BigDecimal(100), new BigDecimal(160), BigDecimal.ZERO, new BigDecimal(160), false);
        this.addNewLine();
        this.model.setValue("isincludetax", (Object)Boolean.TRUE);
        this.model.setValue("e_material", (Object)this.material, 2);
        this.model.setValue("e_taxclass", (Object)this.taxClassCode, 2);
        this.model.setValue("e_recamount", (Object)new BigDecimal(100), 2);
        this.model.setValue("e_discountmode", (Object)"PERUNIT", 2);
        this.model.setValue("e_discountrate", (Object)new BigDecimal(20), 2);
        this.validateArInvoiceBill(2, new BigDecimal(120), new BigDecimal(100), BigDecimal.ZERO, new BigDecimal(100), false);
        this.model.setValue("e_quantity", (Object)2, 2);
        this.validateArInvoiceBill(2, new BigDecimal(70), new BigDecimal(100), BigDecimal.ZERO, new BigDecimal(100), false);
        this.invoiceView.invokeOperation("save");
        this.model.setValue("billno", (Object)"ArInvoiceBasicTest_1");
        OperationResult saveResult = this.invoiceView.invokeOperation("save");
        AR002_ArInvoiceBasicTest.assertEquals((String)"\u4fdd\u5b58\u5931\u8d25", (boolean)true, (boolean)saveResult.isSuccess());
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5f00\u7968\u5355-\u590d\u5236\u884c-\u4fdd\u5b58")
    @Test
    public void invoiceCopyEntry() {
        this.fillFieldValues();
        this.model.setValue("e_material", (Object)this.material, 0);
        this.model.setValue("e_taxclass", (Object)this.taxClassCode, 0);
        this.model.setValue("e_recamount", (Object)new BigDecimal(100), 0);
        String selectOne = "[{\"key\":\"entry\",\"methodName\":\"entryRowClick\",\"args\":[0],\"postData\":[{\"entry\":{\"fieldKey\":\"e_spectype\",\"row\":0,\"selRows\":[0],\"isClientNewRow\":false,\"clientNewRows\":\"\",\"selDatas\":[]}},[]]}]";
        this.util.invokeAction(this.invoiceView, selectOne);
        String copyRow = "[{\"key\":\"advcontoolbarap\",\"methodName\":\"itemClick\",\"args\":[\"copyentryrow\",\"copyentryrow\"],\"postData\":[{},[]]}]";
        this.util.invokeAction(this.invoiceView, copyRow);
        this.validateArInvoiceBill(1, new BigDecimal(100), new BigDecimal(100), BigDecimal.ZERO, new BigDecimal(100), false);
        this.invoiceView.invokeOperation("save");
        this.model.setValue("billno", (Object)"ArInvoiceBasicTest_2");
        OperationResult saveResult = this.invoiceView.invokeOperation("save");
        AR002_ArInvoiceBasicTest.assertEquals((String)"\u4fdd\u5b58\u5931\u8d25", (boolean)true, (boolean)saveResult.isSuccess());
    }

    @TestMethod(value=3)
    @DisplayName(value="\u5f00\u7968\u5355\u590d\u6742\u6570\u636e\u4fdd\u5b58\u6821\u9a8c")
    @Test
    public void invoiceComplexData() {
        this.fillFieldValues();
        this.model.setValue("e_material", (Object)this.material, 0);
        this.model.setValue("e_taxclass", (Object)this.taxClassCode, 0);
        this.model.setValue("currency", (Object)BaseDataTestProvider.getCurrencyUSD());
        this.model.setValue("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        this.model.setValue("exratedate", (Object)new Date());
        this.model.setValue("exchangerate", (Object)new BigDecimal("6.3045"));
        this.model.setValue("e_recamount", (Object)new BigDecimal(100), 0);
        this.model.setValue("taxrateid", (Object)BaseDataTestProvider.getTaxRate(), 0);
        this.model.setValue("e_discountmode", (Object)"PERUNIT", 0);
        this.model.setValue("e_discountrate", (Object)new BigDecimal(20), 0);
        this.invoiceView.invokeOperation("save");
        this.model.setValue("billno", (Object)"ArInvoiceBasicTest_3");
        OperationResult saveResult = this.invoiceView.invokeOperation("save");
        AR002_ArInvoiceBasicTest.assertEquals((String)"\u4fdd\u5b58\u5931\u8d25", (boolean)true, (boolean)saveResult.isSuccess());
        this.validateArInvoiceBill(0, new BigDecimal("106.1946902655"), new BigDecimal("88.4955752212"), new BigDecimal("11.5044247788"), new BigDecimal(100), true);
    }

    private void validateArInvoiceBill(int index, BigDecimal ePrice, BigDecimal eAmount, BigDecimal eTax, BigDecimal eRecAmount, boolean isComplexData) {
        BigDecimal recAmount = BigDecimal.ZERO;
        BigDecimal recLocalAmt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localAmt = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal associatedAmt = BigDecimal.ZERO;
        DynamicObjectCollection entry = this.model.getEntryEntity("entry");
        if (isComplexData) {
            DynamicObject baseCurrency = (DynamicObject)this.model.getValue("currency");
            int localPrecision = ObjectUtils.isEmpty((Object)baseCurrency) ? 2 : baseCurrency.getInt("amtprecision");
            eAmount = eAmount.setScale(localPrecision, RoundingMode.HALF_UP);
            eRecAmount = eRecAmount.setScale(localPrecision, RoundingMode.HALF_UP);
            eTax = eTax.setScale(localPrecision, RoundingMode.HALF_UP);
        }
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject row = (DynamicObject)entry.get(i);
            BigDecimal e_amount = row.getBigDecimal("e_amount");
            BigDecimal e_localamt = row.getBigDecimal("e_localamt");
            BigDecimal e_tax = row.getBigDecimal("e_tax");
            BigDecimal e_recamount = row.getBigDecimal("e_recamount");
            BigDecimal e_reclocalamt = row.getBigDecimal("e_reclocalamt");
            BigDecimal e_associatedamt = row.getBigDecimal("e_associatedamt");
            recAmount = recAmount.add(e_recamount);
            recLocalAmt = recLocalAmt.add(e_reclocalamt);
            amount = amount.add(e_amount);
            localAmt = localAmt.add(e_localamt);
            tax = tax.add(e_tax);
            associatedAmt = associatedAmt.add(e_associatedamt);
            if (index == i) {
                AR002_ArInvoiceBasicTest.assertEquals((String)String.format("\u5f00\u7968\u5355\u7b2c%s\u884c\u5355\u4ef7\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", i), (int)0, (int)row.getBigDecimal("e_unitprice").compareTo(ePrice));
                AR002_ArInvoiceBasicTest.assertEquals((String)String.format("\u5f00\u7968\u5355\u7b2c%s\u884c\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", i), (int)0, (int)e_amount.compareTo(eAmount));
                AR002_ArInvoiceBasicTest.assertEquals((String)String.format("\u5f00\u7968\u5355\u7b2c%s\u884c\u7a0e\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", i), (int)0, (int)e_tax.compareTo(eTax));
                AR002_ArInvoiceBasicTest.assertEquals((String)String.format("\u5f00\u7968\u5355\u7b2c%s\u884c\u4ef7\u7a0e\u5408\u8ba1\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", i), (int)0, (int)e_recamount.compareTo(eRecAmount));
            }
            AR002_ArInvoiceBasicTest.assertEquals((String)String.format("\u5f00\u7968\u5355\u7b2c%s\u884c\u5df2\u7ea2\u51b2\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", i), (int)0, (int)row.getBigDecimal("e_verifiedwriteoffamt").compareTo(BigDecimal.ZERO));
            AR002_ArInvoiceBasicTest.assertEquals((String)String.format("\u5f00\u7968\u5355\u7b2c%s\u884c\u672a\u7ea2\u51b2\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", i), (int)0, (int)row.getBigDecimal("e_unverifiedwriteoffamt").compareTo(e_recamount));
            AR002_ArInvoiceBasicTest.assertEquals((String)String.format("\u5f00\u7968\u5355\u7b2c%s\u884c\u5df2\u7ea2\u51b2\u6570\u91cf\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", i), (int)0, (int)row.getInt("e_verifiedwriteoffqty"));
            AR002_ArInvoiceBasicTest.assertEquals((String)String.format("\u5f00\u7968\u5355\u7b2c%s\u884c\u672a\u7ea2\u51b2\u6570\u91cf\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", i), (int)row.getInt("e_quantity"), (int)row.getInt("e_unverifiedwriteoffqty"));
            AR002_ArInvoiceBasicTest.assertEquals((String)String.format("\u5f00\u7968\u5355\u7b2c%s\u884c\u5df2\u5173\u8054\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", i), (int)0, (int)row.getBigDecimal("e_associatedamt").compareTo(BigDecimal.ZERO));
        }
        boolean flag = recAmount.compareTo((BigDecimal)this.model.getValue("recamount")) == 0 && recLocalAmt.compareTo((BigDecimal)this.model.getValue("reclocalamt")) == 0 && amount.compareTo((BigDecimal)this.model.getValue("amount")) == 0 && localAmt.compareTo((BigDecimal)this.model.getValue("localamt")) == 0 && tax.compareTo((BigDecimal)this.model.getValue("tax")) == 0 && associatedAmt.compareTo((BigDecimal)this.model.getValue("associatedamt")) == 0;
        AR002_ArInvoiceBasicTest.assertEquals((String)"\u6536\u7968\u5355\u5206\u5f55\u6c47\u603b\u4e0d\u7b49\u4e8e\u8868\u5934", (boolean)true, (boolean)flag);
        AR002_ArInvoiceBasicTest.assertEquals((String)"\u6536\u7968\u5355\u8868\u5934\u5df2\u5173\u8054\u91d1\u989d\u4e0d\u7b49\u4e8e0", (int)0, (int)BigDecimal.ZERO.compareTo((BigDecimal)this.model.getValue("associatedamt")));
    }

    private void fillFieldValues() {
        this.invoiceView = this.util.clickBarItemReturnChildView((IFormView)((IListView)this.getView()), "tblnew", "new");
        this.model = this.invoiceView.getModel();
        DynamicObject customer = BaseDataTestProvider.getCustomer();
        this.model.setValue("asstact", (Object)customer);
        this.model.setValue("remark", (Object)"\u5f00\u7968\u5355\u65b0\u5355\u5143\u6d4b\u8bd5\u672c\u7aef\u6d4b\u8bd5\u6570\u636e\uff0c\u52ff\u52a8");
        this.model.setValue("sellertin", (Object)"\u5317\u4eac\u91d1\u8776\u8f6f\u4ef6\u56ed");
        this.model.setValue("selleraddr", (Object)"\u5317\u4eac\u91d1\u8776\u8f6f\u4ef6\u56ed");
        this.model.setValue("buyer", (Object)customer);
        this.model.setValue("buyername", (Object)customer.getString("name"));
        this.model.setValue("buyertin", (Object)"\u5317\u4eac\u91d1\u8776\u8f6f\u4ef6\u56ed");
        this.model.setValue("buyeraddr", (Object)"\u5317\u4eac\u91d1\u8776\u8f6f\u4ef6\u56ed");
        this.model.setValue("buyertel", (Object)"\u5317\u4eac\u91d1\u8776\u8f6f\u4ef6\u56ed");
    }

    private void addNewLine() {
        String param = "[{\"key\":\"advcontoolbarap\",\"methodName\":\"itemClick\",\"args\":[\"newentry\",\"newentry\"],\"postData\":[{},[]]}]";
        this.util.invokeAction(this.invoiceView, param);
    }
}

