/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.basic;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.list.IListView;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.RevCfmBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.SimulatorTestHelper;
import org.junit.Test;

public class AR004_ArRevCfmBasicTest
extends AbstractJUnitTestPlugIn {
    private IListView listView = null;
    private SimulatorTestHelper util = new SimulatorTestHelper(this);
    private IFormView arBillView = null;
    private IDataModel model = null;
    private static final String CONFIRM_LOCAL_AMT = "confirmlocamt";
    private static final String ENTRY = "entry";
    private static final String ENTRY_CONFIRM_RATE = "e_confirmrate";

    public void initData() {
        super.initData();
        this.listView = (IListView)this.getView();
    }

    @TestMethod(value=1)
    @DisplayName(value="\u4ed8\u6b3e\u7533\u8bf7\u5355\u672c\u7aef\u5168\u6d41\u7a0b\u6d4b\u8bd5-\u5207\u6362\u7ec4\u7ec7\uff08\u73af\u5b87\u5bb6\u7535\u603b\u90e8\uff09")
    @Test
    public void changeOrg() {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        String param = "[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[],[{\"FieldName\":[\"billtype.id\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"bizdate\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"billstatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"org.id\"],\"Value\":[\"" + org.getLong("id") + "\"],\"Compare\":[\"\"]}],\"entry\"],\"postData\":[{},[]]}]";
        this.util.invokeAction((IFormView)this.listView, param);
        AR004_ArRevCfmBasicTest.assertEquals((int)1, (int)1);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u521d\u59cb\u5316\u6570\u636e\u6821\u9a8c\u6d4b\u8bd5")
    @Test
    public void initTest() {
        this.arBillView = this.util.clickBarItemReturnChildView((IFormView)this.listView, "tblnew", "new");
        this.model = this.arBillView.getModel();
        this.model.createNewEntryRow(ENTRY);
        DynamicObject asst = BaseDataTestProvider.getCustomer();
        this.model.setValue("asstact", (Object)asst);
        DynamicObject payProperty = BaseDataTestProvider.getRecProperty();
        this.model.setValue("payproperty", (Object)payProperty);
        this.model.setValue("remark", (Object)"AR004_ArRevCfmBasicTest");
        DynamicObject material = BaseDataTestProvider.getMaterial();
        this.model.setValue("e_material", (Object)material, 0);
        this.model.setValue("e_quantity", (Object)10, 0);
        this.model.setValue("e_unitprice", (Object)100, 0);
        this.model.setValue("e_material", material.getPkValue(), 1);
        this.model.setValue("e_quantity", (Object)10, 1);
        this.model.setValue("e_unitprice", (Object)100, 1);
        DynamicObject revCfmBill = this.model.getDataEntity();
        String confirmWay = revCfmBill.getString("confirmway");
        AR004_ArRevCfmBasicTest.assertEquals((String)"RATE", (String)confirmWay);
        BigDecimal confirmRate = revCfmBill.getBigDecimal("confirmrate");
        AR004_ArRevCfmBasicTest.assertEquals((Object)100.0, (Object)confirmRate.doubleValue());
        this.getView().updateView(ENTRY);
        this.checkHeadAmt(2000.0);
        this.checkEntryAmt(10.0, 100.0, 1000.0);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u4fee\u6539\u6298\u6263\u65b9\u5f0f")
    @Test
    public void discountTest() {
        DynamicObjectCollection detailEntries = this.model.getEntryEntity(ENTRY);
        this.model.setValue("e_discountmode", (Object)"TOTAL", 0);
        this.model.setValue("e_discountamount", (Object)10, 0);
        this.model.setValue("e_quantity", (Object)5, 0);
        RevCfmBillTestChecker.validateDetailEntryAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(5L), BigDecimal.valueOf(99L), BigDecimal.valueOf(99L), BigDecimal.valueOf(495L), BigDecimal.valueOf(495L), BigDecimal.valueOf(495L));
        this.model.setValue("e_discountmode", (Object)"PERCENT", 0);
        this.model.setValue("e_discountrate", (Object)BigDecimal.valueOf(10L), 0);
        this.model.setValue("e_discountmode", (Object)"PERUNIT", 1);
        this.model.setValue("e_discountrate", (Object)BigDecimal.valueOf(20L), 1);
        this.model.setValue("e_quantity", (Object)10, 0);
        RevCfmBillTestChecker.validateDetailEntryAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(100L), BigDecimal.valueOf(90L), BigDecimal.valueOf(90L), BigDecimal.valueOf(900L), BigDecimal.valueOf(900L), BigDecimal.valueOf(900L));
        DynamicObject revCfmBill = this.model.getDataEntity();
        RevCfmBillTestChecker.validateHeadAmt(revCfmBill, BigDecimal.valueOf(1700L), BigDecimal.valueOf(1700L), BigDecimal.valueOf(1700L), BigDecimal.valueOf(1700L), BigDecimal.valueOf(1700L));
        this.model.setEntryCurrentRowIndex(ENTRY, 0);
        this.model.setValue("e_discountmode", (Object)"TOTAL", 0);
        this.model.setValue("e_discountamount", (Object)BigDecimal.valueOf(50L), 0);
        RevCfmBillTestChecker.validateDetailEntryAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(50L), BigDecimal.valueOf(95L), BigDecimal.valueOf(95L), BigDecimal.valueOf(950L), BigDecimal.valueOf(950L), BigDecimal.valueOf(950L));
        RevCfmBillTestChecker.validateHeadAmt(revCfmBill, BigDecimal.valueOf(1750L), BigDecimal.valueOf(1750L), BigDecimal.valueOf(1750L), BigDecimal.valueOf(1750L), BigDecimal.valueOf(1750L));
    }

    @TestMethod(value=4)
    @DisplayName(value="\u6309\u6bd4\u4f8b\u786e\u8ba4-\u4fee\u6539\u8868\u5934\u6bd4\u4f8b\u6821\u9a8c\u6d4b\u8bd5")
    @Test
    public void rateTest() {
        this.model.setValue("e_discountmode", (Object)"NULL", 0);
        this.model.setValue("e_discountmode", (Object)"NULL", 1);
        this.model.setValue("confirmrate", (Object)50);
        this.checkHeadAmt(1000.0);
        this.checkEntryAmt(5.0, 50.0, 500.0);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u6309\u91d1\u989d\u786e\u8ba4-\u4fee\u6539\u5206\u5f55\u6bd4\u4f8b\u6821\u9a8c\u6d4b\u8bd5")
    @Test
    public void amtTest() {
        this.model.setValue("confirmway", (Object)"AMOUNT");
        this.model.setValue("e_confirmamt", (Object)200, 0);
        this.model.setValue("e_confirmamt", (Object)200, 1);
        this.checkHeadAmt(400.0);
        this.checkEntryAmt(2.0, 20.0, 200.0);
        this.getView().updateView();
    }

    @TestMethod(value=6)
    @DisplayName(value="\u6267\u884c\u5355\u636e\u9875\u4fdd\u5b58-\u63d0\u4ea4-\u5ba1\u6838\u6d4b\u8bd5")
    @Test
    public void operationTest() {
        OperationResult opResult = this.arBillView.invokeOperation("save");
        AR004_ArRevCfmBasicTest.assertInvokeOperation((OperationResult)opResult);
        OperationResult submitOp = this.arBillView.invokeOperation("submit");
        AR004_ArRevCfmBasicTest.assertInvokeOperation((OperationResult)submitOp);
        OperationResult auditOp = this.arBillView.invokeOperation("audit");
        AR004_ArRevCfmBasicTest.assertInvokeOperation((OperationResult)auditOp);
        AR004_ArRevCfmBasicTest.assertEquals((Object)"C", (Object)this.model.getValue("billstatus"));
        this.checkHeadAmt(400.0);
        this.checkEntryAmt(2.0, 20.0, 200.0);
    }

    private void checkHeadAmt(double expectedAmt) {
        DynamicObject arRevCfm = this.model.getDataEntity();
        BigDecimal totalAmt = arRevCfm.getBigDecimal("amount");
        AR004_ArRevCfmBasicTest.assertEquals((Object)2000.0, (Object)totalAmt.doubleValue());
        BigDecimal totalLocalAmt = arRevCfm.getBigDecimal("localamt");
        AR004_ArRevCfmBasicTest.assertEquals((Object)2000.0, (Object)totalLocalAmt.doubleValue());
        BigDecimal totalConfirmAmt = arRevCfm.getBigDecimal("confirmamt");
        AR004_ArRevCfmBasicTest.assertEquals((Object)expectedAmt, (Object)totalConfirmAmt.doubleValue());
        BigDecimal totalConfirmLocalAmt = arRevCfm.getBigDecimal(CONFIRM_LOCAL_AMT);
        AR004_ArRevCfmBasicTest.assertEquals((Object)expectedAmt, (Object)totalConfirmLocalAmt.doubleValue());
        BigDecimal totalUnVeryAmt = arRevCfm.getBigDecimal("unverifyamt");
        AR004_ArRevCfmBasicTest.assertEquals((Object)expectedAmt, (Object)totalUnVeryAmt.doubleValue());
    }

    private void checkEntryAmt(double qty, double rate, double confirmAmt) {
        DynamicObjectCollection detailEntries = this.model.getEntryEntity(ENTRY);
        for (DynamicObject detailRow : detailEntries) {
            BigDecimal actualUnitPrice = detailRow.getBigDecimal("e_actunitprice");
            AR004_ArRevCfmBasicTest.assertEquals((Object)100.0, (Object)actualUnitPrice.doubleValue());
            BigDecimal amount = detailRow.getBigDecimal("e_amount");
            AR004_ArRevCfmBasicTest.assertEquals((Object)1000.0, (Object)amount.doubleValue());
            BigDecimal unVeryQty = detailRow.getBigDecimal("e_unverifyqty");
            AR004_ArRevCfmBasicTest.assertEquals((Object)qty, (Object)unVeryQty.doubleValue());
            BigDecimal unVeryAmt = detailRow.getBigDecimal("e_unverifyamt");
            AR004_ArRevCfmBasicTest.assertEquals((Object)confirmAmt, (Object)unVeryAmt.doubleValue());
            BigDecimal rowConfirmRate = detailRow.getBigDecimal(ENTRY_CONFIRM_RATE);
            AR004_ArRevCfmBasicTest.assertEquals((Object)rate, (Object)rowConfirmRate.doubleValue());
            BigDecimal rowConfirmAmt = detailRow.getBigDecimal("e_confirmamt");
            AR004_ArRevCfmBasicTest.assertEquals((Object)confirmAmt, (Object)rowConfirmAmt.doubleValue());
            BigDecimal rowConfirmQty = detailRow.getBigDecimal("e_confirmqty");
            AR004_ArRevCfmBasicTest.assertEquals((Object)qty, (Object)rowConfirmQty.doubleValue());
        }
    }
}

