/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.apfin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.api.param.AssignBillPushParam;
import kd.fi.arapcommon.api.param.ServiceNameEnum;
import kd.fi.arapcommon.api.push.IPushBillService;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.InvokeTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SimulatorTestHelper;
import org.junit.Test;

public class AP016_002_ApFinAdjustTest
extends AbstractJUnitTestPlugIn {
    private static final long sleepTime = 5000L;
    SimulatorTestHelper util = new SimulatorTestHelper(this);
    long sourceBillId;
    long adjustBillId;
    static String[] billNos = new String[]{"AP016_FINAP_002_1", "AP016_FINAP_002_ADJUST_2", "AP016_FINAP_002_ADJUST_3", "AP016_FINAP_002_4", "AP016_FINAP_002_ADJUST_5", "AP016_FINAP_002_6", "AP016_FINAP_002_ADJUST_7", "AP016_FINAP_002_ZBJ_6", "AP016_FINAP_002_ZBJ_4", "AP016_FINAP_002_0"};

    public void initData() {
        super.initData();
        DeleteServiceHelper.delete((String)"ap_finapbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
        DeleteServiceHelper.delete((String)"ap_settlerecord", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8\u5355-\u8c03\u589e\u4e0d\u81ea\u52a8\u7ed3\u7b97-\u6309\u7269\u6599\u884c\u8ba1\u7b97")
    @Test
    public void FinApBillUnitTest_001() throws InterruptedException {
        String sourceBillno = "AP016_FINAP_002_1";
        String adjustBillno = "AP016_FINAP_002_ADJUST_2";
        this.prepareSourceFinApBill(false, sourceBillno, false);
        DynamicObject adjustBill = this.prepareAdjustBill(sourceBillno, adjustBillno, BigDecimal.valueOf(-100L), BigDecimal.valueOf(-13L), BigDecimal.valueOf(-50L), BigDecimal.valueOf(-6.5), false);
        AP016_002_ApFinAdjustTest.assertEquals((String)"\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u6682\u5b58", (String)"A", (String)adjustBill.getString("billstatus"));
        AP016_002_ApFinAdjustTest.assertEquals((String)"\u662f\u5426\u501f\u8d37\u8c03\u6574\u4e0d\u4e3atrue", (boolean)true, (boolean)adjustBill.getBoolean("isadjust"));
        FinApBillTestChecker.validateApFinHeadAmt(adjustBill, BigDecimal.valueOf(-150L), BigDecimal.valueOf(-906.75), BigDecimal.valueOf(-19.5), BigDecimal.valueOf(-169.5), BigDecimal.valueOf(-1024.6275));
        DynamicObjectCollection entrys = adjustBill.getDynamicObjectCollection("detailentry");
        DynamicObject entry = (DynamicObject)entrys.get(0);
        FinApBillTestChecker.validateApFinDetailData((DynamicObject)entrys.get(0), ((DynamicObject)entrys.get(0)).getBigDecimal("quantity"), ((DynamicObject)entrys.get(0)).getBigDecimal("price"), BigDecimal.valueOf(-13L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-604.5), BigDecimal.valueOf(-113L), BigDecimal.valueOf(-683.085));
        FinApBillTestChecker.validateApFinDetailVerifyData(entry, entry.getBigDecimal("verifyquantity"), entry.getBigDecimal("unverifyquantity"), BigDecimal.ZERO, BigDecimal.valueOf(-100L));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(entry, BigDecimal.ZERO, BigDecimal.valueOf(-113L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-113L), BigDecimal.valueOf(-683.085));
        entry = (DynamicObject)entrys.get(1);
        FinApBillTestChecker.validateApFinDetailData(entry, entry.getBigDecimal("quantity"), entry.getBigDecimal("price"), BigDecimal.valueOf(-6.5), BigDecimal.valueOf(-50L), BigDecimal.valueOf(-302.25), BigDecimal.valueOf(-56.5), BigDecimal.valueOf(-341.5425));
        FinApBillTestChecker.validateApFinDetailVerifyData(entry, entry.getBigDecimal("verifyquantity"), entry.getBigDecimal("unverifyquantity"), BigDecimal.ZERO, BigDecimal.valueOf(-50L));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(entry, BigDecimal.ZERO, BigDecimal.valueOf(-56.5), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-56.5), BigDecimal.valueOf(-341.5425));
        OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])new Object[]{this.adjustBillId}, (OperateOption)OperateOption.create());
        OperationResult audit = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Object[]{this.adjustBillId}, (OperateOption)OperateOption.create());
        AP016_002_ApFinAdjustTest.assertEquals((String)("\u8c03\u6574\u5355\u672a\u5ba1\u6838,\u539f\u56e0\uff1a" + audit.getMessage()), (boolean)true, (boolean)audit.isSuccess());
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(79.1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(79.1), BigDecimal.valueOf(478.1595));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.ZERO, BigDecimal.valueOf(33.9), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(33.9), BigDecimal.valueOf(204.9255));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(113L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(113L), BigDecimal.valueOf(683.085));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-113L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-113L), BigDecimal.valueOf(-683.085));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.ZERO, BigDecimal.valueOf(-56.5), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-56.5), BigDecimal.valueOf(-341.5425));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-169.5), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-169.5), BigDecimal.valueOf(-1024.6275));
        SettleRecordTestChecker.checkNotExist(new Long[]{this.sourceBillId}, new Long[]{this.adjustBillId}, false);
        Thread.sleep(5000L);
        OperationResult unaudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Object[]{this.adjustBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(unaudit);
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(79.1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(79.1), BigDecimal.valueOf(478.1595));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.ZERO, BigDecimal.valueOf(33.9), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(33.9), BigDecimal.valueOf(204.9255));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(113L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(113L), BigDecimal.valueOf(683.085));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-113L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-113L), BigDecimal.valueOf(-683.085));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.ZERO, BigDecimal.valueOf(-56.5), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-56.5), BigDecimal.valueOf(-341.5425));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-169.5), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-169.5), BigDecimal.valueOf(-1024.6275));
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8\u5355-\u8c03\u51cf\u81ea\u52a8\u7ed3\u7b97-\u6309\u7269\u6599\u884c\u8ba1\u7b97")
    @Test
    public void FinApBillUnitTest_002() throws InterruptedException {
        String sourceBillno = "AP016_FINAP_002_0";
        String adjustBillno = "AP016_FINAP_002_ADJUST_3";
        this.prepareSourceFinApBill(false, sourceBillno, false);
        DynamicObject adjustBill = this.prepareAdjustBill(sourceBillno, adjustBillno, BigDecimal.valueOf(-50L), BigDecimal.valueOf(-0.4), BigDecimal.valueOf(-20L), BigDecimal.valueOf(-0.2), false);
        AP016_002_ApFinAdjustTest.assertEquals((String)"\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u6682\u5b58", (String)"A", (String)adjustBill.getString("billstatus"));
        AP016_002_ApFinAdjustTest.assertEquals((String)"\u662f\u5426\u501f\u8d37\u8c03\u6574\u4e0d\u4e3atrue", (boolean)true, (boolean)adjustBill.getBoolean("isadjust"));
        FinApBillTestChecker.validateApFinHeadAmt(adjustBill, BigDecimal.valueOf(-70L), BigDecimal.valueOf(-423.15), BigDecimal.valueOf(-0.6), BigDecimal.valueOf(-70.6), BigDecimal.valueOf(-426.777));
        FinApBillTestChecker.validateApFinHeadVerifyData(adjustBill, adjustBill.getString("verifystatus"), BigDecimal.valueOf(-70L));
        FinApBillTestChecker.validateApFinHeadSettleAmt(adjustBill, BigDecimal.valueOf(-70.6), BigDecimal.valueOf(-426.777), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection entrys = adjustBill.getDynamicObjectCollection("detailentry");
        DynamicObject entry = (DynamicObject)entrys.get(0);
        FinApBillTestChecker.validateApFinDetailData(entry, entry.getBigDecimal("quantity"), entry.getBigDecimal("price"), BigDecimal.valueOf(-0.4), BigDecimal.valueOf(-50L), BigDecimal.valueOf(-302.25), BigDecimal.valueOf(-50.4), BigDecimal.valueOf(-304.668));
        FinApBillTestChecker.validateApFinDetailVerifyData(entry, entry.getBigDecimal("verifyquantity"), entry.getBigDecimal("unverifyquantity"), BigDecimal.ZERO, BigDecimal.valueOf(-50L));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(entry, BigDecimal.ZERO, BigDecimal.valueOf(-50.4), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-50.4), BigDecimal.valueOf(-304.668));
        entry = (DynamicObject)entrys.get(1);
        FinApBillTestChecker.validateApFinDetailData(entry, entry.getBigDecimal("quantity"), entry.getBigDecimal("price"), BigDecimal.valueOf(-0.2), BigDecimal.valueOf(-20L), BigDecimal.valueOf(-120.9), BigDecimal.valueOf(-20.2), BigDecimal.valueOf(-122.109));
        FinApBillTestChecker.validateApFinDetailVerifyData(entry, entry.getBigDecimal("verifyquantity"), entry.getBigDecimal("unverifyquantity"), BigDecimal.ZERO, BigDecimal.valueOf(-20L));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(entry, BigDecimal.ZERO, BigDecimal.valueOf(-20.2), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-20.2), BigDecimal.valueOf(-122.109));
        OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])new Object[]{this.adjustBillId}, (OperateOption)OperateOption.create());
        OperationResult audit = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Object[]{this.adjustBillId}, (OperateOption)OperateOption.create());
        AP016_002_ApFinAdjustTest.assertEquals((String)("\u8c03\u6574\u5355\u672a\u5ba1\u6838,\u539f\u56e0\uff1a" + audit.getMessage()), (boolean)true, (boolean)audit.isSuccess());
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(50.4), BigDecimal.valueOf(28.7), BigDecimal.valueOf(50.4), BigDecimal.valueOf(304.668), BigDecimal.valueOf(28.7), BigDecimal.valueOf(173.4915));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.valueOf(20.2), BigDecimal.valueOf(13.7), BigDecimal.valueOf(20.2), BigDecimal.valueOf(122.109), BigDecimal.valueOf(13.7), BigDecimal.valueOf(82.8165));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(70.6), BigDecimal.valueOf(42.4), BigDecimal.valueOf(70.6), BigDecimal.valueOf(426.777), BigDecimal.valueOf(42.4), BigDecimal.valueOf(256.308));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(-50.4), BigDecimal.ZERO, BigDecimal.valueOf(-50.4), BigDecimal.valueOf(-304.668), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.valueOf(-20.2), BigDecimal.ZERO, BigDecimal.valueOf(-20.2), BigDecimal.valueOf(-122.109), BigDecimal.ZERO, BigDecimal.ZERO);
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(-70.6), BigDecimal.ZERO, BigDecimal.valueOf(-70.6), BigDecimal.valueOf(-426.777), BigDecimal.ZERO, BigDecimal.ZERO);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.sourceBillId}, new Long[]{this.adjustBillId}, false);
        Thread.sleep(5000L);
        OperationResult unaudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Object[]{this.adjustBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(unaudit);
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(79.1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(79.1), BigDecimal.valueOf(478.1595));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.ZERO, BigDecimal.valueOf(33.9), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(33.9), BigDecimal.valueOf(204.9255));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(113L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(113L), BigDecimal.valueOf(683.085));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-50.4), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-50.4), BigDecimal.valueOf(-304.668));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.ZERO, BigDecimal.valueOf(-20.2), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-20.2), BigDecimal.valueOf(-122.109));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-70.6), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-70.6), BigDecimal.valueOf(-426.777));
        SettleRecordTestChecker.checkNotExist(new Long[]{this.sourceBillId}, new Long[]{this.adjustBillId}, false);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8\u5355-\u8c03\u51cf\u81ea\u52a8\u7ed3\u7b97(\u542b\u8d28\u4fdd\u91d1)-\u6309\u8ba1\u5212\u884c\u7ed3\u7b97")
    public void FinApBillUnitTest_003() {
        String sourceBillno = "AP016_FINAP_002_4";
        String adjustBillno = "AP016_FINAP_002_ADJUST_5";
        this.prepareSourceFinApBill(true, sourceBillno, true);
        DynamicObject adjustBill = this.prepareAdjustBill(sourceBillno, adjustBillno, BigDecimal.valueOf(-63L), BigDecimal.valueOf(-0.63), BigDecimal.valueOf(-27L), BigDecimal.valueOf(-0.27), false);
        AP016_002_ApFinAdjustTest.assertEquals((String)"\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u6682\u5b58", (String)"A", (String)adjustBill.getString("billstatus"));
        AP016_002_ApFinAdjustTest.assertEquals((String)"\u662f\u5426\u501f\u8d37\u8c03\u6574\u4e0d\u4e3atrue", (boolean)true, (boolean)adjustBill.getBoolean("isadjust"));
        FinApBillTestChecker.validateApFinHeadAmt(adjustBill, BigDecimal.valueOf(-90L), BigDecimal.valueOf(-544.05), BigDecimal.valueOf(-0.9), BigDecimal.valueOf(-90.9), BigDecimal.valueOf(-549.4906));
        FinApBillTestChecker.validateApFinHeadVerifyData(adjustBill, adjustBill.getString("verifystatus"), BigDecimal.valueOf(-90L));
        FinApBillTestChecker.validateApFinHeadSettleAmt(adjustBill, BigDecimal.valueOf(-90.9), BigDecimal.valueOf(-549.4906), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection entrys = adjustBill.getDynamicObjectCollection("detailentry");
        DynamicObject entry = (DynamicObject)entrys.get(0);
        FinApBillTestChecker.validateApFinDetailData(entry, entry.getBigDecimal("quantity"), entry.getBigDecimal("price"), BigDecimal.valueOf(-0.63), BigDecimal.valueOf(-63L), BigDecimal.valueOf(-380.835), BigDecimal.valueOf(-63.63), BigDecimal.valueOf(-384.6434));
        FinApBillTestChecker.validateApFinDetailVerifyData(entry, entry.getBigDecimal("verifyquantity"), entry.getBigDecimal("unverifyquantity"), BigDecimal.ZERO, BigDecimal.valueOf(-63L));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(entry, BigDecimal.ZERO, BigDecimal.valueOf(-63.63), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-63.63), BigDecimal.valueOf(-384.6434));
        entry = (DynamicObject)entrys.get(1);
        FinApBillTestChecker.validateApFinDetailData(entry, entry.getBigDecimal("quantity"), entry.getBigDecimal("price"), BigDecimal.valueOf(-0.27), BigDecimal.valueOf(-27L), BigDecimal.valueOf(-163.215), BigDecimal.valueOf(-27.27), BigDecimal.valueOf(-164.8472));
        FinApBillTestChecker.validateApFinDetailVerifyData(entry, entry.getBigDecimal("verifyquantity"), entry.getBigDecimal("unverifyquantity"), BigDecimal.ZERO, BigDecimal.valueOf(-27L));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(entry, BigDecimal.ZERO, BigDecimal.valueOf(-27.27), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-27.27), BigDecimal.valueOf(-164.8472));
        OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])new Object[]{this.adjustBillId}, (OperateOption)OperateOption.create());
        OperationResult audit = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Object[]{this.adjustBillId}, (OperateOption)OperateOption.create());
        AP016_002_ApFinAdjustTest.assertEquals((String)("\u8c03\u6574\u5355\u672a\u5ba1\u6838,\u539f\u56e0\uff1a" + audit.getMessage()), (boolean)true, (boolean)audit.isSuccess());
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(71.54), BigDecimal.valueOf(7.56), BigDecimal.valueOf(71.54), BigDecimal.valueOf(432.4594), BigDecimal.valueOf(7.56), BigDecimal.valueOf(45.7001));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.valueOf(30.66), BigDecimal.valueOf(3.24), BigDecimal.valueOf(30.66), BigDecimal.valueOf(185.3396), BigDecimal.valueOf(3.24), BigDecimal.valueOf(19.5859));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(102.2), BigDecimal.valueOf(10.8), BigDecimal.valueOf(102.2), BigDecimal.valueOf(617.799), BigDecimal.valueOf(10.8), BigDecimal.valueOf(65.286));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(-63.63), BigDecimal.ZERO, BigDecimal.valueOf(-63.63), BigDecimal.valueOf(-384.6434), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.valueOf(-27.27), BigDecimal.ZERO, BigDecimal.valueOf(-27.27), BigDecimal.valueOf(-164.8472), BigDecimal.ZERO, BigDecimal.ZERO);
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(-90.9), BigDecimal.ZERO, BigDecimal.valueOf(-90.9), BigDecimal.valueOf(-549.4906), BigDecimal.ZERO, BigDecimal.ZERO);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.sourceBillId}, new Long[]{this.adjustBillId}, false);
        DynamicObject[] records = SettleRecordTestHelper.loadData(new Long[]{this.sourceBillId}, new Long[]{this.adjustBillId}, false);
        SettleRecordTestHelper.setIsVoucherToTrue(records);
        OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (DynamicObject[])records, (OperateOption)OperateOption.create());
        records = SettleRecordTestHelper.loadData(new Long[]{this.sourceBillId}, new Long[]{this.adjustBillId}, false);
        this.redRecordCheck(this.sourceBillId, this.adjustBillId);
        SettleRecordTestChecker.checkSettleAmtAndJournal(records);
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(7.91), BigDecimal.valueOf(71.19), BigDecimal.valueOf(7.91), BigDecimal.valueOf(47.816), BigDecimal.valueOf(71.19), BigDecimal.valueOf(430.3435));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.valueOf(3.39), BigDecimal.valueOf(30.51), BigDecimal.valueOf(3.39), BigDecimal.valueOf(20.4925), BigDecimal.valueOf(30.51), BigDecimal.valueOf(184.433));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(11.3), BigDecimal.valueOf(101.7), BigDecimal.valueOf(11.3), BigDecimal.valueOf(68.3085), BigDecimal.valueOf(101.7), BigDecimal.valueOf(614.7765));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-63.63), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-63.63), BigDecimal.valueOf(-384.6434));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.ZERO, BigDecimal.valueOf(-27.27), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-27.27), BigDecimal.valueOf(-164.8472));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-90.9), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-90.9), BigDecimal.valueOf(-549.4906));
        OperationResult unaudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Object[]{this.adjustBillId}, (OperateOption)OperateOption.create());
        AP016_002_ApFinAdjustTest.assertEquals((String)"\u8c03\u6574\u5355\u672a\u53cd\u5ba1\u6838", (boolean)true, (boolean)unaudit.isSuccess());
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(7.91), BigDecimal.valueOf(71.19), BigDecimal.valueOf(7.91), BigDecimal.valueOf(47.816), BigDecimal.valueOf(71.19), BigDecimal.valueOf(430.3435));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.valueOf(3.39), BigDecimal.valueOf(30.51), BigDecimal.valueOf(3.39), BigDecimal.valueOf(20.4925), BigDecimal.valueOf(30.51), BigDecimal.valueOf(184.433));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(11.3), BigDecimal.valueOf(101.7), BigDecimal.valueOf(11.3), BigDecimal.valueOf(68.3085), BigDecimal.valueOf(101.7), BigDecimal.valueOf(614.7765));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-63.63), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-63.63), BigDecimal.valueOf(-384.6434));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.ZERO, BigDecimal.valueOf(-27.27), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-27.27), BigDecimal.valueOf(-164.8472));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-90.9), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-90.9), BigDecimal.valueOf(-549.4906));
        this.redRecordCheck(this.sourceBillId, this.adjustBillId);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.sourceBillId}, new Long[]{this.adjustBillId}, false);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.sourceBillId}, new Long[]{AP016_002_ApFinAdjustTest.getPremium(this.sourceBillId).getLong("id")}, false);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8\u5355-\u8c03\u51cf\u81ea\u52a8\u7ed3\u7b97(\u542b\u8d28\u4fdd\u91d1)-\u6309\u7269\u6599\u884c\u7ed3\u7b97")
    public void FinApBillUnitTest_004() {
        String sourceBillno = "AP016_FINAP_002_6";
        String adjustBillno = "AP016_FINAP_002_ADJUST_7";
        this.prepareSourceFinApBill(false, sourceBillno, true);
        DynamicObject adjustBill = this.prepareAdjustBill(sourceBillno, adjustBillno, BigDecimal.valueOf(-40L), BigDecimal.ZERO, BigDecimal.valueOf(-30L), BigDecimal.ZERO, false);
        AP016_002_ApFinAdjustTest.assertEquals((String)"\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u6682\u5b58", (String)"A", (String)adjustBill.getString("billstatus"));
        AP016_002_ApFinAdjustTest.assertEquals((String)"\u662f\u5426\u501f\u8d37\u8c03\u6574\u4e0d\u4e3atrue", (boolean)true, (boolean)adjustBill.getBoolean("isadjust"));
        FinApBillTestChecker.validateApFinHeadAmt(adjustBill, BigDecimal.valueOf(-70L), BigDecimal.valueOf(-423.15), BigDecimal.ZERO, BigDecimal.valueOf(-70L), BigDecimal.valueOf(-423.15));
        FinApBillTestChecker.validateApFinHeadVerifyData(adjustBill, adjustBill.getString("verifystatus"), BigDecimal.valueOf(-70L));
        FinApBillTestChecker.validateApFinHeadSettleAmt(adjustBill, BigDecimal.valueOf(-70L), BigDecimal.valueOf(-423.15), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection entrys = adjustBill.getDynamicObjectCollection("detailentry");
        DynamicObject entry = (DynamicObject)entrys.get(0);
        FinApBillTestChecker.validateApFinDetailData(entry, entry.getBigDecimal("quantity"), entry.getBigDecimal("price"), BigDecimal.ZERO, BigDecimal.valueOf(-40L), BigDecimal.valueOf(-241.8), BigDecimal.valueOf(-40L), BigDecimal.valueOf(-241.8));
        FinApBillTestChecker.validateApFinDetailVerifyData(entry, entry.getBigDecimal("verifyquantity"), entry.getBigDecimal("unverifyquantity"), BigDecimal.ZERO, BigDecimal.valueOf(-40L));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(entry, BigDecimal.ZERO, BigDecimal.valueOf(-40L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-40L), BigDecimal.valueOf(-241.8));
        entry = (DynamicObject)entrys.get(1);
        FinApBillTestChecker.validateApFinDetailData(entry, entry.getBigDecimal("quantity"), entry.getBigDecimal("price"), BigDecimal.ZERO, BigDecimal.valueOf(-30L), BigDecimal.valueOf(-181.35), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-181.35));
        FinApBillTestChecker.validateApFinDetailVerifyData(entry, entry.getBigDecimal("verifyquantity"), entry.getBigDecimal("unverifyquantity"), BigDecimal.ZERO, BigDecimal.valueOf(-30L));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(entry, BigDecimal.ZERO, BigDecimal.valueOf(-30L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-30L), BigDecimal.valueOf(-181.35));
        this.getView().close();
        OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])new Object[]{this.adjustBillId}, (OperateOption)OperateOption.create());
        OperationResult audit = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Object[]{this.adjustBillId}, (OperateOption)OperateOption.create());
        AP016_002_ApFinAdjustTest.assertEquals((String)("\u8c03\u6574\u5355\u672a\u5ba1\u6838,\u539f\u56e0\uff1a" + audit.getMessage()), (boolean)true, (boolean)audit.isSuccess());
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(47.91), BigDecimal.valueOf(31.19), BigDecimal.valueOf(47.91), BigDecimal.valueOf(289.616), BigDecimal.valueOf(31.19), BigDecimal.valueOf(188.5435));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.valueOf(33.39), BigDecimal.valueOf(0.51), BigDecimal.valueOf(33.39), BigDecimal.valueOf(201.8426), BigDecimal.valueOf(0.51), BigDecimal.valueOf(3.0829));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(81.3), BigDecimal.valueOf(31.7), BigDecimal.valueOf(81.3), BigDecimal.valueOf(491.4586), BigDecimal.valueOf(31.7), BigDecimal.valueOf(191.6264));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(-40L), BigDecimal.ZERO, BigDecimal.valueOf(-40L), BigDecimal.valueOf(-241.8), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.valueOf(-30L), BigDecimal.ZERO, BigDecimal.valueOf(-30L), BigDecimal.valueOf(-181.35), BigDecimal.ZERO, BigDecimal.ZERO);
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(-70L), BigDecimal.ZERO, BigDecimal.valueOf(-70L), BigDecimal.valueOf(-423.15), BigDecimal.ZERO, BigDecimal.ZERO);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.sourceBillId}, new Long[]{this.adjustBillId}, false);
        DynamicObject[] records = SettleRecordTestHelper.loadData(new Long[]{this.sourceBillId}, new Long[]{this.adjustBillId}, false);
        SettleRecordTestHelper.setIsVoucherToTrue(records);
        OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (DynamicObject[])records, (OperateOption)OperateOption.create());
        records = SettleRecordTestHelper.loadData(new Long[]{this.sourceBillId}, new Long[]{this.adjustBillId}, false);
        this.redRecordCheck(this.sourceBillId, this.adjustBillId);
        SettleRecordTestChecker.checkSettleAmtAndJournal(records);
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(7.91), BigDecimal.valueOf(71.19), BigDecimal.valueOf(7.91), BigDecimal.valueOf(47.816), BigDecimal.valueOf(71.19), BigDecimal.valueOf(430.3435));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.valueOf(3.39), BigDecimal.valueOf(30.51), BigDecimal.valueOf(3.39), BigDecimal.valueOf(20.4926), BigDecimal.valueOf(30.51), BigDecimal.valueOf(184.4329));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(11.3), BigDecimal.valueOf(101.7), BigDecimal.valueOf(11.3), BigDecimal.valueOf(68.3085), BigDecimal.valueOf(101.7), BigDecimal.valueOf(614.7765));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-40L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-40L), BigDecimal.valueOf(-241.8));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.ZERO, BigDecimal.valueOf(-30L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-30L), BigDecimal.valueOf(-181.35));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-70L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-70L), BigDecimal.valueOf(-423.15));
        OperationResult unaudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Object[]{this.adjustBillId}, (OperateOption)OperateOption.create());
        AP016_002_ApFinAdjustTest.assertEquals((String)"\u8c03\u6574\u5355\u672a\u53cd\u5ba1\u6838", (boolean)true, (boolean)unaudit.isSuccess());
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(7.91), BigDecimal.valueOf(71.19), BigDecimal.valueOf(7.91), BigDecimal.valueOf(47.816), BigDecimal.valueOf(71.19), BigDecimal.valueOf(430.3435));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.valueOf(3.39), BigDecimal.valueOf(30.51), BigDecimal.valueOf(3.39), BigDecimal.valueOf(20.4926), BigDecimal.valueOf(30.51), BigDecimal.valueOf(184.4329));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.sourceBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.valueOf(11.3), BigDecimal.valueOf(101.7), BigDecimal.valueOf(11.3), BigDecimal.valueOf(68.3085), BigDecimal.valueOf(101.7), BigDecimal.valueOf(614.7765));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-40L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-40L), BigDecimal.valueOf(-241.8));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)entrys.get(1), BigDecimal.ZERO, BigDecimal.valueOf(-30L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-30L), BigDecimal.valueOf(-181.35));
        entrys = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill").getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-70L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-70L), BigDecimal.valueOf(-423.15));
        this.redRecordCheck(this.sourceBillId, this.adjustBillId);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.sourceBillId}, new Long[]{this.adjustBillId}, false);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.sourceBillId}, new Long[]{AP016_002_ApFinAdjustTest.getPremium(this.sourceBillId).getLong("id")}, false);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8\u5355-\u603b\u989d\u8c03\u6574\u63a5\u53e3\u662f\u5426\u53ef\u4ee5\u6b63\u5e38\u751f\u6210\u5355\u636e")
    @Test
    public void meterialEntryDispose_blue() {
        DynamicObject finApBill = FinApBillTestDataProvider.buildByHeadPriceTaxTotal("testServiceAdjust_ap_1", BigDecimal.valueOf(100L));
        Long apPk = finApBill.getLong("id");
        ArrayList<AssignBillPushParam> paramList = new ArrayList<AssignBillPushParam>(2);
        HashMap<String, String> pushMapArgs = new HashMap<String, String>();
        pushMapArgs.put("adjusttype", "buckle");
        pushMapArgs.put("adjusttotalamt", "-30");
        pushMapArgs.put("adjusttotaltaxamt", "-40");
        AssignBillPushParam param = new AssignBillPushParam(apPk);
        param.setAdjustPushArgsMap(pushMapArgs);
        paramList.add(param);
        IPushBillService service = ArApServiceAPIFactory.getPushBillService(ServiceNameEnum.PUSHFINADJUSTAP.getValue());
        List<Object> targetPKs = service.assignBillPush("ap_finapbill", paramList, "646082310541694976");
        if (targetPKs.size() > 1) {
            AP016_002_ApFinAdjustTest.assertEquals((boolean)true, (boolean)true);
        }
    }

    private void redRecordCheck(long mainId, long asstId) {
        DynamicObject[] records = SettleRecordTestHelper.loadData(new Long[]{mainId}, new Long[]{asstId}, false);
        int notRedCount = 0;
        for (DynamicObject record : records) {
            if (!record.getBoolean("hadwrittenoff")) continue;
            ++notRedCount;
        }
        AP016_002_ApFinAdjustTest.assertEquals((String)"\u7ea2\u51b2\u7ed3\u7b97\u8bb0\u5f55\u672a\u751f\u6210", (boolean)true, (records.length == notRedCount * 2 ? 1 : 0) != 0);
    }

    public void prepareSourceFinApBill(boolean isPlanOrg, String billNo, boolean isPremiu) {
        IFormView addView = this.util.clickBarItemReturnChildView((IFormView)((IListView)this.getView()), "tblnew", "new");
        AP016_002_ApFinAdjustTest.assertEquals((String)"\u8d22\u52a1\u5e94\u4ed8\u5355:\u8c03\u6574\u6267\u884c\u5931\u8d25,\u65b0\u589e\u9875\u9762\u5c55\u5f00\u5f02\u5e38.", (boolean)true, (addView != null ? 1 : 0) != 0);
        IDataModel model = addView.getModel();
        String remark = "\u8d22\u52a1\u5e94\u4ed8\u5355\u5355\u5143\u6d4b\u8bd5\u7528\u4f8b-\u8c03\u6574";
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        if (isPlanOrg) {
            org = BaseDataTestProvider.getPlanInitOrg();
            model.setValue("payorg", org.getPkValue());
        }
        if (isPremiu) {
            model.setValue("premiumamt", (Object)BigDecimal.valueOf(11.3));
            model.setValue("premiumrate", (Object)10);
        }
        model.setValue("org", org.getPkValue());
        model.setValue("payorg", org.getPkValue());
        model.setValue("basecurrency", BaseDataTestProvider.getCurrencyCNY().getPkValue());
        model.setValue("asstact", BaseDataTestProvider.getSupplier().getPkValue());
        model.setValue("payproperty", BaseDataTestProvider.getPayProperty().getPkValue());
        model.setValue("currency", BaseDataTestProvider.getCurrencyUSD().getPkValue());
        model.setValue("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        model.setValue("exchangerate", (Object)6.045);
        model.setValue("quotation", (Object)0);
        model.setValue("remark", (Object)remark);
        model.setValue("material", BaseDataTestProvider.getMaterial().getPkValue(), 0);
        model.setValue("price", (Object)new BigDecimal(70), 0);
        model.setValue("taxrateid", BaseDataTestProvider.getTaxRate().getPkValue(), 0);
        String param = "[{\"key\":\"advcontoolbarap\",\"methodName\":\"itemClick\",\"args\":[\"newentry\",\"newdetailentry\"],\"postData\":[{},[]]}]";
        InvokeTestHelper.invokeAction(addView, param, this);
        model.setValue("material", BaseDataTestProvider.getMaterial().getPkValue(), 1);
        model.setValue("price", (Object)new BigDecimal(30), 1);
        model.setValue("taxrateid", BaseDataTestProvider.getTaxRate().getPkValue(), 1);
        OperationResult result = addView.invokeOperation("submit");
        AP016_002_ApFinAdjustTest.assertInvokeOperation((OperationResult)result);
        result = addView.invokeOperation("audit");
        AP016_002_ApFinAdjustTest.assertInvokeOperation((OperationResult)result);
        addView.close();
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)model.getValue("id"), (DynamicObjectType)model.getDataEntityType());
        this.sourceBillId = (Long)finApBill.getPkValue();
        finApBill.set("billno", (Object)billNo);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finApBill});
        finApBill = BusinessDataServiceHelper.loadSingle((Object)model.getValue("id"), (DynamicObjectType)model.getDataEntityType());
        AP016_002_ApFinAdjustTest.assertEquals((String)"\u6e90\u8d22\u52a1\u5e94\u4ed8\u5355\u672a\u5ba1\u6838", (String)"C", (String)finApBill.getString("billstatus"));
        if (isPremiu) {
            DynamicObject premiumBill = AP016_002_ApFinAdjustTest.getPremium(this.sourceBillId);
            OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])new Object[]{premiumBill.getLong("id")}, (OperateOption)OperateOption.create());
            OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Object[]{premiumBill.getLong("id")}, (OperateOption)OperateOption.create());
            premiumBill = BusinessDataServiceHelper.loadSingle((Object)premiumBill.get("id"), (String)"ap_finapbill");
            AP016_002_ApFinAdjustTest.assertEquals((String)"\u8d28\u4fdd\u91d1\u672a\u5ba1\u6838", (String)"C", (String)premiumBill.getString("billstatus"));
            premiumBill.set("billno", (Object)(billNo.substring(0, billNo.length() - 2) + "_ZBJ" + billNo.substring(billNo.length() - 2)));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{premiumBill});
        }
    }

    private DynamicObject prepareAdjustBill(String sourceBillno, String adjustBillno, BigDecimal eAmount0, BigDecimal eTax0, BigDecimal eAmount1, BigDecimal eTax1, boolean isUp) {
        FinApBillTestHelper.searchOneRowDataByBillNo(this, sourceBillno);
        IFormView adjustView = this.util.clickBarItemReturnChildView(this.getView(), "toolbarap", "tbladjust", "billmodify");
        IDataModel model = adjustView.getModel();
        model.setValue("e_amount", (Object)eAmount0, 0);
        model.setValue("expenseitem", (Object)BaseDataTestProvider.getExpenseItem(), 0);
        model.setValue("e_tax", (Object)eTax0, 0);
        model.setValue("e_amount", (Object)eAmount1, 1);
        model.setValue("e_tax", (Object)eTax1, 1);
        model.setValue("expenseitem", (Object)BaseDataTestProvider.getExpenseItem(), 1);
        if (isUp) {
            model.setValue("adjusttype", (Object)"overdue");
        } else {
            model.setValue("adjusttype", (Object)"buckle");
        }
        this.getView().updateView();
        adjustView.invokeOperation("save");
        this.adjustBillId = (Long)model.getDataEntity().getPkValue();
        DynamicObject adjustBill = BusinessDataServiceHelper.loadSingle((Object)this.adjustBillId, (String)"ap_finapbill");
        adjustBill.set("billno", (Object)adjustBillno);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjustBill});
        adjustView.close();
        return adjustBill;
    }

    public static DynamicObject getPremium(long sourceBillId) {
        QFilter q1 = new QFilter("sourcebillid", "=", (Object)sourceBillId);
        QFilter q2 = new QFilter("ispremium", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.queryOne((String)"ap_finapbill", (String)"id,billno,billstatus", (QFilter[])new QFilter[]{q1.and(q2)});
    }
}

