/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.apfin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SimulatorTestHelper;
import org.junit.Test;

public class AP016_003_ApFinTransPayTest
extends AbstractJUnitTestPlugIn {
    private SimulatorTestHelper util = new SimulatorTestHelper(this);
    private IListView listView = null;

    public void initData() {
        super.initData();
        this.listView = (IListView)this.getView();
        FinApBillTestHelper.selectInitOrg(this, BaseDataTestProvider.getDetailInitOrg().getLong("id"));
        ConfigCache.put("ap_stdconfig", "isTransferasSaved", "false");
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8\u5355-\u6309\u884c\u8f6c\u4ed8\uff08\u7269\u6599\u884c\uff09")
    @Test
    public void ApFinUnitTest_003_1() throws InterruptedException {
        DynamicObject srcBill = FinApBillTestDataProvider.createFinApBill(false, true, false, true, "AP016_003_apfin_1");
        long srcPk = srcBill.getLong("id");
        FinApBillTestHelper.searchOneRowDataByBillNo(this, "AP016_003_apfin_1");
        FinApBillTestHelper.turnPayByRow(this);
        Long transBillId = this.validateExistTransBill(srcPk, 1).get(0);
        DynamicObject transBill = BusinessDataServiceHelper.loadSingle((Object)transBillId, (String)"ap_finapbill");
        this.validateTransBillByRow(transBill);
        srcBill = BusinessDataServiceHelper.loadSingle((Object)srcPk, (String)"ap_finapbill");
        this.validateSrcBillByRow(srcBill, transBillId, false);
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{transBillId}, (OperateOption)option);
        FinApBillTestChecker.validateApFinJournalData(BusinessDataServiceHelper.loadSingle((Object)transBillId, (String)"ap_finapbill"));
        srcBill = BusinessDataServiceHelper.loadSingle((Object)srcPk, (String)"ap_finapbill");
        this.validateSrcBillByRow(srcBill, transBillId, true);
        Thread.sleep(1000L);
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{transBillId}, (OperateOption)option);
        OperationHelper.assertResult(result);
        srcBill = BusinessDataServiceHelper.loadSingle((Object)srcPk, (String)"ap_finapbill");
        this.validateSrcBillByRow(srcBill, transBillId, false);
        OperationServiceHelper.executeOperate((String)"delete", (String)"ap_finapbill", (Object[])new Long[]{transBillId}, (OperateOption)option);
        srcBill = BusinessDataServiceHelper.loadSingle((Object)srcPk, (String)"ap_finapbill");
        FinApBillTestChecker.validateInitialApFin(srcBill);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8\u5355-\u6574\u5355\u8f6c\u4ed8(\u4e00\u5bf9\u4e00\uff0c\u7269\u6599\u884c)")
    @Test
    public void ApFinUnitTest_003_2() throws InterruptedException {
        DynamicObject srcBill = FinApBillTestDataProvider.createFinApBill(false, true, "AP016_003_apfin_2");
        long srcPk = srcBill.getLong("id");
        FinApBillTestHelper.searchOneRowDataByBillNo(this, "AP016_003_apfin_2");
        IFormView turnPayView = this.util.clickBarItemReturnChildView((IFormView)this.listView, "transferall", "transferall");
        IDataModel turnPayModel = turnPayView.getModel();
        turnPayModel.setValue("head_exchangerate", (Object)BigDecimal.valueOf(5L));
        turnPayModel.setValue("t_asstact", (Object)BaseDataTestProvider.getSupplier(), 0);
        turnPayModel.setValue("t_payproperty", (Object)BaseDataTestProvider.getPayProperty(), 0);
        turnPayModel.setValue("transamount", (Object)BigDecimal.valueOf(90L), 0);
        turnPayModel.setValue("transtax", (Object)BigDecimal.valueOf(10L), 0);
        AP016_003_ApFinTransPayTest.assertEquals((String)"\u7b2c\u4e00\u884c\u8f6c\u4ed8\u5e94\u4ed8\u91d1\u989d\u4e0d\u7b49\u4e8e\u8f6c\u4ed8\u91d1\u989d+\u8f6c\u4ed8\u7a0e\u989d", (int)0, (int)BigDecimal.valueOf(100L).compareTo((BigDecimal)turnPayModel.getValue("transpricetaxtotal")));
        turnPayView.invokeOperation("transferall");
        Long transBillId = this.validateExistTransBill(srcPk, 1).get(0);
        DynamicObject transBill = BusinessDataServiceHelper.loadSingle((Object)transBillId, (String)"ap_finapbill");
        this.validateTransBillByBill(transBill);
        srcBill = BusinessDataServiceHelper.loadSingle((Object)srcPk, (String)"ap_finapbill");
        this.validateSrcBillByBill(srcBill, transBillId, false);
        OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{transBillId}, (OperateOption)OperateOption.create());
        FinApBillTestChecker.validateApFinJournalData(BusinessDataServiceHelper.loadSingle((Object)transBillId, (String)"ap_finapbill"));
        srcBill = BusinessDataServiceHelper.loadSingle((Object)srcPk, (String)"ap_finapbill");
        this.validateSrcBillByBill(srcBill, transBillId, true);
        Thread.sleep(1000L);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{transBillId}, (OperateOption)OperateOption.create());
        srcBill = BusinessDataServiceHelper.loadSingle((Object)srcPk, (String)"ap_finapbill");
        this.validateSrcBillByBill(srcBill, transBillId, false);
        OperationServiceHelper.executeOperate((String)"delete", (String)"ap_finapbill", (Object[])new Long[]{transBillId}, (OperateOption)OperateOption.create());
        srcBill = BusinessDataServiceHelper.loadSingle((Object)srcPk, (String)"ap_finapbill");
        FinApBillTestChecker.validateInitialApFin(srcBill);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8\u5355-\u6574\u5355\u8f6c\u4ed8(\u4e00\u5bf9\u591a,\u8ba1\u5212\u884c)")
    @Test
    public void ApFinUnitTest_003_3() throws InterruptedException {
        DynamicObject srcBill = FinApBillTestDataProvider.createFinApBill(true, false, "AP016_003_apfin_3");
        long srcPk = srcBill.getLong("id");
        FinApBillTestHelper.searchOneRowDataByBillNo(this, "AP016_003_apfin_3");
        IFormView turnPayView = this.util.clickBarItemReturnChildView((IFormView)this.listView, "transferall", "transferall");
        IDataModel turnPayModel = turnPayView.getModel();
        turnPayModel.setValue("t_asstact", (Object)BaseDataTestProvider.getSupplier(), 0);
        turnPayModel.setValue("t_payproperty", (Object)BaseDataTestProvider.getPayProperty(), 0);
        turnPayModel.setValue("transamount", (Object)BigDecimal.valueOf(40L), 0);
        turnPayModel.setValue("transtax", (Object)BigDecimal.valueOf(10L), 0);
        this.util.invokeAction(turnPayView, "[{\"key\":\"advcontoolbarap\",\"methodName\":\"itemClick\",\"args\":[\"newentry\",\"newentry\"],\"postData\":[{},[]]}]");
        turnPayModel.setValue("t_asstact", (Object)BaseDataTestProvider.getSupplier(), 1);
        turnPayModel.setValue("t_payproperty", (Object)BaseDataTestProvider.getPayProperty(), 1);
        turnPayModel.setValue("transamount", (Object)BigDecimal.valueOf(50L), 1);
        turnPayModel.setValue("transpricetaxtotal", (Object)BigDecimal.valueOf(50L), 1);
        turnPayView.invokeOperation("transferall");
        List<Long> transBillIds = this.validateExistTransBill(srcPk, 2);
        long transBillOnePk = this.getTransBillOne(transBillIds);
        long transBillTwoPk = transBillIds.stream().filter(billId -> billId != transBillOnePk).findFirst().get();
        srcBill = BusinessDataServiceHelper.loadSingle((Object)srcPk, (String)"ap_finapbill");
        this.validateSrcByBillOne2More(srcBill, transBillOnePk, "30");
        OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{transBillOnePk}, (OperateOption)OperateOption.create());
        srcBill = BusinessDataServiceHelper.loadSingle((Object)srcPk, (String)"ap_finapbill");
        this.validateSrcByBillOne2More(srcBill, transBillOnePk, "10");
        FinApBillTestChecker.validateApFinJournalData(BusinessDataServiceHelper.loadSingle((Object)transBillOnePk, (String)"ap_finapbill"));
        OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{transBillTwoPk}, (OperateOption)OperateOption.create());
        srcBill = BusinessDataServiceHelper.loadSingle((Object)srcPk, (String)"ap_finapbill");
        FinApBillTestChecker.validateApFinJournalData(BusinessDataServiceHelper.loadSingle((Object)transBillTwoPk, (String)"ap_finapbill"));
        this.validateSrcByBillOne2More(srcBill, transBillOnePk, "20");
        Thread.sleep(1000L);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{transBillOnePk, transBillTwoPk}, (OperateOption)OperateOption.create());
        srcBill = BusinessDataServiceHelper.loadSingle((Object)srcPk, (String)"ap_finapbill");
        this.validateSrcByBillOne2More(srcBill, transBillOnePk, "30");
        OperationServiceHelper.executeOperate((String)"delete", (String)"ap_finapbill", (Object[])new Long[]{transBillOnePk, transBillTwoPk}, (OperateOption)OperateOption.create());
        srcBill = BusinessDataServiceHelper.loadSingle((Object)srcPk, (String)"ap_finapbill");
        FinApBillTestChecker.validateInitialApFin(srcBill);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u6e05\u7a7a\u53c2\u6570")
    @Test
    public void clear_args_4() {
        ConfigCache.clear();
        AP016_003_ApFinTransPayTest.assertEquals((boolean)true, (boolean)true);
    }

    private void validateSrcByBillOne2More(DynamicObject srcBill, long transBillId, String args) {
        DynamicObjectCollection detailEntry = srcBill.getDynamicObjectCollection("detailentry");
        DynamicObjectCollection planEntity = srcBill.getDynamicObjectCollection("planentity");
        if ("10".equals(args)) {
            AP016_003_ApFinTransPayTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u90e8\u5206\u7ed3\u7b97", (String)"partsettle", (String)srcBill.getString("settlestatus"));
            FinApBillTestChecker.validateApFinHeadSettleAmt(srcBill, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
            FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)detailEntry.get(0), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
            FinApBillTestChecker.validateApFinPlanSettleAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
            SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{srcBill.getLong("id")}, new Long[]{transBillId}, false);
        } else if ("20".equals(args)) {
            FinApBillTestChecker.validateFinishApFin(srcBill, true, false);
            SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{srcBill.getLong("id")}, new Long[]{transBillId}, false);
        } else if ("30".equals(args)) {
            AP016_003_ApFinTransPayTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u672a\u7ed3\u7b97", (String)"unsettle", (String)srcBill.getString("settlestatus"));
            FinApBillTestChecker.validateApFinHeadSettleAmt(srcBill, BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO);
            FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)detailEntry.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.valueOf(100L));
            FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)detailEntry.get(0), BigDecimal.valueOf(100L), BigDecimal.ZERO);
            FinApBillTestChecker.validateApFinPlanSettleAmt((DynamicObject)planEntity.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.valueOf(100L));
            FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(100L), BigDecimal.ZERO);
        }
    }

    private void validateTransBillByBill(DynamicObject transBill) {
        AP016_003_ApFinTransPayTest.assertEquals((String)"\u8f6c\u4ed8\u5355\u975e\u63d0\u4ea4\u6001", (String)"B", (String)transBill.getString("billstatus"));
        FinApBillTestChecker.validateApFinHeadAmt(transBill, BigDecimal.valueOf(90L), BigDecimal.valueOf(450.0), BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(500.0));
        FinApBillTestChecker.validateApFinHeadSettleAmt(transBill, BigDecimal.valueOf(100L), BigDecimal.valueOf(500.0), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection detailEntry = transBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailData((DynamicObject)detailEntry.get(0), BigDecimal.ONE, BigDecimal.valueOf(90L), BigDecimal.valueOf(10L), BigDecimal.valueOf(90L), BigDecimal.valueOf(450.0), BigDecimal.valueOf(100L), BigDecimal.valueOf(500L));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(0), BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntity = transBill.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanEntry((DynamicObject)planEntity.get(0), BigDecimal.valueOf(100L), BigDecimal.valueOf(500L), BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.valueOf(500L));
    }

    private void validateSrcBillByBill(DynamicObject srcBill, long transBillId, boolean isAudit) {
        if (isAudit) {
            FinApBillTestChecker.validateFinishApFin(srcBill, true, false);
            SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{srcBill.getLong("id")}, new Long[]{transBillId}, false);
        } else {
            AP016_003_ApFinTransPayTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u672a\u7ed3\u7b97", (String)"unsettle", (String)srcBill.getString("settlestatus"));
            FinApBillTestChecker.validateApFinHeadSettleAmt(srcBill, BigDecimal.valueOf(100L), BigDecimal.valueOf(604.5), BigDecimal.ZERO, BigDecimal.ZERO);
            DynamicObjectCollection detailEntry = srcBill.getDynamicObjectCollection("detailentry");
            FinApBillTestChecker.validateApFinDetailData((DynamicObject)detailEntry.get(0), BigDecimal.ONE, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.valueOf(604.5), BigDecimal.valueOf(100L), BigDecimal.valueOf(604.5));
            FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(0), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.valueOf(604.5));
            DynamicObjectCollection planEntity = srcBill.getDynamicObjectCollection("planentity");
            FinApBillTestChecker.validateApFinPlanEntry((DynamicObject)planEntity.get(0), BigDecimal.valueOf(100L), BigDecimal.valueOf(604.5), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.valueOf(604.5));
        }
    }

    private void validateTransBillByRow(DynamicObject transBill) {
        AP016_003_ApFinTransPayTest.assertEquals((String)"\u8f6c\u4ed8\u5355\u975e\u63d0\u4ea4\u6001", (String)"B", (String)transBill.getString("billstatus"));
        FinApBillTestChecker.validateApFinHeadAmt(transBill, BigDecimal.valueOf(40L), BigDecimal.valueOf(40L), BigDecimal.valueOf(5.0), BigDecimal.valueOf(45L), BigDecimal.valueOf(45L));
        FinApBillTestChecker.validateApFinHeadSettleAmt(transBill, BigDecimal.valueOf(45L), BigDecimal.valueOf(45L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection detailEntry = transBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailData((DynamicObject)detailEntry.get(0), BigDecimal.valueOf(2L), BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), BigDecimal.valueOf(15L), BigDecimal.valueOf(15L));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(0), BigDecimal.ZERO, BigDecimal.valueOf(15L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(15L), BigDecimal.valueOf(15L));
        FinApBillTestChecker.validateApFinDetailData((DynamicObject)detailEntry.get(1), BigDecimal.ONE, BigDecimal.valueOf(30L), BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(1), BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObjectCollection planEntity = transBill.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanEntry((DynamicObject)planEntity.get(0), BigDecimal.valueOf(45L), BigDecimal.valueOf(45L), BigDecimal.ZERO, BigDecimal.valueOf(45L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(45L), BigDecimal.valueOf(45L));
    }

    private void validateSrcBillByRow(DynamicObject srcBill, long transBillId, boolean isAudit) {
        if (isAudit) {
            AP016_003_ApFinTransPayTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u90e8\u5206\u7ed3\u7b97", (String)"partsettle", (String)srcBill.getString("settlestatus"));
            FinApBillTestChecker.validateApFinHeadSettleAmt(srcBill, BigDecimal.valueOf(55L), BigDecimal.valueOf(55L), BigDecimal.valueOf(45L), BigDecimal.valueOf(45L));
        } else {
            AP016_003_ApFinTransPayTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u672a\u7ed3\u7b97", (String)"unsettle", (String)srcBill.getString("settlestatus"));
            FinApBillTestChecker.validateApFinHeadSettleAmt(srcBill, BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO);
        }
        DynamicObjectCollection detailEntry = srcBill.getDynamicObjectCollection("detailentry");
        if (isAudit) {
            FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(0), BigDecimal.valueOf(15L), BigDecimal.valueOf(55L), BigDecimal.valueOf(15.0), BigDecimal.valueOf(15.0), BigDecimal.valueOf(55L), BigDecimal.valueOf(55L));
            FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(1), BigDecimal.valueOf(30L), BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.ZERO, BigDecimal.ZERO);
        } else {
            FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(0), BigDecimal.valueOf(15L), BigDecimal.valueOf(55L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(70L), BigDecimal.valueOf(70L));
            FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(1), BigDecimal.valueOf(30L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        }
        DynamicObjectCollection planEntity = srcBill.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(45L), BigDecimal.valueOf(25L));
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(1), BigDecimal.ZERO, BigDecimal.valueOf(30L));
        if (isAudit) {
            FinApBillTestChecker.validateApFinPlanSettleAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(45L), BigDecimal.valueOf(45L), BigDecimal.valueOf(25L), BigDecimal.valueOf(25L));
            FinApBillTestChecker.validateApFinPlanSettleAmt((DynamicObject)planEntity.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        } else {
            FinApBillTestChecker.validateApFinPlanSettleAmt((DynamicObject)planEntity.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(70L), BigDecimal.valueOf(70L));
            FinApBillTestChecker.validateApFinPlanSettleAmt((DynamicObject)planEntity.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        }
        if (isAudit) {
            SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{srcBill.getLong("id")}, new Long[]{transBillId}, false);
        }
    }

    private List<Long> validateExistTransBill(Long srcBillId, int quantity) {
        QFilter filter = new QFilter("sourcebillid", "=", (Object)srcBillId);
        filter.and("istanspay", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection transBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id", (QFilter[])new QFilter[]{filter});
        AP016_003_ApFinTransPayTest.assertEquals((String)"\u672a\u751f\u6210\u8f6c\u4ed8\u5355\u6216\u751f\u6210\u8f6c\u4ed8\u5355\u6570\u91cf\u4e0d\u5bf9", (boolean)true, (transBills.size() == quantity ? 1 : 0) != 0);
        if (quantity == 1) {
            return Collections.singletonList(((DynamicObject)transBills.get(0)).getLong("id"));
        }
        return Arrays.asList(((DynamicObject)transBills.get(0)).getLong("id"), ((DynamicObject)transBills.get(1)).getLong("id"));
    }

    private long getTransBillOne(List<Long> transBillIds) {
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"ap_finapbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", transBillIds), new QFilter("tax", "!=", (Object)BigDecimal.ZERO)});
        return queryOne.getLong("id");
    }
}

