/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.apfin;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import org.junit.Test;

public class AP016_004_ApFinPremiumTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        HashMap<String, Object> paramMap1 = new HashMap<String, Object>(4);
        paramMap1.put("ap_auditpre", false);
        SystemParameterHelper.setSystemParameter(false, BaseDataTestProvider.getPlanInitOrg().getLong("id"), paramMap1);
        SystemParameterHelper.setSystemParameter(false, BaseDataTestProvider.getDetailInitOrg().getLong("id"), paramMap1);
        ThreadCache.clear();
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u8d22\u52a1\u5e94\u4ed8\uff08\u8d28\u4fdd\u91d1\uff09(\u7269\u6599\u884c\u7ed3\u7b97\u6b63\u8d1f\u5206\u5f55\u5f02\u5e01\u522b\u590d\u6742\u6570\u636e)")
    @Test
    public void ApFinUnitTest_004_1() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApPremiumBill("AP016_004_apfin_1", true, true);
        long srcBillId = finBill.getLong("id");
        long premiumBillId = FinApBillTestHelper.getPremiumBillId(srcBillId);
        finBill = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (String)"ap_finapbill");
        DynamicObject premiumBill = BusinessDataServiceHelper.loadSingle((Object)premiumBillId, (String)"ap_finapbill");
        this.validateComplexSrcBill(finBill, premiumBillId, false);
        this.validateComplexPremiumBill(premiumBill);
        OperateOption option = OperateOption.create();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])new Long[]{premiumBillId}, (OperateOption)option);
        OperationHelper.assertResult(operationResult);
        operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{premiumBillId}, (OperateOption)option);
        OperationHelper.assertResult(operationResult);
        premiumBill = BusinessDataServiceHelper.loadSingle((Object)premiumBillId, (String)"ap_finapbill");
        finBill = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (String)"ap_finapbill");
        FinApBillTestChecker.validateApFinJournalData(premiumBill);
        this.validateComplexSrcBill(finBill, premiumBillId, true);
        operationResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{premiumBillId}, (OperateOption)option);
        OperationHelper.assertResult(operationResult);
        finBill = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (String)"ap_finapbill");
        this.validateComplexSrcBill(finBill, premiumBillId, false);
        operationResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{srcBillId}, (OperateOption)option);
        OperationHelper.assertResult(operationResult);
        finBill = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (String)"ap_finapbill");
        FinApBillTestChecker.validateInitialApFin(finBill);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u8d22\u52a1\u5e94\u4ed8\uff08\u8d28\u4fdd\u91d1\uff09(\u8ba1\u5212\u884c\u7ed3\u7b97\u7b80\u5355\u6570\u636e)")
    @Test
    public void ApFinUnitTest_004_2() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApPremiumBill("AP016_004_apfin_2", false, true);
        long srcBillId = finBill.getLong("id");
        long premiumBillId = FinApBillTestHelper.getPremiumBillId(srcBillId);
        finBill = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (String)"ap_finapbill");
        this.validateSimpleSrcBill(finBill, premiumBillId, false);
        OperateOption option = OperateOption.create();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])new Long[]{premiumBillId}, (OperateOption)option);
        OperationHelper.assertResult(operationResult);
        operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{premiumBillId}, (OperateOption)option);
        OperationHelper.assertResult(operationResult);
        finBill = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (String)"ap_finapbill");
        DynamicObject premiumBill = BusinessDataServiceHelper.loadSingle((Object)premiumBillId, (String)"ap_finapbill");
        FinApBillTestChecker.validateApFinJournalData(premiumBill);
        this.validateSimpleSrcBill(finBill, premiumBillId, true);
        operationResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{premiumBillId}, (OperateOption)option);
        OperationHelper.assertResult(operationResult);
        finBill = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (String)"ap_finapbill");
        this.validateSimpleSrcBill(finBill, premiumBillId, false);
        operationResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{srcBillId}, (OperateOption)option);
        OperationHelper.assertResult(operationResult);
        finBill = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (String)"ap_finapbill");
        FinApBillTestChecker.validateInitialApFin(finBill);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u8d22\u52a1\u5e94\u4ed8\uff08\u8d28\u4fdd\u91d1\uff09->\u5e94\u4ed8\u5355\u51b2\u9500 ")
    @Test
    public void ApFinUnitTest_004_3() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApPremiumBill("AP016_004_apfin_3", false, false);
        long srcBillId = finBill.getLong("id");
        long premiumBillId = FinApBillTestHelper.getPremiumBillId(srcBillId);
        OperateOption option = OperateOption.create();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])new Long[]{premiumBillId}, (OperateOption)option);
        OperationHelper.assertResult(operationResult);
        operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{premiumBillId}, (OperateOption)option);
        OperationHelper.assertResult(operationResult);
        DynamicObject writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(srcBillId);
        FinApBillTestChecker.validateFinishApFin(srcBillId, true, true);
        operationResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{writeOffBill.getLong("id")}, (OperateOption)option);
        OperationHelper.assertResult(operationResult);
        finBill = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (String)"ap_finapbill");
        this.validateSimpleSrcBill(finBill, premiumBillId, true);
    }

    private void validateSimpleSrcBill(DynamicObject srcBill, long premiumBillId, boolean isAudit) {
        if (isAudit) {
            AP016_004_ApFinPremiumTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u90e8\u5206\u7ed3\u7b97", (String)"partsettle", (String)srcBill.getString("settlestatus"));
            FinApBillTestChecker.validateApFinHeadSettleAmt(srcBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        } else {
            AP016_004_ApFinPremiumTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u672a\u7ed3\u7b97", (String)"unsettle", (String)srcBill.getString("settlestatus"));
            FinApBillTestChecker.validateApFinHeadSettleAmt(srcBill, BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO);
        }
        DynamicObjectCollection detailEntry = srcBill.getDynamicObjectCollection("detailentry");
        if (isAudit) {
            FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(0), BigDecimal.valueOf(14L), BigDecimal.valueOf(56L), BigDecimal.valueOf(14L), BigDecimal.valueOf(14L), BigDecimal.valueOf(56L), BigDecimal.valueOf(56L));
            FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(1), BigDecimal.valueOf(6L), BigDecimal.valueOf(24L), BigDecimal.valueOf(6L), BigDecimal.valueOf(6L), BigDecimal.valueOf(24L), BigDecimal.valueOf(24L));
        } else {
            FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(0), BigDecimal.valueOf(14L), BigDecimal.valueOf(56L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(70L), BigDecimal.valueOf(70L));
            FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(1), BigDecimal.valueOf(6L), BigDecimal.valueOf(24L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        }
        DynamicObjectCollection planEntity = srcBill.getDynamicObjectCollection("planentity");
        if (isAudit) {
            FinApBillTestChecker.validateApFinPlanEntry((DynamicObject)planEntity.get(0), BigDecimal.valueOf(70L), BigDecimal.valueOf(70L), BigDecimal.valueOf(14L), BigDecimal.valueOf(56L), BigDecimal.valueOf(14L), BigDecimal.valueOf(14L), BigDecimal.valueOf(56L), BigDecimal.valueOf(56L));
            FinApBillTestChecker.validateApFinPlanEntry((DynamicObject)planEntity.get(1), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(6L), BigDecimal.valueOf(24L), BigDecimal.valueOf(6L), BigDecimal.valueOf(6L), BigDecimal.valueOf(24L), BigDecimal.valueOf(24L));
        } else {
            FinApBillTestChecker.validateApFinPlanEntry((DynamicObject)planEntity.get(0), BigDecimal.valueOf(70L), BigDecimal.valueOf(70L), BigDecimal.valueOf(14L), BigDecimal.valueOf(56L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(70L), BigDecimal.valueOf(70L));
            FinApBillTestChecker.validateApFinPlanEntry((DynamicObject)planEntity.get(1), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(6L), BigDecimal.valueOf(24L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        }
        if (isAudit) {
            SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{srcBill.getLong("id")}, new Long[]{premiumBillId}, false);
        }
    }

    private void validateComplexSrcBill(DynamicObject srcBill, long premiumBillId, boolean isAudit) {
        if (isAudit) {
            AP016_004_ApFinPremiumTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u90e8\u5206\u7ed3\u7b97", (String)"partsettle", (String)srcBill.getString("settlestatus"));
            FinApBillTestChecker.validateApFinHeadSettleAmt(srcBill, BigDecimal.valueOf(16L), BigDecimal.valueOf(96.72), BigDecimal.valueOf(4L), BigDecimal.valueOf(24.18));
        } else {
            AP016_004_ApFinPremiumTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u672a\u7ed3\u7b97", (String)"unsettle", (String)srcBill.getString("settlestatus"));
            FinApBillTestChecker.validateApFinHeadSettleAmt(srcBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(120.9), BigDecimal.ZERO, BigDecimal.ZERO);
        }
        DynamicObjectCollection detailEntry = srcBill.getDynamicObjectCollection("detailentry");
        if (isAudit) {
            FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(0), BigDecimal.valueOf(12L), BigDecimal.valueOf(48L), BigDecimal.valueOf(12L), BigDecimal.valueOf(72.54), BigDecimal.valueOf(48L), BigDecimal.valueOf(290.16));
            FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(1), BigDecimal.valueOf(-8L), BigDecimal.valueOf(-32L), BigDecimal.valueOf(-8L), BigDecimal.valueOf(-48.36), BigDecimal.valueOf(-32L), BigDecimal.valueOf(-193.44));
        } else {
            FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(0), BigDecimal.valueOf(12L), BigDecimal.valueOf(48L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(60L), BigDecimal.valueOf(362.7));
            FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(1), BigDecimal.valueOf(-8L), BigDecimal.valueOf(-32L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-40L), BigDecimal.valueOf(-241.8));
        }
        DynamicObjectCollection planEntity = srcBill.getDynamicObjectCollection("planentity");
        if (isAudit) {
            FinApBillTestChecker.validateApFinPlanEntry((DynamicObject)planEntity.get(0), BigDecimal.valueOf(20L), BigDecimal.valueOf(120.9), BigDecimal.valueOf(4L), BigDecimal.valueOf(16L), BigDecimal.valueOf(4L), BigDecimal.valueOf(24.18), BigDecimal.valueOf(16L), BigDecimal.valueOf(96.72));
        } else {
            FinApBillTestChecker.validateApFinPlanEntry((DynamicObject)planEntity.get(0), BigDecimal.valueOf(20L), BigDecimal.valueOf(120.9), BigDecimal.valueOf(4L), BigDecimal.valueOf(16L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(20L), BigDecimal.valueOf(120.9));
        }
        if (isAudit) {
            SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{srcBill.getLong("id")}, new Long[]{premiumBillId}, false);
        }
    }

    private void validateComplexPremiumBill(DynamicObject premiumBill) {
        AP016_004_ApFinPremiumTest.assertEquals((String)"\u8f6c\u4ed8\u5355\u975e\u6682\u5b58\u6001", (String)"A", (String)premiumBill.getString("billstatus"));
        FinApBillTestChecker.validateApFinHeadAmt(premiumBill, BigDecimal.valueOf(4L), BigDecimal.valueOf(24.18), BigDecimal.ZERO, BigDecimal.valueOf(4L), BigDecimal.valueOf(24.18));
        FinApBillTestChecker.validateApFinHeadSettleAmt(premiumBill, BigDecimal.valueOf(4L), BigDecimal.valueOf(24.18), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection detailEntry = premiumBill.getDynamicObjectCollection("detailentry");
        AP016_004_ApFinPremiumTest.assertEquals((String)"\u8d28\u4fdd\u91d1\u5206\u5f55\u5fc5\u987b\u4e3a\u5355\u884c", (boolean)true, (detailEntry.size() == 1 ? 1 : 0) != 0);
        FinApBillTestChecker.validateApFinDetailData((DynamicObject)detailEntry.get(0), BigDecimal.valueOf(1L), BigDecimal.valueOf(4L), BigDecimal.ZERO, BigDecimal.valueOf(4L), BigDecimal.valueOf(24.18), BigDecimal.valueOf(4L), BigDecimal.valueOf(24.18));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(0), BigDecimal.ZERO, BigDecimal.valueOf(4L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(4L), BigDecimal.valueOf(24.18));
        DynamicObjectCollection planEntity = premiumBill.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanEntry((DynamicObject)planEntity.get(0), BigDecimal.valueOf(4L), BigDecimal.valueOf(24.18), BigDecimal.ZERO, BigDecimal.valueOf(4L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(4L), BigDecimal.valueOf(24.18));
    }
}

