/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.apfin;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.bos.unittest.rules.KDTimeout;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.LiquidateBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import org.junit.Test;

public class AP016_006_ApFinCoordination2LiquidateTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u8d22\u52a1\u5e94\u6536->\u6e05\u7406")
    @Test
    public void ApFinUnitTest_001() throws InterruptedException {
        this.timeout = new KDTimeout(500000L);
        FinApBillDataVO finApBillDataVO = FinApBillTestDataProvider.structureFinApCoordinationHeadVo("AP016_006_apfin_1", true, false);
        List<FinApBillDataDetailVO> finApBillDataDetailVOS = FinApBillTestDataProvider.structureFinApDataDetailVO(true, false);
        DynamicObject finApBill = FinApBillTestDataProvider.buildByPriceAndQuantity(finApBillDataVO, finApBillDataDetailVOS);
        long finApBillId = finApBill.getLong("id");
        Thread.sleep(10000L);
        QFilter filter = new QFilter("sourcebilltype", "=", (Object)"ap_finapbill");
        filter.and(new QFilter("sourcebillid", "=", (Object)String.valueOf(finApBillId)));
        DynamicObject finArBill = QueryServiceHelper.queryOne((String)"ar_finarbill", (String)"id", (QFilter[])new QFilter[]{filter});
        long finArBillId = finArBill.getLong("id");
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"submit", (String)"ar_finarbill", (Object[])new Long[]{finArBillId}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])new Long[]{finArBillId}, (OperateOption)option);
        DynamicObject[] liquidateBills = LiquidateBillTestHelper.fullPushLiquidateBill("ap_finapbill", Collections.singletonList(finApBillId), "C", false);
        long liquidateBillId = liquidateBills[0].getLong("id");
        FinApBillTestChecker.validateFinishApFin(finApBillId, true, false);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{finApBillId}, new Long[]{liquidateBillId}, false);
        this.validateLiquidateBillIssettledAndBillstatus(liquidateBillId, true, "C");
        option = OperateOption.create();
        OperationResult unaudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_liquidation", (Object[])new Long[]{liquidateBillId}, (OperateOption)option);
        AP016_006_ApFinCoordination2LiquidateTest.assertInvokeOperation((OperationResult)unaudit);
        this.validateLiquidateBillIssettledAndBillstatus(liquidateBillId, false, "B");
        SettleRecordTestChecker.checkNotExist(new Long[]{finApBillId}, new Long[]{liquidateBillId}, false);
        OperationServiceHelper.executeOperate((String)"invalid", (String)"ap_liquidation", (Object[])new Long[]{liquidateBillId}, (OperateOption)option);
        this.validateLiquidateBillIssettledAndBillstatus(liquidateBillId, false, "D");
        FinApBillTestChecker.validateFinishApFin(finApBillId, false, false);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u8d22\u52a1\u5e94\u6536->\u6e05\u7406\uff08\u7ed3\u7b97\u8bb0\u5f55\u751f\u6210\u51ed\u8bc1\u540e\u53cd\u5ba1\u6838\uff09")
    @Test
    public void ApFinUnitTest_002() throws InterruptedException {
        FinApBillDataVO finApBillDataVO = FinApBillTestDataProvider.structureFinApCoordinationHeadVo("AP016_006_apfin_2", true, false);
        List<FinApBillDataDetailVO> finApBillDataDetailVOS = FinApBillTestDataProvider.structureFinApDataDetailVO(true, false);
        DynamicObject finApBill = FinApBillTestDataProvider.buildByPriceAndQuantity(finApBillDataVO, finApBillDataDetailVOS);
        long finApBillId = finApBill.getLong("id");
        Thread.sleep(10000L);
        QFilter filter = new QFilter("sourcebilltype", "=", (Object)"ap_finapbill");
        filter.and(new QFilter("sourcebillid", "=", (Object)String.valueOf(finApBillId)));
        DynamicObject finArBill = QueryServiceHelper.queryOne((String)"ar_finarbill", (String)"id", (QFilter[])new QFilter[]{filter});
        long finArBillId = finArBill.getLong("id");
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"submit", (String)"ar_finarbill", (Object[])new Long[]{finArBillId}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])new Long[]{finArBillId}, (OperateOption)option);
        DynamicObject[] liquidateBills = LiquidateBillTestHelper.fullPushLiquidateBill("ap_finapbill", Collections.singletonList(finApBillId), "C", false);
        long liquidateBillId = liquidateBills[0].getLong("id");
        DynamicObject[] records = SettleRecordTestHelper.loadData(new Long[]{finApBillId}, new Long[]{liquidateBillId}, false);
        SettleRecordTestHelper.setIsVoucherToTrue(records);
        option = OperateOption.create();
        OperationResult unaudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_liquidation", (Object[])new Long[]{liquidateBillId}, (OperateOption)option);
        AP016_006_ApFinCoordination2LiquidateTest.assertEquals((String)"\u53cd\u5ba1\u6838\u81ea\u52a8\u5931\u8d25", (boolean)false, (boolean)unaudit.isSuccess());
        FinApBillTestChecker.validateFinishApFin(finApBillId, true, false);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{finApBillId}, new Long[]{liquidateBillId}, false);
        this.validateLiquidateBillIssettledAndBillstatus(liquidateBillId, true, "C");
    }

    private void validateLiquidateBillIssettledAndBillstatus(long liquidateBillId, boolean isSettled, String billstatus) {
        DynamicObject liquidateBill = BusinessDataServiceHelper.loadSingle((Object)liquidateBillId, (String)"ap_liquidation");
        if (isSettled) {
            AP016_006_ApFinCoordination2LiquidateTest.assertEquals((String)"\u6e05\u7406\u5355\u8868\u5934<\u662f\u5426\u5df2\u7ed3\u7b97>\u5e94\u4e3aTRUE", (Object)Boolean.TRUE, (Object)liquidateBill.get("issettled"));
        } else {
            AP016_006_ApFinCoordination2LiquidateTest.assertEquals((String)"\u6e05\u7406\u5355\u8868\u5934<\u662f\u5426\u5df2\u7ed3\u7b97>\u5e94\u4e3aFALSE", (Object)Boolean.FALSE, (Object)liquidateBill.get("issettled"));
        }
        AP016_006_ApFinCoordination2LiquidateTest.assertEquals((String)"\u6e05\u7406\u5355\u5355\u636e\u72b6\u6001\u5f02\u5e38", (String)billstatus, (String)liquidateBill.getString("billstatus"));
    }

    @TestMethod(value=3)
    @DisplayName(value="\u8d39\u7528\u8d22\u52a1\u5e94\u4ed8->\u8d22\u52a1\u5e94\u6536->\u6e05\u7406")
    @Test
    public void ApFinUnitTest_003() throws InterruptedException {
        FinApBillDataVO finApBillDataVO = FinApBillTestDataProvider.structureFinApCoordinationHeadVo("AP016_007_apfin_2", true, true);
        List<FinApBillDataDetailVO> finApBillDataDetailVOS = FinApBillTestDataProvider.structureFinApDataDetailVO(true, false);
        DynamicObject finApBill = FinApBillTestDataProvider.buildBySaleFeePriceAndQuantity(finApBillDataVO, finApBillDataDetailVOS);
        long finApBillId = finApBill.getLong("id");
        Thread.sleep(10000L);
        QFilter filter = new QFilter("sourcebilltype", "=", (Object)"ap_finapbill");
        filter.and(new QFilter("sourcebillid", "=", (Object)String.valueOf(finApBillId)));
        filter.and(new QFilter("billtype.number", "=", (Object)"arfin_salefee_BT_S"));
        DynamicObject finArBill = QueryServiceHelper.queryOne((String)"ar_finarbill", (String)"id", (QFilter[])new QFilter[]{filter});
        long finArBillId = finArBill.getLong("id");
        QFilter feeFilter = new QFilter("sourcebilltype", "=", (Object)"ap_finapbill");
        feeFilter.and(new QFilter("sourcebillid", "=", (Object)String.valueOf(finApBillId)));
        feeFilter.and(new QFilter("billtype.number", "=", (Object)"arfin_other_BT_S"));
        boolean exists = QueryServiceHelper.exists((String)"ar_finarbill", (QFilter[])new QFilter[]{feeFilter});
        AP016_006_ApFinCoordination2LiquidateTest.assertEquals((String)"\u6536\u4ed8\u4ee3\u57ab\u81ea\u52a8\u751f\u6210\u5176\u4ed6\u5e94\u6536\u5355", (boolean)true, (boolean)exists);
        OperateOption option = OperateOption.create();
        OperationResult apSubResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_finarbill", (Object[])new Long[]{finArBillId}, (OperateOption)option);
        OperationHelper.assertResult(apSubResult);
        OperationResult apAuditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])new Long[]{finArBillId}, (OperateOption)option);
        OperationHelper.assertResult(apAuditResult);
        DynamicObject[] liquidateBills = LiquidateBillTestHelper.fullPushLiquidateBill("ap_finapbill", Collections.singletonList(finApBillId), "C", false);
        long liquidateBillId = liquidateBills[0].getLong("id");
        FinApBillTestChecker.validateFinishApFin(finApBillId, true, false);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{finApBillId}, new Long[]{liquidateBillId}, false);
        this.validateLiquidateBillIssettledAndBillstatus(liquidateBillId, true, "C");
        option = OperateOption.create();
        OperationResult unaudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_liquidation", (Object[])new Long[]{liquidateBillId}, (OperateOption)option);
        AP016_006_ApFinCoordination2LiquidateTest.assertInvokeOperation((OperationResult)unaudit);
        this.validateLiquidateBillIssettledAndBillstatus(liquidateBillId, false, "B");
        SettleRecordTestChecker.checkNotExist(new Long[]{finApBillId}, new Long[]{liquidateBillId}, false);
        OperationServiceHelper.executeOperate((String)"invalid", (String)"ap_liquidation", (Object[])new Long[]{liquidateBillId}, (OperateOption)option);
        this.validateLiquidateBillIssettledAndBillstatus(liquidateBillId, false, "D");
        FinApBillTestChecker.validateFinishApFin(finApBillId, false, false);
        DynamicObject arLi = QueryServiceHelper.queryOne((String)"ar_liquidation", (String)"id", (QFilter[])new QFilter[]{new QFilter("entryentity.sourcebillid", "=", (Object)finArBillId)});
        OperationServiceHelper.executeOperate((String)"invalid", (String)"ar_liquidation", (Object[])new Long[]{arLi.getLong("id")}, (OperateOption)option);
        OperationResult arUnAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (Object[])new Long[]{finArBillId}, (OperateOption)option);
        OperationHelper.assertResult(arUnAudit);
        OperationResult apUnAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{finApBillId}, (OperateOption)option);
        OperationHelper.assertResult(apUnAudit);
        OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"ap_finapbill", (Object[])new Long[]{finApBillId}, (OperateOption)option);
        OperationHelper.assertResult(deleteResult);
        AP016_006_ApFinCoordination2LiquidateTest.assertEquals((boolean)true, (boolean)true);
    }
}

