/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.apfin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PayApplyBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import org.junit.Test;

public class AP016_008_ApFin2Apply2PayTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deleteApplys = Arrays.asList("AP016_008_payapply_1", "AP016_008_payapply_2", "AP016_008_payapply_3");
        DeleteServiceHelper.delete((String)"ap_payapply", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteApplys)});
        List<String> deletePayBills = Arrays.asList("AP016_008_payBill_1", "AP016_008_payBill_2", "AP016_008_payBill_3");
        DeleteServiceHelper.delete((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deletePayBills)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u7533\u8bf7->\u4ed8\u6b3e\u5355\uff08\u7269\u6599\u884c,\u7f8e\u5143\uff0c\u64cd\u4f5c\u6821\u9a8c\uff09")
    @Test
    public void ApFinUnitTest_008_1() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApBill(false, false, true, true, "AP016_008_apfin_1");
        long finpk = finBill.getLong("id");
        DynamicObject[] applyBills = PayApplyBillTestHelper.pushPayApplyBill("ap_finapbill", Collections.singletonList(finpk), "AP016_008_payapply_1");
        DynamicObject applyBill = applyBills[0];
        finBill = BusinessDataServiceHelper.loadSingle((Object)finpk, (String)"ap_finapbill");
        this.validateApFinLockAmt(finBill, 0L, false, false);
        DynamicObject[] payBills = CasPayBillTestHelper.pushPayBill(BigDecimal.valueOf(999999L), "ap_payapply", Collections.singletonList(applyBill.getLong("id")), "AP016_008_payBill_1");
        finBill = BusinessDataServiceHelper.loadSingle((Object)finpk, (String)"ap_finapbill");
        this.validateApFinLockAmt(finBill, payBills[0].getLong("id"), false, true);
        OperationServiceHelper.executeOperate((String)"closepay", (String)"ap_payapply", (Object[])new Long[]{applyBill.getLong("id")}, (OperateOption)OperateOption.create());
        finBill = BusinessDataServiceHelper.loadSingle((Object)finpk, (String)"ap_finapbill");
        this.validateApFinLockAmt(finBill, payBills[0].getLong("id"), true, true);
        OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])new Long[]{payBills[0].getLong("id")}, (OperateOption)OperateOption.create());
        finBill = BusinessDataServiceHelper.loadSingle((Object)finpk, (String)"ap_finapbill");
        this.validateApFinLockAmt(finBill, payBills[0].getLong("id"), true, false);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u7533\u8bf7->\u4ed8\u6b3e\u5355\uff08\u7269\u6599\u884c,\u7f8e\u5143,\u624b\u5de5\u53cd\u7ed3\u7b97\uff09")
    @Test
    public void ApFinUnitTest_008_2() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApBill(false, false, true, true, "AP016_008_apfin_2");
        long finpk = finBill.getLong("id");
        DynamicObject[] applyBills = PayApplyBillTestHelper.pushPayApplyBill("ap_finapbill", Collections.singletonList(finpk), "AP016_008_payapply_2");
        DynamicObject applyBill = applyBills[0];
        DynamicObject[] payBills = CasPayBillTestHelper.pushPayBill(BigDecimal.valueOf(999999L), "ap_payapply", Collections.singletonList(applyBill.getLong("id")), "AP016_008_payBill_2");
        DynamicObject payBill = payBills[0];
        DynamicObject[] records = SettleRecordTestHelper.loadData(new Long[]{finpk}, new Long[]{payBill.getLong("id")}, false);
        OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (DynamicObject[])records, (OperateOption)OperateOption.create());
        finBill = BusinessDataServiceHelper.loadSingle((Object)finpk, (String)"ap_finapbill");
        FinApBillTestChecker.validateInitialApFin(finBill);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u7533\u8bf7->\u4ed8\u6b3e\u5355\uff08\u4eba\u6c11\u5e01\uff0c\u7ed3\u7b97\u8bb0\u5f55\u751f\u6210\u51ed\u8bc1\u53cd\u7ed3\u7b97\uff09")
    @Test
    public void ApFinUnitTest_008_3() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApBill(true, false, false, true, "AP016_008_apfin_3");
        long finpk = finBill.getLong("id");
        DynamicObject[] applyBills = PayApplyBillTestHelper.fullPushPayApply("ap_finapbill", Collections.singletonList(finpk), "AP016_008_payapply_3");
        DynamicObject[] payBills = CasPayBillTestHelper.pushPayBill(BigDecimal.valueOf(999999L), "ap_payapply", Collections.singletonList(applyBills[0].getLong("id")), "AP016_008_payBill_3");
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(new Long[]{finpk}, new Long[]{payBills[0].getLong("id")}, false);
        SettleRecordTestHelper.setIsVoucherToTrue(settleRecords);
        OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (DynamicObject[])settleRecords, (OperateOption)OperateOption.create());
        settleRecords = SettleRecordTestHelper.loadData(new Long[]{finpk}, new Long[]{payBills[0].getLong("id")}, false);
        AP016_008_ApFin2Apply2PayTest.assertEquals((String)"\u7ed3\u7b97\u8bb0\u5f55\u5e94\u4e3a4\u6761\uff0c\u5305\u542b2\u6761\u7ea2\u51b2\u7684\u7ed3\u7b97\u8bb0\u5f55", (boolean)true, (settleRecords.length == 4 ? 1 : 0) != 0);
        SettleRecordTestChecker.checkSettleAmtAndJournal(settleRecords);
    }

    private void validateApFinLockAmt(DynamicObject finBill, long payBillId, boolean isClose, boolean isSettle) {
        DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailOne = (DynamicObject)detailEntry.get(0);
        DynamicObject detailTwo = (DynamicObject)detailEntry.get(1);
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        DynamicObject planOne = (DynamicObject)planEntity.get(0);
        DynamicObject planTwo = (DynamicObject)planEntity.get(1);
        if (!isClose) {
            FinApBillTestChecker.validateApFinDetailLockAmt(detailOne, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
            FinApBillTestChecker.validateApFinDetailLockAmt(detailTwo, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
            FinApBillTestChecker.validateApFinPlanLockAmt(planOne, BigDecimal.valueOf(50L), BigDecimal.valueOf(10L));
            FinApBillTestChecker.validateApFinPlanLockAmt(planTwo, BigDecimal.ZERO, BigDecimal.valueOf(40L));
        } else if (isSettle) {
            FinApBillTestChecker.validateApFinDetailLockAmt(detailOne, BigDecimal.valueOf(15L), BigDecimal.valueOf(45L));
            FinApBillTestChecker.validateApFinDetailLockAmt(detailTwo, BigDecimal.valueOf(10L), BigDecimal.valueOf(30L));
            FinApBillTestChecker.validateApFinPlanLockAmt(planOne, BigDecimal.valueOf(25L), BigDecimal.valueOf(35L));
            FinApBillTestChecker.validateApFinPlanLockAmt(planTwo, BigDecimal.ZERO, BigDecimal.valueOf(40L));
        }
        if (isSettle) {
            AP016_008_ApFin2Apply2PayTest.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u7ed3\u7b97\u72b6\u6001\u5e94\u4e3a\u90e8\u5206\u7ed3\u7b97", (String)"partsettle", (String)finBill.getString("settlestatus"));
            FinApBillTestChecker.validateApFinHeadSettleAmt(finBill, BigDecimal.valueOf(75.0), BigDecimal.valueOf(453.375), BigDecimal.valueOf(25.0), BigDecimal.valueOf(151.125));
            FinApBillTestChecker.validateApFinDetailSettleAmt(detailOne, BigDecimal.valueOf(15L), BigDecimal.valueOf(90.675), BigDecimal.valueOf(45L), BigDecimal.valueOf(272.025));
            FinApBillTestChecker.validateApFinDetailSettleAmt(detailTwo, BigDecimal.valueOf(10L), BigDecimal.valueOf(60.45), BigDecimal.valueOf(30L), BigDecimal.valueOf(181.35));
            FinApBillTestChecker.validateApFinPlanSettleAmt(planOne, BigDecimal.valueOf(25L), BigDecimal.valueOf(151.125), BigDecimal.valueOf(35L), BigDecimal.valueOf(211.575));
            FinApBillTestChecker.validateApFinPlanSettleAmt(planTwo, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(40L), BigDecimal.valueOf(241.8));
            SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{finBill.getLong("id")}, new Long[]{payBillId}, false);
        }
    }
}

