/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.apfin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PayApplyBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PayApplyBillTestHelper;
import org.junit.Test;

public class AP016_009_ApFin2Apply2ReturnMoneyTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deleteApplys = Collections.singletonList("AP016_009_payapply_1");
        DeleteServiceHelper.delete((String)"ap_payapply", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteApplys)});
        List<String> deletePayBills = Collections.singletonList("AP016_009_payBill_1");
        DeleteServiceHelper.delete((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deletePayBills)});
        List<String> deleteRecBills = Collections.singletonList("AP016_009_recBill_1");
        DeleteServiceHelper.delete((String)"cas_recbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteRecBills)});
        List<String> deleteRecords = Arrays.asList("AP016_009_payBill_1", "AP016_009_apfin_1");
        DeleteServiceHelper.delete((String)"ap_settlerecord", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteRecords)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u7533\u8bf7(\u91d1\u989d\u51cf\u534a)->\u4ed8\u6b3e\u5355(\u91d1\u989d\u51cf\u534a)->\u4ed8\u6b3e\u7533\u8bf7\uff08\u7b2c\u4e8c\u884c\u5206\u5f55\u8fdb\u884c\u884c\u5173\u95ed\uff09->\u9000\u6b3e")
    @Test
    public void ApFinUnitTest_010_1() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApBill(false, false, false, true, "AP016_009_apfin_1");
        long finpk = finBill.getLong("id");
        DynamicObject[] applyBills = PayApplyBillTestHelper.pushPayApplyBill("ap_finapbill", Collections.singletonList(finpk), "AP016_009_payapply_1");
        long payApplyId = applyBills[0].getLong("id");
        Long secondEntryId = ((DynamicObject)applyBills[0].getDynamicObjectCollection("entry").get(1)).getLong("id");
        DynamicObject[] payBills = CasPayBillTestHelper.pushPayBill(BigDecimal.valueOf(999L), "ap_payapply", Collections.singletonList(payApplyId), "D", "AP016_009_payBill_1", null);
        long payBillId = payBills[0].getLong("id");
        ArrayList<Long> selectRows = new ArrayList<Long>(1);
        selectRows.add(secondEntryId);
        OperateOption option = OperateOption.create();
        option.setVariableValue("mutex_writeback", "false");
        option.setVariableValue("selectrows", SerializationUtils.toJsonString(selectRows));
        OperationServiceHelper.executeOperate((String)"closepay", (String)"ap_payapply", (Object[])new Object[]{payApplyId}, (OperateOption)option);
        DynamicObject casRecBill = CasRecBillTestDataProvider.createCasRecBillByReturnMoney("AP016_009_recBill_1", BigDecimal.valueOf(20L), false, false);
        long recBillId = casRecBill.getLong("id");
        CasPayBillTestHelper.executeReturnMoney(this, payBillId, recBillId);
        this.validateData(finpk, payApplyId, payBillId, recBillId);
    }

    private void validateData(long finpk, long payApplyId, long payBillId, long casRecBillId) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finpk, (String)"ap_finapbill");
        this.validateApFin(finBill, payBillId);
        DynamicObject applyBill = BusinessDataServiceHelper.loadSingle((Object)payApplyId, (String)"ap_payapply");
        PayApplyBillTestChecker.validatorPayApply(applyBill, "Inpayment", BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.ZERO, BigDecimal.ZERO);
        KDAssert.assertEquals((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u72b6\u6001\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (String)"E", (String)applyBill.getString("billstatus"));
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)casRecBillId, (String)"cas_recbill");
        BigDecimal eSettledAmt = ((DynamicObject)recBill.getDynamicObjectCollection("entry").get(0)).getBigDecimal("e_settledamt");
        AP016_009_ApFin2Apply2ReturnMoneyTest.assertEquals((String)String.format("\u6536\u6b3e\u5355[%s]\u9000\u6b3e\u5931\u8d25,\u5206\u5f55\u7ed3\u7b97\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", recBill.getString("billno")), (int)0, (int)BigDecimal.valueOf(20L).compareTo(eSettledAmt));
        DynamicObject casPayBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        AP016_009_ApFin2Apply2ReturnMoneyTest.assertEquals((String)"\u4ed8\u6b3e\u5355\u8868\u5934\u72b6\u6001\u5e94\u4e3a\u9000\u6b3e\u72b6\u6001", (boolean)true, (boolean)"I".equals(casPayBill.getString("billstatus")));
        DynamicObjectCollection entry = casPayBill.getDynamicObjectCollection("entry");
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(10L), BigDecimal.valueOf(15L), BigDecimal.ZERO, BigDecimal.valueOf(15L), BigDecimal.valueOf(15L), BigDecimal.ZERO, BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.ZERO);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{payBillId}, new Long[]{casRecBillId}, false);
    }

    private void validateApFin(DynamicObject finBill, long assBillId) {
        DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailOne = (DynamicObject)detailEntry.get(0);
        DynamicObject detailTwo = (DynamicObject)detailEntry.get(1);
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        DynamicObject planOne = (DynamicObject)planEntity.get(0);
        DynamicObject planTwo = (DynamicObject)planEntity.get(1);
        AP016_009_ApFin2Apply2ReturnMoneyTest.assertEquals((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u5e94\u4e3a\u90e8\u5206\u7ed3\u7b97", (String)"partsettle", (String)finBill.getString("settlestatus"));
        FinApBillTestChecker.validateApFinHeadSettleAmt(finBill, BigDecimal.valueOf(95.0), BigDecimal.valueOf(95.0), BigDecimal.valueOf(5L), BigDecimal.valueOf(5L));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailOne, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.valueOf(55L), BigDecimal.valueOf(55L));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailTwo, BigDecimal.valueOf(0L), BigDecimal.valueOf(40L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(40L), BigDecimal.valueOf(40L));
        FinApBillTestChecker.validateApFinPlanLockAmt(planOne, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        FinApBillTestChecker.validateApFinPlanLockAmt(planTwo, BigDecimal.ZERO, BigDecimal.valueOf(40L));
        FinApBillTestChecker.validateApFinPlanSettleAmt(planOne, BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.valueOf(55L), BigDecimal.valueOf(55L));
        FinApBillTestChecker.validateApFinPlanSettleAmt(planTwo, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(40L), BigDecimal.valueOf(40L));
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{finBill.getLong("id")}, new Long[]{assBillId}, false);
    }
}

