/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.apfin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import org.junit.Test;

public class AP016_011_ApFinReturnMoneyTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deletePayBills = Collections.singletonList("AP016_011_payBill_1");
        DeleteServiceHelper.delete((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deletePayBills)});
        List<String> deleteRecBills = Collections.singletonList("AP016_011_recBill_1");
        DeleteServiceHelper.delete((String)"cas_recbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteRecBills)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u5355->\u9000\u6b3e\u9000\u7968\uff08\u5f02\u5e01\u522b\uff0c\u8d22\u52a1\u5e94\u4ed8\u548c\u8d28\u4fdd\u91d1\u5408\u5e76\u4e0b\u63a8\u91d1\u989d\u51cf\u534a\u4ed8\u6b3e\u5355\uff09\u5b58\u5728bug\uff0c\u5df2\u7ecf\u8bb0\u5f55")
    @Test
    public void ApFinUnitTest_010_1() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApBill(true, false, true, false, "AP016_011_apfin_1");
        long finBillId = finBill.getLong("id");
        long premiumId = this.provideAuditPremiumBill(finBill);
        DynamicObject[] payBills = CasPayBillTestHelper.pushPayBill(BigDecimal.valueOf(999999L), "ap_finapbill", Arrays.asList(finBillId, premiumId), "AP016_011_payBill_1");
        long payBillId = payBills[0].getLong("id");
        DynamicObject recBill = CasRecBillTestDataProvider.createCasRecBillByReturnMoney("AP016_011_recBill_1", BigDecimal.valueOf(40L), true, true);
        long recBillId = recBill.getLong("id");
        CasPayBillTestHelper.executeReturnMoney(this, payBillId, recBillId);
        this.validateData(finBillId, premiumId, payBillId, recBillId);
    }

    private void validateData(long finBillId, long premiumId, long payBillId, long casRecBillId) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ap_finapbill");
        AP016_011_ApFinReturnMoneyTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u90e8\u5206\u7ed3\u7b97", (String)"partsettle", (String)finBill.getString("settlestatus"));
        FinApBillTestChecker.validateApFinHeadSettleAmt(finBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(483.6), BigDecimal.valueOf(20L), BigDecimal.valueOf(120.9));
        DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(0), BigDecimal.valueOf(12L), BigDecimal.valueOf(48L), BigDecimal.valueOf(12L), BigDecimal.valueOf(72.54), BigDecimal.valueOf(48L), BigDecimal.valueOf(290.16));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(1), BigDecimal.valueOf(8L), BigDecimal.valueOf(32L), BigDecimal.valueOf(8L), BigDecimal.valueOf(48.36), BigDecimal.valueOf(32L), BigDecimal.valueOf(193.44));
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(12L), BigDecimal.valueOf(48L));
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(1), BigDecimal.valueOf(8L), BigDecimal.valueOf(32L));
        FinApBillTestChecker.validateApFinPlanSettleAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(12L), BigDecimal.valueOf(72.54), BigDecimal.valueOf(48L), BigDecimal.valueOf(290.16));
        FinApBillTestChecker.validateApFinPlanSettleAmt((DynamicObject)planEntity.get(1), BigDecimal.valueOf(8L), BigDecimal.valueOf(48.36), BigDecimal.valueOf(32L), BigDecimal.valueOf(193.44));
        DynamicObject premiumBill = BusinessDataServiceHelper.loadSingle((Object)premiumId, (String)"ap_finapbill");
        AP016_011_ApFinReturnMoneyTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u90e8\u5206\u7ed3\u7b97", (String)"partsettle", (String)premiumBill.getString("settlestatus"));
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{premiumId}, new Long[]{payBillId}, false);
        FinApBillTestChecker.validateApFinHeadSettleAmt(premiumBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(60.45), BigDecimal.valueOf(10L), BigDecimal.valueOf(60.45));
        detailEntry = premiumBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(0), BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), BigDecimal.valueOf(60.45), BigDecimal.valueOf(10L), BigDecimal.valueOf(60.45));
        planEntity = premiumBill.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(10L), BigDecimal.valueOf(10L));
        FinApBillTestChecker.validateApFinPlanSettleAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(10L), BigDecimal.valueOf(60.45), BigDecimal.valueOf(10L), BigDecimal.valueOf(60.45));
        DynamicObject casPayBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        AP016_011_ApFinReturnMoneyTest.assertEquals((String)"\u4ed8\u6b3e\u5355\u8868\u5934\u72b6\u6001\u5e94\u4e3a\u9000\u6b3e\u72b6\u6001", (boolean)true, (boolean)"I".equals(casPayBill.getString("billstatus")));
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{payBillId}, new Long[]{casRecBillId}, false);
        DynamicObjectCollection entry = casPayBill.getDynamicObjectCollection("entry");
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(24L), BigDecimal.valueOf(24L), BigDecimal.ZERO, BigDecimal.valueOf(24L), BigDecimal.valueOf(145.08), BigDecimal.ZERO, BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(16L), BigDecimal.valueOf(16L), BigDecimal.ZERO, BigDecimal.valueOf(16L), BigDecimal.valueOf(96.72), BigDecimal.ZERO, BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(2), BigDecimal.ZERO, BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(10L), BigDecimal.valueOf(60.45), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)casRecBillId, (String)"cas_recbill");
        BigDecimal eSettledAmt = ((DynamicObject)recBill.getDynamicObjectCollection("entry").get(0)).getBigDecimal("e_settledamt");
        AP016_011_ApFinReturnMoneyTest.assertEquals((String)String.format("\u6536\u6b3e\u5355[%s]\u9000\u6b3e\u5931\u8d25,\u5206\u5f55\u7ed3\u7b97\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", recBill.getString("billno")), (int)0, (int)BigDecimal.valueOf(40L).compareTo(eSettledAmt));
    }

    private long provideAuditPremiumBill(DynamicObject finBill) {
        finBill.set("premiumrate", (Object)BigDecimal.valueOf(20L));
        finBill.set("premiumamt", (Object)BigDecimal.valueOf(20L));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill});
        long srcBillId = finBill.getLong("id");
        OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{srcBillId}, (OperateOption)OperateOption.create());
        QFilter filter = new QFilter("sourcebillid", "=", (Object)srcBillId);
        filter.and("ispremium", "=", (Object)Boolean.TRUE);
        DynamicObject premiumBill = QueryServiceHelper.queryOne((String)"ap_finapbill", (String)"id", (QFilter[])new QFilter[]{filter});
        AP016_011_ApFinReturnMoneyTest.assertEquals((String)"\u672a\u751f\u6210\u8d28\u4fdd\u91d1\u5355", (boolean)false, (premiumBill == null ? 1 : 0) != 0);
        long premiumId = premiumBill.getLong("id");
        OperationResult submit = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])new Long[]{premiumId}, (OperateOption)OperateOption.create());
        OperationResult audit = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{premiumId}, (OperateOption)OperateOption.create());
        premiumBill = BusinessDataServiceHelper.loadSingle((Object)premiumId, (String)"ap_finapbill");
        FinApBillTestChecker.validateApFinJournalData(premiumBill);
        AP016_011_ApFinReturnMoneyTest.assertEquals((String)"\u8d28\u4fdd\u91d1\u63d0\u4ea4\u6216\u5ba1\u6838\u5931\u8d25", (boolean)true, (submit.isSuccess() && audit.isSuccess() ? 1 : 0) != 0);
        return premiumId;
    }
}

