/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.apfin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.LiquidateBillTestHelper;
import org.junit.Test;

public class AP016_012_ApFin2LiquidateTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deletePayBills = Arrays.asList("AP016_012_payBill_1", "AP016_012_payBill_2", "AP016_013_payBill_3", "AP016_012_payBill_4");
        DeleteServiceHelper.delete((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deletePayBills)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u6708\u672b\u6e05\u7406\u5355\uff08\u6309\u7269\u6599\u884c,\u4eba\u6c11\u5e01\uff09")
    @Test
    public void ApFinUnitTest_001() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApBill(false, true, false, true, "AP016_012_apfin_1");
        long finPk = finBill.getLong("id");
        DynamicObject[] liquidateBills = LiquidateBillTestHelper.fullPushLiquidateBill("ap_finapbill", Collections.singletonList(finPk), "C", false);
        long liquidateBillId = liquidateBills[0].getLong("id");
        FinApBillTestChecker.validateFinishApFin(finPk, true, false);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{finPk}, new Long[]{liquidateBillId}, false);
        this.validateLiquidateBillIssettledAndBillstatus(liquidateBillId, true, "C");
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_liquidation", (Object[])new Long[]{liquidateBillId}, (OperateOption)option);
        FinApBillTestChecker.validateFinApFullLockData(finPk);
        this.validateLiquidateBillIssettledAndBillstatus(liquidateBillId, false, "B");
        SettleRecordTestChecker.checkNotExist(new Long[]{finPk}, new Long[]{liquidateBillId}, false);
        OperationServiceHelper.executeOperate((String)"invalid", (String)"ap_liquidation", (Object[])new Long[]{liquidateBillId}, (OperateOption)option);
        FinApBillTestChecker.validateInitialApFin(finPk);
        this.validateLiquidateBillIssettledAndBillstatus(liquidateBillId, false, "D");
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u6708\u672b\u6e05\u7406\u5355\uff08\u6309\u8ba1\u5212\u884c,\u7f8e\u5143\uff09")
    @Test
    public void ApFinUnitTest_002() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApBill(true, true, true, true, "AP016_012_apfin_2");
        long finPk = finBill.getLong("id");
        DynamicObject[] liquidateBills = LiquidateBillTestHelper.fullPushLiquidateBill("ap_finapbill", Collections.singletonList(finPk), "C", false);
        long liquidateBillId = liquidateBills[0].getLong("id");
        FinApBillTestChecker.validateFinishApFin(finPk, true, false);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{finPk}, new Long[]{liquidateBillId}, false);
        this.validateLiquidateBillIssettledAndBillstatus(liquidateBillId, true, "C");
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_liquidation", (Object[])new Long[]{liquidateBillId}, (OperateOption)option);
        FinApBillTestChecker.validateFinApFullLockData(finPk);
        this.validateLiquidateBillIssettledAndBillstatus(liquidateBillId, false, "B");
        SettleRecordTestChecker.checkNotExist(new Long[]{finPk}, new Long[]{liquidateBillId}, false);
        OperationServiceHelper.executeOperate((String)"invalid", (String)"ap_liquidation", (Object[])new Long[]{liquidateBillId}, (OperateOption)option);
        FinApBillTestChecker.validateInitialApFin(finPk);
        this.validateLiquidateBillIssettledAndBillstatus(liquidateBillId, false, "D");
    }

    @TestMethod(value=3)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u5355 then \u8d22\u52a1\u5e94\u4ed8->\u6708\u672b\u6e05\u7406\u5355\uff08\u90e8\u5206\u4e0b\u63a8,\u4e0d\u4ed8\u6b3e\uff09")
    @Test
    public void ApFinUnitTest_003() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApBill(false, true, false, true, "AP016_012_apfin_3");
        long finPk = finBill.getLong("id");
        CasPayBillTestHelper.pushPayBill(BigDecimal.valueOf(50L), "ap_finapbill", Collections.singletonList(finPk), "A", "AP016_012_payBill_3", null);
        DynamicObject[] liquidateBill = LiquidateBillTestHelper.fullPushLiquidateBill("ap_finapbill", Collections.singletonList(finPk), "B", false);
        long liquidateBillId = liquidateBill[0].getLong("id");
        OperationResult audit = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_liquidation", (Object[])new Object[]{liquidateBillId}, (OperateOption)OperateOption.create());
        AP016_012_ApFin2LiquidateTest.assertEquals((String)"\u5ba1\u6838\u64cd\u4f5c\u81ea\u52a8\u5931\u8d25", (boolean)false, (boolean)audit.isSuccess());
        this.validateLiquidateBillIssettledAndBillstatus(liquidateBillId, false, "B");
        FinApBillTestChecker.validateFinishApFin(finPk, false, false);
        SettleRecordTestChecker.checkNotExist(new Long[]{finPk}, new Long[]{liquidateBillId}, false);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u5355 then \u8d22\u52a1\u5e94\u4ed8->\u6708\u672b\u6e05\u7406\u5355\uff08\u90e8\u5206\u4e0b\u63a8,\u786e\u8ba4\u4ed8\u6b3e\uff09")
    @Test
    public void ApFinUnitTest_004() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApBill(true, true, false, true, "AP016_012_apfin_4");
        long finPk = finBill.getLong("id");
        CasPayBillTestHelper.pushPayBill(BigDecimal.valueOf(50L), "ap_finapbill", Collections.singletonList(finPk), "D", "AP016_012_payBill_4", null);
        DynamicObject[] liquidateBill = LiquidateBillTestHelper.fullPushLiquidateBill("ap_finapbill", Collections.singletonList(finPk), "C", false);
        long liquidateBillId = liquidateBill[0].getLong("id");
        FinApBillTestChecker.validateFinishApFin(finPk, true, false);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{finPk}, new Long[]{liquidateBillId}, false);
        this.validateLiquidateBillIssettledAndBillstatus(liquidateBillId, true, "C");
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_liquidation", (Object[])new Long[]{liquidateBillId}, (OperateOption)option);
        FinApBillTestChecker.validateFinApFullLockData(finPk);
        this.validateLiquidateBillIssettledAndBillstatus(liquidateBillId, false, "B");
        SettleRecordTestChecker.checkNotExist(new Long[]{finPk}, new Long[]{liquidateBillId}, false);
        OperationServiceHelper.executeOperate((String)"invalid", (String)"ap_liquidation", (Object[])new Long[]{liquidateBillId}, (OperateOption)option);
        this.validateHalfSettleApFin(finPk);
        this.validateLiquidateBillIssettledAndBillstatus(liquidateBillId, false, "D");
    }

    private void validateLiquidateBillIssettledAndBillstatus(long liquidateBillId, boolean isSettled, String billstatus) {
        DynamicObject liquidateBill = BusinessDataServiceHelper.loadSingle((Object)liquidateBillId, (String)"ap_liquidation");
        if (isSettled) {
            AP016_012_ApFin2LiquidateTest.assertEquals((String)"\u6e05\u7406\u5355\u8868\u5934<\u662f\u5426\u5df2\u7ed3\u7b97>\u5e94\u4e3aTRUE", (Object)Boolean.TRUE, (Object)liquidateBill.get("issettled"));
        } else {
            AP016_012_ApFin2LiquidateTest.assertEquals((String)"\u6e05\u7406\u5355\u8868\u5934<\u662f\u5426\u5df2\u7ed3\u7b97>\u5e94\u4e3aFALSE", (Object)Boolean.FALSE, (Object)liquidateBill.get("issettled"));
        }
        AP016_012_ApFin2LiquidateTest.assertEquals((String)"\u6e05\u7406\u5355\u5355\u636e\u72b6\u6001\u5f02\u5e38", (String)billstatus, (String)liquidateBill.getString("billstatus"));
    }

    private void validateHalfSettleApFin(long finBillId) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ap_finapbill");
        KDAssert.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u7ed3\u7b97\u72b6\u6001\u5e94\u4e3a\u90e8\u5206\u7ed3\u7b97", (String)"partsettle", (String)finBill.getString("settlestatus"));
        FinApBillTestChecker.validateApFinHeadSettleAmt(finBill, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        FinApBillTestChecker.validateApFinHeadVerifyData(finBill, "10", BigDecimal.valueOf(100L));
        DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        DynamicObject entry = (DynamicObject)detailEntry.get(0);
        FinApBillTestChecker.validateApFinDetailSettleAmt(entry, BigDecimal.valueOf(35L), BigDecimal.valueOf(35L), BigDecimal.valueOf(35L), BigDecimal.valueOf(35L));
        FinApBillTestChecker.validateApFinDetailVerifyData(entry, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.valueOf(70L));
        FinApBillTestChecker.validateApFinDetailLockAmt(entry, BigDecimal.valueOf(35L), BigDecimal.valueOf(35L));
        entry = (DynamicObject)detailEntry.get(1);
        FinApBillTestChecker.validateApFinDetailSettleAmt(entry, BigDecimal.valueOf(15L), BigDecimal.valueOf(15L), BigDecimal.valueOf(15L), BigDecimal.valueOf(15L));
        FinApBillTestChecker.validateApFinDetailVerifyData(entry, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.valueOf(30L));
        FinApBillTestChecker.validateApFinDetailLockAmt(entry, BigDecimal.valueOf(15L), BigDecimal.valueOf(15L));
        FinApBillTestChecker.validateApFinPlanSettleAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(35L), BigDecimal.valueOf(35L), BigDecimal.valueOf(35L), BigDecimal.valueOf(35L));
        FinApBillTestChecker.validateApFinPlanSettleAmt((DynamicObject)planEntity.get(1), BigDecimal.valueOf(15L), BigDecimal.valueOf(15L), BigDecimal.valueOf(15L), BigDecimal.valueOf(15L));
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(35L), BigDecimal.valueOf(35L));
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(1), BigDecimal.valueOf(15L), BigDecimal.valueOf(15L));
    }
}

