/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.apfin;

import java.math.BigDecimal;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import org.junit.Test;

public class AP016_015_ApFinPremium2WriteOffTest
extends AbstractJUnitTestPlugIn {
    long srcBillId;
    long premiumBillId;
    DynamicObject writeOffBill;

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8-\u8d28\u4fdd\u91d1 AND \u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500\uff08\u8ba1\u5212\u884c,\u4eba\u6c11\u5e01\u6570\u636e\uff09")
    @Test
    public void ApFinUnitTest_001() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApPremiumBill("AP016_015_apfin_1", false, true);
        this.srcBillId = finBill.getLong("id");
        this.premiumBillId = FinApBillTestHelper.getPremiumBillId(this.srcBillId);
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])new Long[]{this.premiumBillId}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{this.premiumBillId}, (OperateOption)option);
        this.writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(this.srcBillId);
        this.validateData(this.srcBillId, this.premiumBillId);
        AP016_015_ApFinPremium2WriteOffTest.assertEquals((boolean)true, (boolean)true);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8-\u8d28\u4fdd\u91d1 AND \u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500\uff08\u8ba1\u5212\u884c,\u4eba\u6c11\u5e01\u6570\u636e\uff09")
    @Test
    public void ApFinUnitTest_001_1() {
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{this.writeOffBill.getLong("id")}, (OperateOption)OperateOption.create());
        AP016_015_ApFinPremium2WriteOffTest.assertEquals((String)"\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u5931\u8d25", (boolean)true, (boolean)unAudit.isSuccess());
        this.validateFinApBill(this.srcBillId);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Object[]{this.premiumBillId}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Object[]{this.srcBillId}, (OperateOption)OperateOption.create());
        FinApBillTestChecker.validateInitialApFin(this.srcBillId);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8-\u8d28\u4fdd\u91d1 AND \u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500\uff08\u8ba1\u5212\u884c,\u4eba\u6c11\u5e01\u6570\u636e,\u751f\u6210\u51ed\u8bc1\u518d\u51b2\u9500\uff09")
    @Test
    public void ApFinUnitTest_002() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApPremiumBill("AP016_015_apfin_2", false, true);
        this.srcBillId = finBill.getLong("id");
        this.premiumBillId = FinApBillTestHelper.getPremiumBillId(this.srcBillId);
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])new Long[]{this.premiumBillId}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{this.premiumBillId}, (OperateOption)option);
        DynamicObject[] records = SettleRecordTestHelper.loadData(new Long[]{this.srcBillId}, new Long[]{this.premiumBillId}, false);
        SettleRecordTestHelper.setIsVoucherToTrue(records);
        AP016_015_ApFinPremium2WriteOffTest.assertEquals((boolean)true, (boolean)true);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8-\u8d28\u4fdd\u91d1 AND \u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500\uff08\u8ba1\u5212\u884c,\u4eba\u6c11\u5e01\u6570\u636e,\u751f\u6210\u51ed\u8bc1\u518d\u51b2\u9500\uff09")
    @Test
    public void ApFinUnitTest_002_1() {
        this.writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(this.srcBillId);
        this.validateData(this.srcBillId, this.premiumBillId);
        boolean isExists = SettleRecordTestHelper.existsWriteOff(new Long[]{this.srcBillId}, new Long[]{this.premiumBillId}, false);
        AP016_015_ApFinPremium2WriteOffTest.assertEquals((String)"\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u7ed3\u7b97\u8bb0\u5f55\u53cd\u7ed3\u7b97\u672a\u751f\u6210\u7ea2\u51b2\u7ed3\u7b97\u8bb0\u5f55\u3002", (boolean)true, (boolean)isExists);
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{this.writeOffBill.getLong("id")}, (OperateOption)OperateOption.create());
        AP016_015_ApFinPremium2WriteOffTest.assertEquals((String)"\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u5931\u8d25", (boolean)true, (boolean)unAudit.isSuccess());
        this.validateFinApBill(this.srcBillId);
        OperationResult unAudit1 = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Object[]{this.premiumBillId}, (OperateOption)OperateOption.create());
        AP016_015_ApFinPremium2WriteOffTest.assertEquals((boolean)true, (boolean)((IOperateInfo)unAudit1.getAllErrorOrValidateInfo().get(0)).getMessage().contains("\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002"));
    }

    @TestMethod(value=5)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8-\u8d28\u4fdd\u91d1 AND \u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500\uff08\u7269\u6599\u884c,\u4eba\u6c11\u5e01\u6570\u636e\uff09")
    @Test
    public void ApFinUnitTest_003() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApPremiumBill("AP016_015_apfin_3", false, false);
        this.srcBillId = finBill.getLong("id");
        this.premiumBillId = FinApBillTestHelper.getPremiumBillId(this.srcBillId);
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])new Long[]{this.premiumBillId}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{this.premiumBillId}, (OperateOption)option);
        AP016_015_ApFinPremium2WriteOffTest.assertEquals((boolean)true, (boolean)true);
    }

    @TestMethod(value=6)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8-\u8d28\u4fdd\u91d1 AND \u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500\uff08\u7269\u6599\u884c,\u4eba\u6c11\u5e01\u6570\u636e\uff09")
    @Test
    public void ApFinUnitTest_003_1() {
        this.writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(this.srcBillId);
        this.validateData(this.srcBillId, this.premiumBillId);
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{this.writeOffBill.getLong("id")}, (OperateOption)OperateOption.create());
        AP016_015_ApFinPremium2WriteOffTest.assertEquals((String)"\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u5931\u8d25", (boolean)true, (boolean)unAudit.isSuccess());
        this.validateFinApBill(this.srcBillId);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Object[]{this.premiumBillId}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Object[]{this.srcBillId}, (OperateOption)OperateOption.create());
        FinApBillTestChecker.validateInitialApFin(this.srcBillId);
    }

    private void validateData(long srcBillId, long premiumBillId) {
        FinApBillTestChecker.validateFinishApFin(srcBillId, true, true);
        long srcWriterOffId = FinApBillTestHelper.getWriteOffBillId(srcBillId);
        FinApBillTestChecker.validateApFinVerifyRecordData(srcBillId, srcWriterOffId);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{srcBillId}, new Long[]{srcWriterOffId}, false);
        FinApBillTestChecker.validateFinishApFin(srcWriterOffId, true, true);
        FinApBillTestChecker.validateFinishApFin(premiumBillId, true, false);
        long premiumWriterOffId = FinApBillTestHelper.getWriteOffBillId(premiumBillId);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{premiumBillId}, new Long[]{premiumWriterOffId}, false);
        FinApBillTestChecker.validateFinishApFin(premiumWriterOffId, true, false);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(new Long[]{srcBillId}, new Long[]{premiumBillId}, false);
        AP016_015_ApFinPremium2WriteOffTest.assertEquals((String)"\u6e90\u8d22\u52a1\u5e94\u4ed8\u5355\u548c\u8d28\u4fdd\u91d1\u7684\u7ed3\u7b97\u8bb0\u5f55\u5e94\u8be5\u4e3a4\u6761", (boolean)true, (settleRecords.length == 4 ? 1 : 0) != 0);
        SettleRecordTestChecker.checkSettleAmtAndJournal(settleRecords);
    }

    private void validateFinApBill(long finBillId) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ap_finapbill");
        KDAssert.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u7ed3\u7b97\u72b6\u6001\u5e94\u4e3a\u90e8\u5206\u7ed3\u7b97", (String)"partsettle", (String)finBill.getString("settlestatus"));
        FinApBillTestChecker.validateApFinHeadSettleAmt(finBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        FinApBillTestChecker.validateApFinHeadVerifyData(finBill, "10", BigDecimal.valueOf(100L));
        DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        DynamicObject entry = (DynamicObject)detailEntry.get(0);
        FinApBillTestChecker.validateApFinDetailSettleAmt(entry, BigDecimal.valueOf(14L), BigDecimal.valueOf(14L), BigDecimal.valueOf(56L), BigDecimal.valueOf(56L));
        FinApBillTestChecker.validateApFinDetailVerifyData(entry, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.valueOf(70L));
        FinApBillTestChecker.validateApFinDetailLockAmt(entry, BigDecimal.valueOf(14L), BigDecimal.valueOf(56L));
        entry = (DynamicObject)detailEntry.get(1);
        FinApBillTestChecker.validateApFinDetailSettleAmt(entry, BigDecimal.valueOf(6L), BigDecimal.valueOf(6L), BigDecimal.valueOf(24L), BigDecimal.valueOf(24L));
        FinApBillTestChecker.validateApFinDetailVerifyData(entry, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.valueOf(30L));
        FinApBillTestChecker.validateApFinDetailLockAmt(entry, BigDecimal.valueOf(6L), BigDecimal.valueOf(24L));
        FinApBillTestChecker.validateApFinPlanSettleAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(14L), BigDecimal.valueOf(14L), BigDecimal.valueOf(56L), BigDecimal.valueOf(56L));
        FinApBillTestChecker.validateApFinPlanSettleAmt((DynamicObject)planEntity.get(1), BigDecimal.valueOf(6L), BigDecimal.valueOf(6L), BigDecimal.valueOf(24L), BigDecimal.valueOf(24L));
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(14L), BigDecimal.valueOf(56L));
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(1), BigDecimal.valueOf(6L), BigDecimal.valueOf(24L));
    }
}

