/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.apfin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import org.junit.Test;

public class AP016_016_ApFin2Pay2WriteOffTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deletePayBills = Arrays.asList("AP016_016_payBill_1", "AP016_016_payBill_2", "AP016_016_payBill_3");
        DeleteServiceHelper.delete((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deletePayBills)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8-\u4ed8\u6b3e\u5355 AND \u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500\uff08\u7269\u6599\u884c,\u7f8e\u5143\u6570\u636e\uff09")
    @Test
    public void ApFinUnitTest_001() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApBill(false, true, true, true, "AP016_016_apfin_1");
        long finpk = finBill.getLong("id");
        DynamicObject[] payBills = CasPayBillTestHelper.fullPushPayBill("ap_finapbill", Collections.singletonList(finBill.getLong("id")), "AP016_016_payBill_1", BigDecimal.valueOf(6.045));
        DynamicObject writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(finpk);
        this.validateData(finpk, writeOffBill, payBills[0].getLong("id"), false);
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{writeOffBill.getLong("id")}, (OperateOption)OperateOption.create());
        AP016_016_ApFin2Pay2WriteOffTest.assertEquals((String)"\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u5931\u8d25", (boolean)true, (boolean)unAudit.isSuccess());
        FinApBillTestChecker.validateInitialApFin(finpk);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8-\u4ed8\u6b3e\u5355 AND \u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500\uff08\u7269\u6599\u884c,\u7f8e\u5143\u6570\u636e,\u751f\u6210\u51ed\u8bc1\u540e\u518d\u51b2\u9500\uff09")
    @Test
    public void ApFinUnitTest_002() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApBill(false, true, true, true, "AP016_016_apfin_2");
        long finpk = finBill.getLong("id");
        DynamicObject[] payBills = CasPayBillTestHelper.fullPushPayBill("ap_finapbill", Collections.singletonList(finBill.getLong("id")), "AP016_016_payBill_2", BigDecimal.valueOf(6.045));
        long payBillId = payBills[0].getLong("id");
        DynamicObject[] records = SettleRecordTestHelper.loadData(new Long[]{finpk}, new Long[]{payBillId}, false);
        SettleRecordTestHelper.setIsVoucherToTrue(records);
        DynamicObject writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(finpk);
        this.validateData(finpk, writeOffBill, payBillId, false);
        boolean isExists = SettleRecordTestHelper.existsWriteOff(new Long[]{finpk}, new Long[]{payBillId}, false);
        AP016_016_ApFin2Pay2WriteOffTest.assertEquals((String)"\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u7ed3\u7b97\u8bb0\u5f55\u53cd\u7ed3\u7b97\u672a\u751f\u6210\u7ea2\u51b2\u7ed3\u7b97\u8bb0\u5f55\u3002", (boolean)true, (boolean)isExists);
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{writeOffBill.getLong("id")}, (OperateOption)OperateOption.create());
        AP016_016_ApFin2Pay2WriteOffTest.assertEquals((String)"\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u5931\u8d25", (boolean)true, (boolean)unAudit.isSuccess());
        FinApBillTestChecker.validateInitialApFin(finpk);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8-\u4ed8\u6b3e\u5355 AND \u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500\uff08\u7269\u6599\u884c,\u7f8e\u5143,\u5408\u5e76\u4e0b\u63a8\u540e\u51b2\u9500\u4e00\u4e2a\u5355\u636e\uff09,\u5408\u5e76\u573a\u666f\u9700\u8981\u6269\u5c55BOTP\u652f\u6301\u5408\u5e76")
    @Test
    public void ApFinUnitTest_003() {
        DynamicObject finBillOne = FinApBillTestDataProvider.createFinApBill(false, true, true, true, "AP016_016_apfin_3");
        DynamicObject finBillTwo = FinApBillTestDataProvider.createFinApBill(false, false, true, true, "AP016_016_apfin_4");
        long finpkOne = finBillOne.getLong("id");
        long finpkTwo = finBillTwo.getLong("id");
        DynamicObject[] payBills = CasPayBillTestHelper.fullPushPayBill("ap_finapbill", Arrays.asList(finpkOne, finpkTwo), "AP016_016_payBill_3", BigDecimal.valueOf(6.045));
        long payBillId = payBills[0].getLong("id");
        DynamicObject writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(finpkOne);
        this.validateData(finpkOne, writeOffBill, payBillId, true);
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{writeOffBill.getLong("id")}, (OperateOption)OperateOption.create());
        AP016_016_ApFin2Pay2WriteOffTest.assertEquals((String)"\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u5931\u8d25", (boolean)true, (boolean)unAudit.isSuccess());
        FinApBillTestChecker.validateInitialApFin(finBillOne);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8-\u4ed8\u6b3e\u5355 AND \u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500\uff08\u8ba1\u5212\u884c,\u4eba\u6c11\u5e01,\u751f\u6210\u51ed\u8bc1\u540e\u518d\u51b2\u9500\uff09")
    @Test
    public void ApFinUnitTest_004() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApBill(true, true, false, true, "AP016_016_apfin_4");
        long finpk = finBill.getLong("id");
        DynamicObject[] payBills = CasPayBillTestHelper.fullPushPayBill("ap_finapbill", Collections.singletonList(finBill.getLong("id")), null);
        long payBillId = payBills[0].getLong("id");
        DynamicObject[] records = SettleRecordTestHelper.loadData(new Long[]{finpk}, new Long[]{payBillId}, false);
        SettleRecordTestHelper.setIsVoucherToTrue(records);
        DynamicObject writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(finpk);
        this.validateData(finpk, writeOffBill, payBillId, false);
        boolean isExists = SettleRecordTestHelper.existsWriteOff(new Long[]{finpk}, new Long[]{payBillId}, false);
        AP016_016_ApFin2Pay2WriteOffTest.assertEquals((String)"\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u7ed3\u7b97\u8bb0\u5f55\u53cd\u7ed3\u7b97\u672a\u751f\u6210\u7ea2\u51b2\u7ed3\u7b97\u8bb0\u5f55\u3002", (boolean)true, (boolean)isExists);
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{writeOffBill.getLong("id")}, (OperateOption)OperateOption.create());
        AP016_016_ApFin2Pay2WriteOffTest.assertEquals((String)"\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u5931\u8d25", (boolean)true, (boolean)unAudit.isSuccess());
        FinApBillTestChecker.validateInitialApFin(finpk);
    }

    private void validateData(long finPk, DynamicObject writeOffBill, long payBillId, boolean isManyToOne) {
        FinApBillTestChecker.validateFinishApFin(finPk, true, true);
        long writerOffId = writeOffBill.getLong("id");
        FinApBillTestChecker.validateApFinVerifyRecordData(finPk, writerOffId);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{finPk}, new Long[]{writerOffId}, false);
        Map<String, HashSet<Long>> targetBills = BOTPHelper.findTargetBills("ap_finapbill", finPk);
        AP016_016_ApFin2Pay2WriteOffTest.assertEquals((String)"\u6e90\u8d22\u52a1\u5e94\u4ed8\u5355\u672a\u4e0e\u4ed8\u6b3e\u5355\u65adBOTP\u5173\u7cfb", (boolean)false, (boolean)targetBills.containsKey("cas_paybill"));
        FinApBillTestChecker.validateFinishApFin(writeOffBill, true, true);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(new Long[]{finPk}, new Long[]{payBillId}, false);
        AP016_016_ApFin2Pay2WriteOffTest.assertEquals((String)"\u6e90\u8d22\u52a1\u5e94\u4ed8\u5355\u548c\u4ed8\u6b3e\u5355\u7684\u7ed3\u7b97\u8bb0\u5f55\u5e94\u8be5\u4e3a4\u6761", (boolean)true, (settleRecords.length == 4 ? 1 : 0) != 0);
        SettleRecordTestChecker.checkSettleAmtAndJournal(settleRecords);
        DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        if (isManyToOne) {
            this.validateCasPayBill(payBill);
        } else {
            CasPayBillTestChecker.validateInitialCasPayBill(payBill);
        }
    }

    private void validateCasPayBill(DynamicObject casPayBill) {
        DynamicObjectCollection detailRows = casPayBill.getDynamicObjectCollection("entry");
        DynamicObject detail = (DynamicObject)detailRows.get(0);
        CasPayBillTestChecker.validateCasPayBillDetailRefundAmt(detail, BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayDetailLockAmt(detail, BigDecimal.ZERO, BigDecimal.valueOf(70L));
        CasPayBillTestChecker.validateCasPayDetailSettleAmt(detail, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(70L), BigDecimal.valueOf(423.15));
        detail = (DynamicObject)detailRows.get(1);
        CasPayBillTestChecker.validateCasPayBillDetailRefundAmt(detail, BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayDetailLockAmt(detail, BigDecimal.ZERO, BigDecimal.valueOf(30L));
        CasPayBillTestChecker.validateCasPayDetailSettleAmt(detail, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.valueOf(181.35));
        detail = (DynamicObject)detailRows.get(2);
        CasPayBillTestChecker.validateCasPayBillDetailRefundAmt(detail, BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayDetailLockAmt(detail, BigDecimal.valueOf(60L), BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayDetailSettleAmt(detail, BigDecimal.valueOf(60L), BigDecimal.valueOf(362.7), BigDecimal.ZERO, BigDecimal.ZERO);
        detail = (DynamicObject)detailRows.get(3);
        CasPayBillTestChecker.validateCasPayBillDetailRefundAmt(detail, BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayDetailLockAmt(detail, BigDecimal.valueOf(40L), BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayDetailSettleAmt(detail, BigDecimal.valueOf(40L), BigDecimal.valueOf(241.8), BigDecimal.ZERO, BigDecimal.ZERO);
    }
}

