/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.apfin;

import java.math.BigDecimal;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.list.IListView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SimulatorTestHelper;
import org.junit.Test;

public class AP016_018_ApFinTransPay2WriteOffTes
extends AbstractJUnitTestPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8-\u8f6c\u4ed8 AND \u8f6c\u4ed8-\u51b2\u9500\uff08\u6574\u5355\u8f6c\u4ed8\uff0c\u8ba1\u5212\u884c,\u4eba\u6c11\u5e01\u6570\u636e,\u6709bug\uff09")
    @Test
    public void ApFinUnitTest_001() {
        DynamicObject srcBill = FinApBillTestDataProvider.createFinApBill(false, false, "AP016_018_apfin_1");
        long srcPk = srcBill.getLong("id");
        FinApBillTestHelper.searchOneRowDataByBillNo(this, "AP016_018_apfin_1");
        SimulatorTestHelper util = new SimulatorTestHelper(this);
        IFormView turnPayView = util.clickBarItemReturnChildView((IFormView)((IListView)this.getView()), "transferall", "transferall");
        IDataModel turnPayModel = turnPayView.getModel();
        turnPayModel.setValue("head_exchangerate", (Object)BigDecimal.ONE);
        turnPayModel.setValue("t_asstact", (Object)BaseDataTestProvider.getSupplier(), 0);
        turnPayModel.setValue("t_payproperty", (Object)BaseDataTestProvider.getPayProperty(), 0);
        turnPayModel.setValue("transamount", (Object)BigDecimal.valueOf(100L), 0);
        turnPayView.invokeOperation("transferall");
        long transBillId = FinApBillTestHelper.getTransBillId(srcPk);
        OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{transBillId}, (OperateOption)OperateOption.create());
        DynamicObject writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(transBillId);
        this.validateDataByBill(srcPk, writeOffBill, transBillId);
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{writeOffBill.getLong("id")}, (OperateOption)OperateOption.create());
        AP016_018_ApFinTransPay2WriteOffTes.assertEquals((String)"\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u5931\u8d25", (boolean)true, (boolean)unAudit.isSuccess());
        this.validateTransBill(transBillId);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8-\u8f6c\u4ed8 AND \u8f6c\u4ed8-\u51b2\u9500\uff08\u6309\u884c\u8f6c\u4ed8\uff0c\u7269\u6599\u884c,\u7f8e\u5143\u6570\u636e\uff0c\u6709bug\uff09")
    @Test
    public void ApFinUnitTest_002() {
        DynamicObject srcBill = FinApBillTestDataProvider.createFinApBill(true, true, true, true, "AP016_018_apfin_2");
        long srcPk = srcBill.getLong("id");
        FinApBillTestHelper.searchOneRowDataByBillNo(this, "AP016_018_apfin_2");
        FinApBillTestHelper.turnPayByRow(this);
        long transBillId = FinApBillTestHelper.getTransBillId(srcPk);
        OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{transBillId}, (OperateOption)OperateOption.create());
        DynamicObject transBill = BusinessDataServiceHelper.loadSingle((Object)transBillId, (String)"ap_finapbill");
        DynamicObject[] dynamicObjects = FinApBillTestHelper.remedyNoSameRateFinApData(new DynamicObject[]{transBill}, BigDecimal.valueOf(6.045));
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        DynamicObject writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(transBillId);
        this.validateDataByRow(srcPk, writeOffBill, transBillId);
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{writeOffBill.getLong("id")}, (OperateOption)OperateOption.create());
        AP016_018_ApFinTransPay2WriteOffTes.assertEquals((String)"\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u5931\u8d25", (boolean)true, (boolean)unAudit.isSuccess());
        this.validateTransBillByRow(transBillId);
    }

    private void validateDataByRow(long srcFinId, DynamicObject writeOffBill, long transBillId) {
        FinApBillTestChecker.validateFinishApFin(srcFinId, false, false);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(new Long[]{srcFinId}, new Long[]{transBillId}, false);
        AP016_018_ApFinTransPay2WriteOffTes.assertEquals((String)"\u6e90\u8d22\u52a1\u5e94\u4ed8\u5355\u548c\u8f6c\u4ed8\u5355\u7684\u7ed3\u7b97\u8bb0\u5f55\u5e94\u8be5\u4e3a2\u6761", (boolean)true, (settleRecords.length == 2 ? 1 : 0) != 0);
        SettleRecordTestChecker.checkSettleAmtAndJournal(settleRecords);
        this.validateWriteOffBill(writeOffBill);
        FinApBillTestChecker.validateFinApSettledBill(transBillId);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{transBillId}, new Long[]{writeOffBill.getLong("id")}, false);
    }

    private void validateDataByBill(long srcFinId, DynamicObject writeOffBill, long transBillId) {
        FinApBillTestChecker.validateInitialApFin(srcFinId);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(new Long[]{srcFinId}, new Long[]{transBillId}, false);
        AP016_018_ApFinTransPay2WriteOffTes.assertEquals((String)"\u6e90\u8d22\u52a1\u5e94\u4ed8\u5355\u548c\u8f6c\u4ed8\u5355\u7684\u7ed3\u7b97\u8bb0\u5f55\u5e94\u8be5\u4e3a2\u6761", (boolean)true, (settleRecords.length == 2 ? 1 : 0) != 0);
        SettleRecordTestChecker.checkSettleAmtAndJournal(settleRecords);
        FinApBillTestChecker.validateFinishApFin(writeOffBill, true, false);
        FinApBillTestChecker.validateFinApSettledBill(transBillId);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{transBillId}, new Long[]{writeOffBill.getLong("id")}, false);
    }

    private void validateTransBill(long transBillId) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)transBillId, (String)"ap_finapbill");
        AP016_018_ApFinTransPay2WriteOffTes.assertEquals((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u5e94\u4e3a\u672a\u7ed3\u7b97", (String)"unsettle", (String)finBill.getString("settlestatus"));
        FinApBillTestChecker.validateApFinHeadSettleAmt(finBill, BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHeadVerifyData(finBill, "10", BigDecimal.valueOf(100L));
        DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        DynamicObject entry = (DynamicObject)detailEntry.get(0);
        FinApBillTestChecker.validateApFinDetailSettleAmt(entry, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.valueOf(100L));
        FinApBillTestChecker.validateApFinDetailLockAmt(entry, BigDecimal.ZERO, BigDecimal.valueOf(100L));
        FinApBillTestChecker.validateApFinPlanSettleAmt((DynamicObject)planEntity.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.valueOf(100L));
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(0), BigDecimal.ZERO, BigDecimal.valueOf(100L));
    }

    private void validateTransBillByRow(long transBillId) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)transBillId, (String)"ap_finapbill");
        AP016_018_ApFinTransPay2WriteOffTes.assertEquals((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u5e94\u4e3a\u672a\u7ed3\u7b97", (String)"unsettle", (String)finBill.getString("settlestatus"));
        FinApBillTestChecker.validateApFinHeadSettleAmt(finBill, BigDecimal.valueOf(45L), BigDecimal.valueOf(283.7025), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHeadVerifyData(finBill, "10", BigDecimal.valueOf(40L));
        DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        DynamicObject entry = (DynamicObject)detailEntry.get(0);
        FinApBillTestChecker.validateApFinDetailSettleAmt(entry, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(15L), BigDecimal.valueOf(94.5675));
        FinApBillTestChecker.validateApFinDetailVerifyData(entry, BigDecimal.ZERO, BigDecimal.valueOf(2L), BigDecimal.ZERO, BigDecimal.valueOf(10L));
        FinApBillTestChecker.validateApFinDetailLockAmt(entry, BigDecimal.ZERO, BigDecimal.valueOf(15L));
        entry = (DynamicObject)detailEntry.get(1);
        FinApBillTestChecker.validateApFinDetailSettleAmt(entry, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.valueOf(189.135));
        FinApBillTestChecker.validateApFinDetailVerifyData(entry, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.valueOf(30L));
        FinApBillTestChecker.validateApFinDetailLockAmt(entry, BigDecimal.ZERO, BigDecimal.valueOf(30L));
        FinApBillTestChecker.validateApFinPlanSettleAmt((DynamicObject)planEntity.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(45L), BigDecimal.valueOf(283.7025));
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(0), BigDecimal.ZERO, BigDecimal.valueOf(45L));
    }

    private void validateWriteOffBill(DynamicObject writeOffBill) {
        AP016_018_ApFinTransPay2WriteOffTes.assertEquals((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u5e94\u4e3a\u5168\u90e8\u7ed3\u7b97", (String)"settled", (String)writeOffBill.getString("settlestatus"));
        FinApBillTestChecker.validateApFinHeadSettleAmt(writeOffBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-45L), BigDecimal.valueOf(-283.7025));
        FinApBillTestChecker.validateApFinHeadVerifyData(writeOffBill, "10", BigDecimal.valueOf(-40L));
        DynamicObjectCollection detailEntry = writeOffBill.getDynamicObjectCollection("detailentry");
        DynamicObjectCollection planEntity = writeOffBill.getDynamicObjectCollection("planentity");
        DynamicObject entry = (DynamicObject)detailEntry.get(0);
        FinApBillTestChecker.validateApFinDetailSettleAmt(entry, BigDecimal.valueOf(-15L), BigDecimal.valueOf(-94.5675), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData(entry, BigDecimal.ZERO, BigDecimal.valueOf(-2L), BigDecimal.ZERO, BigDecimal.valueOf(-10L));
        FinApBillTestChecker.validateApFinDetailLockAmt(entry, BigDecimal.valueOf(-15L), BigDecimal.ZERO);
        entry = (DynamicObject)detailEntry.get(1);
        FinApBillTestChecker.validateApFinDetailSettleAmt(entry, BigDecimal.valueOf(-30.0), BigDecimal.valueOf(-189.135), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData(entry, BigDecimal.ZERO, BigDecimal.valueOf(-1L), BigDecimal.ZERO, BigDecimal.valueOf(-30L));
        FinApBillTestChecker.validateApFinDetailLockAmt(entry, BigDecimal.valueOf(-30L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinPlanSettleAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(-45L), BigDecimal.valueOf(-283.7025), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(-45L), BigDecimal.ZERO);
    }
}

