/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.apfin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.factory.SettleServiceFactory;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.IManualSettleService;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PayApplyBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasPayBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.CasRecTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PayApplyBillTestHelper;
import kd.fi.arapcommon.unittest.scene.process.settle.ManualSettleUnitTestHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import org.junit.Test;

public class AP016_021_ApFinToPayAndReturnMoneyTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deletePayBills = Arrays.asList("ApToPayAndRefund_Pay_001", "ApToPayAndRefund_Pay_002", "ApToPayAndRefund_Pay_003", "ApToPayAndRefund_Pay_004");
        DeleteServiceHelper.delete((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deletePayBills)});
        List<String> deleteApplyBills = Collections.singletonList("ApToPayAndRefund_Appy_003");
        DeleteServiceHelper.delete((String)"ap_payapply", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteApplyBills)});
        List<String> deleteRecBills = Arrays.asList("ApToPayAndRefund_Rec_001", "ApToPayAndRefund_Rec_002", "ApToPayAndRefund_Rec_003", "ApToPayAndRefund_Rec_004");
        DeleteServiceHelper.delete((String)"cas_recbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteRecBills)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u5355->\u9000\u6b3e\u9000\u7968->\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff08\u5355\u5206\u5f55\uff09-\u65b0\u903b\u8f91")
    @Test
    public void testApToPayAndRefund_001() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinApBillDataDetailVO> details = new ArrayList<FinApBillDataDetailVO>(2);
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity("ApToPayAndRefund_AP_001", org, details);
        long apBillId = apBill.getLong("id");
        DynamicObject[] payBills = CasPayBillTestHelper.fullPushPayBill("ap_finapbill", Collections.singletonList(apBillId), "ApToPayAndRefund_Pay_001");
        DynamicObject recBill = CasRecBillTestDataProvider.createCasRecBillByReturnMoney("ApToPayAndRefund_Rec_001", BigDecimal.valueOf(40L), true, false);
        long recBillId = recBill.getLong("id");
        long payBillId = payBills[0].getLong("id");
        CasPayBillTestHelper.executeReturnMoney(this, payBillId, recBillId);
        this.sleep(recBillId);
        this.validateTestApToPayAndRefund_001_Confirm(apBillId, payBillId, recBillId);
        CasRecTestHelper.cancelRenoteOrRefund(recBillId);
        this.sleep(recBillId);
        this.validateTestApToPayAndRefund_001_Cancel(apBillId, payBillId, recBillId);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u5355->\u9000\u6b3e\u9000\u7968->\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff08\u591a\u5206\u5f55\uff09-\u65b0\u903b\u8f91")
    @Test
    public void testApToPayAndRefund_002() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinApBillDataDetailVO> details = new ArrayList<FinApBillDataDetailVO>(2);
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity("ApToPayAndRefund_AP_002", org, details);
        long apBillId = apBill.getLong("id");
        DynamicObject[] payBills = CasPayBillTestHelper.fullPushPayBill("ap_finapbill", Collections.singletonList(apBillId), "ApToPayAndRefund_Pay_002");
        DynamicObject recBill = CasRecBillTestDataProvider.createCasRecBillByReturnMoney("ApToPayAndRefund_Rec_002", BigDecimal.valueOf(200L), true, false);
        long recBillId = recBill.getLong("id");
        long payBillId = payBills[0].getLong("id");
        CasPayBillTestHelper.executeReturnMoney(this, payBillId, recBillId);
        this.sleep(recBillId);
        this.validateTestApToPayAndRefund_002_Confirm(apBillId, payBillId, recBillId);
        CasRecTestHelper.cancelRenoteOrRefund(recBillId);
        this.sleep(recBillId);
        this.validateTestApToPayAndRefund_002_Cancel(apBillId, payBillId, recBillId);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u7533\u8bf7->\u4ed8\u6b3e\u5355->\u9000\u6b3e\u9000\u7968->\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff08\u591a\u5206\u5f55\uff09-\u65b0\u903b\u8f91")
    @Test
    public void testApToPayAndRefund_003() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinApBillDataDetailVO> details = new ArrayList<FinApBillDataDetailVO>(2);
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity("ApToPayAndRefund_AP_003", org, details);
        long apBillId = apBill.getLong("id");
        DynamicObject[] applyBills = PayApplyBillTestHelper.pushPayApplyBill("ap_finapbill", Collections.singletonList(apBillId), "ApToPayAndRefund_Appy_003");
        long payApplyId = applyBills[0].getLong("id");
        DynamicObject[] payBills = CasPayBillTestHelper.fullPushPayBill("ap_payapply", Collections.singletonList(payApplyId), "ApToPayAndRefund_Pay_003");
        DynamicObject recBill = CasRecBillTestDataProvider.createCasRecBillByReturnMoney("ApToPayAndRefund_Rec_003", BigDecimal.valueOf(100L), true, false);
        long recBillId = recBill.getLong("id");
        long payBillId = payBills[0].getLong("id");
        CasPayBillTestHelper.executeReturnMoney(this, payBillId, recBillId);
        this.sleep(recBillId);
        this.validateTestApToPayAndRefund_003_Confirm(apBillId, payApplyId, payBillId, recBillId);
        CasRecTestHelper.cancelRenoteOrRefund(recBillId);
        this.sleep(recBillId);
        this.validateTestApToPayAndRefund_003_Cancel(apBillId, payApplyId, payBillId, recBillId);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8\u548c\u4ed8\u6b3e\u5355\u624b\u5de5\u7ed3\u7b97->\u9000\u6b3e\u9000\u7968->\u53d6\u6d88\u9000\u6b3e\u9000\u7968-\u65b0\u903b\u8f91")
    @Test
    public void testApToPayAndRefund_004() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinApBillDataDetailVO> details = new ArrayList<FinApBillDataDetailVO>(1);
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity("ApToPayAndRefund_AP_004", org, details);
        long apBillId = apBill.getLong("id");
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(1);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal("ApToPayAndRefund_Pay_004", org, entryInfoPayList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal(apBill, BigDecimal.valueOf(100L), false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal(payBill, BigDecimal.valueOf(100L), false);
        IManualSettleService service = SettleServiceFactory.getManualService("appaysettle");
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk(orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam(orgId));
        service.manualSettle(mainRows, asstRows, param);
        DynamicObject recBill = CasRecBillTestDataProvider.createCasRecBillByReturnMoney("ApToPayAndRefund_Rec_004", BigDecimal.valueOf(100L), true, false);
        long recBillId = recBill.getLong("id");
        long payBillId = payBill.getLong("id");
        CasPayBillTestHelper.executeReturnMoney(this, payBillId, recBillId);
        this.sleep(recBillId);
        this.validateTestApToPayAndRefund_004_Confirm(apBillId, payBillId, recBillId);
        CasRecTestHelper.cancelRenoteOrRefund(recBillId);
        this.sleep(recBillId);
        this.validateTestApToPayAndRefund_004_Cancel(apBillId, payBillId, recBillId);
    }

    private void validateTestApToPayAndRefund_001_Confirm(long finBillId, long payBillId, long casRecBillId) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ap_finapbill");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u90e8\u5206\u7ed3\u7b97", (String)"partsettle", (String)finBill.getString("settlestatus"));
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(60L), BigDecimal.valueOf(40L));
        DynamicObject casPayBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)"\u4ed8\u6b3e\u5355\u8868\u5934\u72b6\u6001\u5e94\u4e3a\u9000\u6b3e\u72b6\u6001", (boolean)true, (boolean)"I".equals(casPayBill.getString("billstatus")));
        DynamicObjectCollection entry = casPayBill.getDynamicObjectCollection("entry");
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(40L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)casRecBillId, (String)"cas_recbill");
        BigDecimal eSettledAmt = ((DynamicObject)recBill.getDynamicObjectCollection("entry").get(0)).getBigDecimal("e_settledamt");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)String.format("\u6536\u6b3e\u5355[%s]\u9000\u6b3e\u5931\u8d25,\u5206\u5f55\u7ed3\u7b97\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", recBill.getString("billno")), (int)0, (int)BigDecimal.valueOf(40L).compareTo(eSettledAmt));
    }

    private void validateTestApToPayAndRefund_001_Cancel(long finBillId, long payBillId, long casRecBillId) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ap_finapbill");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u5168\u90e8\u7ed3\u7b97", (String)"settled", (String)finBill.getString("settlestatus"));
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(100L), BigDecimal.valueOf(0L));
        DynamicObject casPayBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)"\u4ed8\u6b3e\u5355\u8868\u5934\u72b6\u6001\u5e94\u4e3a\u4ed8\u6b3e\u72b6\u6001", (boolean)true, (boolean)"D".equals(casPayBill.getString("billstatus")));
        DynamicObjectCollection entry = casPayBill.getDynamicObjectCollection("entry");
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)casRecBillId, (String)"cas_recbill");
        BigDecimal eSettledAmt = ((DynamicObject)recBill.getDynamicObjectCollection("entry").get(0)).getBigDecimal("e_settledamt");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)String.format("\u6536\u6b3e\u5355[%s]\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u5931\u8d25,\u5206\u5f55\u7ed3\u7b97\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", recBill.getString("billno")), (int)0, (int)BigDecimal.valueOf(0L).compareTo(eSettledAmt));
    }

    private void validateTestApToPayAndRefund_002_Confirm(long finBillId, long payBillId, long casRecBillId) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ap_finapbill");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u672a\u7ed3\u7b97", (String)"unsettle", (String)finBill.getString("settlestatus"));
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(100L));
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(1), BigDecimal.valueOf(0L), BigDecimal.valueOf(100L));
        DynamicObject casPayBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)"\u4ed8\u6b3e\u5355\u8868\u5934\u72b6\u6001\u5e94\u4e3a\u9000\u6b3e\u72b6\u6001", (boolean)true, (boolean)"I".equals(casPayBill.getString("billstatus")));
        DynamicObjectCollection entry = casPayBill.getDynamicObjectCollection("entry");
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)casRecBillId, (String)"cas_recbill");
        BigDecimal eSettledAmt = ((DynamicObject)recBill.getDynamicObjectCollection("entry").get(0)).getBigDecimal("e_settledamt");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)String.format("\u6536\u6b3e\u5355[%s]\u9000\u6b3e\u5931\u8d25,\u5206\u5f55\u7ed3\u7b97\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4\uff0c\u5e94\u8be5\u4e3a\u5168\u90e8\u7ed3\u7b97\u72b6\u6001", recBill.getString("billno")), (int)0, (int)BigDecimal.valueOf(200L).compareTo(eSettledAmt));
    }

    private void validateTestApToPayAndRefund_002_Cancel(long finBillId, long payBillId, long casRecBillId) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ap_finapbill");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u5168\u90e8\u7ed3\u7b97", (String)"settled", (String)finBill.getString("settlestatus"));
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(100L), BigDecimal.valueOf(0L));
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(1), BigDecimal.valueOf(100L), BigDecimal.valueOf(0L));
        DynamicObject casPayBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)"\u4ed8\u6b3e\u5355\u8868\u5934\u72b6\u6001\u5e94\u4e3a\u4ed8\u6b3e\u72b6\u6001", (boolean)true, (boolean)"D".equals(casPayBill.getString("billstatus")));
        DynamicObjectCollection entry = casPayBill.getDynamicObjectCollection("entry");
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(0L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)casRecBillId, (String)"cas_recbill");
        BigDecimal eSettledAmt = ((DynamicObject)recBill.getDynamicObjectCollection("entry").get(0)).getBigDecimal("e_settledamt");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)String.format("\u6536\u6b3e\u5355[%s]\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u5931\u8d25,\u5206\u5f55\u7ed3\u7b97\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4\uff0c\u5e94\u8be5\u4e3a\u672a\u7ed3\u7b97\u72b6\u6001", recBill.getString("billno")), (int)0, (int)BigDecimal.valueOf(0L).compareTo(eSettledAmt));
    }

    private void validateTestApToPayAndRefund_003_Confirm(long finBillId, long payApplyId, long payBillId, long casRecBillId) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ap_finapbill");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u672a\u7ed3\u7b97", (String)"unsettle", (String)finBill.getString("settlestatus"));
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(1), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject applyBill = BusinessDataServiceHelper.loadSingle((Object)payApplyId, (String)"ap_payapply");
        DynamicObjectCollection applyEntry = applyBill.getDynamicObjectCollection("entry");
        PayApplyBillTestChecker.validatePayApplyDetailLock((DynamicObject)applyEntry.get(0), BigDecimal.ZERO, BigDecimal.ZERO);
        PayApplyBillTestChecker.validatePayApplyDetailLock((DynamicObject)applyEntry.get(1), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject casPayBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)"\u4ed8\u6b3e\u5355\u8868\u5934\u72b6\u6001\u5e94\u4e3a\u9000\u6b3e\u72b6\u6001", (boolean)true, (boolean)"I".equals(casPayBill.getString("billstatus")));
        DynamicObjectCollection entry = casPayBill.getDynamicObjectCollection("entry");
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.ZERO, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.ZERO, BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.ZERO, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)casRecBillId, (String)"cas_recbill");
        BigDecimal eSettledAmt = ((DynamicObject)recBill.getDynamicObjectCollection("entry").get(0)).getBigDecimal("e_settledamt");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)String.format("\u6536\u6b3e\u5355[%s]\u9000\u6b3e\u5931\u8d25,\u5206\u5f55\u7ed3\u7b97\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4\uff0c\u5e94\u8be5\u4e3a\u5168\u90e8\u7ed3\u7b97\u72b6\u6001", recBill.getString("billno")), (int)0, (int)BigDecimal.valueOf(100L).compareTo(eSettledAmt));
    }

    private void validateTestApToPayAndRefund_003_Cancel(long finBillId, long payApplyId, long payBillId, long casRecBillId) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ap_finapbill");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u90e8\u5206\u7ed3\u7b97", (String)"partsettle", (String)finBill.getString("settlestatus"));
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(1), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject applyBill = BusinessDataServiceHelper.loadSingle((Object)payApplyId, (String)"ap_payapply");
        DynamicObjectCollection applyEntry = applyBill.getDynamicObjectCollection("entry");
        PayApplyBillTestChecker.validatePayApplyDetailLock((DynamicObject)applyEntry.get(0), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        PayApplyBillTestChecker.validatePayApplyDetailLock((DynamicObject)applyEntry.get(1), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject casPayBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)"\u4ed8\u6b3e\u5355\u8868\u5934\u72b6\u6001\u5e94\u4e3a\u4ed8\u6b3e\u72b6\u6001", (boolean)true, (boolean)"D".equals(casPayBill.getString("billstatus")));
        DynamicObjectCollection entry = casPayBill.getDynamicObjectCollection("entry");
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.ZERO, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.ZERO, BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.ZERO, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)casRecBillId, (String)"cas_recbill");
        BigDecimal eSettledAmt = ((DynamicObject)recBill.getDynamicObjectCollection("entry").get(0)).getBigDecimal("e_settledamt");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)String.format("\u6536\u6b3e\u5355[%s]\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u5931\u8d25,\u5206\u5f55\u7ed3\u7b97\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4\uff0c\u5e94\u8be5\u4e3a\u672a\u7ed3\u7b97\u72b6\u6001", recBill.getString("billno")), (int)0, (int)BigDecimal.valueOf(0L).compareTo(eSettledAmt));
    }

    private void validateTestApToPayAndRefund_004_Confirm(long finBillId, long payBillId, long casRecBillId) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ap_finapbill");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u672a\u7ed3\u7b97", (String)"unsettle", (String)finBill.getString("settlestatus"));
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(100L));
        DynamicObject casPayBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)"\u4ed8\u6b3e\u5355\u8868\u5934\u72b6\u6001\u5e94\u4e3a\u9000\u6b3e\u72b6\u6001", (boolean)true, (boolean)"I".equals(casPayBill.getString("billstatus")));
        DynamicObjectCollection entry = casPayBill.getDynamicObjectCollection("entry");
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)casRecBillId, (String)"cas_recbill");
        BigDecimal eSettledAmt = ((DynamicObject)recBill.getDynamicObjectCollection("entry").get(0)).getBigDecimal("e_settledamt");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)String.format("\u6536\u6b3e\u5355[%s]\u9000\u6b3e\u5931\u8d25,\u5206\u5f55\u7ed3\u7b97\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4\uff0c\u5e94\u8be5\u4e3a\u5168\u90e8\u7ed3\u7b97\u72b6\u6001", recBill.getString("billno")), (int)0, (int)BigDecimal.valueOf(100L).compareTo(eSettledAmt));
    }

    private void validateTestApToPayAndRefund_004_Cancel(long finBillId, long payBillId, long casRecBillId) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ap_finapbill");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u5168\u90e8\u7ed3\u7b97", (String)"settled", (String)finBill.getString("settlestatus"));
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(100L), BigDecimal.valueOf(0L));
        DynamicObject casPayBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)"\u4ed8\u6b3e\u5355\u8868\u5934\u72b6\u6001\u5e94\u4e3a\u4ed8\u6b3e\u72b6\u6001", (boolean)true, (boolean)"D".equals(casPayBill.getString("billstatus")));
        DynamicObjectCollection entry = casPayBill.getDynamicObjectCollection("entry");
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)casRecBillId, (String)"cas_recbill");
        BigDecimal eSettledAmt = ((DynamicObject)recBill.getDynamicObjectCollection("entry").get(0)).getBigDecimal("e_settledamt");
        AP016_021_ApFinToPayAndReturnMoneyTest.assertEquals((String)String.format("\u6536\u6b3e\u5355[%s]\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u5931\u8d25,\u5206\u5f55\u7ed3\u7b97\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4\uff0c\u5e94\u8be5\u4e3a\u672a\u7ed3\u7b97\u72b6\u6001", recBill.getString("billno")), (int)0, (int)BigDecimal.valueOf(0L).compareTo(eSettledAmt));
    }

    private void sleep(long recBillId) {
        int count = 1;
        List locked = TxCheckUtil.getLocked(Collections.singletonList(String.valueOf(recBillId)));
        boolean isEC = locked.contains(String.valueOf(recBillId));
        while (isEC) {
            ++count;
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            locked = TxCheckUtil.getLocked(Collections.singletonList(String.valueOf(recBillId)));
            isEC = locked.contains(String.valueOf(recBillId));
            if (count <= 30) continue;
            isEC = false;
        }
    }
}

