/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.apinvoice;

import java.util.Collections;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.ApInvoiceBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.ApInvoiceBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.ApInvoiceBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import org.junit.Test;

public class AP018_002_Invoice2Fin2WriterOffTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        ApInvoiceBillTestHelper.setAP001(BaseDataTestProvider.getDetailInitOrg().getLong("id"), false);
    }

    @TestMethod(value=1)
    @DisplayName(value="\u6536\u7968\u5355->\u8d22\u52a1\u5e94\u4ed8->\u51b2\u9500\uff08\u7269\u6599\u884c\uff0c\u4eba\u6c11\u5e01\uff09")
    @Test
    public void unitTest_001() {
        DynamicObject invoice = ApInvoiceBillTestDataProvider.createApInvoiceBill("AP018_002_apinvoice_1", false, true, false);
        long invId = invoice.getLong("id");
        DynamicObject[] finApBills = FinApBillTestHelper.fullPushFinApBill("ap_invoice", Collections.singletonList(invId), null);
        long finId = finApBills[0].getLong("id");
        ApInvoiceBillTestChecker.validateInvRelationAmtByFull(invId);
        FinApBillTestHelper.executeAndGetWriteOffBill(finId);
        ApInvoiceBillTestChecker.validateInvRelationAmtByZero(invId);
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{FinApBillTestHelper.getWriteOffBillId(finId)}, (OperateOption)OperateOption.create());
        AP018_002_Invoice2Fin2WriterOffTest.assertEquals((String)"\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u5931\u8d25", (boolean)true, (boolean)unAudit.isSuccess());
        FinApBillTestChecker.validateInitialApFin(finId);
        ApInvoiceBillTestChecker.validateInvRelationAmtByFull(invId);
    }
}

