/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.arfin;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.RevCfmBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.check.VerifyRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import kd.fi.arapcommon.unittest.scene.process.arfin.FinBillBaseTest;
import org.junit.Test;

public class AR018_002_WriteOffFinArTest
extends FinBillBaseTest {
    private static final String RULE_ID = "516550166468103168";
    private long writeOffFinArBillId;
    private long redRevCfmBillId;
    private long autoRevCfmBillId;
    private static final String FIN_BILL_SELECT = "id, sourcebillId, sourcebilltype, hadwrittenoff, iswrittenoff, entry.e_confirmedamt e_confirmedamt, entry.e_unconfirmamt e_unconfirmamt, entry.e_amount e_amount";
    private static final String REV_BILL_SELECT = "id, hadwrittenoff, iswrittenoff";

    public void initData() {
        super.initData();
        FinArBillDataVO header = new FinArBillDataVO();
        header.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id"));
        header.setExchangerate(BigDecimal.valueOf(1L));
        header.setOrg(BaseDataTestProvider.getDetailInitOrg());
        header.setBillNo("AR_018_002-TEST");
        header.setBillStatus("B");
        DynamicObject finArBill = FinArBillTestDataProvider.createAR018FinBill(header, new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.finArBillId = finArBill.getLong("id");
        long orgId = finArBill.getLong("org.id");
        this.billNo = finArBill.getString("billno");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("ar_005", 1);
        SystemParameterHelper.setSystemParameter(true, orgId, params);
        OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])new Object[]{this.finArBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        FinArBillTestHelper.checkFinJournal(this.finArBillId);
    }

    @TestMethod(value=1)
    @DisplayName(value="\u51b2\u9500\u5355\u4fdd\u5b58")
    @Test
    public void tetWriteOff() {
        List<DynamicObject> writeOffFinArBill = BOTPHelper.push("ar_finarbill", "ar_finarbill", RULE_ID, Collections.singletonList(this.finArBillId));
        KDAssert.assertTrue((String)"\u751f\u6210\u51b2\u9500\u5355\u5931\u8d25", (writeOffFinArBill.size() > 0 ? 1 : 0) != 0);
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])writeOffFinArBill.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        DynamicObjectCollection writeOffFinBillList = QueryServiceHelper.query((String)"ar_finarbill", (String)FIN_BILL_SELECT, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)result.getSuccessPkIds())});
        KDAssert.assertTrue((String)"\u51b2\u9500\u5355\u672a\u751f\u6210", (writeOffFinBillList.size() > 0 ? 1 : 0) != 0);
        DynamicObject writeOffFinBill = (DynamicObject)writeOffFinBillList.get(0);
        this.writeOffFinArBillId = writeOffFinBill.getLong("id");
        KDAssert.assertEquals((String)"\u51b2\u9500\u5355\u6e90\u5355\u7c7b\u578b\u6821\u9a8c\u5931\u8d25", (String)"ar_finarbill", (String)writeOffFinBill.getString("sourcebilltype"));
        KDAssert.assertEquals((String)"\u51b2\u9500\u5355\u6e90\u5355ID\u6821\u9a8c\u5931\u8d25", (long)this.finArBillId, (long)Long.parseLong(writeOffFinBill.getString("sourcebillid")));
        KDAssert.assertEquals((String)"\u51b2\u9500\u5355\u51b2\u9500\u6807\u8bc6\u6821\u9a8c\u5931\u8d25", (boolean)true, (boolean)writeOffFinBill.getBoolean("iswrittenoff"));
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.finArBillId}, new Long[]{this.writeOffFinArBillId}, true);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u4e0b\u6e38\u7ea2\u5b57\u6536\u5165\u786e\u8ba4\u5355\u6821\u9a8c")
    @Test
    public void testRevCfm() {
        DynamicObjectCollection originRevCfmBillList = QueryServiceHelper.query((String)"ar_revcfmbill", (String)REV_BILL_SELECT, (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)this.finArBillId)});
        KDAssert.assertTrue((originRevCfmBillList.size() > 0 ? 1 : 0) != 0);
        DynamicObject originRevCfmBill = (DynamicObject)originRevCfmBillList.get(0);
        KDAssert.assertNotNull((String)"\u672a\u81ea\u52a8\u6536\u5165\u786e\u8ba4", (Object)originRevCfmBill);
        this.autoRevCfmBillId = originRevCfmBill.getLong("id");
        KDAssert.assertEquals((String)"\u81ea\u52a8\u751f\u6210\u6536\u5165\u786e\u8ba4\u5355\u88ab\u51b2\u9500\u6807\u8bc6\u6821\u9a8c\u5931\u8d25", (boolean)true, (boolean)originRevCfmBill.getBoolean("hadwrittenoff"));
        KDAssert.assertEquals((String)"\u81ea\u52a8\u751f\u6210\u6536\u5165\u786e\u8ba4\u5355\u51b2\u9500\u6807\u8bc6\u6821\u9a8c\u5931\u8d25", (boolean)false, (boolean)originRevCfmBill.getBoolean("iswrittenoff"));
        DynamicObjectCollection redRevCfmBillList = QueryServiceHelper.query((String)"ar_revcfmbill", (String)REV_BILL_SELECT, (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)originRevCfmBill.getLong("id"))});
        KDAssert.assertTrue((String)"\u672a\u751f\u6210\u7ea2\u5b57\u6536\u5165\u786e\u8ba4", (redRevCfmBillList.size() > 0 ? 1 : 0) != 0);
        DynamicObject redRevCfmBill = (DynamicObject)redRevCfmBillList.get(0);
        this.redRevCfmBillId = redRevCfmBill.getLong("id");
        KDAssert.assertEquals((String)"\u81ea\u52a8\u751f\u6210\u7ea2\u5b57\u6536\u5165\u786e\u8ba4\u5355\u88ab\u51b2\u9500\u6807\u8bc6\u6821\u9a8c\u5931\u8d25", (boolean)false, (boolean)redRevCfmBill.getBoolean("hadwrittenoff"));
        KDAssert.assertEquals((String)"\u81ea\u52a8\u751f\u6210\u7ea2\u5b57\u6536\u5165\u786e\u8ba4\u5355\u51b2\u9500\u6807\u8bc6\u6821\u9a8c\u5931\u8d25", (boolean)true, (boolean)redRevCfmBill.getBoolean("iswrittenoff"));
        VerifyRecordTestChecker.checkVerifyRecordExists(this.autoRevCfmBillId, this.redRevCfmBillId, true, true);
        DynamicObject revCfmBill = BusinessDataServiceHelper.loadSingle((Object)this.autoRevCfmBillId, (String)"ar_revcfmbill");
        DynamicObjectCollection detailEntries = revCfmBill.getDynamicObjectCollection("entry");
        RevCfmBillTestChecker.validateDetailEntryVerify((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(10L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        RevCfmBillTestChecker.validateDetailEntryVerify((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(10L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u51b2\u9500\u5355\u53cd\u5199\u6821\u9a8c")
    @Test
    public void testOriginFinBill() {
        DynamicObjectCollection originFinArBillList = QueryServiceHelper.query((String)"ar_finarbill", (String)FIN_BILL_SELECT, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.finArBillId)});
        KDAssert.assertTrue((String)"\u672a\u627e\u5230\u6e90\u8d22\u52a1\u5e94\u6536\u5355", (originFinArBillList.size() > 0 ? 1 : 0) != 0);
        KDAssert.assertNotNull((Object)originFinArBillList.get(0));
        KDAssert.assertEquals((String)"\u6e90\u8d22\u52a1\u5e94\u6536\u5355\u88ab\u51b2\u9500\u6807\u8bc6\u6821\u9a8c\u5f02\u5e38", (boolean)true, (boolean)((DynamicObject)originFinArBillList.get(0)).getBoolean("hadwrittenoff"));
        KDAssert.assertEquals((String)"\u6e90\u8d22\u52a1\u5e94\u6536\u5355\u51b2\u9500\u6807\u8bc6\u6821\u9a8c\u5f02\u5e38", (boolean)false, (boolean)((DynamicObject)originFinArBillList.get(0)).getBoolean("iswrittenoff"));
        for (DynamicObject originFinArBill : originFinArBillList) {
            KDAssert.assertEquals((String)"\u6e90\u8d22\u52a1\u5e94\u6536\u5355\u5206\u5f55\u672a\u786e\u8ba4\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", (int)0, (int)originFinArBill.getBigDecimal("e_amount").compareTo(originFinArBill.getBigDecimal("e_unconfirmamt")));
            KDAssert.assertEquals((String)"\u6e90\u8d22\u52a1\u5e94\u6536\u5355\u5206\u5f55\u786e\u8ba4\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", (int)0, (int)originFinArBill.getBigDecimal("e_confirmedamt").compareTo(BigDecimal.ZERO));
        }
        FinArBillTestHelper.checkFinJournal(this.writeOffFinArBillId);
        DynamicObject finBill = this.getFinBill(this.finArBillId);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.valueOf(2000L), BigDecimal.valueOf(2000L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryConfirmAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryConfirmAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryVerify((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(10L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryVerify((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(10L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u51b2\u9500\u5355\u53cd\u5ba1\u6838")
    @Test
    public void testWriteOffUnAudit() {
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (Object[])new Object[]{this.writeOffFinArBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        boolean writeOffFinArBillExist = QueryServiceHelper.exists((String)"ar_finarbill", (Object)this.writeOffFinArBillId);
        KDAssert.assertFalse((String)"\u51b2\u9500\u5355\u672a\u5220\u9664", (boolean)writeOffFinArBillExist);
        boolean redRevCfmExist = QueryServiceHelper.exists((String)"ar_revcfmbill", (Object)this.redRevCfmBillId);
        KDAssert.assertFalse((String)"\u7ea2\u5b57\u6536\u5165\u786e\u8ba4\u5355\u672a\u5220\u9664", (boolean)redRevCfmExist);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u53cd\u5199\u68c0\u67e5")
    @Test
    public void testOriginFinBill2() {
        DynamicObjectCollection originFinArBillList = QueryServiceHelper.query((String)"ar_finarbill", (String)FIN_BILL_SELECT, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.finArBillId)});
        KDAssert.assertTrue((originFinArBillList.size() > 0 ? 1 : 0) != 0);
        KDAssert.assertNotNull((String)"\u6e90\u8d22\u52a1\u5e94\u6536\u5355\u672a\u627e\u5230", (Object)originFinArBillList.get(0));
        KDAssert.assertEquals((String)"\u6e90\u8d22\u52a1\u5e94\u6536\u5355\u88ab\u51b2\u9500\u6807\u8bc6\u6821\u9a8c\u5f02\u5e38", (boolean)false, (boolean)((DynamicObject)originFinArBillList.get(0)).getBoolean("hadwrittenoff"));
        KDAssert.assertEquals((String)"\u6e90\u8d22\u52a1\u5e94\u6536\u5355\u51b2\u9500\u6807\u8bc6\u6821\u9a8c\u5f02\u5e38", (boolean)false, (boolean)((DynamicObject)originFinArBillList.get(0)).getBoolean("iswrittenoff"));
        for (DynamicObject originFinArBill : originFinArBillList) {
            KDAssert.assertEquals((String)"\u6e90\u8d22\u52a1\u5e94\u6536\u5355\u5206\u5f55\u672a\u786e\u8ba4\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", (int)0, (int)originFinArBill.getBigDecimal("e_unconfirmamt").compareTo(BigDecimal.ZERO));
            KDAssert.assertEquals((String)"\u6e90\u8d22\u52a1\u5e94\u6536\u5355\u5206\u5f55\u786e\u8ba4\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", (int)0, (int)originFinArBill.getBigDecimal("e_amount").compareTo(originFinArBill.getBigDecimal("e_confirmedamt")));
        }
        VerifyRecordTestChecker.checkVerifyRecordExists(this.autoRevCfmBillId, this.redRevCfmBillId, true, false);
        DynamicObject finBill = this.getFinBill(this.finArBillId);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(2000L), BigDecimal.valueOf(2000L));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryConfirmAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryConfirmAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryVerify((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(10L), BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryVerify((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(10L), BigDecimal.valueOf(1000L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
    }
}

