/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.arfin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import kd.fi.arapcommon.unittest.scene.process.arfin.FinBillBaseTest;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import org.junit.Test;

public class AR018_004_TransferFinArTest
extends FinBillBaseTest {
    private Set<Long> transferBillId1 = new HashSet<Long>(16);
    private Set<Long> transferBillId2 = new HashSet<Long>(16);
    private long cacheFinBillId1;
    private long cacheFinBillId2;

    public void initData() {
        super.initData();
        FinArBillDataVO header = new FinArBillDataVO();
        header.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id"));
        header.setExchangerate(BigDecimal.valueOf(1L));
        header.setOrg(BaseDataTestProvider.getDetailInitOrg());
        header.setBillNo("AR_018_004-TEST-1");
        DynamicObject finArBill1 = FinArBillTestDataProvider.createAR018FinBill(header, new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.cacheFinBillId1 = finArBill1.getLong("id");
        FinArBillDataVO header1 = new FinArBillDataVO();
        header1.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id"));
        header1.setExchangerate(BigDecimal.valueOf(1L));
        header1.setOrg(BaseDataTestProvider.getDetailInitOrg());
        header1.setBillNo("AR_018_004-TEST-2");
        DynamicObject finArBill2 = FinArBillTestDataProvider.createAR018FinBill(header1, new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.cacheFinBillId2 = finArBill2.getLong("id");
    }

    @TestMethod(value=1)
    @DisplayName(value="\u6309\u7269\u6599\u7ed3\u7b97-\u90e8\u5206\u6309\u6c47\u603b\u503a\u6743\u8f6c\u79fb1\u6821\u9a8c")
    @Test
    public void partSumPushAuditTest1() {
        this.transferBillId1 = this.pushAndSaveTransfer("bijection", new BigDecimal[]{BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.valueOf(5L)}, new BigDecimal[]{BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L)}, true);
        this.checkTransferBill(this.transferBillId1);
        DynamicObject finBill = this.getFinBill(this.cacheFinBillId1);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinBillId2);
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        this.audit(this.transferBillId1);
        for (Long id : this.transferBillId1) {
            FinArBillTestHelper.checkFinJournal(id);
        }
        DynamicObject finBill3 = this.getFinBill(this.cacheFinBillId1);
        FinArBillTestChecker.validateHeadSettleAmt(finBill3, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObjectCollection detailEntries3 = finBill3.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries3.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries3.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries3 = finBill3.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries3.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries3.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObject finBill4 = this.getFinBill(this.cacheFinBillId2);
        DynamicObjectCollection detailEntries4 = finBill4.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries4.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries4.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries4 = finBill4.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries4.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries4.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinBillId1}, this.transferBillId1.toArray(new Long[0]), true);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinBillId2}, this.transferBillId1.toArray(new Long[0]), true);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u6309\u7269\u6599\u7ed3\u7b97-\u90e8\u5206\u6309\u5206\u6563\u503a\u6743\u8f6c\u79fb2\u6821\u9a8c")
    @Test
    public void partDispersePushAuditTest2() {
        this.transferBillId2 = this.pushAndSaveTransfer("sum", new BigDecimal[]{BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.valueOf(5L)}, new BigDecimal[]{BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L)}, true);
        this.checkTransferBill(this.transferBillId2);
        this.audit(this.transferBillId2);
        for (Long id : this.transferBillId2) {
            FinArBillTestHelper.checkFinJournal(id);
        }
        this.assetFinishedStatus(this.cacheFinBillId1);
        this.assetFinishedStatus(this.cacheFinBillId2);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinBillId1}, this.transferBillId2.toArray(new Long[0]), true);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinBillId2}, this.transferBillId2.toArray(new Long[0]), true);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u503a\u6743\u8f6c\u79fb1\u5220\u9664\u6821\u9a8c")
    @Test
    public void partSumPushDeleteTest1() {
        this.unAuditBill("ar_finarbill", this.transferBillId1);
        for (Long id : this.transferBillId1) {
            FinArBillTestHelper.checkJournalExists(id, false);
        }
        DynamicObject finBill3 = this.getFinBill(this.cacheFinBillId1);
        FinArBillTestChecker.validateHeadSettleAmt(finBill3, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObjectCollection detailEntries3 = finBill3.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries3.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries3.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries3 = finBill3.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries3.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries3.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObject finBill4 = this.getFinBill(this.cacheFinBillId2);
        DynamicObjectCollection detailEntries4 = finBill4.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries4.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries4.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries4 = finBill4.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries4.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries4.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        this.deleteTempBill("ar_finarbill", this.transferBillId1);
        DynamicObject finBill = this.getFinBill(this.cacheFinBillId1);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinBillId2);
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinBillId1}, this.transferBillId1.toArray(new Long[0]), true);
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinBillId2}, this.transferBillId1.toArray(new Long[0]), true);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u503a\u6743\u8f6c\u79fb2\u5220\u9664\u6821\u9a8c")
    @Test
    public void partDispersePushDeleteTest2() {
        this.unAuditBill("ar_finarbill", this.transferBillId2);
        this.deleteTempBill("ar_finarbill", this.transferBillId2);
        for (Long id : this.transferBillId2) {
            FinArBillTestHelper.checkJournalExists(id, false);
        }
        this.assetInitStatus(this.cacheFinBillId1);
        this.assetInitStatus(this.cacheFinBillId2);
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinBillId1}, this.transferBillId2.toArray(new Long[0]), true);
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinBillId2}, this.transferBillId2.toArray(new Long[0]), true);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u6309\u8ba1\u5212\u884c\u7ed3\u7b97-\u5f02\u5e01\u522b\u90e8\u5206\u6309\u5206\u6563\u503a\u6743\u8f6c\u79fb3\u6821\u9a8c")
    @Test
    public void partSumPushAuditTest3() {
        FinArBillDataVO header = new FinArBillDataVO();
        header.setCurrency(BaseDataTestProvider.getCurrencyUSD().getLong("id"));
        header.setExchangerate(BigDecimal.valueOf(6.3725));
        header.setOrg(BaseDataTestProvider.getPlanInitOrg());
        header.setBillNo("AR_018_004-TEST-USD-1");
        DynamicObject finArBill1 = FinArBillTestDataProvider.createAR018FinBill(header, new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.cacheFinBillId1 = finArBill1.getLong("id");
        FinArBillDataVO header1 = new FinArBillDataVO();
        header1.setCurrency(BaseDataTestProvider.getCurrencyUSD().getLong("id"));
        header1.setExchangerate(BigDecimal.valueOf(6.3725));
        header1.setOrg(BaseDataTestProvider.getPlanInitOrg());
        header1.setBillNo("AR_018_004-TEST-USD-2");
        DynamicObject finArBill2 = FinArBillTestDataProvider.createAR018FinBill(header1, new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.cacheFinBillId2 = finArBill2.getLong("id");
        this.transferBillId1 = this.pushAndSaveTransfer("bijection", new BigDecimal[]{BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.valueOf(5L)}, new BigDecimal[]{BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L)}, false);
        this.checkTransferBill(this.transferBillId1);
        this.audit(this.transferBillId1);
        for (Long id : this.transferBillId1) {
            FinArBillTestHelper.checkFinJournal(id);
        }
        DynamicObject finBill = this.getFinBill(this.cacheFinBillId1);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinBillId2);
        FinArBillTestChecker.validateHeadSettleAmt(finBill2, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinBillId1}, this.transferBillId1.toArray(new Long[0]), true);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinBillId2}, this.transferBillId1.toArray(new Long[0]), true);
    }

    @TestMethod(value=6)
    @DisplayName(value="\u6309\u8ba1\u5212\u884c\u7ed3\u7b97-\u90e8\u5206\u6309\u6c47\u603b\u503a\u6743\u8f6c\u79fb4\u6821\u9a8c")
    @Test
    public void partDispersePushAuditTest4() {
        this.transferBillId2 = this.pushAndSaveTransfer("sum", new BigDecimal[]{BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.valueOf(5L)}, new BigDecimal[]{BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L)}, false);
        this.checkTransferBill(this.transferBillId2);
        this.audit(this.transferBillId2);
        for (Long id : this.transferBillId1) {
            FinArBillTestHelper.checkFinJournal(id);
        }
        DynamicObject finBill = this.getFinBill(this.cacheFinBillId1);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.valueOf(2000L), BigDecimal.valueOf(12745.0), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject finBill2 = this.getFinBill(this.cacheFinBillId2);
        FinArBillTestChecker.validateHeadSettleAmt(finBill2, BigDecimal.valueOf(2000L), BigDecimal.valueOf(12745.0), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.ZERO, BigDecimal.ZERO);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinBillId1}, this.transferBillId2.toArray(new Long[0]), true);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinBillId2}, this.transferBillId2.toArray(new Long[0]), true);
    }

    @TestMethod(value=7)
    @DisplayName(value="\u503a\u6743\u8f6c\u79fb3\u5220\u9664\u6821\u9a8c")
    @Test
    public void partSumPushDeleteTest3() {
        this.unAuditBill("ar_finarbill", this.transferBillId1);
        for (Long id : this.transferBillId1) {
            FinArBillTestHelper.checkJournalExists(id, false);
        }
        this.deleteTempBill("ar_finarbill", this.transferBillId1);
        DynamicObject finBill = this.getFinBill(this.cacheFinBillId1);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinBillId2);
        FinArBillTestChecker.validateHeadSettleAmt(finBill2, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinBillId1}, this.transferBillId1.toArray(new Long[0]), true);
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinBillId2}, this.transferBillId1.toArray(new Long[0]), true);
    }

    @TestMethod(value=8)
    @DisplayName(value="\u503a\u6743\u8f6c\u79fb4\u5220\u9664\u6821\u9a8c")
    @Test
    public void partDispersePushDeleteTest4() {
        this.unAuditBill("ar_finarbill", this.transferBillId2);
        for (Long id : this.transferBillId2) {
            FinArBillTestHelper.checkJournalExists(id, false);
        }
        this.deleteTempBill("ar_finarbill", this.transferBillId2);
        DynamicObject finBill = this.getFinBill(this.cacheFinBillId1);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(2000L), BigDecimal.valueOf(12745.0));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinBillId2);
        FinArBillTestChecker.validateHeadSettleAmt(finBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(2000L), BigDecimal.valueOf(12745.0));
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinBillId1}, this.transferBillId2.toArray(new Long[0]), true);
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinBillId2}, this.transferBillId2.toArray(new Long[0]), true);
    }

    private Set<Long> pushAndSaveTransfer(String transferType, BigDecimal[] transferQtyArray, BigDecimal[] transferAmtArray, boolean isMaterial) {
        DynamicObject finArBill = BusinessDataServiceHelper.loadSingle((Object)this.cacheFinBillId1, (String)"ar_finarbill");
        DynamicObject finArBill2 = BusinessDataServiceHelper.loadSingle((Object)this.cacheFinBillId2, (String)"ar_finarbill");
        DynamicObject transfer = BusinessDataServiceHelper.newDynamicObject((String)"ar_transferofcredit");
        transfer.set("transfertype", (Object)transferType);
        transfer.set("asstacttype", (Object)finArBill.getString("asstacttype"));
        transfer.set("asstact", (Object)finArBill.getDynamicObject("asstact"));
        transfer.set("bizdate", (Object)finArBill.getDate("bizdate"));
        transfer.set("duedate", (Object)finArBill.getDate("bizdate"));
        transfer.set("payproperty", (Object)finArBill.getDynamicObject("payproperty"));
        transfer.set("currency", (Object)finArBill.getDynamicObject("currency"));
        transfer.set("head_exchangerate", (Object)finArBill.getBigDecimal("exchangerate"));
        transfer.set("org", (Object)finArBill.getDynamicObject("org"));
        transfer.set("recorg", (Object)finArBill.getDynamicObject("recorg"));
        transfer.set("exratetable", (Object)finArBill.getDynamicObject("exratetable"));
        transfer.set("billtype", (Object)finArBill.getDynamicObject("billtype"));
        if (EntityMetadataUtils.isExistProperty(transfer, "quotation")) {
            transfer.set("quotation", (Object)"0");
        }
        int i = 0;
        int j = 0;
        this.setTransferEntry(finArBill, transfer, new BigDecimal[]{transferQtyArray[i++], transferQtyArray[i++]}, new BigDecimal[]{transferAmtArray[j++], transferAmtArray[j++]}, isMaterial);
        this.setTransferEntry(finArBill2, transfer, new BigDecimal[]{transferQtyArray[i++], transferQtyArray[i++]}, new BigDecimal[]{transferAmtArray[j++], transferAmtArray[j++]}, isMaterial);
        OperationResult transferResult = OperationServiceHelper.executeOperate((String)"transfer", (String)"ar_transferofcredit", (DynamicObject[])new DynamicObject[]{transfer}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(transferResult);
        return this.getTransferBillId();
    }

    private Set<Long> getTransferBillId() {
        Map<String, HashSet<Long>> botpResult = BOTPHelper.findTargetBills("ar_finarbill", new Long[]{this.cacheFinBillId1, this.cacheFinBillId2});
        Set debtBillIds = botpResult.getOrDefault("ar_finarbill", new HashSet(16));
        for (Long id : this.transferBillId1) {
            debtBillIds.remove(id);
        }
        for (Long id : this.transferBillId2) {
            debtBillIds.remove(id);
        }
        return debtBillIds;
    }

    private void setTransferEntry(DynamicObject finArBill, DynamicObject transfer, BigDecimal[] transferQtyArray, BigDecimal[] transferAmtArray, boolean isMaterial) {
        DynamicObjectType dataEntityType = (DynamicObjectType)transfer.getDataEntityType();
        DynamicObjectType transferEntryType = ((EntryProp)dataEntityType.getProperty("entryentity")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection detailEntries = finArBill.getDynamicObjectCollection("entry");
        DynamicObjectCollection transferEntries = transfer.getDynamicObjectCollection("entryentity");
        int precision = finArBill.getDynamicObject("currency").getInt("amtprecision");
        for (int i = 0; i < detailEntries.size(); ++i) {
            DynamicObject detailEntryRow = (DynamicObject)detailEntries.get(i);
            DynamicObject transferEntryRow = new DynamicObject(transferEntryType);
            transferEntryRow.set("e_srcfinbillid", (Object)finArBill.getLong("id"));
            transferEntryRow.set("e_asstacttype", (Object)finArBill.getString("asstacttype"));
            transferEntryRow.set("e_asstact", (Object)finArBill.getString("asstact"));
            transferEntryRow.set("e_billno", (Object)finArBill.getString("billno"));
            transferEntryRow.set("e_bizdate", (Object)finArBill.getDate("bizdate"));
            transferEntryRow.set("e_currency", (Object)finArBill.getDynamicObject("currency"));
            transferEntryRow.set("e_currency", (Object)finArBill.getDynamicObject("currency"));
            transferEntryRow.set("e_trate", (Object)finArBill.getBigDecimal("exchangerate"));
            transferEntryRow.set("e_srcentryid", (Object)detailEntryRow.getLong("id"));
            transferEntryRow.set("e_material", (Object)detailEntryRow.getDynamicObject("e_material"));
            transferEntryRow.set("e_recamount", (Object)detailEntryRow.getBigDecimal("e_recamount"));
            transferEntryRow.set("e_measureunit", (Object)detailEntryRow.getDynamicObject("e_measureunit"));
            transferEntryRow.set("e_quantity", (Object)(isMaterial ? transferQtyArray[i] : detailEntryRow.getBigDecimal("e_quantity")));
            transferEntryRow.set("e_taxrate", (Object)BigDecimal.ZERO);
            transferEntryRow.set("e_transamount", (Object)transferAmtArray[i]);
            transferEntryRow.set("e_transtax", (Object)BigDecimal.ZERO);
            transferEntryRow.set("e_transrecamount", (Object)transferAmtArray[i]);
            transferEntryRow.set("e_localamount", (Object)transferAmtArray[i].multiply(finArBill.getBigDecimal("exchangerate")).setScale(precision, RoundingMode.HALF_UP));
            transferEntries.add((Object)transferEntryRow);
        }
        DynamicObjectType transferPlanEntryType = ((EntryProp)dataEntityType.getProperty("planentity")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection planEntries = finArBill.getDynamicObjectCollection("planentity");
        DynamicObjectCollection transferPlanEntries = transfer.getDynamicObjectCollection("planentity");
        for (int i = 0; i < planEntries.size(); ++i) {
            DynamicObject detailEntryRow = (DynamicObject)planEntries.get(i);
            DynamicObject transferEntryRow = new DynamicObject(transferPlanEntryType);
            transferEntryRow.set("p_billid", (Object)finArBill.getLong("id"));
            transferEntryRow.set("p_billno", (Object)finArBill.getString("billno"));
            transferEntryRow.set("planduedate", (Object)finArBill.getDate("bizdate"));
            transferEntryRow.set("planpricetax", (Object)detailEntryRow.getBigDecimal("planpricetax"));
            transferEntryRow.set("unplanlockamt", (Object)detailEntryRow.getBigDecimal("planpricetax"));
            transferEntryRow.set("p_transpricetaxtotal", (Object)transferAmtArray[i]);
            transferEntryRow.set("p_entryid", (Object)detailEntryRow.getLong("id"));
            transferPlanEntries.add((Object)transferEntryRow);
        }
    }

    private void audit(Set<Long> billIds) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])billIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
    }

    private void checkTransferBill(Set<Long> transferBillId1) {
        DynamicObjectCollection trasferBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,istransfer,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", transferBillId1)});
        for (DynamicObject transferBill : trasferBills) {
            KDAssert.assertEquals((String)"B", (String)transferBill.getString("billstatus"));
            KDAssert.assertEquals((boolean)true, (boolean)transferBill.getBoolean("istransfer"));
        }
    }
}

