/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.arfin;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.RevCfmTestHelper;
import kd.fi.arapcommon.unittest.scene.process.arfin.FinBillBaseTest;
import org.junit.Test;

public class AR018_007_RevCfmFinArTest
extends FinBillBaseTest {
    private long arRevCfmBillId;
    private long arRevCfmBillId2;
    private long orgId;
    private int revCfmBillIndex = 1;

    public void initData() {
        super.initData();
        FinArBillDataVO header = new FinArBillDataVO();
        header.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id"));
        header.setExchangerate(BigDecimal.valueOf(1L));
        header.setOrg(BaseDataTestProvider.getDetailInitOrg());
        header.setBillNo("AR_018_007-TEST");
        header.setBillStatus("B");
        DynamicObject finArBill = FinArBillTestDataProvider.createAR018FinBill(header, new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.finArBillId = finArBill.getLong("id");
        this.orgId = finArBill.getLong("org.id");
    }

    @TestMethod(value=1)
    @DisplayName(value="\u81ea\u52a8\u6536\u5165\u786e\u8ba4\u6821\u9a8c")
    @Test
    public void autoRevCfmTest() {
        this.setAutoRevCfm(true);
        OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])new Object[]{this.finArBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        this.arRevCfmBillId = this.getAutoRevCfmId();
        RevCfmTestHelper.checkAutoRevCfmExist(this.finArBillId, true);
        this.assetFinishedStatus(this.finArBillId);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u81ea\u52a8\u6536\u5165\u786e\u8ba4\u5355\u5220\u9664\u6821\u9a8c")
    @Test
    public void autoRevCfmDeleteTest() {
        try {
            Thread.sleep(15000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setAutoRevCfm(false);
        String entrySql = "update t_ar_revcfmbill set fbillsrctype = '' where fid = " + this.arRevCfmBillId;
        DB.execute((DBRoute)DBRouteConst.AR, (String)entrySql);
        this.deleteBill("ar_revcfmbill", this.arRevCfmBillId);
        RevCfmTestHelper.checkAutoRevCfmExist(this.finArBillId, false);
        this.assetInitStatus(this.finArBillId);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u6309\u6bd4\u4f8b\u6536\u5165\u786e\u8ba4-\u624b\u5de5\u90e8\u5206\u6536\u5165\u786e\u8ba4")
    @Test
    public void percentPartPushRevCfmTest1() {
        this.arRevCfmBillId = this.pushRevCfm(true, BigDecimal.valueOf(20L));
        RevCfmTestHelper.checkRevCfmExist(this.arRevCfmBillId, true);
        DynamicObject finBill = this.getFinBill(this.finArBillId);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryConfirmAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(200L), BigDecimal.valueOf(800L));
        FinArBillTestChecker.validateDetailEntryConfirmAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(200L), BigDecimal.valueOf(800L));
    }

    @TestMethod(value=4)
    @DisplayName(value="\u6309\u6bd4\u4f8b\u6536\u5165\u786e\u8ba4-\u624b\u5de5\u5269\u4f59\u90e8\u5206\u6536\u5165\u786e\u8ba4")
    @Test
    public void percentPartPushRevCfmTest2() {
        this.arRevCfmBillId2 = this.pushRevCfm(true, BigDecimal.valueOf(80L));
        RevCfmTestHelper.checkRevCfmExist(this.arRevCfmBillId2, true);
        this.assetFinishedStatus(this.finArBillId);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u6309\u6bd4\u4f8b\u6536\u5165\u786e\u8ba4-\u5220\u9664\u6536\u5165\u786e\u8ba41")
    @Test
    public void percentPartRevCfmDeleteTest1() {
        this.deleteBill("ar_revcfmbill", this.arRevCfmBillId);
        RevCfmTestHelper.checkRevCfmExist(this.arRevCfmBillId, false);
        DynamicObject finBill = this.getFinBill(this.finArBillId);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryConfirmAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(800L), BigDecimal.valueOf(200L));
        FinArBillTestChecker.validateDetailEntryConfirmAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(800L), BigDecimal.valueOf(200L));
    }

    @TestMethod(value=6)
    @DisplayName(value="\u6309\u6bd4\u4f8b\u6536\u5165\u786e\u8ba4-\u5220\u9664\u6536\u5165\u786e\u8ba42")
    @Test
    public void percentPartRevCfmDeleteTest2() {
        this.deleteBill("ar_revcfmbill", this.arRevCfmBillId2);
        RevCfmTestHelper.checkRevCfmExist(this.arRevCfmBillId2, false);
        this.assetInitStatus(this.finArBillId);
    }

    @TestMethod(value=7)
    @DisplayName(value="\u6309\u91d1\u989d\u6536\u5165\u786e\u8ba4-\u624b\u5de5\u90e8\u5206\u6536\u5165\u786e\u8ba43")
    @Test
    public void amtPartPushRevCfmTest1() {
        this.setAutoRevCfm(false);
        this.arRevCfmBillId = this.pushRevCfm(false, BigDecimal.valueOf(300L), BigDecimal.valueOf(300L));
        RevCfmTestHelper.checkRevCfmExist(this.arRevCfmBillId, true);
        DynamicObject finBill = this.getFinBill(this.finArBillId);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryConfirmAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(300L), BigDecimal.valueOf(700L));
        FinArBillTestChecker.validateDetailEntryConfirmAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(300L), BigDecimal.valueOf(700L));
    }

    @TestMethod(value=8)
    @DisplayName(value="\u6309\u91d1\u989d\u6536\u5165\u786e\u8ba4-\u624b\u5de5\u5269\u4f59\u90e8\u5206\u6536\u5165\u786e\u8ba44")
    @Test
    public void amtPartPushRevCfmTest2() {
        this.setAutoRevCfm(false);
        this.arRevCfmBillId2 = this.pushRevCfm(false, BigDecimal.valueOf(700L), BigDecimal.valueOf(700L));
        RevCfmTestHelper.checkRevCfmExist(this.arRevCfmBillId2, true);
        this.assetFinishedStatus(this.finArBillId);
    }

    @TestMethod(value=9)
    @DisplayName(value="\u6309\u91d1\u989d\u6536\u5165\u786e\u8ba4-\u5220\u9664\u6536\u5165\u786e\u8ba43")
    @Test
    public void amtPartRevCfmDeleteTest1() {
        this.deleteBill("ar_revcfmbill", this.arRevCfmBillId);
        RevCfmTestHelper.checkRevCfmExist(this.arRevCfmBillId, false);
        DynamicObject finBill = this.getFinBill(this.finArBillId);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryConfirmAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(700L), BigDecimal.valueOf(300L));
        FinArBillTestChecker.validateDetailEntryConfirmAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(700L), BigDecimal.valueOf(300L));
    }

    @TestMethod(value=10)
    @DisplayName(value="\u6309\u91d1\u989d\u6536\u5165\u786e\u8ba4-\u5220\u9664\u6536\u5165\u786e\u8ba44")
    @Test
    public void amtPartRevCfmDeleteTest2() {
        this.deleteBill("ar_revcfmbill", this.arRevCfmBillId2);
        RevCfmTestHelper.checkRevCfmExist(this.arRevCfmBillId2, false);
        this.assetInitStatus(this.finArBillId);
    }

    @TestMethod(value=11)
    @DisplayName(value="\u4e0b\u63a8\u8c03\u6574\u5355\u81ea\u52a8\u786e\u8ba4\u6d4b\u8bd5")
    @Test
    public void adjustAutoRevTest() {
        this.setAutoRevCfm(true);
        long finAdjustBillId = this.pushAdjust(BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
        Map<String, HashSet<Long>> result = BOTPHelper.findTargetBills("ar_finarbill", finAdjustBillId);
        KDAssert.assertTrue((String)"\u8c03\u6574\u5355\u672a\u81ea\u52a8\u6536\u5165\u786e\u8ba4", (boolean)result.containsKey("ar_revcfmbill"));
    }

    @Override
    protected void assetInitStatus(long finArBillId) {
        DynamicObject finBill = this.getFinBill(finArBillId);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryConfirmAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryConfirmAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
    }

    @Override
    protected void assetFinishedStatus(long finArBillId) {
        DynamicObject finBill = this.getFinBill(finArBillId);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryConfirmAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryConfirmAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
    }

    private void setAutoRevCfm(boolean open) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("ar_005", open ? "1" : "0");
        SystemParameterHelper.setSystemParameter(true, this.orgId, params);
    }

    private long pushRevCfm(boolean percentPush, BigDecimal ... expected) {
        List<DynamicObject> revCfmBillList = BOTPHelper.push("ar_finarbill", "ar_revcfmbill", "732548615414756352", Collections.singletonList(this.finArBillId));
        KDAssert.assertTrue((revCfmBillList.size() == 1 ? 1 : 0) != 0);
        DynamicObject revCfmBill = revCfmBillList.get(0);
        if (percentPush) {
            RevCfmTestHelper.setByHeadConfirmPercent(revCfmBill, expected[0]);
        } else {
            RevCfmTestHelper.setByHeadConfirmAmt(revCfmBill, expected);
        }
        revCfmBill.set("billno", (Object)("REV-TEST-" + this.finArBillId + "-" + this.revCfmBillIndex++));
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ar_revcfmbill", (DynamicObject[])new DynamicObject[]{revCfmBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        revCfmBill.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{revCfmBill});
        return revCfmBill.getLong("id");
    }

    private long pushAdjust(BigDecimal entryAmt1, BigDecimal entryAmt2) {
        List<DynamicObject> adjustBillList = BOTPHelper.push("ar_finarbill", "ar_finarbill", "646772185041512448", Collections.singletonList(this.finArBillId));
        KDAssert.assertEquals((int)1, (int)adjustBillList.size());
        DynamicObject adjustBill = FinArBillTestHelper.setEntryAmount(adjustBillList.get(0), new BigDecimal[]{entryAmt1, entryAmt2});
        adjustBill.set("billstatus", (Object)"B");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjustBill});
        OperationResult result2 = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])new Object[]{adjustBill.getPkValue()}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result2);
        return adjustBill.getLong("id");
    }

    private long getAutoRevCfmId() {
        Map<String, HashSet<Long>> result = BOTPHelper.findTargetBills("ar_finarbill", this.finArBillId);
        Set revCfmIds = result.get("ar_revcfmbill");
        KDAssert.assertEquals((String)"\u81ea\u52a8\u6536\u5165\u786e\u8ba4\u5355\u4e0d\u552f\u4e00", (int)1, (int)revCfmIds.size());
        return (Long)revCfmIds.iterator().next();
    }
}

