/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.arfin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.PayApplyBillTestHelper;
import kd.fi.arapcommon.unittest.scene.process.arfin.FinBillBaseTest;
import org.junit.Test;

public class AR018_009_PayApplyFinArTest
extends FinBillBaseTest {
    private long cacheFinArBillId1;
    private long cacheFinArBillId2;
    private long payApplyId;
    private long payApplyId2;

    public void initData() {
        super.initData();
        FinArBillDataVO header = new FinArBillDataVO();
        header.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id"));
        header.setExchangerate(BigDecimal.valueOf(1L));
        header.setOrg(BaseDataTestProvider.getPlanInitOrg());
        header.setBillNo("AR_018_009-TEST-1");
        DynamicObject finArBill1 = FinArBillTestDataProvider.createAR018FinBill(header, new BigDecimal[]{BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.cacheFinArBillId1 = finArBill1.getLong("id");
        FinArBillDataVO header1 = new FinArBillDataVO();
        header1.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id"));
        header1.setExchangerate(BigDecimal.valueOf(1L));
        header1.setOrg(BaseDataTestProvider.getPlanInitOrg());
        header1.setBillNo("AR_018_009-TEST-2");
        DynamicObject finArBill2 = FinArBillTestDataProvider.createAR018FinBill(header1, new BigDecimal[]{BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.cacheFinArBillId2 = finArBill2.getLong("id");
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8ba1\u5212\u884c\u5408\u5e76\u4e0b\u63a8-\u90e8\u5206\u4ed8\u6b3e\u5904\u74061\u6821\u9a8c")
    @Test
    public void partPushSaveTest1() {
        this.payApplyId = this.pushAndSaveApply(new BigDecimal[]{BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L)});
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-800L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-800L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-800L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-800L));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-800L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-800L));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-800L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-800L));
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8ba1\u5212\u884c\u5408\u5e76\u4e0b\u63a8-\u5269\u4f59\u90e8\u5206\u4ed8\u6b3e\u5904\u74062\u6821\u9a8c")
    @Test
    public void partPushSaveTest2() {
        this.payApplyId2 = this.pushAndSaveApply(new BigDecimal[]{BigDecimal.valueOf(800L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L)});
        this.assetFinishedStatus(this.cacheFinArBillId1);
        this.assetFinishedStatus(this.cacheFinArBillId2);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u90e8\u5206\u4ed8\u6b3e\u5904\u74061\u5173\u95ed\u6821\u9a8c")
    @Test
    public void partPushCloseTest1() {
        this.close(this.payApplyId);
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-200L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-200L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-200L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-200L));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-200L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-200L));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-200L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-200L));
    }

    @TestMethod(value=4)
    @DisplayName(value="\u90e8\u5206\u4ed8\u6b3e\u5904\u74062\u5173\u95ed\u6821\u9a8c")
    @Test
    public void partPushCloseTest2() {
        this.close(this.payApplyId2);
        this.assetInitStatus(this.cacheFinArBillId1);
        this.assetInitStatus(this.cacheFinArBillId2);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u90e8\u5206\u4ed8\u6b3e\u5904\u74061\u53cd\u5173\u95ed\u6821\u9a8c")
    @Test
    public void partPushOpenTest1() {
        this.open(this.payApplyId);
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-800L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-800L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-800L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-800L));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-800L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-800L));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-800L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-800L));
    }

    @TestMethod(value=6)
    @DisplayName(value="\u90e8\u5206\u4ed8\u6b3e\u5904\u74062\u53cd\u5173\u95ed\u6821\u9a8c")
    @Test
    public void partPushOpenTest2() {
        this.open(this.payApplyId2);
        this.assetFinishedStatus(this.cacheFinArBillId1);
        this.assetFinishedStatus(this.cacheFinArBillId2);
    }

    @TestMethod(value=7)
    @DisplayName(value="\u90e8\u5206\u4ed8\u6b3e\u5904\u74061\u5220\u9664")
    @Test
    public void partPushCasTest1() {
        this.deleteBill("ap_payapply", this.payApplyId);
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-200L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-200L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-200L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-200L));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-200L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-200L));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-200L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-200L));
    }

    @TestMethod(value=8)
    @DisplayName(value="\u90e8\u5206\u4ed8\u6b3e\u5904\u74062\u5220\u9664")
    @Test
    public void partPushCasTest2() {
        this.deleteBill("ap_payapply", this.payApplyId2);
        this.assetInitStatus(this.cacheFinArBillId1);
        this.assetInitStatus(this.cacheFinArBillId2);
    }

    @TestMethod(value=9)
    @DisplayName(value="\u5f02\u5e01\u522b\u5408\u5e76\u5168\u90e8\u4e0b\u63a8\u4ed8\u6b3e\u5904\u74063\u6821\u9a8c")
    @Test
    public void fullPushUSDCasTest3() {
        FinArBillDataVO header = new FinArBillDataVO();
        header.setCurrency(BaseDataTestProvider.getCurrencyUSD().getLong("id"));
        header.setExchangerate(BigDecimal.valueOf(6.3725));
        header.setOrg(BaseDataTestProvider.getPlanInitOrg());
        header.setBillNo("AR_018_009-USD-TEST-1");
        DynamicObject finArBill1 = FinArBillTestDataProvider.createAR018FinBill(header, new BigDecimal[]{BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.cacheFinArBillId1 = finArBill1.getLong("id");
        FinArBillDataVO header1 = new FinArBillDataVO();
        header1.setCurrency(BaseDataTestProvider.getCurrencyUSD().getLong("id"));
        header1.setExchangerate(BigDecimal.valueOf(6.3725));
        header1.setOrg(BaseDataTestProvider.getPlanInitOrg());
        header1.setBillNo("AR_018_009-USD-TEST-2");
        DynamicObject finArBill2 = FinArBillTestDataProvider.createAR018FinBill(header1, new BigDecimal[]{BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.cacheFinArBillId2 = finArBill2.getLong("id");
        this.payApplyId = this.pushAndSaveApply(new BigDecimal[]{BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L)});
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-2000L), BigDecimal.valueOf(-12745.0));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-2000L), BigDecimal.valueOf(-12745.0));
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
    }

    @TestMethod(value=10)
    @DisplayName(value="\u4ed8\u6b3e\u5904\u74063\u5173\u95ed\u6821\u9a8c")
    @Test
    public void fullPushUSDCasCloseTest3() {
        this.close(this.payApplyId);
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-2000L), BigDecimal.valueOf(-12745.0));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-2000L), BigDecimal.valueOf(-12745.0));
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
    }

    @TestMethod(value=11)
    @DisplayName(value="\u4ed8\u6b3e\u5904\u74063\u53cd\u5173\u95ed\u6821\u9a8c")
    @Test
    public void fullPushUSDCasOpenTest3() {
        this.open(this.payApplyId);
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-2000L), BigDecimal.valueOf(-12745.0));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-2000L), BigDecimal.valueOf(-12745.0));
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
    }

    @TestMethod(value=12)
    @DisplayName(value="\u4ed8\u6b3e\u5904\u74063\u5220\u9664\u6821\u9a8c")
    @Test
    public void fullPushUSDCasDeleteTest3() {
        this.deleteBill("ap_payapply", this.payApplyId);
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-2000L), BigDecimal.valueOf(-12745.0));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-2000L), BigDecimal.valueOf(-12745.0));
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-6372.5));
    }

    private long pushAndSaveApply(BigDecimal[] entryAmtArray) {
        List<DynamicObject> payApplyList = BOTPHelper.push("ar_finarbill", "ap_payapply", "753390670084846592", Arrays.asList(this.cacheFinArBillId1, this.cacheFinArBillId2));
        KDAssert.assertTrue((payApplyList.size() == 1 ? 1 : 0) != 0);
        DynamicObject payApplyBill = payApplyList.get(0);
        PayApplyBillTestHelper.setEntryAmt(payApplyBill, entryAmtArray);
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ap_payapply", (DynamicObject[])new DynamicObject[]{payApplyBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        payApplyBill.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payApplyBill});
        return payApplyBill.getLong("id");
    }

    private void close(long casBillId) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"closepay", (String)"ap_payapply", (Object[])new Object[]{casBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
    }

    private void open(long casBillId) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"unclosepay", (String)"ap_payapply", (Object[])new Object[]{casBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
    }

    @Override
    protected void assetInitStatus(long finArBillId) {
        DynamicObject finBill = this.getFinBill(finArBillId);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-2000L), BigDecimal.valueOf(-2000L));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
    }

    @Override
    protected void assetFinishedStatus(long finArBillId) {
        DynamicObject finBill = this.getFinBill(finArBillId);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-2000L), BigDecimal.valueOf(-2000L));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
    }
}

